<?php
/**
 * Elementor Support
 *
 * @package Ascend Theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Check for Elementor.
 */
function ascend_is_ele_active() {
	return Ascend_Elementor_Plugin_Check::active_check_ele();
}

/**
 * Init Elementor Support Check.
 */
function ascend_elementor_support() {
	require_once trailingslashit( get_template_directory() ) . 'lib/elementor/class-ascend-elementor-plugin-check.php';
	if ( ascend_is_ele_active() ) {
		add_action( 'init', 'ascend_elementor_init', 1 );
		require_once trailingslashit( get_template_directory() ) . 'lib/elementor/class-ascend-header-footer.php';
		require_once trailingslashit( get_template_directory() ) . 'lib/elementor/elementor-pro-support.php';
	}
}
add_action( 'after_setup_theme', 'ascend_elementor_support' );

/**
 * Init Elementor Support.
 */
function ascend_elementor_init() {
	add_action( 'admin_action_elementor', 'ascend_ele_init_editor', 6 );
	add_action( 'admin_action_elementor', 'ascend_woo_archive_hooks_re_remove', 9 );
	add_action( 'elementor/frontend/after_enqueue_scripts', 'ascend_elementor_fontend_support_scripts' );
}

/**
 * Init Elementor Widget Support.
 */
function ascend_ele_init_editor() {
	add_action( 'elementor/editor/before_enqueue_scripts', 'ascend_add_widget_support_elementor' );
}

/**
 * Elementor Widget Support.
 */
function ascend_add_widget_support_elementor() {
	wp_enqueue_style( 'ascend_admin_styles', get_template_directory_uri() . '/assets/css/ascend_admin.css', false, ASCEND_VERSION );

	add_action( 'wp_print_footer_scripts', 'ascend_shortcode_content' );
	wp_enqueue_script( 'ascend_elementor_admin_scripts', get_template_directory_uri() . '/assets/js/ascend-elementor-admin.js', array( 'wp-color-picker', 'jquery' ), ASCEND_VERSION, true );
}

/**
 * Elementor frontend Support.
 */
function ascend_elementor_fontend_support_scripts() {
	$elementor_instance = Elementor\Plugin::instance();
	if ( $elementor_instance->preview->is_preview_mode() ) {
		wp_enqueue_script( 'ascend_elementor_preview', get_template_directory_uri() . '/assets/js/ascend-elementor-preview.js', array( 'jquery', 'ascend_main' ), ASCEND_VERSION, true );
	}
}

/**
 * Elementor Woocommerce Support.
 */
function ascend_woo_archive_hooks_re_remove() {
	remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
	remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
	remove_action( 'woocommerce_before_subcategory_title', 'woocommerce_subcategory_thumbnail', 10 );
	remove_action( 'woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_title', 10 );
	remove_action( 'woocommerce_before_subcategory', 'woocommerce_template_loop_category_link_open', 10 );
	remove_action( 'woocommerce_after_subcategory', 'woocommerce_template_loop_category_link_close', 10 );
}

