<?php
/**
 * Configuration Sidebar Show
 *
 * @package Ascend Theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Get Sidebar ID
 */
function ascend_sidebar_id() {
	global $ascend;
	if ( is_front_page() ) {
		$sidebar = ascend_get_option( 'home_sidebar', 'sidebar-primary' );
	} elseif ( is_home() ) {
		$homeid       = get_option( 'page_for_posts' );
		$sidebar_name = get_post_meta( $homeid, '_kad_sidebar_choice', true );
		if ( empty( $sidebar_name ) || 'default' === $sidebar_name ) {
			$sidebar = ascend_get_option( 'blog_cat_sidebar_default', 'sidebar-primary' );
		} elseif ( ! empty( $sidebar_name ) ) {
			$sidebar = $sidebar_name;
		} else {
			$sidebar = 'sidebar-primary';
		}
	} elseif ( class_exists( 'woocommerce' ) && ( is_shop() ) ) {
		$shopid       = get_option( 'woocommerce_shop_page_id' );
		$sidebar_name = get_post_meta( $shopid, '_kad_sidebar_choice', true );
		if ( empty( $sidebar_name ) || 'default' === $sidebar_name ) {
			$sidebar = ascend_get_option( 'shop_cat_sidebar', 'sidebar-primary' );
		} elseif ( ! empty( $sidebar_name ) ) {
			$sidebar = $sidebar_name;
		} else {
			$sidebar = 'sidebar-primary';
		}
	} elseif ( class_exists( 'woocommerce' ) && ( is_product_category() || is_product_tag() || is_tax( 'product_brands' ) || is_tax( 'pa_brands' ) ) ) {
		$sidebar = ascend_get_option( 'shop_cat_sidebar', 'sidebar-primary' );
	} elseif ( class_exists( 'woocommerce' ) && is_product() ) {
		global $post;
		$sidebar_name = get_post_meta( $post->ID, '_kad_sidebar_choice', true );
		if ( empty( $sidebar_name ) || 'default' === $sidebar_name ) {
			$sidebar = ascend_get_option( 'product_sidebar_default', 'sidebar-primary' );
		} elseif ( ! empty( $sidebar_name ) ) {
			$sidebar = $sidebar_name;
		} else {
			$sidebar = 'sidebar-primary';
		}
	} elseif ( is_page() ) {
		global $post;
		$sidebar_name = get_post_meta( $post->ID, '_kad_sidebar_choice', true );
		if ( empty( $sidebar_name ) || 'default' === $sidebar_name ) {
			$sidebar = ascend_get_option( 'page_sidebar_default', 'sidebar-primary' );
		} elseif ( ! empty( $sidebar_name ) ) {
			$sidebar = $sidebar_name;
		} else {
			$sidebar = 'sidebar-primary';
		}
	} elseif ( is_post_type_archive( 'llms_membership' ) && function_exists( 'llms_get_page_id' ) ) {
		$pageid       = llms_get_page_id( 'memberships' );
		$sidebar_name = get_post_meta( $pageid, '_kad_sidebar_choice', true );
		if ( empty( $sidebar_name ) || 'default' === $sidebar_name ) {
			$sidebar = ascend_get_option( 'page_sidebar_default', 'sidebar-primary' );
		} elseif ( ! empty( $sidebar_name ) ) {
			$sidebar = $sidebar_name;
		} else {
			$sidebar = 'sidebar-primary';
		}
	} elseif ( is_post_type_archive( 'course' ) && function_exists( 'llms_get_page_id' ) ) {
		$pageid       = llms_get_page_id( 'courses' );
		$sidebar_name = get_post_meta( $pageid, '_kad_sidebar_choice', true );
		if ( empty( $sidebar_name ) || 'default' === $sidebar_name ) {
			$sidebar = ascend_get_option( 'page_sidebar_default', 'sidebar-primary' );
		} elseif ( ! empty( $sidebar_name ) ) {
			$sidebar = $sidebar_name;
		} else {
			$sidebar = 'sidebar-primary';
		}
	} elseif ( is_singular( 'post' ) ) {
		global $post;
		$sidebar_name = get_post_meta( $post->ID, '_kad_sidebar_choice', true );
		if ( empty( $sidebar_name ) || 'default' === $sidebar_name ) {
			$sidebar = ascend_get_option( 'blog_sidebar_default', 'sidebar-primary' );
		} elseif ( ! empty( $sidebar_name ) ) {
			$sidebar = $sidebar_name;
		} else {
			$sidebar = 'sidebar-primary';
		}
	} elseif ( is_singular( 'portfolio' ) ) {
		global $post;
		$sidebar_name = get_post_meta( $post->ID, '_kad_sidebar_choice', true );
		if ( empty( $sidebar_name ) || 'default' === $sidebar_name ) {
			$sidebar = ascend_get_option( 'portfolio_sidebar_default', 'sidebar-primary' );
		} elseif ( ! empty( $sidebar_name ) ) {
			$sidebar = $sidebar_name;
		} else {
			$sidebar = 'sidebar-primary';
		}
	} elseif ( is_tax( 'portfolio-type' ) || is_tax( 'portfolio-tag' ) ) {
		global $ascend;
		if ( ! empty( $ascend['portfolio_sidebar_default'] ) ) {
			$sidebar = $ascend['portfolio_sidebar_default'];
		} else {
			$sidebar = 'sidebar-primary';
		}
	} elseif ( is_singular( 'staff' ) || is_tax( 'staff-group' ) ) {
		global $post;
		$sidebar_name = get_post_meta( $post->ID, '_kad_sidebar_choice', true );
		if ( empty( $sidebar_name ) || 'default' === $sidebar_name ) {
			global $ascend;
			if ( ! empty( $ascend['staff_sidebar_default'] ) ) {
				$sidebar = $ascend['staff_sidebar_default'];
			} else {
				$sidebar = 'sidebar-primary';
			}
		} elseif ( ! empty( $sidebar_name ) ) {
			$sidebar = $sidebar_name;
		} else {
			$sidebar = 'sidebar-primary';
		}
	} elseif ( is_singular( 'testimonial' ) || is_tax( 'testimonial-group' ) ) {
		global $post;
		$sidebar_name = get_post_meta( $post->ID, '_kad_sidebar_choice', true );
		if ( empty( $sidebar_name ) || 'default' === $sidebar_name ) {
			global $ascend;
			if ( ! empty( $ascend['testimonial_sidebar_default'] ) ) {
				$sidebar = $ascend['testimonial_sidebar_default'];
			} else {
				$sidebar = 'sidebar-primary';
			}
		} elseif ( ! empty( $sidebar_name ) ) {
			$sidebar = $sidebar_name;
		} else {
			$sidebar = 'sidebar-primary';
		}
	} elseif ( is_singular() ) {
		global $post;
		error_log( 'Are we Here?' );
		$sidebar_name = get_post_meta( $post->ID, '_kad_sidebar_choice', true );
		if ( empty( $sidebar_name ) || 'default' === $sidebar_name ) {
			$sidebar = 'sidebar-primary';
		} elseif ( ! empty( $sidebar_name ) ) {
			$sidebar = $sidebar_name;
		} else {
			$sidebar = 'sidebar-primary';
		}
	} elseif ( is_category() ) {
		global $ascend;
		if ( isset( $ascend['blog_cat_sidebar_default'] ) ) {
			$sidebar = $ascend['blog_cat_sidebar_default'];
		} else {
			$sidebar = 'sidebar-primary';
		}
	} elseif ( is_archive() ) {
		global $ascend;
		if ( isset( $ascend['blog_cat_sidebar_default'] ) ) {
			$sidebar = $ascend['blog_cat_sidebar_default'];
		} else {
			$sidebar = 'sidebar-primary';
		}
	} elseif ( is_search() ) {
		if ( isset( $ascend['search_sidebar_default'] ) ) {
			$sidebar = $ascend['search_sidebar_default'];
		} else {
			$sidebar = 'sidebar-primary';
		}
	} else {
		$sidebar = 'sidebar-primary';
	}

	return apply_filters( 'kadence_sidebar_id', $sidebar );
}

/**
 * Get Main Content Classes
 */
function ascend_main_class() {
	if ( ascend_display_sidebar() ) {
		// Classes on pages with the sidebar.
		$side  = ascend_sidebar_side();
		$class = 'col-lg-9 col-md-8 kt-sidebar kt-sidebar-' . $side;
	} else {
		// Classes on full width pages.
		$class = 'col-md-12 kt-nosidebar clearfix';
	}
	$class = apply_filters( 'kadence_main_content_classes', $class ); // Depreciated.
	return apply_filters( 'ascend_main_content_classes', $class );
}

/**
 * Get Sidebar Side
 */
function ascend_sidebar_side() {
	global $ascend;
	if ( class_exists( 'woocommerce' ) && ( is_shop() || is_product_category() || is_product_tag() ) ) {
		if ( isset( $ascend['shop_cat_sidebar_side'] ) && 'left' === $ascend['shop_cat_sidebar_side'] ) {
			$side = 'left';
		} else {
			$side = 'right';
		}
	} else {
		if ( isset( $ascend['sidebar_side'] ) && 'left' === $ascend['sidebar_side'] ) {
			$side = 'left';
		} else {
			$side = 'right';
		}
	}
	return apply_filters( 'kadence_sidebar_side', $side );
}

/**
 * .sidebar classes
 */
function ascend_sidebar_class() {
	return 'col-lg-3 col-md-4 kt-sidebar-container';
}

/**
 * Define which pages shouldn't have the sidebar
 */
function ascend_display_sidebar() {
	$sidebar_config = new Ascend_Sidebar(
		array(
			'ascend_sidebar_on_shop_page', // Shop Page.
			'ascend_sidebar_on_shop_cat_page', // Product Categories and Tags.
			'ascend_sidebar_on_product_post', // Product posts.
			'ascend_sidebar_page', // Pages.
			'ascend_sidebar_on_staff', // staff Posts.
			'ascend_sidebar_on_staff_archive', // staff Posts.
			'ascend_sidebar_on_event', // event Posts.
			'ascend_sidebar_on_courses', // Lifter LMS.
			'ascend_sidebar_on_testimonial', // testimonial Posts.
			'ascend_sidebar_on_testimonial_archive', // testimonial Posts.
			'ascend_sidebar_on_portfolio', // portfolio Posts.
			'ascend_sidebar_on_portfolio_archive', // portfolio Posts.
			'ascend_sidebar_on_post', // Blog Posts & Other post types.
			'ascend_sidebar_on_front_page', // Front Home Page.
			'ascend_sidebar_on_home_page', // Home Posts Page.
			'ascend_sidebar_on_search_page', // Search Page.
			'ascend_sidebar_on_archive', // Post archives.
			'is_404', // 404
			array(
				'is_singular',
				array( 'attachment' ),
			),
		)
	);

	return apply_filters( 'kadence_display_sidebar', $sidebar_config->display );
}

/**
 * Define if shop page should have sidebar.
 */
function ascend_sidebar_on_shop_page() {
	if ( class_exists( 'woocommerce' ) ) {
		if ( is_shop() ) {
			$shopid = get_option( 'woocommerce_shop_page_id' );
			$postsidebar = get_post_meta( $shopid, '_kad_post_sidebar', true );
			if ( isset( $postsidebar ) && $postsidebar == 'yes' ) {
				return false;
			} else if ( isset( $postsidebar ) && $postsidebar == 'default' || empty( $postsidebar ) ) {
				global $ascend;
				if ( isset( $ascend['shop_cat_layout'] ) && $ascend['shop_cat_layout'] == 'sidebar' ) {
					return false;
				} else {
					return true;
				}
			} else {
				return true;
			}
		}
	}
}
function ascend_sidebar_on_shop_cat_page() {
	if ( is_tax( 'product_cat' ) || is_tax( 'product_tag' ) || is_tax( 'product_brands' ) ) {
		global $ascend;
		if ( isset( $ascend['shop_cat_layout'] ) && $ascend['shop_cat_layout'] == 'sidebar' ) {
			return false;
		} else {
			return true;
		}
	}
}
function ascend_sidebar_on_product_post() {
	if ( is_singular( 'product' ) ) {
		global $post;
		$postsidebar = get_post_meta( $post->ID, '_kad_post_sidebar', true );
		if ( isset( $postsidebar ) && $postsidebar == 'yes' ) {
			return false;
		} else if ( empty( $postsidebar ) || ! isset( $postsidebar ) || $postsidebar == 'default' ) {
			global $ascend;
			if ( isset( $ascend['product_layout'] ) && $ascend['product_layout'] == 'full' ) {
				return true;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
}
function ascend_sidebar_page() {
	if ( is_page() && ! is_front_page() && ! is_home() ) {
		if ( class_exists( 'woocommerce' ) ) {
			if ( is_cart() || is_checkout() ) {
				global $post;
				$postsidebar = get_post_meta( $post->ID, '_kad_post_sidebar', true );
				if ( isset( $postsidebar ) && $postsidebar == 'yes' ) {
					return false;
				} else if ( isset( $postsidebar ) && $postsidebar == 'default' || empty( $postsidebar ) ) {
						return true;
				} else {
					return true;
				}
			} else {
				global $post;
				$postsidebar = get_post_meta( $post->ID, '_kad_post_sidebar', true );
				if ( isset( $postsidebar ) && $postsidebar == 'yes' ) {
					return false;
				} else if ( isset( $postsidebar ) && $postsidebar == 'default' || empty( $postsidebar ) ) {
					global $ascend;
					if ( isset( $ascend['page_layout'] ) && $ascend['page_layout'] == 'sidebar' ) {
						return false;
					} else {
						return true;
					}
				} else {
					return true;
				}
			}
		} else {
			global $post;
			$postsidebar = get_post_meta( $post->ID, '_kad_post_sidebar', true );
			if ( isset( $postsidebar ) && $postsidebar == 'yes' ) {
				return false;
			} else if ( isset( $postsidebar ) && $postsidebar == 'default' || empty( $postsidebar ) ) {
				global $ascend;
				if ( isset( $ascend['page_layout'] ) && $ascend['page_layout'] == 'sidebar' ) {
					return false;
				} else {
					return true;
				}
			} else {
				return true;
			}
		}
	}
}
function ascend_sidebar_on_testimonial() {
	if ( is_singular( 'testimonial' ) ) {
		global $post;
		$postsidebar = get_post_meta( $post->ID, '_kad_post_sidebar', true );
		if ( isset( $postsidebar ) && $postsidebar == 'no' ) {
			return true;
		} else if ( isset( $postsidebar ) && $postsidebar == 'default' || empty( $postsidebar ) ) {
			global $ascend;
			if ( isset( $ascend['testimonial_layout'] ) && $ascend['testimonial_layout'] == 'full' ) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
}
function ascend_sidebar_on_testimonial_archive() {
	if ( is_tax( 'testimonial-group' ) ) {
		global $ascend;
		if ( isset( $ascend['testimonial_layout'] ) && 'full' == $ascend['testimonial_layout'] ) {
			return true;
		} else {
			return false;
		}
	}
}
function ascend_sidebar_on_event() {
	if ( is_singular( 'tribe_events' ) ) {
		global $post;
		$postsidebar = get_post_meta( $post->ID, '_kad_post_sidebar', true );
		if ( isset( $postsidebar ) && $postsidebar == 'no' ) {
			return true;
		} else if ( isset( $postsidebar ) && $postsidebar == 'default' || empty( $postsidebar ) ) {
			global $ascend;
			if ( apply_filters( 'kadence_event_sidebar_default', true ) ) {
				return false;
			} else {
				return true;
			}
		} else {
			return false;
		}
	} else if ( function_exists( 'tribe_is_month' ) ) {
		if ( tribe_is_month() ) {
			if ( apply_filters( 'kadence_event_archive_sidebar_default', false ) ) {
				return false;
			} else {
				return true;
			}
		}
	}
}
/**
 * Check for sidebar enabled for Courses
 */
function ascend_sidebar_on_courses() {
	if ( is_post_type_archive( 'llms_membership' ) && function_exists( 'llms_get_page_id' ) ) {
		$pageid = llms_get_page_id( 'memberships' );
		$postsidebar = get_post_meta( $pageid, '_kad_post_sidebar', true );
		if ( isset( $postsidebar ) && 'no' == $postsidebar ) {
			return true;
		} else if ( isset( $postsidebar ) && 'default' == $postsidebar || empty( $postsidebar ) ) {
			global $ascend;
			if ( isset( $ascend['page_layout'] ) && 'sidebar' == $ascend['page_layout'] ) {
				return false;
			} else {
				return true;
			}
		} else {
			return false;
		}
	} else if ( is_post_type_archive( 'course' ) && function_exists( 'llms_get_page_id' ) ) {
		$pageid = llms_get_page_id( 'courses' );
		$postsidebar = get_post_meta( $pageid, '_kad_post_sidebar', true );
		if ( isset( $postsidebar ) && 'no' == $postsidebar ) {
			return true;
		} else if ( isset( $postsidebar ) && 'default' == $postsidebar || empty( $postsidebar ) ) {
			global $ascend;
			if ( isset( $ascend['page_layout'] ) && 'sidebar' == $ascend['page_layout'] ) {
				return false;
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
}
function ascend_sidebar_on_staff() {
	if ( is_singular( 'staff' ) ) {
		global $post;
		$postsidebar = get_post_meta( $post->ID, '_kad_post_sidebar', true );
		if ( isset( $postsidebar ) && $postsidebar == 'no' ) {
			return true;
		} else if ( isset( $postsidebar ) && $postsidebar == 'default' || empty( $postsidebar ) ) {
			global $ascend;
			if ( isset( $ascend['staff_layout'] ) && $ascend['staff_layout'] == 'full' ) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
}
function ascend_sidebar_on_staff_archive() {
	if ( is_tax( 'staff-group' ) ) {
		global $ascend;
		if ( isset( $ascend['staff_layout'] ) && $ascend['staff_layout'] == 'full' ) {
			return true;
		} else {
			return false;
		}
	}
}
function ascend_sidebar_on_portfolio() {
	if ( is_singular( 'portfolio' ) ) {
		global $post;
		$postsidebar = get_post_meta( $post->ID, '_kad_post_sidebar', true );
		if ( isset( $postsidebar ) && $postsidebar == 'yes' ) {
			return false;
		} else if ( isset( $postsidebar ) && 'default' == $postsidebar || empty( $postsidebar ) ) {
			global $ascend;
			if ( isset( $ascend['portfolio_layout'] ) && 'sidebar' == $ascend['portfolio_layout'] ) {
				return false;
			} else {
				return true;
			}
		} else {
			return true;
		}
	}
}
function ascend_sidebar_on_portfolio_archive() {
	if ( is_tax( 'portfolio-type' ) || is_tax( 'portfolio-tag' ) ) {
		global $ascend;
		if ( isset( $ascend['portfolio_layout'] ) && $ascend['portfolio_layout'] == 'sidebar' ) {
			return false;
		} else {
			return true;
		}
	}
}
function ascend_sidebar_on_post() {
	if ( is_single() && ! is_singular( 'staff' ) && ! is_singular( 'portfolio' ) && ! is_singular( 'product' ) && ! is_singular( 'tribe_events' ) && ! is_singular( 'testimonial' ) ) {
		global $post;
		$postsidebar = get_post_meta( $post->ID, '_kad_post_sidebar', true );
		if ( isset( $postsidebar ) && $postsidebar == 'no' ) {
			return true;
		} else if ( isset( $postsidebar ) && $postsidebar == 'default' || empty( $postsidebar ) ) {
			global $ascend;
			if ( isset( $ascend['blog_layout'] ) && $ascend['blog_layout'] == 'full' ) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
}
function ascend_sidebar_on_front_page() {
	if ( is_front_page() ) {
		global $ascend;
		if ( isset( $ascend['home_sidebar_layout'] ) && $ascend['home_sidebar_layout'] == '1' ) {
			return false;
		} else {
			return true;
		}
	}
}
function ascend_sidebar_on_home_page() {
	if ( is_home() && ! is_front_page() ) {
		$homeid = get_option( 'page_for_posts' );
		$postsidebar = get_post_meta( $homeid, '_kad_post_sidebar', true );
		if ( isset( $postsidebar ) && $postsidebar == 'no' ) {
			return true;
		} else if ( isset( $postsidebar ) && $postsidebar == 'default' || empty( $postsidebar ) ) {
			global $ascend;
			if ( isset( $ascend['blog_cat_layout'] ) && $ascend['blog_cat_layout'] == 'sidebar' ) {
				return false;
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
}
function ascend_sidebar_on_search_page() {
	if ( is_search() ) {
		global $ascend;
		if ( isset( $ascend['search_layout'] ) && $ascend['search_layout'] == 'full' ) {
			return true;
		} else {
			return false;
		}
	}
}
function ascend_sidebar_on_archive() {
	if ( class_exists( 'woocommerce' ) ) {
		if ( is_archive() && ! is_post_type_archive( 'llms_membership' ) && ! is_post_type_archive( 'courses' ) && ( ! is_tax( 'portfolio-type' ) && ! is_tax( 'portfolio-tag' ) && ! is_tax( 'product_cat' ) && ! is_tax( 'product_tag' ) && ! is_tax( 'product_brands' ) && ! is_tax( 'staff-group' ) && ! is_tax( 'testimonial-group' ) && ! is_shop() ) ) {
			global $ascend;
			if ( isset( $ascend['blog_cat_layout'] ) && $ascend['blog_cat_layout'] == 'full' ) {
				return true;
			} else {
				return false;
			}
		}
	} else {
		if ( is_archive() && ! is_post_type_archive( 'llms_membership' ) && ! is_post_type_archive( 'courses' ) && ( ! is_tax( 'portfolio-type' ) && ! is_tax( 'portfolio-tag' ) && ! is_tax( 'staff-group' ) && ! is_tax( 'testimonial-group' ) ) ) {
			global $ascend;
			if ( isset( $ascend['blog_cat_layout'] ) && 'full' == $ascend['blog_cat_layout'] ) {
				return true;
			} else {
				return false;
			}
		}
	}
}


