<?php
/**
 * Ascend Sidebar Class
 *
 * @package Ascend Theme
 */

/**
 * Determines whether or not to display the sidebar based on an array of conditional tags or page templates.
 *
 * @return boolean True will display the sidebar, False will not
 */
class Ascend_Sidebar {
	/**
	 * Holds the bool for showing a sidebar.
	 *
	 * @var values of the theme settings.
	 */
	public static $display = null;

	/**
	 * Checks if page has a sidebar.
	 *
	 * @return boolean True will display the sidebar, False will not
	 */
	public static function has_sidebar() {
		if ( is_null( self::$display ) ) {
			self::$display = self::check_conditionals();
		}
		return self::$display;
	}
	/**
	 * Checks conditionals to see if page has a sidebar.
	 *
	 * @return boolean True will display the sidebar, False will not.
	 */
	public static function check_conditionals() {
		$sidebar = false;
		if ( is_front_page() ) {
			if ( '1' == ascend_get_option( 'home_sidebar_layout' ) ) {
				$sidebar = true;
			}
		} elseif ( is_home() ) {
			$homeid      = get_option( 'page_for_posts' );
			$postsidebar = get_post_meta( $homeid, '_kad_post_sidebar', true );
			if ( isset( $postsidebar ) && 'yes' === $postsidebar ) {
				$sidebar = true;
			} elseif ( isset( $postsidebar ) && 'default' === $postsidebar || empty( $postsidebar ) ) {
				if ( 'sidebar' === ascend_get_option( 'blog_cat_layout' ) ) {
					$sidebar = true;
				}
			}
		} elseif ( is_page() && ! is_attachment() ) {
			$postsidebar = get_post_meta( get_the_ID(), '_kad_post_sidebar', true );
			if ( isset( $postsidebar ) && 'yes' === $postsidebar ) {
				$sidebar = true;
			} elseif ( isset( $postsidebar ) && 'default' === $postsidebar || empty( $postsidebar ) ) {
				if ( 'sidebar' === ascend_get_option( 'page_layout' ) ) {
					$sidebar = true;
				}
			}
		} elseif ( is_post_type_archive( 'llms_membership' ) && function_exists( 'llms_get_page_id' ) ) {
			$pageid      = llms_get_page_id( 'memberships' );
			$postsidebar = get_post_meta( $pageid, '_kad_post_sidebar', true );
			if ( isset( $postsidebar ) && 'yes' === $postsidebar ) {
				$sidebar = true;
			} elseif ( isset( $postsidebar ) && 'default' === $postsidebar || empty( $postsidebar ) ) {
				if ( 'sidebar' === ascend_get_option( 'page_layout' ) ) {
					$sidebar = true;
				}
			}
		} elseif ( is_post_type_archive( 'course' ) && function_exists( 'llms_get_page_id' ) ) {
			$pageid      = llms_get_page_id( 'courses' );
			$postsidebar = get_post_meta( $pageid, '_kad_post_sidebar', true );
			if ( isset( $postsidebar ) && 'yes' === $postsidebar ) {
				$sidebar = true;
			} elseif ( isset( $postsidebar ) && 'default' === $postsidebar || empty( $postsidebar ) ) {
				if ( 'sidebar' === ascend_get_option( 'page_layout' ) ) {
					$sidebar = true;
				}
			}
		} elseif ( is_singular() ) {
			$postsidebar = get_post_meta( get_the_ID(), '_kad_post_sidebar', true );
			if ( isset( $postsidebar ) && 'yes' === $postsidebar ) {
					$sidebar = true;
			} elseif ( isset( $postsidebar ) && 'default' === $postsidebar || empty( $postsidebar ) ) {
				if ( is_singular( 'post' ) ) {
					if ( 'sidebar' === ascend_get_option( 'blog_layout' ) ) {
						$sidebar = true;
					}
				} elseif ( is_singular( 'product' ) ) {
					if ( 'sidebar' === ascend_get_option( 'product_layout' ) ) {
						$sidebar = true;
					}
				} elseif ( is_singular( 'portfolio' ) ) {
					if ( 'sidebar' === ascend_get_option( 'portfolio_layout' ) ) {
						$sidebar = true;
					}
				} elseif ( is_singular( 'staff' ) ) {
					if ( 'sidebar' === ascend_get_option( 'staff_layout' ) ) {
						$sidebar = true;
					}
				} elseif ( is_singular( 'testimonial' ) ) {
					if ( 'sidebar' === ascend_get_option( 'testimonial_layout' ) ) {
						$sidebar = true;
					}
				} elseif ( is_singular( 'tribe_events' ) ) {
					if ( apply_filters( 'kadence_event_sidebar_default', true ) ) {
						$sidebar = true;
					}
				} else {
					if ( 'yes' === ascend_get_option( 'custom_post_sidebar_default' ) ) {
						$sidebar = true;
					}
				}
			}
		} elseif ( class_exists( 'woocommerce' ) && is_archive() && is_shop() ) {
			if ( 'sidebar' === ascend_get_option( 'shop_cat_layout' ) ) {
				$sidebar = true;
			}
		} elseif ( class_exists( 'woocommerce' ) && is_archive() && ( is_product_category() || is_product_tag() || is_tax( 'product_brands' ) || is_tax( 'product_brands' ) ) ) {
			if ( 'sidebar' === ascend_get_option( 'shop_cat_layout' ) ) {
				$sidebar = true;
			}
		} elseif ( function_exists( 'tribe_is_month' ) && tribe_is_month() ) {
			if ( apply_filters( 'kadence_event_archive_sidebar_default', false ) ) {
				$sidebar = true;
			}
		} elseif ( is_archive() && is_tax( 'portfolio-type' ) || is_archive() && is_tax( 'portfolio-tag' ) ) {
			if ( 'sidebar' === ascend_get_option( 'portfolio_layout' ) ) {
				$sidebar = true;
			}
		} elseif ( is_archive() && is_tax( 'staff-group' ) ) {
			if ( 'sidebar' === ascend_get_option( 'staff_layout' ) ) {
				$sidebar = true;
			}
		} elseif ( is_archive() && is_tax( 'testimonial-group' ) ) {
			if ( 'sidebar' === ascend_get_option( 'testimonial_layout' ) ) {
				$sidebar = true;
			}
		} elseif ( is_archive() && is_category() || is_archive() && is_tag() ) {
			if ( 'sidebar' === ascend_get_option( 'blog_cat_layout' ) ) {
				$sidebar = true;
			}
		} elseif ( is_search() ) {
			if ( 'sidebar' === ascend_get_option( 'search_layout' ) ) {
				$sidebar = true;
			}
		} elseif ( is_archive() ) {
			if ( 'yes' === ascend_get_option( 'custom_post_sidebar_default' ) && apply_filters( 'kadence_custom_archive_sidebar', true ) ) {
				$sidebar = true;
			}
		}
		return $sidebar;
	}
}
