<?php
	define( 'OPTIONS_PATH', get_template_directory_uri() . '/themeoptions/options/' );

function ascend_all_ksp_in_array() {
	$result = '';
	if ( class_exists( 'KadenceSliderPro_Output' ) && is_admin() ) {
		global $wpdb;
		$sliders = $wpdb->get_results( 'SELECT * FROM ' . $wpdb->prefix . 'ksp_sliders' );
		if ( ! empty( $sliders ) ) {
			$name  = array();
			$id     = array();
			foreach ( $sliders as $slider ) {
				$name[] = $slider->name;
				$id[]   = $slider->id;
			}
			if ( ! empty( $id ) ) {
				$result = array_combine( $id, $name );
			} else {
				$result = '';
			}
		}
	}
	return $result;
}
	$of_ksp = array();
	$of_ksp_test = ascend_all_ksp_in_array();
if ( ! empty( $of_ksp_test ) ) {
	$of_ksp = $of_ksp_test;
} else {
	$of_ksp = '';
}


	/*
	--- BEGIN Config ----
	*/

if ( ! class_exists( 'Redux' ) ) {
	return;
}

	// This is your option name where all the Redux data is stored.
	$opt_name = 'ascend';

	// If Redux is running as a plugin, this will remove the demo notice and links
	add_action( 'redux/loaded', 'ascend_remove_demo' );

	$theme = wp_get_theme();
	$args = array(
		'opt_name'             => $opt_name,
		'display_name'         => $theme->get( 'Name' ),
		'display_version'      => $theme->get( 'Version' ),
		'menu_type'            => 'menu',
		'allow_sub_menu'       => false,
		'menu_title'           => __( 'Theme Options', 'ascend' ),
		'page_title'           => __( 'Theme Options', 'ascend' ),
		'google_api_key'       => 'AIzaSyALkgUvb8LFAmrsczX56ZGJx-PPPpwMid0',
		'google_update_weekly' => false,
		'async_typography'     => false,
		'admin_bar'            => true,
		'admin_bar_icon'       => 'dashicons-admin-generic',
		'admin_bar_priority'   => 50,
		'dev_mode'             => false,
		'update_notice'        => false,
		'customizer'           => true,
		'forced_dev_mode_off'  => false,
		'use_cdn'              => false,
		'page_priority'        => 49,
		'page_permissions'     => 'manage_options',
		'menu_icon'            => '',
		'page_icon'            => 'kad_logo_header',
		'page_slug'            => 'kad_options',
		'ajax_save'            => true,
		'show_options_object'  => false,
		'default_show'         => false,
		'default_mark'         => '',
		'footer_credit'         => __( 'Thank you for using the Ascend Theme by <a href="https://kadencewp.com/" target="_blank">Kadence WP</a>.', 'ascend' ),
		'hints'                => array(
			'icon'          => 'kt-icon-question',
			'icon_position' => 'right',
			'icon_color'    => '#444',
			'icon_size'     => 'normal',
			'tip_style'     => array(
				'color'   => 'dark',
				'shadow'  => true,
				'rounded' => false,
				'style'   => '',
			),
			'tip_position'  => array(
				'my' => 'top left',
				'at' => 'bottom right',
			),
			'tip_effect'    => array(
				'show' => array(
					'effect'   => 'slide',
					'duration' => '500',
					'event'    => 'mouseover',
				),
				'hide' => array(
					'effect'   => 'slide',
					'duration' => '500',
					'event'    => 'click mouseleave',
				),
			),
		),
	);

	$args['share_icons'][] = array(
		'url' => 'https://www.facebook.com/KadenceWP',
		'title' => 'Follow Kadence WP on Facebook',
		'icon' => 'dashicons dashicons-facebook',
	);
	$args['share_icons'][] = array(
		'url' => 'https://www.twitter.com/KadenceWP',
		'title' => 'Follow Kadence WP on Twitter',
		'icon' => 'dashicons dashicons-twitter',
	);
	$args['share_icons'][] = array(
		'url' => 'https://www.instagram.com/KadenceWP',
		'title' => 'Follow Kadence WP on Instagram',
		'icon' => 'dashicons dashicons-format-image',
	);
	$args['share_icons'][] = array(
		'url' => 'http://www.youtube.com/c/KadenceWP',
		'title' => 'Follow Kadence WP on YouTube',
		'icon' => 'dashicons dashicons-video-alt3',
	);

	 $args = apply_filters( 'kadence_theme_options_args', $args );
	Redux::setArgs( $opt_name, $args );


	Redux::setSection(
		$opt_name,
		array(
			'title' => __( 'Layout Settings', 'ascend' ),
			'id' => 'layout_settings',
			'header' => '',
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Layout Settings', 'ascend' ) . '</h3></div>',
			'icon' => '',
			'fields' => array(
				array(
					'id' => 'site_layout',
					'type' => 'image_select',

					'title' => __( 'Site Layout Header Style', 'ascend' ),
					'subtitle' => __( 'Select left, above or right header style', 'ascend' ),
					'options' => array(
						'left' => array(
							'alt' => 'Left Layout',
							'img' => OPTIONS_PATH . 'img/left_layout-min.png',
						),
						'above' => array(
							'alt' => 'Above Layout',
							'img' => OPTIONS_PATH . 'img/above_layout-min.png',
						),
						'right' => array(
							'alt' => 'Right Layout',
							'img' => OPTIONS_PATH . 'img/right_layout-min.png',
						),
					),
					'default' => 'above',
				),
				array(
					'id' => 'site_layout_style',
					'type' => 'image_select',

					'title' => __( 'Site Layout Style', 'ascend' ),
					'subtitle' => __( 'Select Normal or Boxed Layout Style', 'ascend' ),
					'options' => array(
						'normal' => array(
							'alt' => 'Normal Layout',
							'img' => OPTIONS_PATH . 'img/wide_layout.png',
						),
						'boxed' => array(
							'alt' => 'Boxed Layout',
							'img' => OPTIONS_PATH . 'img/boxed_layout.png',
						),
							// 'bubbled' => array('alt' => 'Bubbled Layout', 'img' => OPTIONS_PATH.'img/3cm.png'),
					),
					'default' => 'normal',
				),
				array(
					'id' => 'site_max_width',
					'type' => 'select',

					'title' => __( 'Site Layout Max-Width', 'ascend' ),
					'description' => __( 'NOTE: Grids where you choose columns are designed for 1140px width. If you make the width larger the columns may increase beyond what your settings say to fill that much space.', 'ascend' ),
					'options' => array(
						'940'   => __( '940px', 'ascend' ),
						'1140'  => __( '1140px', 'ascend' ),
						'1440'  => __( '1440px', 'ascend' ),
						'1740'  => __( '1740px', 'ascend' ),
						'none'  => __( 'none', 'ascend' ),
					),
					'default' => '1140',
				),
				array(
					'id' => 'sidebar_side',
					'type' => 'select',
					'customizer' => true,
					'title' => __( 'Sidebar Side of page.', 'ascend' ),
					'options' => array(
						'right' => __( 'Right Side', 'ascend' ),
						'left'  => __( 'Left Side', 'ascend' ),
					),
					'default' => 'right',
				),
			),
		)
	);
		Redux::setSection(
			$opt_name,
			array(
				'title' => __( 'Header Settings', 'ascend' ),
				'id' => 'header_settings',
				'header' => '',
				// 'priority'=> '37',
				'customizer_width' => '450px',
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Header Settings', 'ascend' ) . '</h3></div>',
				'icon' => '',
				'fields' => array(
					array(
						'id' => 'beside_header_style',
						'type' => 'select',
						'title' => __( 'Choose Side Header Style', 'ascend' ),
						'options' => array(
							'standard' => 'Logo + Menu + Extras',
							'extras_above_menu' => 'Logo + Extras + Menu',
						),
						'default' => 'standard',
						'width' => 'width:60%',
						'required' => array( 'site_layout', '!=', 'above' ),
					),
					array(
						'id' => 'beside_header_width',
						'type'  => 'slider',
						'title' => __( 'Choose Side Header Width', 'ascend' ),
						'default'   => '240',
						'min'       => '80',
						'step'      => '2',
						'max'       => '400',
						'required' => array( 'site_layout', '!=', 'above' ),
					),
					array(
						'id' => 'second_sticky',
						'type' => 'switch',
						'title' => __( 'Make Secondary Menu Sticky?', 'ascend' ),
						'subtitle' => __( 'To make the secondary menu sticky.', 'ascend' ),
						'default' => 0,
						'required' => array( 'site_layout', '!=', 'above' ),
					),
					array(
						'id' => 'above_header_style',
						'type' => 'image_select',
						'title' => __( 'Choose Header Style', 'ascend' ),
						'options' => array(
							'standard' => array(
								'alt' => 'Logo / Menu + Extras',
								'img' => OPTIONS_PATH . 'img/logo_menu.png',
							),
							'center' => array(
								'alt' => 'Menu / Logo / Menu + Extras',
								'img' => OPTIONS_PATH . 'img/center.png',
							),
							'center_menu' => array(
								'alt' => 'Logo / Menu / Extras',
								'img' => OPTIONS_PATH . 'img/center_menu.png',
							),
							'bylogo' => array(
								'alt' => 'Logo + Menu / Extras',
								'img' => OPTIONS_PATH . 'img/bylogo.png',
							),
							'center_below' => array(
								'alt' => 'Extras / Logo / Extras 2 // Menu',
								'img' => OPTIONS_PATH . 'img/center_below.png',
							),
							'extra_middle' => array(
								'alt' => 'Logo / Extras / Menu / Extras 2',
								'img' => OPTIONS_PATH . 'img/logo_extras_menu_and_extras.png',
							),
						),
						// 'options' => array('standard' => 'Logo / Menu + Extras','center' => 'Menu / Logo / Menu + Extras','center_menu' => 'Logo / Menu / Extras', 'bylogo' => 'Logo + Menu / Extras', 'center_below' => 'Extras / Logo / Extras 2 // Menu'),
						'default' => 'standard',
						'width' => 'width:60%',
						'required' => array( 'site_layout', '=', 'above' ),
					),
					array(
						'id' => 'info_header_center',
						'type' => 'info',
						'desc' => __( '*Note this header style is set with two menus.', 'ascend' ),
						'required' => array(
							array( 'above_header_style', '=', 'center' ),
							array( 'site_layout', '=', 'above' ),
						),
					),
					array(
						'id' => 'info_header_center_below',
						'type' => 'info',
						'desc' => __( '*Note the header extras are split first half on the left and second half on the right.', 'ascend' ),
						'required' => array(
							array( 'above_header_style', '=', 'center_below' ),
							array( 'site_layout', '=', 'above' ),
						),
					),
					array(
						'id'        => 'above_header_logo_width',
						'type'      => 'slider',
						'title'     => __( 'Logo Area % Width', 'ascend' ),
						'default'   => '24',
						'min'       => '2',
						'step'      => '2',
						'max'       => '100',
						'required' => array(
							array( 'above_header_style', 'contains', 'center' ),
							array( 'site_layout', '=', 'above' ),
						),
					),
					array(
						'id'        => 'above_header_height',
						'type'      => 'slider',
						'title'     => __( 'Header Height', 'ascend' ),
						'default'   => '100',
						'min'       => '40',
						'step'      => '2',
						'max'       => '400',
						'required' => array( 'site_layout', '=', 'above' ),
					),
					array(
						'id' => 'sticky_header_parts',
						'type' => 'select',
						'title' => __( 'Enable Sticky Parts of Header?', 'ascend' ),
						'options' => array(
							'none' => 'No',
							'header' => 'Yes - Only Main Header',
							'header_top' => 'Yes - Topbar + Header',
							'header_all' => 'Yes - Topbar + Header + Secondary Menu',
							'topbar' => 'Yes - Only Topbar',
							'secondary' => 'Yes - Only secondary',
						),
						'default' => 'none',
						'width' => 'width:60%',
						'required' => array( 'site_layout', '=', 'above' ),
					),
					array(
						'id' => 'shrinking_header',
						'type' => 'switch',
						'title' => __( 'Enable shrinking header when sticky?', 'ascend' ),
						'subtitle' => __( 'Choose to enable shrinking header when sticky.', 'ascend' ),
						'default'       => 0,
						'required' => array(
							array( 'site_layout', '=', 'above' ),
							array( 'sticky_header_parts', 'contains', 'header' ),
						),
					),
					array(
						'id'        => 'above_header_shrunk_height',
						'type'      => 'slider',
						'title'     => __( 'Header Shrunk Height', 'ascend' ),
						'default'   => '100',
						'min'       => '40',
						'step'      => '2',
						'max'       => '400',
						'required' => array(
							array( 'site_layout', '=', 'above' ),
							array( 'sticky_header_parts', 'contains', 'header' ),
							array( 'shrinking_header', '=', '1' ),
						),
					),
					array(
						'id'            => 'info_header_extras',
						'type'          => 'info',
						'desc'          => __( 'Header Extras', 'ascend' ),
					),
					array(
						'id'       => 'header_extras',
						'type'     => 'sortable',
						'customizer'    => true,
						'title'    => __( 'Enable and Sort Header Extras', 'ascend' ),
						'subtitle' => __( 'Check box to enable and sort for output order (Top First).', 'ascend' ),
						'mode'     => 'checkbox',
						'options'  => array(
							'search'    => __( 'Search', 'ascend' ),
							'login'     => __( 'Login/Register & my-account - Woocommerce Only', 'ascend' ),
							'cart'      => __( 'Mini Cart - Woocommerce Only', 'ascend' ),
							'widget'    => __( 'Widget area - customize in appearance > widgets', 'ascend' ),
							'widget2'    => __( 'Second Widget area - customize in appearance > widgets', 'ascend' ),
						),
						'default' => array(
							'search' => true,
							'login'  => false,
							'cart'   => false,
							'widget' => false,
							'widget2' => false,
						),
					),
					array(
						'id' => 'header_extras_search_woo',
						'type' => 'switch',
						'title' => __( 'Search only Products?', 'ascend' ),
						'subtitle' => __( 'Make the header search only products', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'header_extras_cart',
						'type' => 'switch',
						'title' => __( 'Show "Cart" Text with mini cart icon?', 'ascend' ),
						'subtitle' => __( 'Disabling this will just show the icon.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'header_extras_login_link',
						'type' => 'select',
						'title' => __( 'Extras My Account - Login button links to:', 'ascend' ),
						'subtitle' => __( 'This allows you to have a popup login or direct link to account page.', 'ascend' ),
						'options' => array(
							'popup' => 'Popup with login',
							'link' => 'Link to my-account page',
						),
						'default' => 'popup',
					),
				),

			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'title' => __( 'Logo Settings', 'ascend' ),
				'id' => 'logo_settings',
				'header' => '',
				// 'priority'=> '37',
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Logo Settings', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'logo',
						'type' => 'media',
						'url' => true,
						'title' => __( 'Logo', 'ascend' ),
						'customizer' => true,
						'subtitle' => __( 'Upload your Logo. Use an image at least twice the size of your logo width setting below.', 'ascend' ),
					),
					array(
						'id' => 'logo_width',
						'type' => 'slider',
						'customizer' => true,
						'title' => __( 'Logo width', 'ascend' ),
						'subtitle' => __( 'While this effect the width the height is determined by your uploaded logo ratio. Logo will not overflow header size.', 'ascend' ),
						'default'       => '300',
						'min'       => '10',
						'step'      => '2',
						'max'       => '1200',
					),
					array(
						'id' => 'site_title',
						'type' => 'switch',
						'title' => __( 'Show site title?', 'ascend' ),
						'subtitle' => __( 'Choose if you want your site title to appear in "logo" area.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'font_site_title',
						'type' => 'typography',
						'title' => __( 'Site Title Font', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => true,
						'line-height' => true,
						'letter-spacing' => true,
						'text-align' => false,
						'color' => true,
						'preview' => true,
						'output' => array( '#logo a.brand, #mobile-logo a.brand' ),
						'subtitle' => __( 'Choose size and style your site title', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'color' => '#444444',
							'font-style' => '600',
							'letter-spacing' => '0px',
							'font-size' => '32px',
							'line-height' => '40px',
						),
						'required' => array( 'site_title', '=', '1' ),
					),
					array(
						'id' => 'site_tagline',
						'type' => 'switch',
						'title' => __( 'Show site Tagline?', 'ascend' ),
						'subtitle' => __( 'Choose if you want your site Tagline to appear in "logo" area.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'font_site_tagline',
						'type' => 'typography',
						'title' => __( 'Site Tagline Font', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'line-height' => true,
						'color' => true,
						'preview' => true,
						'output' => array( '.kad-site-tagline' ),
						'subtitle' => __( 'Choose size and style your site tagline', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'color' => '#444444',
							'font-style' => '400',
							'font-size' => '14px',
							'letter-spacing' => '0px',
							'line-height' => '20px',
						),
						'required' => array( 'site_tagline', '=', '1' ),
					),
				),

			)
		);

		Redux::setSection(
			$opt_name,
			array(
				'id' => 'mobile_header_settings',
				'icon' => '',
				// 'priority'=> '37',
				'icon_class' => 'icon-large',
				'title' => __( 'Mobile Header', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Mobile Header Settings', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'mobile_header_layout',
						'type' => 'image_select',
						'title' => __( 'Mobile Header Layout', 'ascend' ),
						'subtitle' => __( 'Select left or center mobile header style.', 'ascend' ),
						'options' => array(
							'left' => array(
								'alt' => 'Left Logo with right menu',
								'img' => OPTIONS_PATH . 'img/mheader_style_left-min.png',
							),
							'center' => array(
								'alt' => 'Center Logo, Right and Left Extras',
								'img' => OPTIONS_PATH . 'img/mheader_style_center-min.png',
							),
						),
						'default' => 'left',
					),
					array(
						'id' => 'mobile_header_height',
						'type' => 'slider',
						'title' => __( 'Mobile header height', 'ascend' ),
						'default'       => '60',
						'min'       => '20',
						'step'      => '2',
						'max'       => '300',
					),
					array(
						'id' => 'mobile_header_sticky',
						'type' => 'switch',
						'title' => __( 'Make the mobile header sticky', 'ascend' ),
						'subtitle' => __( 'This will make the mobile header scroll with the page.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'mobile_logo_options',
						'type' => 'info',
						'desc' => __( 'Mobile Logo Options', 'ascend' ),
					),
					array(
						'id' => 'mobile_logo_switch',
						'type' => 'switch',
						'title' => __( 'Use custom mobile logo options?', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'mobile_logo',
						'type' => 'media',
						'url' => true,
						'title' => __( 'Mobile Logo', 'ascend' ),
						'subtitle' => __( 'Upload your Logo. This should be twice the pixel size needed.', 'ascend' ),
						'required' => array( 'mobile_logo_switch', '=', '1' ),
					),
					array(
						'id' => 'mobile_logo_width',
						'type' => 'slider',
						'title' => __( 'Mobile Logo width', 'ascend' ),
						'subtitle' => __( 'While this effects the width the height is determined by your uploaded logo img ratio and logo will not overflow header size.', 'ascend' ),
						'default'       => '100',
						'min'       => '10',
						'step'      => '2',
						'max'       => '1200',
						'required' => array( 'mobile_logo_switch', '=', '1' ),
					),
					array(
						'id' => 'mobile_site_title',
						'type' => 'switch',
						'title' => __( 'Show site title in mobile?', 'ascend' ),
						'subtitle' => __( 'Choose if you want your site title to appear in "logo" area of the mobile header.', 'ascend' ),
						'default' => 1,
						'required' => array( 'mobile_logo_switch', '=', '1' ),
					),
					array(
						'id' => 'mobile_font_site_title',
						'type' => 'typography',
						'title' => __( 'Mobile Site Title Font Size', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => true,
						'line-height' => true,
						'customizer' => true,
						'text-align' => false,
						'color' => true,
						'preview' => true,
						'output' => array( '#mobile-logo .kad-mobile-site-title' ),
						'subtitle' => __( 'Choose size of your site title on mobile', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'color' => '#444444',
							'font-style' => '400',
							'font-size' => '18px',
							'line-height' => '24px',
						),
						'required' => array(
							array( 'mobile_site_title', '=', '1' ),
							array( 'mobile_logo_switch', '=', '1' ),
						),
					),
					array(
						'id' => 'mobile_site_tagline',
						'type' => 'switch',
						'title' => __( 'Show site Tagline?', 'ascend' ),
						'subtitle' => __( 'Choose if you want your site Tagline to appear in "logo" area.', 'ascend' ),
						'default' => 0,
						'required' => array( 'mobile_logo_switch', '=', '1' ),
					),
					array(
						'id' => 'mobile_font_site_tagline',
						'type' => 'typography',
						'title' => __( 'Site Tagline Font', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => true,
						'text-align' => false,
						'customizer' => true,
						'line-height' => true,
						'color' => true,
						'preview' => true,
						'output' => array( '.kad-mobile-site-tagline' ),
						'subtitle' => __( 'Choose size and style your site tagline', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'color' => '#444444',
							'font-style' => '400',
							'font-size' => '12px',
							'line-height' => '16px',
						),
						'required' => array(
							array( 'mobile_site_tagline', '=', '1' ),
							array( 'mobile_logo_switch', '=', '1' ),
						),
					),
					array(
						'id' => 'mobile_menu_options',
						'type' => 'info',
						'desc' => __( 'Mobile Menu Options', 'ascend' ),
					),
					array(
						'id' => 'mobile_header_menu',
						'type' => 'select',
						'title' => __( 'Mobile Menu Display', 'ascend' ),
						'subtitle' => __( 'Select which side to display the mobile menu', 'ascend' ),
						'options' => array(
							'right' => __( 'Right Side', 'ascend' ),
							'left' => __( 'Left Side', 'ascend' ),
							'none' => __( 'None', 'ascend' ),
						),
						'default' => 'right',
					),
					array(
						'id' => 'mobile_menu_search',
						'type' => 'switch',
						'title' => __( 'Show Search in mobile menu', 'ascend' ),
						'subtitle'  => __( 'Show a search form in the mobile menu', 'ascend' ),
						'default'   => 1,
					),
					array(
						'id' => 'mobile_menu_search_woo',
						'type' => 'switch',
						'title' => __( 'Search only Products?', 'ascend' ),
						'subtitle' => __( 'Make the mobile menu search only products', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'mobile_extras_options',
						'type' => 'info',
						'desc' => __( 'Mobile Header Extras', 'ascend' ),
					),
					array(
						'id' => 'mobile_header_cart',
						'type' => 'select',
						'title' => __( 'Mobile Cart Display', 'ascend' ),
						'subtitle' => __( 'Select to optional display a cart icon', 'ascend' ),
						'options' => array(
							'right' => __( 'Right Side', 'ascend' ),
							'left' => __( 'Left Side', 'ascend' ),
							'none' => __( 'None', 'ascend' ),
						),
						'default' => 'none',
					),
					array(
						'id' => 'mobile_header_account',
						'type' => 'select',
						'title' => __( 'Mobile Account Display', 'ascend' ),
						'subtitle' => __( 'Select to optionally display an account icon', 'ascend' ),
						'options' => array(
							'right' => __( 'Right Side', 'ascend' ),
							'left' => __( 'Left Side', 'ascend' ),
							'none' => __( 'None', 'ascend' ),
						),
						'default' => 'none',
					),
					array(
						'id' => 'mobile_header_search',
						'type' => 'select',
						'title' => __( 'Mobile Search Display', 'ascend' ),
						'subtitle' => __( 'Select to optionally display a search icon', 'ascend' ),
						'options' => array(
							'right' => __( 'Right Side', 'ascend' ),
							'left' => __( 'Left Side', 'ascend' ),
							'none' => __( 'None', 'ascend' ),
						),
						'default' => 'none',
					),
					array(
						'id' => 'mobile_topbar_icons_info',
						'type' => 'info',
						'desc' => __( 'Mobile Top Icon Bar', 'ascend' ),
					),
					array(
						'id' => 'mobile_topbar',
						'type' => 'switch',
						'title' => __( 'Enable Mobile Top Icon Bar', 'ascend' ),
						'default'   => 0,
					),
					array(
						'id' => 'mobile_topbar_icon_height',
						'type' => 'slider',
						'title' => __( 'Mobile Top Icon Bar height', 'ascend' ),
						'default'       => '28',
						'min'       => '20',
						'step'      => '2',
						'max'       => '60',
						'required' => array( 'mobile_topbar', '=', '1' ),
					),
					array(
						'id' => 'mobile_topbar_widget_area',
						'type' => 'switch',
						'title' => __( 'Enable Mobile Top Icon Bar Widget Area', 'ascend' ),
						'default'   => 0,
					),
					array(
						'id' => 'mobile_topbar_icons',
						'type' => 'kad_icons',
						'title' => __( 'Mobile Top Icons', 'ascend' ),
						'subtitle' => __( 'Choose your icons for the top icon bar. Description not used.', 'ascend' ),
						'required' => array( 'mobile_topbar', '=', '1' ),
					),
					array(
						'id' => 'mobile_topbar_icon_title',
						'type' => 'switch',
						'title' => __( 'Show Title beside Icon', 'ascend' ),
						'default'   => 0,
						'required' => array( 'mobile_topbar', '=', '1' ),
					),
					array(
						'id' => 'mobile_topbar_icon_size',
						'type' => 'slider',
						'title' => __( 'Mobile Top Icon Bar Icon Size', 'ascend' ),
						'default'       => '18',
						'min'       => '9',
						'step'      => '1',
						'max'       => '50',
						'required' => array( 'mobile_topbar', '=', '1' ),
					),
					array(
						'id' => 'mobile_topbar_icon_color',
						'type' => 'color',
						'title' => __( 'Mobile Top Icon Bar Icon Color', 'ascend' ),
						'transparent' => false,
						'default' => '',
						'output' => array( 'color' => '.mobile-top-icon-bar a.top-icon-bar-link' ),
						'validate' => 'color',
						'required' => array( 'mobile_topbar', '=', '1' ),
					),
					array(
						'id' => 'mobile_topbar_background_color',
						'type' => 'color',
						'title' => __( 'Mobile Top Icon Bar Background Color', 'ascend' ),
						'transparent' => true,
						'default' => '',
						'output' => array( 'background-color' => '.mobile-top-icon-bar' ),
						'validate' => 'color',
						'required' => array( 'mobile_topbar', '=', '1' ),
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'topbar_header_settings',
				'icon' => '',
				// 'priority'=> '37',
				'icon_class' => 'icon-large',
				'title' => __( 'Topbar Settings', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'topbar_enable_info',
						'type' => 'info',
						'desc' => __( 'The topbar is only for the header above content layout style.', 'ascend' ),
						'required' => array( 'site_layout', '!=', 'above' ),
					),
					array(
						'id' => 'topbar_enable',
						'type' => 'switch',
						'title' => __( 'Enable Topbar', 'ascend' ),
						'subtitle' => __( 'This controls whether on not the topbar is displayed.', 'ascend' ),
						'default' => 0,
						'required' => array( 'site_layout', '=', 'above' ),
					),
					array(
						'id' => 'topbar_height',
						'type' => 'slider',
						'title' => __( 'Topbar height', 'ascend' ),
						'default'       => '36',
						'min'       => '20',
						'step'      => '2',
						'max'       => '200',
						'required' => array( 'site_layout', '=', 'above' ),
					),
					array(
						'id' => 'topbar_font',
						'type' => 'typography',
						'title' => __( 'Topbar font size', 'ascend' ),
						'font-family' => false,
						'google' => false,
						'font-backup' => false,
						'font-style' => false,
						'subsets' => false,
						'font-size' => true,
						'text-align' => false,
						'customizer' => true,
						'line-height' => false,
						'color' => false,
						'preview' => false,
						'output' => array( '.topbarclass' ),
						'subtitle' => __( 'Choose size for topbar text', 'ascend' ),
						'default' => array(
							'font-size' => '12px',
						),
						'required' => array( 'site_layout', '=', 'above' ),
					),
					array(
						'id' => 'topbar_menu_info',
						'type' => 'info',
						'desc' => __( 'Topbar Layout Options', 'ascend' ),
						'required' => array( 'site_layout', '=', 'above' ),
					),
					array(
						'id' => 'topbar_menu_location',
						'type' => 'select',
						'title' => __( 'Topbar Menu Location', 'ascend' ),
						'subtitle' => __( 'Select which side to display the topbar menu', 'ascend' ),
						'description' => __( 'Note menu is set up in appearance > menus page', 'ascend' ),
						'options' => array(
							'right' => __( 'Right Side', 'ascend' ),
							'left' => __( 'Left Side', 'ascend' ),
							'none' => __( 'None', 'ascend' ),
						),
						'default' => 'right',
						'required' => array( 'site_layout', '=', 'above' ),
					),
					array(
						'id' => 'topbar_search',
						'type' => 'select',
						'title' => __( 'Search Icon Display', 'ascend' ),
						'subtitle' => __( 'Select to optionally display a search icon in topbar', 'ascend' ),
						'options' => array(
							'right' => __( 'Right Side', 'ascend' ),
							'left' => __( 'Left Side', 'ascend' ),
							'none' => __( 'None', 'ascend' ),
						),
						'default' => 'none',
						'required' => array( 'site_layout', '=', 'above' ),
					),
					array(
						'id' => 'topbar_cart',
						'type' => 'select',
						'title' => __( 'Cart Icon Display', 'ascend' ),
						'subtitle' => __( 'Select to optionally display a cart icon in topbar - woocommerce only', 'ascend' ),
						'options' => array(
							'right' => __( 'Right Side', 'ascend' ),
							'left' => __( 'Left Side', 'ascend' ),
							'none' => __( 'None', 'ascend' ),
						),
						'default' => 'none',
						'required' => array( 'site_layout', '=', 'above' ),
					),
					array(
						'id' => 'topbar_cart_label',
						'type' => 'switch',
						'title' => __( 'Show "Cart" Text with mini cart icon?', 'ascend' ),
						'subtitle' => __( 'Disabling this will just show the icon.', 'ascend' ),
						'default' => 1,
						// 'class' => 'kt_sub_field',
						'required' => array( 'site_layout', '=', 'above' ),
					),
					array(
						'id' => 'topbar_account',
						'type' => 'select',
						'title' => __( 'Account/Login Display', 'ascend' ),
						'subtitle' => __( 'Select to optionally display an account menu item in topbar - woocommerce only', 'ascend' ),
						'options' => array(
							'right' => __( 'Right Side', 'ascend' ),
							'left' => __( 'Left Side', 'ascend' ),
							'none' => __( 'None', 'ascend' ),
						),
						'default' => 'none',
						'required' => array( 'site_layout', '=', 'above' ),
					),
					array(
						'id' => 'topbar_extras_login_link',
						'type' => 'select',
						'title' => __( 'Topbar My Account - Login button links to:', 'ascend' ),
						'subtitle' => __( 'This allows you to have a popup login or direct link to account page.', 'ascend' ),
						'options' => array(
							'popup' => 'Popup with login',
							'link' => 'Link to my-account page',
						),
						'default' => 'popup',
					),
					/*
					Currently Disabled
					array(
					'id'=>'topbar_widget_popup',
					 'type' => 'select',
					'title' => __('Custom icon or text that links to widget area popup.', 'ascend'),
					'subtitle' => __('Select to optionally display an custom icon or text in topbar that leads to widget area.', 'ascend'),
					'description' => __('Note content of widget area is assigned in apperance > widgets page.', 'ascend'),
					'options' => array(
						'right' => __('Right Side', 'ascend'),
						'left' => __('Left Side', 'ascend'),
						'none' => __('None', 'ascend'),
						),
					'default' => 'none',
					'required' => array('site_layout','=','above'),
					),
					array(
					'id'=>'topbar_widget_popup_text',
					'type' => 'text',
					'title' => __('Optionally add text', 'ascend'),
					'subtitle' => __('Select to optionally use text for custom topbar popup link', 'ascend'),
					'default' => '',
					'class' => 'kt_sub_field',
					'required' => array('site_layout','=','above'),
					),
					array(
					'id'=>'topbar_widget_popup_icon',
					'type' => 'select',
					'title' => __('Optionally select an icon', 'ascend'),
					'subtitle' => __('Select to optionally use an icon for custom topbar popup link', 'ascend'),
					'data' => 'font-icons',
					'class' => 'kt_sub_field font-icons',
					'default' => 'none',
					'required' => array('site_layout','=','above'),
					),
					*/
					array(
						'id' => 'topbar_widget_area',
						'type' => 'select',
						'title' => __( 'Topbar Widget area', 'ascend' ),
						'subtitle' => __( 'Select to optionally display a widget area in topbar', 'ascend' ),
						'options' => array(
							'right' => __( 'Right Side', 'ascend' ),
							'left' => __( 'Left Side', 'ascend' ),
							'none' => __( 'None', 'ascend' ),
						),
						'default' => 'none',
						'required' => array( 'site_layout', '=', 'above' ),
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'footer',
				'title' => __( 'Footer Settings', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Footer Layout', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'footer_layout',
						'type' => 'image_select',
						'title' => __( 'Footer Widget Layout', 'ascend' ),
						'subtitle' => __( 'Select how many columns for footer widgets', 'ascend' ),
						'options' => array(
							'fourc' => array(
								'alt' => 'Four Column Layout',
								'img' => OPTIONS_PATH . 'img/footer-widgets-4.png',
							),
							'threec' => array(
								'alt' => 'Three Column Layout',
								'img' => OPTIONS_PATH . 'img/footer-widgets-3.png',
							),
							'twoc' => array(
								'alt' => 'Two Column Layout',
								'img' => OPTIONS_PATH . 'img/footer-widgets-2.png',
							),
							'four_single' => array(
								'alt' => 'One column with three below Layout',
								'img' => OPTIONS_PATH . 'img/footer-widgets-4-single.png',
							),
							'three_single' => array(
								'alt' => 'One column with two below Layout',
								'img' => OPTIONS_PATH . 'img/footer-widgets-3-single.png',
							),
						),
						'default' => 'fourc',
					),
					array(
						'id' => 'footer_extra_enable',
						'type' => 'switch',
						'title' => __( 'Enable an Extra Footer widget area above the footer', 'ascend' ),
						'subtitle' => __( 'This adds an extra footer widget area above the existing footer.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'footer_text',
						'type' => 'textarea',
						'title' => __( 'Footer Copyright Text', 'ascend' ),
						'subtitle' => __( 'Write your own copyright text here. You can use the following shortcodes in your footer text: [copyright] [site-name] [the-year]', 'ascend' ),
						'default' => '[copyright] [the-year] [site-name] [theme-credit]',
					),

				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'transparent_header_options',
				'title' => __( 'Transparent Header Options', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'page_trans_default',
						'type' => 'switch',
						'title' => __( 'Enable Transparent header until scrolled by default?', 'ascend' ),
						'subtitle' => __( 'This will make the page header background fill to the top of the page.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'trans_header_background_transparency',
						'type' => 'select',
						'title' => __( 'Select Transparency', 'ascend' ),
						'options' => array(
							'1' => '1',
							'0.9' => '0.9',
							'0.8' => '0.8',
							'0.7' => '0.7',
							'0.6' => '0.6',
							'0.5' => '0.5',
							'0.4' => '0.4',
							'0.3' => '0.3',
							'0.2' => '0.2',
							'0.1' => '0.1',
							'0' => '0',
						),
						'default' => '0',
						'width' => 'width:60%',
					),
					array(
						'id' => 'trans_header_menu_color',
						'type' => 'color',
						'title' => __( 'Menu Text Color (For Transparent Header)', 'ascend' ),
						'subtitle' => __( 'Choose the font color of the menu font while background is transparent.', 'ascend' ),
						'transparent' => false,
						'default' => '',
						'validate' => 'color',
						'output'    => array(
							'color' => 'body.trans-header div:not(.is-sticky) > .headerclass-outer div:not(.is-sticky) > .kad-header-topbar-primary-outer div:not(.is-sticky) > .headerclass .nav-main ul.sf-menu > li > a, body.trans-header div:not(.is-sticky) > .headerclass-outer div:not(.is-sticky) > .kad-header-topbar-primary-outer div:not(.is-sticky) > .headerclass .kt-header-extras ul.sf-menu > li > a, body.trans-header div:not(.is-sticky) > .headerclass-outer div:not(.is-sticky) > .kad-header-topbar-primary-outer div:not(.is-sticky) > .headerclass .kt-header-extras .kt-extras-label [class*="kt-icon-"], body.trans-header div:not(.is-sticky) > .headerclass-outer div:not(.is-sticky) > .kad-header-topbar-primary-outer div:not(.is-sticky) > .headerclass .kt-header-extras .kadence_social_widget a, body.trans-header div:not(.is-sticky) > .headerclass-outer div:not(.is-sticky) > .second-navclass .sf-menu > li > a, body.trans-header div:not(.is-sticky) > .mobile-headerclass .kt-mobile-header-toggle button',
							'background' => 'body.trans-header div:not(.is-sticky) > .headerclass-outer div:not(.is-sticky) > .second-navclass  .sf-menu>li:after, body.trans-header div:not(.is-sticky) > .mobile-headerclass .kt-mnt span',
						),
					),
					array(
						'id' => 'trans_header_menu_color_hover',
						'type' => 'color',
						'title' => __( 'Menu Text Hover Color (For Transparent Header)', 'ascend' ),
						'subtitle' => __( 'Choose the font color of the menu while mouse is hovering over.', 'ascend' ),
						'transparent' => false,
						'default' => '',
						'validate' => 'color',
						'output'    => array( 'color' => 'body.trans-header div:not(.is-sticky) > .headerclass-outer div:not(.is-sticky) > .kad-header-topbar-primary-outer div:not(.is-sticky) > .headerclass .nav-main ul.sf-menu > li > a:hover, body.trans-header div:not(.is-sticky) > .headerclass-outer div:not(.is-sticky) > .kad-header-topbar-primary-outer div:not(.is-sticky) > .headerclass .kt-header-extras ul.sf-menu > li > a:hover, body.trans-header div:not(.is-sticky) > .headerclass-outer div:not(.is-sticky) > .kad-header-topbar-primary-outer div:not(.is-sticky) > .headerclass .kt-header-extras .kt-extras-label:hover [class*="kt-icon-"], body.trans-header div:not(.is-sticky) > .headerclass-outer div:not(.is-sticky) > .kad-header-topbar-primary-outer div:not(.is-sticky) > .headerclass .kt-header-extras .kadence_social_widget a, body.trans-header div:not(.is-sticky) > .headerclass-outer div:not(.is-sticky) > .second-navclass .sf-menu > li > a:hover, body.trans-header div:not(.is-sticky) > .mobile-headerclass .kt-mobile-header-toggle button:hover' ),
					),
					array(
						'id' => 'trans_header_border_color',
						'type' => 'color',
						'title' => __( 'Border Color (For Transparent Header)', 'ascend' ),
						'subtitle' => __( 'Choose the color of bottom border while background is transparent.', 'ascend' ),
						'transparent' => true,
						'default' => '',
						'output' => array( 'border-color' => 'body.trans-header div:not(.is-sticky) > #kad-header-menu, body.trans-header div:not(.is-sticky) > #kad-mobile-banner,  body.trans-header:not(.kad-header-position-above) .outside-second' ),
						'validate' => 'color',
					),
					array(
						'id' => 'trans_site_title_color',
						'type' => 'color',
						'title' => __( 'Site title font Color (For Transparent Header)', 'ascend' ),
						'subtitle' => __( 'Choose the font color for the site title while background is transparent.', 'ascend' ),
						'transparent' => false,
						'validate' => 'color',
						'default' => '',
						'output'    => array( 'body.trans-header div:not(.is-sticky) > .headerclass-outer div:not(.is-sticky) > .kad-header-topbar-primary-outer div:not(.is-sticky) > .headerclass #logo a.brand, body.trans-header div:not(.is-sticky) > .mobile-headerclass .kad-site-tagline, body.trans-header div:not(.is-sticky) > .mobile-headerclass #mobile-logo a, body.trans-header div:not(.is-sticky) > .mobile-headerclass #mobile-logo .kad-mobile-site-title' ),
					),
					array(
						'id' => 'trans_site_tagline_color',
						'type' => 'color',
						'title' => __( 'Site tagline font Color (For Transparent Header)', 'ascend' ),
						'subtitle' => __( 'Choose the font color for the site tagline while background is transparent.', 'ascend' ),
						'transparent' => false,
						'validate' => 'color',
						'default' => '',
						'output'    => array( ' body.trans-header div:not(.is-sticky) > .mobile-headerclass .kad-mobile-site-tagline, body.trans-header div:not(.is-sticky) > .headerclass-outer div:not(.is-sticky) > .kad-header-topbar-primary-outer div:not(.is-sticky) > .headerclass .kad-site-tagline' ),
					),
					array(
						'id' => 'trans_logo',
						'type' => 'media',
						'url' => true,
						'title' => __( 'Optional Replacement Logo (For Transparent Header)', 'ascend' ),
						'subtitle' => __( 'Upload your Logo.', 'ascend' ),
					),
					array(
						'id' => 'trans_logo_mobile',
						'type' => 'media',
						'url' => true,
						'title' => __( 'Optional Replacement Mobile Logo (For Transparent Header)', 'ascend' ),
						'subtitle' => __( 'Upload your Logo.', 'ascend' ),
						'required' => array( 'mobile_logo_switch', '=', '1' ),
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'page_title',
				'title' => __( 'Default Title Options', 'ascend' ),
				'fields' => array(
					array(
						'id'        => 'pageheader_background',
						'type'      => 'background',
						'output'    => array( '.titleclass' ),
						'default'  => array(
							'background-color' => '#444',
						),
						'title'     => __( 'Header Title Default Background', 'ascend' ),
					),
					array(
						'id' => 'pagetitle_background_parallax',
						'type' => 'switch',
						'title' => __( 'Enable Parallax for Default Background.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'pagetitle_color',
						'type' => 'color',
						'title' => __( 'Header Title Default Color', 'ascend' ),
						'transparent' => false,
						'validate' => 'color',
						'default' => '#ffffff',
						'output'    => array( '.titleclass .top-contain-title' ),
					),
					array(
						'id' => 'single_header_title_size',
						'type' => 'slider',
						'title' => __( 'Header Title Font Size', 'ascend' ),
						'default'       => '70',
						'min'       => '10',
						'step'      => '1',
						'max'       => '200',
					),
					array(
						'id' => 'single_header_title_size_small',
						'type' => 'slider',
						'title' => __( 'Smaller Device Title font size', 'ascend' ),
						'default'       => '30',
						'min'       => '5',
						'step'      => '1',
						'max'       => '200',
					),
					array(
						'id' => 'pagetitle_uppercase',
						'type' => 'switch',
						'title' => __( 'Enable Text transform "uppercase" for page title.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'pagesubtitle_color',
						'type' => 'color',
						'title' => __( 'Header Subtitle Default Color', 'ascend' ),
						'transparent' => false,
						'validate' => 'color',
						'default' => '#ffffff',
						'output'    => array( '.titleclass .subtitle, .titleclass .page-header-inner #kadbreadcrumbs, .titleclass .page-header-inner #kadbreadcrumbs a' ),
					),
					array(
						'id' => 'single_header_subtitle_size',
						'type' => 'slider',
						'title' => __( 'Header Subtitle Font Size', 'ascend' ),
						'default'       => '40',
						'min'       => '10',
						'step'      => '1',
						'max'       => '200',
					),
					array(
						'id' => 'single_header_subtitle_size_small',
						'type' => 'slider',
						'title' => __( 'Smaller Device Subtitle Font Size', 'ascend' ),
						'default'       => '20',
						'min'       => '5',
						'step'      => '1',
						'max'       => '200',
					),
					array(
						'id' => 'pagesubtitle_uppercase',
						'type' => 'switch',
						'title' => __( 'Enable Text transform "uppercase" for page subtitle.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'pagetitle_align',
						'type' => 'select',
						'customizer' => true,
						'title' => __( 'Header Title Default Align', 'ascend' ),
						'options' => array(
							'center' => __( 'Center', 'ascend' ),
							'left' => __( 'Left', 'ascend' ),
							'right' => __( 'Right', 'ascend' ),
						),
						'default' => 'center',
						'width' => 'width:60%',
					),
					array(
						'id' => 'page_title_height',
						'type' => 'slider',
						'title' => __( 'Header Title Default Height', 'ascend' ),
						'default'       => '360',
						'min'       => '20',
						'step'      => '5',
						'max'       => '1500',
					),
					array(
						'id' => 'page_title_height_min',
						'type' => 'slider',
						'title' => __( 'Smaller Device Title Height', 'ascend' ),
						'default'       => '360',
						'min'       => '20',
						'step'      => '5',
						'max'       => '1500',
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'home_header_section',
				'title' => __( 'Home Page Header', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Home Page Header Content', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'home_header',
						'type' => 'select',
						'title' => __( 'Choose home page header settings', 'ascend' ),
						'options' => array(
							'pagetitle' => __( 'Page Title', 'ascend' ),
							'basic' => __( 'Basic Slider', 'ascend' ),
							'ksp' => __( 'Kadence Slider Pro', 'ascend' ),
							'shortcode' => __( 'Shortcode Entry', 'ascend' ),
							'basic_post_carousel' => __( 'Post Carousel', 'ascend' ),
							'none' => __( 'None', 'ascend' ),
						),
						'default' => 'pagetitle',
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_transheader',
						'type' => 'select',
						'title' => __( 'Transparent Header on Home page?', 'ascend' ),
						'options' => array(
							'default' => __( 'Default', 'ascend' ),
							'true' => __( 'True', 'ascend' ),
							'false' => __( 'False', 'ascend' ),
						),
						'default' => 'default',
						'width' => 'width:60%',
						'required' => array( 'home_header', '!=', 'none' ),
					),
					array(
						'id' => 'home_page_title_typed_text',
						'type' => 'switch',
						'title' => __( 'Enable Typed Text instead of standard', 'ascend' ),
						'default'  => 0,
						'required' => array( 'home_header', '=', 'pagetitle' ),
					),
					array(
						'id' => 'home_page_title_typed',
						'type' => 'multi_text',
						'title' => __( 'Home Page Title Typed Text', 'ascend' ),
						'default' => 'Welcome to [site-name]',
						'required' => array(
							array( 'home_header', '=', 'pagetitle' ),
							array( 'home_page_title_typed_text', '=', '1' ),
						),
					),
					array(
						'id' => 'home_page_title_typed_text_delay',
						'type' => 'slider',
						'title' => __( 'Typed Text Delay', 'ascend' ),
						'subtitle' => __( 'In milliseconds', 'ascend' ),
						'default'  => '500',
						'min'       => '100',
						'step'      => '10',
						'max'       => '8000',
						'required' => array(
							array( 'home_header', '=', 'pagetitle' ),
							array( 'home_page_title_typed_text', '=', '1' ),
						),
					),
					array(
						'id' => 'home_page_title_typed_text_loop',
						'type' => 'switch',
						'title' => __( 'Enable Typed Loop', 'ascend' ),
						'default'  => 1,
						'required' => array(
							array( 'home_header', '=', 'pagetitle' ),
							array( 'home_page_title_typed_text', '=', '1' ),
						),
					),
					array(
						'id' => 'home_page_title',
						'type' => 'textarea',
						'title' => __( 'Home Page Title', 'ascend' ),
						'default' => 'Welcome to [site-name]',
						'required' => array(
							array( 'home_header', '=', 'pagetitle' ),
							array( 'home_page_title_typed_text', '=', '0' ),
						),
					),
					array(
						'id' => 'home_page_sub_title',
						'type' => 'textarea',
						'title' => __( 'Home Page SubTitle', 'ascend' ),
						'subtitle' => __( 'optional text below home page title', 'ascend' ),
						'default' => '[site-tagline]',
						'required' => array( 'home_header', '=', 'pagetitle' ),
					),
					array(
						'id' => 'home_basic_slider_type',
						'type' => 'select',
						'title' => __( 'Basic Slider Type', 'ascend' ),
						'options' => array(
							'equal-ratio' => __( 'Equal Ratio Images', 'ascend' ),
							'different-ratio' => __( 'Different Ratio Images', 'ascend' ),
							'fullwidth' => __( 'Forced Fullwidth Images', 'ascend' ),
							'thumb' => __( 'Thumbnails', 'ascend' ),
							'carousel' => __( 'Images in Carousel', 'ascend' ),
						),
						'default' => 'equal-ratio',
						'width' => 'width:60%',
						'required' => array( 'home_header', '=', 'basic' ),
					),
					array(
						'id' => 'home_post_carousel_type',
						'type' => 'select',
						'title' => __( 'Post Carousel Type', 'ascend' ),
						'options' => array(
							'post' => __( 'Blog Posts', 'ascend' ),
							'portfolio' => __( 'Portfolio Posts', 'ascend' ),
							'product' => __( 'Products', 'ascend' ),
						),
						'default' => 'post',
						'width' => 'width:60%',
						'required' => array( 'home_header', '=', 'basic_post_carousel' ),
					),
					array(
						'id' => 'home_post_carousel_post_cat',
						'type' => 'select',
						'data' => 'terms',
						'args' => array(
							'taxonomies' => 'category',
							'args' => array(),
						),
						'title' => __( 'Blog Post Carousel Category Type', 'ascend' ),
						'subtitle' => __( 'Leave blank to select all types', 'ascend' ),
						'width' => 'width:60%',
						'required' => array(
							array( 'home_header', '=', 'basic_post_carousel' ),
							array( 'home_post_carousel_type', '=', 'post' ),
						),
					),
					array(
						'id' => 'home_post_carousel_portfolio_cat',
						'type' => 'select',
						'data' => 'terms',
						'args' => array(
							'taxonomies' => 'portfolio-type',
							'args' => array(),
						),
						'title' => __( 'Portfolio Carousel Category Type', 'ascend' ),
						'subtitle' => __( 'Leave blank to select all types', 'ascend' ),
						'width' => 'width:60%',
						'required' => array(
							array( 'home_header', '=', 'basic_post_carousel' ),
							array( 'home_post_carousel_type', '=', 'portfolio' ),
						),
					),
					array(
						'id' => 'home_post_carousel_product_cat',
						'type' => 'select',
						'data' => 'terms',
						'args' => array(
							'taxonomies' => 'product_cat',
							'args' => array(),
						),
						'title' => __( 'Product Carousel Category Type', 'ascend' ),
						'subtitle' => __( 'Leave blank to select all types', 'ascend' ),
						'width' => 'width:60%',
						'required' => array(
							array( 'home_header', '=', 'basic_post_carousel' ),
							array( 'home_post_carousel_type', '=', 'product' ),
						),
					),
					array(
						'id' => 'home_post_carousel_items',
						'type' => 'slider',
						'title' => __( 'Home Post Carousel max items', 'ascend' ),
						'default'       => '8',
						'min'       => '4',
						'step'      => '1',
						'max'       => '28',
						'required' => array( 'home_header', '=', 'basic_post_carousel' ),
					),
					array(
						'id' => 'home_post_carousel_orderby',
						'type' => 'select',
						'title' => __( 'Post Carousel Order by:', 'ascend' ),
						'options' => array(
							'date' => __( 'Date', 'ascend' ),
							'menu_order' => __( 'Menu Order', 'ascend' ),
							'title' => __( 'Title', 'ascend' ),
						),
						'default' => 'date',
						'width' => 'width:60%',
						'required' => array( 'home_header', '=', 'basic_post_carousel' ),
					),
					array(
						'id' => 'home_post_carousel_order',
						'type' => 'select',
						'title' => __( 'Post Carousel Order', 'ascend' ),
						'options' => array(
							'DESC' => __( 'Descending', 'ascend' ),
							'ASC' => __( 'Ascending', 'ascend' ),
						),
						'default' => 'DESC',
						'width' => 'width:60%',
						'required' => array( 'home_header', '=', 'basic_post_carousel' ),
					),
					array(
						'id' => 'home_carousel_height',
						'type' => 'slider',
						'title' => __( 'Carousel Max Height', 'ascend' ),
						'subtitle' => __( 'Note: does not work if images are smaller than max.', 'ascend' ),
						'default'       => '400',
						'min'       => '100',
						'step'      => '5',
						'max'       => '1000',
						'required' => array( 'home_header', '=', 'basic_post_carousel' ),
					),
					array(
						'id' => 'home_basic_slider',
						'type' => 'kad_slides',
						'title' => __( 'Basic Slider Images', 'ascend' ),
						'subtitle' => __( 'Use large images for best results.', 'ascend' ),
						'required' => array( 'home_header', '=', 'basic' ),
					),
					array(
						'id' => 'slider_size',
						'type' => 'slider',
						'title' => __( 'Slider Max Height', 'ascend' ),
						'subtitle' => __( 'Note: does not work if images are smaller than max.', 'ascend' ),
						'default'       => '400',
						'min'       => '100',
						'step'      => '5',
						'max'       => '1000',
						'required' => array( 'home_header', '=', 'basic' ),
					),
					array(
						'id' => 'slider_size_width',
						'type' => 'slider',
						'title' => __( 'Slider Max Width', 'ascend' ),
						'subtitle' => __( 'Note: does not work if images are smaller than max.', 'ascend' ),
						'default'       => '1140',
						'min'       => '600',
						'step'      => '5',
						'max'       => '2400',
						'required' => array(
							array( 'home_header', '=', 'basic' ),
							array( 'home_basic_slider_type', '!=', 'different-ratio' ),
							array( 'home_basic_slider_type', '!=', 'carousel' ),
							array( 'home_basic_slider_type', '!=', 'fullwidth' ),
						),
					),
					array(
						'id' => 'slider_captions',
						'type' => 'switch',
						'title' => __( 'Show Captions?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide captions', 'ascend' ),
						'default'       => 1,
						'required' => array( 'home_header', '=', 'basic' ),
					),
					array(
						'id' => 'home_page_title_color',
						'type' => 'color',
						'title' => __( 'Title Color', 'ascend' ),
						'subtitle' => __( 'Choose the title color', 'ascend' ),
						'transparent' => false,
						'output'    => array( 'color' => '.home .titleclass .entry-title' ),
						'required' => array(
							array( 'home_header', '!=', 'shortcode' ),
							array( 'home_header', '!=', 'ksp' ),
							array( 'home_header', '!=', 'basic_post_carousel' ),
							array( 'home_header', '!=', 'none' ),
						),
					),
					array(
						'id' => 'home_page_title_max_size',
						'type' => 'text',
						'title' => __( 'Home Page Title Font size', 'ascend' ),
						'validate' => 'numeric',
						'subtitle' => __( '*Number Only', 'ascend' ),
						'required' => array(
							array( 'home_header', '!=', 'shortcode' ),
							array( 'home_header', '!=', 'ksp' ),
							array( 'home_header', '!=', 'basic_post_carousel' ),
							array( 'home_header', '!=', 'none' ),
						),
					),
					array(
						'id' => 'home_page_title_min_size',
						'type' => 'text',
						'title' => __( 'Smaller Device - Title Font Size', 'ascend' ),
						'subtitle' => __( '*Number Only', 'ascend' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'home_header', '!=', 'shortcode' ),
							array( 'home_header', '!=', 'ksp' ),
							array( 'home_header', '!=', 'basic_post_carousel' ),
							array( 'home_header', '!=', 'none' ),
						),
					),
					array(
						'id' => 'home_page_subtitle_color',
						'type' => 'color',
						'title' => __( 'Subtitle Color', 'ascend' ),
						'subtitle' => __( 'Choose the subtitle color.', 'ascend' ),
						'output'    => array( 'color' => '.home .titleclass .subtitle' ),
						'transparent' => false,
						'required' => array(
							array( 'home_header', '!=', 'shortcode' ),
							array( 'home_header', '!=', 'ksp' ),
							array( 'home_header', '!=', 'basic_post_carousel' ),
							array( 'home_header', '!=', 'none' ),
						),
					),
					array(
						'id' => 'home_page_subtitle_max_size',
						'type' => 'text',
						'title' => __( 'Home Page Subtitle Font size', 'ascend' ),
						'validate' => 'numeric',
						'subtitle' => __( '*Number Only', 'ascend' ),
						'required' => array(
							array( 'home_header', '!=', 'shortcode' ),
							array( 'home_header', '!=', 'ksp' ),
							array( 'home_header', '!=', 'basic_post_carousel' ),
							array( 'home_header', '!=', 'none' ),
						),
					),
					array(
						'id' => 'home_page_subtitle_min_size',
						'type' => 'text',
						'title' => __( 'Smaller Device - Subtitle Font Size', 'ascend' ),
						'subtitle' => __( '*Number Only', 'ascend' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'home_header', '!=', 'shortcode' ),
							array( 'home_header', '!=', 'ksp' ),
							array( 'home_header', '!=', 'basic_post_carousel' ),
							array( 'home_header', '!=', 'none' ),
						),
					),
					array(
						'id' => 'home_page_title_align',
						'type' => 'select',
						'title' => __( 'Text align', 'ascend' ),
						'options' => array(
							'center' => __( 'Center', 'ascend' ),
							'left' => __( 'Left', 'ascend' ),
							'right' => __( 'Right', 'ascend' ),
						),
						'default' => 'center',
						'width' => 'width:60%',
						'required' => array(
							array( 'home_header', '!=', 'shortcode' ),
							array( 'home_header', '!=', 'ksp' ),
							array( 'home_header', '!=', 'basic_post_carousel' ),
							array( 'home_header', '!=', 'none' ),
						),
					),
					array(
						'id' => 'home_page_title_height',
						'type' => 'slider',
						'title' => __( 'Home Page Title Height', 'ascend' ),
						'default'       => '360',
						'min'       => '20',
						'step'      => '5',
						'max'       => '1500',
						'required' => array( 'home_header', '=', 'pagetitle' ),
					),
					array(
						'id' => 'home_page_title_height_min',
						'type' => 'slider',
						'title' => __( 'Smaller Device Title Height', 'ascend' ),
						'default'       => '360',
						'min'       => '20',
						'step'      => '5',
						'max'       => '1500',
						'required' => array( 'home_header', '=', 'pagetitle' ),
					),
					array(
						'id'        => 'home_pagetitle_background',
						'type'      => 'background',
						'required' => array( 'home_header', '=', 'pagetitle' ),
					),
					array(
						'id' => 'home_page_title_parallax',
						'type' => 'switch',
						'title' => __( 'Enable background parallax', 'ascend' ),
						'default'  => 0,
						'required' => array( 'home_header', '=', 'pagetitle' ),
					),
					array(
						'id' => 'home_ksp_slider',
						'type' => 'select',
						'title' => __( 'If Kadence Slider Pro', 'ascend' ),
						'subtitle' => __( 'Choose your Kadence Slider Pro Here', 'ascend' ),
						'options' => $of_ksp,
						'default' => 'select',
						'width' => 'width:60%',
						'required' => array( 'home_header', '=', 'ksp' ),
					),
					array(
						'id' => 'home_shortcode_entry',
						'type' => 'text',
						'title' => __( 'Shortcode Entry', 'ascend' ),
						'subtitle' => __( 'Paste shortcode here', 'ascend' ),
						'required' => array( 'home_header', '=', 'shortcode' ),
					),
					array(
						'id' => 'slider_autoplay',
						'type' => 'switch',
						'title' => __( 'Auto Play?', 'ascend' ),
						'subtitle' => __( 'This determines if a slider automatically scrolls', 'ascend' ),
						'default'       => 1,
						'required' => array( 'home_header', 'contains', 'basic' ),
					),
					array(
						'id' => 'slider_pausetime',
						'type' => 'slider',
						'title' => __( 'Slider Pause Time', 'ascend' ),
						'subtitle' => __( 'How long to pause on each slide, in milliseconds.', 'ascend' ),
						'default'       => '7000',
						'min'       => '3000',
						'step'      => '1000',
						'max'       => '12000',
						'required' => array( 'home_header', 'contains', 'basic' ),
					),
					array(
						'id' => 'trans_type',
						'type' => 'select',
						'title' => __( 'Transition Type', 'ascend' ),
						'subtitle' => __( 'Choose a transition type', 'ascend' ),
						'options' => array(
							'true' => __( 'Fade', 'ascend' ),
							'false' => __( 'Slide', 'ascend' ),
						),
						'default' => 'true',
						'required' => array(
							array( 'home_header', '=', 'basic' ),
							array( 'home_basic_slider_type', '!=', 'carousel' ),
						),
					),
					array(
						'id' => 'slider_transtime',
						'type' => 'slider',
						'title' => __( 'Slider Transition Time', 'ascend' ),
						'subtitle' => __( 'How long for slide transitions, in milliseconds.', 'ascend' ),
						'default'       => '600',
						'min'       => '200',
						'step'      => '100',
						'max'       => '1200',
						'required' => array( 'home_header', 'contains', 'basic' ),
					),
				),
			)
		);

		Redux::setSection(
			$opt_name,
			array(
				'id' => 'home_mobile_slider',
				'title' => __( 'Mobile Home Header', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Create a simpler home page header for your mobile visitors.', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'mobile_switch',
						'type' => 'switch',
						'title' => __( 'Would you like to use this feature?', 'ascend' ),
						'subtitle' => __( 'Choose if you would like to show a different home page header content for your mobile visitors.', 'ascend' ),
						'default'       => 0,
					),
					array(
						'id' => 'mobile_tablet_show',
						'type' => 'switch',
						'title' => __( 'Show for tablet also?', 'ascend' ),
						'subtitle' => __( 'Choose if you would like to show the mobile home page header for tablets also.', 'ascend' ),
						'default'       => 0,
						'required' => array( 'mobile_switch', '=', '1' ),
					),
					array(
						'id' => 'home_mobile_header',
						'type' => 'select',
						'title' => __( 'Choose home page header settings', 'ascend' ),
						'options' => array(
							'pagetitle' => __( 'Page Title', 'ascend' ),
							'basic' => __( 'Basic Slider', 'ascend' ),
							'ksp' => __( 'Kadence Slider Pro', 'ascend' ),
							'shortcode' => __( 'Shortcode Entry', 'ascend' ),
							'none' => __( 'None', 'ascend' ),
						),
						'default' => 'pagetitle',
						'width' => 'width:60%',
						'required' => array( 'mobile_switch', '=', '1' ),
					),
					array(
						'id' => 'home_mobile_page_title_typed_text',
						'type' => 'switch',
						'title' => __( 'Enable Typed Text instead of standard', 'ascend' ),
						'default'  => 0,
						'required' => array( 'home_mobile_header', '=', 'pagetitle' ),
					),
					array(
						'id' => 'home_mobile_page_title_typed',
						'type' => 'multi_text',
						'title' => __( 'Home Page Title Typed Text', 'ascend' ),
						'default' => 'Welcome to [site-name]',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'pagetitle' ),
							array( 'home_mobile_page_title_typed_text', '=', '1' ),
						),
					),
					array(
						'id' => 'home_mobile_page_title_typed_text_delay',
						'type' => 'slider',
						'title' => __( 'Typed Text Delay', 'ascend' ),
						'subtitle' => __( 'In milliseconds', 'ascend' ),
						'default'  => '500',
						'min'       => '100',
						'step'      => '10',
						'max'       => '8000',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'pagetitle' ),
							array( 'home_mobile_page_title_typed_text', '=', '1' ),
						),
					),
					array(
						'id' => 'home_mobile_page_title_typed_text_loop',
						'type' => 'switch',
						'title' => __( 'Enable Typed Loop', 'ascend' ),
						'default'  => 1,
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'pagetitle' ),
							array( 'home_mobile_page_title_typed_text', '=', '1' ),
						),
					),
					array(
						'id' => 'home_mobile_page_title',
						'type' => 'textarea',
						'title' => __( 'Home Page Title', 'ascend' ),
						'default' => 'Welcome to [site-name]',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'pagetitle' ),
							array( 'home_mobile_page_title_typed_text', '=', '0' ),
						),
					),
					array(
						'id' => 'home_mobile_page_sub_title',
						'type' => 'textarea',
						'title' => __( 'Home Page SubTitle', 'ascend' ),
						'subtitle' => __( 'optional text below home page title', 'ascend' ),
						'default' => '[site-tagline]',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'pagetitle' ),
						),
					),
					array(
						'id' => 'home_mobile_basic_slider_type',
						'type' => 'select',
						'title' => __( 'Basic Slider Type', 'ascend' ),
						'options' => array(
							'equal-ratio' => __( 'Equal Ratio Images', 'ascend' ),
							'different-ratio' => __( 'Different Ratio Images', 'ascend' ),
							'fullwidth' => __( 'Forced Fullwidth Images', 'ascend' ),
							'thumb' => __( 'Thumbnails', 'ascend' ),
							'carousel' => __( 'Images in Carousel', 'ascend' ),
						),
						'default' => 'equal-ratio',
						'width' => 'width:60%',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'basic' ),
						),
					),
					array(
						'id' => 'home_mobile_basic_slider',
						'type' => 'kad_slides',
						'title' => __( 'Basic Slider Images', 'ascend' ),
						'subtitle' => __( 'Use large images for best results.', 'ascend' ),
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'basic' ),
						),
					),
					array(
						'id' => 'mobile_slider_size',
						'type' => 'slider',
						'title' => __( 'Slider Max Height', 'ascend' ),
						'subtitle' => __( 'Note: does not work if images are smaller than max.', 'ascend' ),
						'default'       => '400',
						'min'       => '100',
						'step'      => '5',
						'max'       => '1000',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'basic' ),
						),
					),
					array(
						'id' => 'mobile_slider_size_width',
						'type' => 'slider',
						'title' => __( 'Slider Max Width', 'ascend' ),
						'subtitle' => __( 'Note: does not work if images are smaller than max.', 'ascend' ),
						'default'       => '1140',
						'min'       => '600',
						'step'      => '5',
						'max'       => '2400',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'basic' ),
							array( 'home_mobile_basic_slider_type', '!=', 'different-ratio' ),
							array( 'home_mobile_basic_slider_type', '!=', 'carousel' ),
							array( 'home_mobile_basic_slider_type', '!=', 'fullwidth' ),
						),
					),
					array(
						'id' => 'mobile_slider_captions',
						'type' => 'switch',
						'title' => __( 'Show Captions?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide captions', 'ascend' ),
						'default'       => 1,
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'basic' ),
						),
					),
					array(
						'id' => 'home_mobile_page_title_color',
						'type' => 'color',
						'title' => __( 'Title Color', 'ascend' ),
						'subtitle' => __( 'Choose the title color', 'ascend' ),
						'transparent' => false,
						'output'    => array( 'color' => '.home .titleclass.kt_mobile_slider .entry-title' ),
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '!=', 'shortcode' ),
							array( 'home_mobile_header', '!=', 'ksp' ),
							array( 'home_mobile_header', '!=', 'basic_post_carousel' ),
							array( 'home_mobile_header', '!=', 'none' ),
						),
					),
					array(
						'id' => 'home_mobile_page_title_max_size',
						'type' => 'text',
						'title' => __( 'Home Page Title Font size', 'ascend' ),
						'validate' => 'numeric',
						'subtitle' => __( '*Number Only', 'ascend' ),
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '!=', 'shortcode' ),
							array( 'home_mobile_header', '!=', 'ksp' ),
							array( 'home_mobile_header', '!=', 'basic_post_carousel' ),
							array( 'home_mobile_header', '!=', 'none' ),
						),
					),
					array(
						'id' => 'home_mobile_page_title_min_size',
						'type' => 'text',
						'title' => __( 'Smaller Device - Title Font Size', 'ascend' ),
						'subtitle' => __( '*Number Only', 'ascend' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '!=', 'shortcode' ),
							array( 'home_mobile_header', '!=', 'ksp' ),
							array( 'home_mobile_header', '!=', 'basic_post_carousel' ),
							array( 'home_mobile_header', '!=', 'none' ),
						),
					),
					array(
						'id' => 'home_mobile_page_sutitle_color',
						'type' => 'color',
						'title' => __( 'Subtitle Color', 'ascend' ),
						'output'    => array( 'color' => '.home .titleclass.kt_mobile_slider .subtitle' ),
						'subtitle' => __( 'Choose the subtitle color.', 'ascend' ),
						'transparent' => false,
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '!=', 'shortcode' ),
							array( 'home_mobile_header', '!=', 'ksp' ),
							array( 'home_mobile_header', '!=', 'basic_post_carousel' ),
							array( 'home_mobile_header', '!=', 'none' ),
						),
					),
					array(
						'id' => 'home_mobile_page_subtitle_max_size',
						'type' => 'text',
						'title' => __( 'Home Page Subtitle Font size', 'ascend' ),
						'validate' => 'numeric',
						'subtitle' => __( '*Number Only', 'ascend' ),
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '!=', 'shortcode' ),
							array( 'home_mobile_header', '!=', 'ksp' ),
							array( 'home_mobile_header', '!=', 'basic_post_carousel' ),
							array( 'home_mobile_header', '!=', 'none' ),
						),
					),
					array(
						'id' => 'home_mobile_page_subtitle_min_size',
						'type' => 'text',
						'title' => __( 'Smaller Device - Subtitle Font Size', 'ascend' ),
						'subtitle' => __( '*Number Only', 'ascend' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '!=', 'shortcode' ),
							array( 'home_mobile_header', '!=', 'ksp' ),
							array( 'home_mobile_header', '!=', 'basic_post_carousel' ),
							array( 'home_mobile_header', '!=', 'none' ),
						),
					),
					array(
						'id' => 'home_mobile_page_title_align',
						'type' => 'select',
						'title' => __( 'Text align', 'ascend' ),
						'options' => array(
							'center' => __( 'Center', 'ascend' ),
							'left' => __( 'Left', 'ascend' ),
							'right' => __( 'Right', 'ascend' ),
						),
						'default' => 'center',
						'width' => 'width:60%',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '!=', 'shortcode' ),
							array( 'home_mobile_header', '!=', 'ksp' ),
							array( 'home_mobile_header', '!=', 'basic_post_carousel' ),
							array( 'home_mobile_header', '!=', 'none' ),
						),
					),
					array(
						'id' => 'home_mobile_page_title_height',
						'type' => 'slider',
						'title' => __( 'Home Page Title Height', 'ascend' ),
						'default'       => '360',
						'min'       => '20',
						'step'      => '5',
						'max'       => '1500',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'pagetitle' ),
						),
					),
					array(
						'id' => 'home_mobile_page_title_height_min',
						'type' => 'slider',
						'title' => __( 'Smaller Device Title Height', 'ascend' ),
						'default'       => '360',
						'min'       => '20',
						'step'      => '5',
						'max'       => '1500',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'pagetitle' ),
						),
					),
					array(
						'id'        => 'home_mobile_pagetitle_background',
						'type'      => 'background',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'pagetitle' ),
						),
					),
					array(
						'id' => 'home_mobile_ksp_slider',
						'type' => 'select',
						'title' => __( 'If Kadence Slider Pro', 'ascend' ),
						'subtitle' => __( 'Choose your Kadence Slider Pro Here', 'ascend' ),
						'options' => $of_ksp,
						'default' => 'select',
						'width' => 'width:60%',
						'required' => array( 'home_mobile_header', '=', 'ksp' ),
					),
					array(
						'id' => 'home_mobile_shortcode_entry',
						'type' => 'text',
						'title' => __( 'Shortcode Entry', 'ascend' ),
						'subtitle' => __( 'Paste shortcode here', 'ascend' ),
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'shortcode' ),
						),
					),
					array(
						'id' => 'mobile_slider_autoplay',
						'type' => 'switch',
						'title' => __( 'Auto Play?', 'ascend' ),
						'subtitle' => __( 'This determines if a slider automatically scrolls', 'ascend' ),
						'default'       => 1,
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', 'contains', 'basic' ),
						),
					),
					array(
						'id' => 'mobile_slider_pausetime',
						'type' => 'slider',
						'title' => __( 'Slider Pause Time', 'ascend' ),
						'subtitle' => __( 'How long to pause on each slide, in milliseconds.', 'ascend' ),
						'default'       => '7000',
						'min'       => '3000',
						'step'      => '1000',
						'max'       => '12000',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', 'contains', 'basic' ),
						),
					),
					array(
						'id' => 'mobile_trans_type',
						'type' => 'select',
						'title' => __( 'Transition Type', 'ascend' ),
						'subtitle' => __( 'Choose a transition type', 'ascend' ),
						'options' => array(
							'true' => __( 'Fade', 'ascend' ),
							'false' => __( 'Slide', 'ascend' ),
						),
						'default' => 'true',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', '=', 'basic' ),
							array( 'home_basic_slider_type', '!=', 'carousel' ),
						),
					),
					array(
						'id' => 'mobile_slider_transtime',
						'type' => 'slider',
						'title' => __( 'Slider Transition Time', 'ascend' ),
						'subtitle' => __( 'How long for slide transitions, in milliseconds.', 'ascend' ),
						'default'       => '600',
						'min'       => '200',
						'step'      => '100',
						'max'       => '1200',
						'required' => array(
							array( 'mobile_switch', '=', '1' ),
							array( 'home_mobile_header', 'contains', 'basic' ),
						),
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'home_layout',
				'title' => __( 'Home Page Layout', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'home_sidebar_layout',
						'type' => 'switch',
						'title' => __( 'Display a sidebar on the Home Page?', 'ascend' ),
						'subtitle' => __( 'This determines if there is a sidebar on the home page.', 'ascend' ),
						'default' => '0',
					),
					array(
						'id' => 'home_sidebar',
						'type' => 'select',
						'title' => __( 'Choose a Sidebar for your Home Page', 'ascend' ),
						'data' => 'sidebars',
						'default' => 'sidebar-primary',
						'width' => 'width:60%',
						'required' => array( 'home_sidebar_layout', '=', '1' ),
					),
					array(
						'id'       => 'homepage_layout',
						'type'     => 'sortable',
						'customizer'    => true,
						'title'    => __( 'Homepage Layout Manager', 'ascend' ),
						'subtitle' => __( 'Check box to enable and sort for output order (Top First).', 'ascend' ),
						'mode'     => 'checkbox',
						'options'  => array(
							'block_one'     => __( 'Page Content', 'ascend' ),
							'block_two'     => __( 'Latest Blog Posts', 'ascend' ),
							'block_three'   => __( 'Product Carousel Tabs', 'ascend' ),
							'block_four'    => __( 'Image Menu', 'ascend' ),
							'block_five'    => __( 'Icon Menu', 'ascend' ),
							'block_six'     => __( 'Portfolio Carousel', 'ascend' ),
							'block_seven'   => __( 'Portfolio Grid', 'ascend' ),
							'block_eight'   => __( 'Custom Carousel', 'ascend' ),
							'block_nine'    => __( 'Home Widget Area', 'ascend' ),
						),
						'default' => array(
							'block_one'     => true,
							'block_two'     => false,
							'block_three'   => false,
							'block_four'    => false,
							'block_five'    => false,
							'block_six'     => false,
							'block_seven'   => false,
							'block_eight'   => false,
							'block_nine'    => false,
						),
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'home_layout_latest_posts',
				'subsection'       => true,
				'title' => __( 'Module Latest Posts', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'home_blog_title',
						'type' => 'text',
						'title' => __( 'Home Blog Title', 'ascend' ),
						'subtitle' => __( 'e.g. = Latest posts', 'ascend' ),
						'default' => __( 'Latest posts', 'ascend' ),
					),
					array(
						'id' => 'home_blog_style',
						'type' => 'select',
						'title' => __( 'Post output style', 'ascend' ),
						'subtitle' => __( 'Choose how you want your posts to show', 'ascend' ),
						'options' => array(
							'normal' => __( 'Standard', 'ascend' ),
							'below_title' => __( 'Standard with image below title', 'ascend' ),
							'full' => __( 'Full Post', 'ascend' ),
							'grid' => __( 'Grid', 'ascend' ),
							'grid_standard' => __( 'Grid with first post as standard', 'ascend' ),
							'photo' => __( 'Photo', 'ascend' ),
							'mosaic' => __( 'Mosaic', 'ascend' ),
						),
						'default' => 'grid',
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_post_column',
						'type' => 'slider',
						'title' => __( 'Choose how many post columns on Homepage', 'ascend' ),
						'default'   => '3',
						'min'       => '2',
						'step'      => '1',
						'max'       => '4',
						'required' => array(
							array( 'home_blog_style', '!=', 'normal' ),
							array( 'home_blog_style', '!=', 'below_title' ),
							array( 'home_blog_style', '!=', 'mosaic' ),
							array( 'home_blog_style', '!=', 'full' ),
						),
					),
					array(
						'id' => 'home_post_count',
						'type' => 'slider',
						'title' => __( 'Choose How many posts on homepage', 'ascend' ),
						'default'   => '3',
						'min'       => '2',
						'step'      => '1',
						'max'       => '16',
					),
					array(
						'id' => 'home_post_type',
						'type' => 'select',
						'data' => 'categories',
						'title' => __( 'Limit posts to a Category', 'ascend' ),
						'subtitle' => __( 'Leave blank to select all', 'ascend' ),
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_post_readmore',
						'type' => 'switch',
						'title' => __( 'Enable Read More Button after posts to link to blog page', 'ascend' ),
						'default'  => '0',
					),
					array(
						'id' => 'home_post_readmore_text',
						'type' => 'text',
						'title' => __( 'Read More Button text', 'ascend' ),
						'subtitle' => __( 'e.g. = Read More', 'ascend' ),
						'default' => __( 'Read More', 'ascend' ),
						'required' => array( 'home_post_readmore', '=', '1' ),
					),
					array(
						'id' => 'home_post_readmore_link',
						'type' => 'select',
						'data' => 'pages',
						'width' => 'width:60%',
						'title' => __( 'Select Read More Page link', 'ascend' ),
						'subtitle' => __( 'This sets the read more button link', 'ascend' ),
						'required' => array( 'home_post_readmore', '=', '1' ),
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'home_layout_tabs_products',
				'subsection'       => true,
				'title' => __( 'Module Product Carousel Tabs', 'ascend' ),
				'fields' => array(
					array(
						'id'       => 'home_product_tabs',
						'type'     => 'sortable',
						'customizer'    => true,
						'title'    => __( 'Enable and Sort Product Tabs', 'ascend' ),
						'subtitle' => __( 'Check box to enable and sort for output order (Top First).', 'ascend' ),
						'mode'     => 'checkbox',
						'options'  => array(
							'featured'  => __( 'Featured', 'ascend' ),
							'best'      => __( 'Best Selling', 'ascend' ),
							'sale'      => __( 'On Sale', 'ascend' ),
							'latest'    => __( 'Latest', 'ascend' ),
						),
						'default' => array(
							'featured'  => true,
							'best'      => true,
							'sale'      => true,
							'latest'    => true,
						),
					),
					array(
						'id' => 'home_featured_title',
						'type' => 'text',
						'title' => __( 'Featured Tab Title', 'ascend' ),
						'subtitle' => __( 'e.g. = Featured', 'ascend' ),
					),
					array(
						'id' => 'home_best_title',
						'type' => 'text',
						'title' => __( 'Best Selling Tab Title', 'ascend' ),
						'subtitle' => __( 'e.g. = Best Selling', 'ascend' ),
					),
					array(
						'id' => 'home_sale_title',
						'type' => 'text',
						'title' => __( 'On Sale Tab Title', 'ascend' ),
						'subtitle' => __( 'e.g. = On Sale', 'ascend' ),
					),
					array(
						'id' => 'home_latest_title',
						'type' => 'text',
						'title' => __( 'Latest Tab Title', 'ascend' ),
						'subtitle' => __( 'e.g. = Latest', 'ascend' ),
					),
					array(
						'id'        => 'home_product_tabs_column',
						'type'      => 'slider',
						'title'     => __( 'Choose how many columns are in each carousel', 'ascend' ),
						'default'   => '4',
						'min'       => '3',
						'step'      => '1',
						'max'       => '6',
					),
					array(
						'id' => 'home_product_count',
						'type' => 'slider',
						'title'         => __( 'Choose how many products are in each carousel', 'ascend' ),
						'default'       => '8',
						'min'       => '3',
						'step'      => '1',
						'max'       => '18',
					),
					array(
						'id' => 'home_product_scroll',
						'type' => 'select',
						'title' => __( 'Carousel Scroll', 'ascend' ),
						'subtitle' => __( 'Choose how the product items scroll.', 'ascend' ),
						'options' => array(
							'1' => __( 'One Item', 'ascend' ),
							'all' => __( 'All Visible', 'ascend' ),
						),
						'default' => '1',
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_product_speed',
						'type' => 'slider',
						'title' => __( 'Choose the carousel speed (in seconds)', 'ascend' ),
						'default'       => '9',
						'min'       => '2',
						'step'      => '1',
						'max'       => '12',
					),
					array(
						'id' => 'home_product_auto',
						'type' => 'switch',
						'title' => __( 'Auto Scroll Carousel?', 'ascend' ),
						'default'    => '1',
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'home_layout_image',
				'subsection'       => true,
				'title' => __( 'Module Image Menu', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'info_iconmenu_settings',
						'type' => 'info',
						'desc' => __( 'Home Image Menu', 'ascend' ),
					),
					array(
						'id' => 'home_image_menu',
						'type' => 'kad_slides',
						'title' => __( 'Image Menu', 'ascend' ),
						'subtitle' => __( 'Add images, descriptions, titles, and links', 'ascend' ),
					),
					array(
						'id' => 'home_image_menu_column',
						'type' => 'slider',
						'title' => __( 'Choose how many columns in each row', 'ascend' ),
						'default'       => '3',
						'min'       => '1',
						'step'      => '1',
						'max'       => '6',
					),
					array(
						'id' => 'img_menu_height',
						'type' => 'slider',
						'title' => __( 'Image Menu Height', 'ascend' ),
						'default'       => '220',
						'min'       => '80',
						'step'      => '2',
						'max'       => '600',
					),
					array(
						'id' => 'img_menu_height_setting',
						'type' => 'select',
						'title' => __( 'Height set by', 'ascend' ),
						'subtitle' => __( 'Choose how the image menu height will be set.', 'ascend' ),
						'options' => array(
							'normal' => __( 'Height setting above', 'ascend' ),
							'image_height' => __( 'Image Size', 'ascend' ),
						),
						'default' => 'normal',
						'width' => 'width:60%',
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'home_layout_icon_menu',
				'subsection'       => true,
				'title' => __( 'Module Icon Menu', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'info_icon_menu_settings',
						'type' => 'info',
						'desc' => __( 'Home Icon Menu', 'ascend' ),
					),
					array(
						'id' => 'icon_menu',
						'type' => 'kad_icons',
						'title' => __( 'Icon Menu', 'ascend' ),
						'subtitle' => __( 'Choose your icons for the icon menu.', 'ascend' ),
					),
					array(
						'id' => 'home_icon_menu_column',
						'type' => 'slider',
						'title' => __( 'Choose how many columns in each row', 'ascend' ),
						'default'       => '3',
						'min'       => '2',
						'step'      => '1',
						'max'       => '6',
					),
					array(
						'id' => 'home_icon_menu_btn',
						'type' => 'text',
						'title' => __( 'Icon menu button text (optional)', 'ascend' ),
						'subtitle' => __( 'e.g. = Read More', 'ascend' ),
					),
					array(
						'id' => 'icon_font_color',
						'type' => 'color',
						'title' => __( 'Icon Color', 'ascend' ),
						'subtitle' => __( 'Choose the color for icon.', 'ascend' ),
						'default' => '',
						'transparent' => false,
						'output' => array( 'color' => '.kt-home-icon-menu .box-icon-item .icon-container' ),
						'validate' => 'color',
					),
					array(
						'id' => 'icon_border_color',
						'type' => 'color',
						'title' => __( 'Icon Border Color', 'ascend' ),
						'subtitle' => __( 'Choose the border color for icon.', 'ascend' ),
						'default' => '',
						'validate' => 'color',
						'output' => array( 'border-color' => '.kt-home-icon-menu .box-icon-item .icon-container' ),
					),
					array(
						'id' => 'icon_bg_color',
						'type' => 'color',
						'title' => __( 'Icon Background Color', 'ascend' ),
						'subtitle' => __( 'Choose the background color for icon.', 'ascend' ),
						'default' => '',
						'validate' => 'color',
						'output' => array( 'background-color' => '.kt-home-icon-menu .box-icon-item .icon-container' ),
					),
					array(
						'id' => 'icon_menu_font_color',
						'type' => 'color',
						'title' => __( 'Icon Menu Title and Description Font Color', 'ascend' ),
						'subtitle' => __( 'Choose the color for icon menu title and description Font', 'ascend' ),
						'default' => '',
						'transparent' => false,
						'validate' => 'color',
						'output' => array( 'color' => '.kt-home-icon-menu .box-icon-item h4, .kt-home-icon-menu .box-icon-item .menu-icon-description, .kt-home-icon-menu .box-icon-item .menu-icon-read-more' ),
					),
					array(
						'id' => 'icon_border_hover_color',
						'type' => 'color',
						'title' => __( 'Highlight Border Color', 'ascend' ),
						'subtitle' => __( 'Choose the highlight border color for icon and above the read more.', 'ascend' ),
						'default' => '',
						'transparent' => false,
						'validate' => 'color',
						'output' => array(
							'border-color' => '.kt-home-icon-menu .box-icon-item .icon-container .icon-heighlight',
							'background-color' => '.kt-home-icon-menu .box-icon-item .menu-icon-read-more .read-more-highlight',
						),
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'home_layout_portfolio_carousel',
				// 'priority'=> '38',
				'subsection'       => true,
				'title' => __( 'Module Portfolio Carousel', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'info_home_portfolio_carousel_settings',
						'type' => 'info',
						'desc' => __( 'Home Portfolio Carousel Settings', 'ascend' ),
					),
					array(
						'id' => 'home_portfolio_carousel_title',
						'type' => 'text',
						'title' => __( 'Home Portfolio Carousel title', 'ascend' ),
						'subtitle' => __( 'e.g. = Latest Projects', 'ascend' ),
						'default' => __( 'Latest Projects', 'ascend' ),
					),
					array(
						'id' => 'home_portfolio_carousel_style',
						'type' => 'select',
						'title' => __( 'Portfolio Carousel Item Style', 'ascend' ),
						'subtitle' => __( 'Choose how the portfolio items should be ordered in the carousel.', 'ascend' ),
						'options' => array(
							'pgrid' => __( 'Normal Grid', 'ascend' ),
							'pgrid-no-margin' => __( 'Grid without margin between items', 'ascend' ),
							'poststyle' => __( 'Post style', 'ascend' ),
						),
						'default' => 'pgrid',
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_portfolio_carousel_ratio',
						'type' => 'select',
						'title' => __( 'Portfolio Carousel image ratio', 'ascend' ),
						'subtitle' => __( 'Choose how the portfolio items images should be cropped.', 'ascend' ),
						'options' => array(
							'square' => __( 'Square', 'ascend' ),
							'portrait' => __( 'Portrait', 'ascend' ),
							'landscape' => __( 'Landscape', 'ascend' ),
							'widelandscape' => __( 'Wide Landscape', 'ascend' ),
						),
						'default' => 'square',
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_portfolio_carousel_type',
						'type' => 'select',
						'data' => 'terms',
						'args' => array(
							'taxonomies' => 'portfolio-type',
							'args' => array(),
						),
						'title' => __( 'Portfolio Carousel Category Type', 'ascend' ),
						'subtitle' => __( 'Leave blank to select all types', 'ascend' ),
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_portfolio_carousel_column',
						'type' => 'slider',
						'title' => __( 'Choose how many columns are in carousel', 'ascend' ),
						'default'       => '3',
						'min'       => '2',
						'step'      => '1',
						'max'       => '6',
					),
					array(
						'id' => 'home_portfolio_carousel_count',
						'type' => 'slider',
						'title' => __( 'Choose how many portfolio items are in carousel', 'ascend' ),
						'default'       => '6',
						'min'       => '4',
						'step'      => '1',
						'max'       => '18',
					),
					array(
						'id' => 'home_portfolio_carousel_speed',
						'type' => 'slider',
						'title' => __( 'Choose the carousel speed (in seconds)', 'ascend' ),
						'default'       => '9',
						'min'       => '2',
						'step'      => '1',
						'max'       => '12',
					),
					array(
						'id' => 'home_portfolio_carousel_scroll',
						'type' => 'select',
						'title' => __( 'Portfolio Carousel Scroll', 'ascend' ),
						'subtitle' => __( 'Choose how the portfolio items scroll.', 'ascend' ),
						'options' => array(
							'oneitem' => __( 'One Item', 'ascend' ),
							'all' => __( 'All Visible', 'ascend' ),
						),
						'default' => 'oneitem',
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_portfolio_carousel_order',
						'type' => 'select',
						'title' => __( 'Portfolio Carousel Order by', 'ascend' ),
						'subtitle' => __( 'Choose how the portfolio items should be ordered in the carousel.', 'ascend' ),
						'options' => array(
							'menu_order' => __( 'Menu Order', 'ascend' ),
							'title' => __( 'Title', 'ascend' ),
							'date' => __( 'Date', 'ascend' ),
							'rand' => __( 'Random', 'ascend' ),
						),
						'default' => 'menu_order',
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_portfolio_carousel_show_type',
						'type' => 'switch',
						'title' => __( 'Display Portfolio Types under Title', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'home_portfolio_carousel_show_excerpt',
						'type' => 'switch',
						'title' => __( 'Display Portfolio Excerpt under Title', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'home_portfolio_carousel_show_lightbox',
						'type' => 'switch',
						'title' => __( 'Display lightbox icon in portfolio posts', 'ascend' ),
						'default' => 0,
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'home_layout_custom_carousel',
				'subsection'       => true,
				'title' => __( 'Module Custom Carousel', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'info_custom_carousel_settings',
						'type' => 'info',
						'desc' => __( 'Home Custom Carousel Settings', 'ascend' ),
					),
					array(
						'id' => 'custom_carousel_title',
						'type' => 'text',
						'title' => __( 'Home Custom Carousel Title', 'ascend' ),
						'subtitle' => __( 'e.g. = Featured News', 'ascend' ),
					),
					array(
						'id' => 'home_custom_carousel_items',
						'type' => 'kad_slides',
						'title' => __( 'Custom Carousel Items', 'ascend' ),
						'subtitle' => __( 'Add images, descriptions, titles, and links', 'ascend' ),
					),
					array(
						'id' => 'home_custom_carousel_column',
						'type' => 'slider',
						'title' => __( 'Choose how many columns are in carousel', 'ascend' ),
						'default'       => '4',
						'min'       => '2',
						'step'      => '1',
						'max'       => '6',
					),
					array(
						'id' => 'home_custom_carousel_scroll',
						'type' => 'select',
						'title' => __( 'Custom Carousel Scroll', 'ascend' ),
						'subtitle' => __( 'Choose how the custom items scroll.', 'ascend' ),
						'options' => array(
							'oneitem' => __( 'One Item', 'ascend' ),
							'all' => __( 'All Visible', 'ascend' ),
						),
						'default' => 'oneitem',
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_custom_speed',
						'type' => 'slider',
						'title' => __( 'Choose the carousel speed (in seconds).', 'ascend' ),
						'default'       => '9',
						'min'       => '2',
						'step'      => '1',
						'max'       => '12',
					),
					array(
						'id' => 'home_custom_carousel_imageratio',
						'type' => 'switch',
						'title' => __( 'Enable custom image ratio for carousel', 'ascend' ),
						'default' => 0,
					),
				),
			)
		);

		Redux::setSection(
			$opt_name,
			array(
				'id' => 'home_layout_portfolio_full',
				// 'priority'=> '38',
				'subsection'       => true,
				'title' => __( 'Module Portfolio Grid', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'portfolio_full_title',
						'type' => 'text',
						'title' => __( 'Home Portfolio Full Title', 'ascend' ),
						'subtitle' => __( 'e.g. = Our Work', 'ascend' ),
					),
					array(
						'id' => 'home_portfolio_full_style',
						'type' => 'select',
						'title' => __( 'Portfolio Grid Item Style', 'ascend' ),
						'subtitle' => __( 'Choose how the portfolio items should be ordered in the grid.', 'ascend' ),
						'options' => array(
							'pgrid' => __( 'Normal Grid', 'ascend' ),
							'pgrid-no-margin' => __( 'Grid without margin between items', 'ascend' ),
							'poststyle' => __( 'Post style', 'ascend' ),
							'mosaic' => __( 'Mosaic', 'ascend' ),
							'tiles' => __( 'Tiles', 'ascend' ),
						),
						'default' => 'pgrid',
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_portfolio_full_ratio',
						'type' => 'select',
						'title' => __( 'Portfolio Grid image ratio', 'ascend' ),
						'subtitle' => __( 'Choose how the portfolio items images should be cropped.', 'ascend' ),
						'options' => array(
							'square' => __( 'Square', 'ascend' ),
							'portrait' => __( 'Portrait', 'ascend' ),
							'landscape' => __( 'Landscape', 'ascend' ),
							'widelandscape' => __( 'Wide Landscape', 'ascend' ),
							'softcrop' => __( 'Inherit from image', 'ascend' ),
						),
						'default' => 'square',
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_portfolio_full_type',
						'type' => 'select',
						'data' => 'terms',
						'args' => array(
							'taxonomies' => 'portfolio-type',
							'args' => array(),
						),
						'title' => __( 'Portfolio Full Category Type', 'ascend' ),
						'subtitle' => __( 'Choose type for the Portfolio Grid or leave blank to show all types', 'ascend' ),
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_portfolio_full_show_filter',
						'type' => 'switch',
						'title' => __( 'Display Portfolio Filter', 'ascend' ),
						'default'       => 0,
						'required' => array( 'home_portfolio_full_style', '!=', 'tiles' ),
					),
					array(
						'id' => 'home_portfolio_full_count',
						'type' => 'slider',
						'title' => __( 'Choose how many Portfolio Items on Homepage', 'ascend' ),
						'default'       => '8',
						'min'       => '4',
						'step'      => '1',
						'max'       => '26',
					),
					array(
						'id'      => 'home_portfolio_full_pagination',
						'type'    => 'switch',
						'title'   => __( 'Show Pagination?', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'home_portfolio_full_order',
						'type' => 'select',
						'title' => __( 'Portfolio full Order by', 'ascend' ),
						'subtitle' => __( 'Choose how the portfolio items should be ordered.', 'ascend' ),
						'options' => array(
							'menu_order' => __( 'Menu Order', 'ascend' ),
							'title' => __( 'Title', 'ascend' ),
							'date' => __( 'Date', 'ascend' ),
							'rand' => __( 'Random', 'ascend' ),
						),
						'default' => 'menu_order',
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_portfolio_full_columns',
						'type' => 'slider',
						'title' => __( 'Choose how many Portfolio columns', 'ascend' ),
						'default'       => '4',
						'min'       => '2',
						'step'      => '1',
						'max'       => '6',
						'required' => array(
							array( 'home_portfolio_full_style', '!=', 'tiles' ),
							array( 'home_portfolio_full_style', '!=', 'mosaic' ),
						),
					),
					array(
						'id' => 'home_portfolio_full_show_type',
						'type' => 'switch',
						'title' => __( 'Display Portfolio Types under Title', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'home_portfolio_full_show_excerpt',
						'type' => 'switch',
						'title' => __( 'Display Portfolio Excerpt under Title', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'home_portfolio_full_show_lightbox',
						'type' => 'switch',
						'title' => __( 'Display lightbox icon in portfolio posts', 'ascend' ),
						'default' => 0,
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'home_layout_page_content',
				'subsection'       => true,
				'title' => __( 'Module Page Content', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'info_page_content',
						'type' => 'info',
						'desc' => __( 'Page Content Options (if home page is latest post page)', 'ascend' ),
					),
					array(
						'id' => 'home_main_post_style',
						'type' => 'select',
						'title' => __( 'Latest Post Display', 'ascend' ),
						'subtitle' => __( 'If Latest Post page is front page. Choose to the latest posts output style', 'ascend' ),
						'options' => array(
							'normal' => __( 'Standard', 'ascend' ),
							'below_title' => __( 'Standard with image below title', 'ascend' ),
							'full' => __( 'Full Post', 'ascend' ),
							'grid' => __( 'Grid', 'ascend' ),
							'grid_standard' => __( 'Grid with first post as standard', 'ascend' ),
							'photo' => __( 'Photo', 'ascend' ),
							'mosaic' => __( 'Mosaic', 'ascend' ),
						),
						'default' => 'grid_standard',
						'width' => 'width:60%',
					),
					array(
						'id' => 'home_main_columns',
						'type' => 'slider',
						'title' => __( 'Post Columns', 'ascend' ),
						'default'   => '3',
						'min'       => '2',
						'step'      => '1',
						'max'       => '4',
						'required' => array(
							array( 'home_main_post_style', '!=', 'normal' ),
							array( 'home_main_post_style', '!=', 'below_title' ),
							array( 'home_main_post_style', '!=', 'mosaic' ),
							array( 'home_main_post_style', '!=', 'full' ),
						),
					),

				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'shop_archive_settings',
				'title' => __( 'Shop Archive Settings', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'product_shop_layout',
						'type' => 'select',
						'title' => __( 'Shop Product Column Layout', 'ascend' ),
						'subtitle' => __( 'NOTE: This sets the columns for standard screen size. May be more on larger screens and less on smaller screens.', 'ascend' ),
						'options' => array(
							'1' => __( 'One Column', 'ascend' ),
							'2' => __( 'Two Column', 'ascend' ),
							'3' => __( 'Three Column', 'ascend' ),
							'4' => __( 'Four Column', 'ascend' ),
							'5' => __( 'Five Column', 'ascend' ),
							'6' => __( 'Six Column', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => '4',
					),
					array(
						'id'            => 'products_per_page',
						'type'          => 'slider',
						'title'         => __( 'How many products per page', 'ascend' ),
						'default'       => '12',
						'min'           => '2',
						'step'          => '1',
						'max'           => '80',
					),
					array(
						'id'        => 'product_fitrows',
						'type'      => 'switch',
						'title'     => __( 'Force products into rows', 'ascend' ),
						'subtitle'  => __( 'Products fit into rows regardless of size', 'ascend' ),
						'default'   => 1,
					),
					array(
						'id' => 'info_archive_sidebar',
						'type' => 'info',
						'desc' => __( 'Shop Archive Sidebar Defaults', 'ascend' ),
					),
					array(
						'id' => 'shop_cat_layout',
						'type' => 'select',
						'title' => __( 'Default Layout for product archive pages', 'ascend' ),
						'subtitle' => __( 'This determines if there is a sidebar on the product archive pages.', 'ascend' ),
						'options' => array(
							'full' => __( 'No Sidebar Layout', 'ascend' ),
							'sidebar' => __( 'Sidebar Layout', 'ascend' ),
						),
						'default' => 'full',
					),
					array(
						'id' => 'shop_cat_sidebar_side',
						'type' => 'select',
						'title' => __( 'Sidebar side for product archive pages', 'ascend' ),
						'subtitle' => __( 'This determines if the sidebar is on the left of right of page.', 'ascend' ),
						'options' => array(
							'right' => __( 'Right', 'ascend' ),
							'left' => __( 'Left', 'ascend' ),
						),
						'default' => 'right',
					),
					array(
						'id' => 'shop_cat_sidebar',
						'type' => 'select',
						'title' => __( 'Choose a default Sidebar for your product archive pages', 'ascend' ),
						'data' => 'sidebars',
						'default' => 'sidebar-primary',
						'width' => 'width:60%',
					),
					array(
						'id' => 'info_shop_img_size',
						'type' => 'info',
						'desc' => __( 'Product Image Sizes', 'ascend' ),
					),
					array(
						'id'        => 'shop_img_ratio',
						'type'      => 'select',
						'title'     => __( 'Product Image Aspect Ratio', 'ascend' ),
						'subtitle'  => __( 'If enabled below this sets how you want your product images to be cropped.', 'ascend' ),
						'options'   => array(
							'square' => __( 'Square 1:1', 'ascend' ),
							'portrait' => __( 'Portrait 3:4', 'ascend' ),
							'landscape' => __( 'Landscape 4:3', 'ascend' ),
							'widelandscape' => __( 'Wide Landscape 4:2', 'ascend' ),
							'softcrop' => __( 'Variable based on uploaded image', 'ascend' ),
						),
						'default'   => 'square',
						'width'     => 'width:60%',
					),
					array(
						'id' => 'product_img_resize',
						'type' => 'switch',
						'title' => __( 'Enable Product Image Aspect Ratio on Catalog pages', 'ascend' ),
						'subtitle' => __( 'If turned off image dimensions are set by woocommerce settings - recommended width: 300px for Catalog Images', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'product_simg_resize',
						'type' => 'switch',
						'title' => __( 'Enable Product Image Aspect Ratio on product Page', 'ascend' ),
						'subtitle' => __( 'If turned off image dimensions are set by woocommerce settings - recommended width: 480px for Single Product Image', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'info_cat_product_size',
						'type' => 'info',
						'desc' => __( 'Category Image Size', 'ascend' ),
					),
					array(
						'id' => 'product_cat_layout',
						'type' => 'select',
						'title' => __( 'Shop Category Column Layout', 'ascend' ),
						'subtitle' => __( 'Choose how many Category Image columns to show on the shop and category pages', 'ascend' ),
						'options' => array(
							'2' => __( 'Two Column', 'ascend' ),
							'3' => __( 'Three Column', 'ascend' ),
							'4' => __( 'Four Column', 'ascend' ),
							'5' => __( 'Five Column', 'ascend' ),
							'6' => __( 'Six Column', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => '3',
					),
					array(
						'id' => 'product_cat_img_ratio',
						'type' => 'select',
						'title' => __( 'Category Image Aspect Ratio', 'ascend' ),
						'subtitle' => __( 'If enabled below this sets how you want your category images to be cropped.', 'ascend' ),
						'options' => array(
							'square' => __( 'Square 1:1', 'ascend' ),
							'portrait' => __( 'Portrait 3:4', 'ascend' ),
							'landscape' => __( 'Landscape 4:3', 'ascend' ),
							'widelandscape' => __( 'Wide Landscape 4:2', 'ascend' ),
							'off' => __( 'Turn Off', 'ascend' ),
						),
						'default' => 'square',
						'width' => 'width:60%',
					),
					array(
						'id' => 'info_shop_product_title',
						'type' => 'info',
						'desc' => __( 'Archive Product Title Settings', 'ascend' ),
					),
					array(
						'id' => 'font_shop_title',
						'type' => 'typography',
						'title' => __( 'Shop & archive Product title Font', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => true,
						'line-height' => true,
						'text-align' => false,
						'text-transform' => true,
						'letter-spacing' => true,
						'color' => true,
						'preview' => true,
						'output' => array( '.product_item .product_archive_title' ),
						'subtitle' => __( 'Choose Size and Style for product titles on category and archive pages.', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'color' => '#444444',
							'font-style' => '600',
							'font-size' => '15px',
							'line-height' => '20px',
							'letter-spacing' => '1.2',
							'text-transform' => 'none',
						),
					),
					array(
						'id' => 'shop_title_min_height',
						'type' => 'slider',
						'title' => __( 'Product title Min Height', 'ascend' ),
						'subtitle' => __( 'If your titles are long increase this to help align your products height.', 'ascend' ),
						'default'       => '20',
						'min'       => '20',
						'step'      => '5',
						'max'       => '220',
					),
					array(
						'id' => 'info_archive_extras',
						'type' => 'info',
						'desc' => __( 'Shop Archive Extras', 'ascend' ),
					),
					array(
						'id' => 'product_add_to_cart_show',
						'type' => 'switch',
						'title' => __( 'Show add to cart button only on hover', 'ascend' ),
						'subtitle' => __( 'If this is turned off your add to cart button will show all the time.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'shop_filter',
						'type' => 'switch',
						'title' => __( 'Show Category Filter on Shop Page', 'ascend' ),
						'subtitle' => __( 'This adds an quick filter to the shop page. NOTE this filter is only designed to filter what is visible on the page. It does not act as a menu and query products from multiple pages.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'cat_filter',
						'type' => 'switch',
						'title' => __( 'Show Category Filter on Category Pages', 'ascend' ),
						'subtitle' => __( 'This adds an quick filter to Category pages. NOTE this filter is only designed to filter what is visible on the page. It does not act as a menu and query products from multiple pages.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'infinitescroll',
						'type' => 'switch',
						'title' => __( 'Use infinite scroll on shop archive pages', 'ascend' ),
						'subtitle' => __( 'Not recommended that you use with filter.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'shop_toggle',
						'type' => 'switch',
						'title' => __( 'Show toggle buttons for list/grid on shop page', 'ascend' ),
						'subtitle' => __( 'Adds two icons for toggling between a grid and list layout on shop page.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'shop_excerpt',
						'type' => 'switch',
						'title' => __( 'Stop Product Excerpt from loading in the shop grid pages.', 'ascend' ),
						'subtitle' => __( 'Good to turn on if there are conflicts on your shop grid pages.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'shop_rating',
						'type' => 'switch',
						'title' => __( 'Show Ratings in Shop and Category Pages', 'ascend' ),
						'subtitle' => __( 'This determines if the rating is displayed in the product archive pages', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'outofstocktag',
						'type' => 'switch',
						'title' => __( 'Show Sold tag if product out of stock.', 'ascend' ),
						'subtitle' => __( 'This determines if a sold tag is displayed on the top right of the product image', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'product_img_flip',
						'type' => 'switch',
						'title' => __( 'Product hover image switch', 'ascend' ),
						'subtitle' => __( 'This allows your product image to slide to the first gallery image when hovered over on shop page.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'product_quantity_input',
						'type' => 'switch',
						'title' => __( 'Quantity Box plus and minus', 'ascend' ),
						'subtitle' => __( 'Turn this off if you would like to use browser added plus and minus for number boxes', 'ascend' ),
						'default' => 1,
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'shop_page_header',
				'title' => __( 'Shop Page Header', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Shop Page Header Settings', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'shop_header',
						'type' => 'select',
						'title' => __( 'Choose home page header settings', 'ascend' ),
						'options' => array(
							'pagetitle' => __( 'Page Title', 'ascend' ),
							'basic' => __( 'Basic Slider', 'ascend' ),
							'ksp' => __( 'Kadence Slider Pro', 'ascend' ),
							'shortcode' => __( 'Shortcode Entry', 'ascend' ),
							'none' => __( 'None', 'ascend' ),
						),
						'default' => 'pagetitle',
						'width' => 'width:60%',
					),
					array(
						'id' => 'info_shop_slider',
						'type' => 'info',
						'desc' => __( 'Edit the page to change your page title options.', 'ascend' ),
						'required' => array( 'shop_header', '=', 'pagetitle' ),
					),
					array(
						'id' => 'shop_basic_slider_type',
						'type' => 'select',
						'title' => __( 'Basic Slider Type', 'ascend' ),
						'options' => array(
							'equal-ratio' => __( 'Equal Ratio Images', 'ascend' ),
							'different-ratio' => __( 'Different Ratio Images', 'ascend' ),
							'fullwidth' => __( 'Forced Fullwidth Images', 'ascend' ),
							'thumb' => __( 'Thumbnails', 'ascend' ),
							'carousel' => __( 'Images in Carousel', 'ascend' ),
						),
						'default' => 'equal-ratio',
						'width' => 'width:60%',
						'required' => array( 'shop_header', '=', 'basic' ),
					),
					array(
						'id' => 'shop_basic_slider',
						'type' => 'kad_slides',
						'title' => __( 'Basic Slider Images', 'ascend' ),
						'subtitle' => __( 'Use large images for best results.', 'ascend' ),
						'required' => array( 'shop_header', '=', 'basic' ),
					),
					array(
						'id' => 'shop_slider_size',
						'type' => 'slider',
						'title' => __( 'Slider Max Height', 'ascend' ),
						'subtitle' => __( 'Note: does not work if images are smaller than max.', 'ascend' ),
						'default'       => '400',
						'min'       => '100',
						'step'      => '5',
						'max'       => '1000',
						'required' => array( 'shop_header', '=', 'basic' ),
					),
					array(
						'id' => 'shop_slider_size_width',
						'type' => 'slider',
						'title' => __( 'Slider Max Width', 'ascend' ),
						'subtitle' => __( 'Note: does not work if images are smaller than max.', 'ascend' ),
						'default'       => '1140',
						'min'       => '600',
						'step'      => '5',
						'max'       => '2400',
						'required' => array(
							array( 'shop_header', '=', 'basic' ),
							array( 'shop_basic_slider_type', '!=', 'different-ratio' ),
							array( 'shop_basic_slider_type', '!=', 'carousel' ),
							array( 'shop_basic_slider_type', '!=', 'fullwidth' ),
						),
					),
					array(
						'id' => 'shop_slider_captions',
						'type' => 'switch',
						'title' => __( 'Show Captions?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide captions', 'ascend' ),
						'default'       => 1,
						'required' => array( 'shop_header', '=', 'basic' ),
					),
					array(
						'id' => 'shop_page_title_color',
						'type' => 'color',
						'title' => __( 'Title Color', 'ascend' ),
						'subtitle' => __( 'Choose the title color', 'ascend' ),
						'transparent' => false,
						'required' => array( 'shop_header', '=', 'basic' ),
					),
					array(
						'id' => 'shop_page_title_max_size',
						'type' => 'text',
						'title' => __( 'Shop Caption Title Font size', 'ascend' ),
						'validate' => 'numeric',
						'subtitle' => __( '*Number Only', 'ascend' ),
						'required' => array( 'shop_header', '=', 'basic' ),
					),
					array(
						'id' => 'shop_page_title_min_size',
						'type' => 'text',
						'title' => __( 'Smaller Device - Title Font Size', 'ascend' ),
						'subtitle' => __( '*Number Only', 'ascend' ),
						'validate' => 'numeric',
						'required' => array( 'shop_header', '=', 'basic' ),
					),
					array(
						'id' => 'shop_page_sutitle_color',
						'type' => 'color',
						'title' => __( 'Subtitle Color', 'ascend' ),
						'subtitle' => __( 'Choose the subtitle color.', 'ascend' ),
						'transparent' => false,
						'required' => array( 'shop_header', '=', 'basic' ),
					),
					array(
						'id' => 'shop_page_subtitle_max_size',
						'type' => 'text',
						'title' => __( 'Shop Caption Subtitle Font size', 'ascend' ),
						'validate' => 'numeric',
						'subtitle' => __( '*Number Only', 'ascend' ),
						'required' => array( 'shop_header', '=', 'basic' ),
					),
					array(
						'id' => 'shop_page_subtitle_min_size',
						'type' => 'text',
						'title' => __( 'Smaller Device - Subtitle Font Size', 'ascend' ),
						'subtitle' => __( '*Number Only', 'ascend' ),
						'validate' => 'numeric',
						'required' => array( 'shop_header', '=', 'basic' ),
					),
					array(
						'id' => 'shop_page_title_align',
						'type' => 'select',
						'title' => __( 'Text align', 'ascend' ),
						'options' => array(
							'center' => __( 'Center', 'ascend' ),
							'left' => __( 'Left', 'ascend' ),
							'right' => __( 'Right', 'ascend' ),
						),
						'default' => 'center',
						'width' => 'width:60%',
						'required' => array( 'shop_header', '=', 'basic' ),
					),
					array(
						'id' => 'shop_ksp_slider',
						'type' => 'select',
						'title' => __( 'If Kadence Slider Pro', 'ascend' ),
						'subtitle' => __( 'Choose your Kadence Slider Pro Here', 'ascend' ),
						'options' => $of_ksp,
						'default' => 'select',
						'width' => 'width:60%',
						'required' => array( 'shop_header', '=', 'ksp' ),
					),
					array(
						'id' => 'shop_shortcode_entry',
						'type' => 'text',
						'title' => __( 'Shortcode Entry', 'ascend' ),
						'subtitle' => __( 'Paste shortcode here', 'ascend' ),
						'required' => array( 'home_header', '=', 'shortcode' ),
					),
					array(
						'id' => 'shop_slider_autoplay',
						'type' => 'switch',
						'title' => __( 'Auto Play?', 'ascend' ),
						'subtitle' => __( 'This determines if a slider automatically scrolls', 'ascend' ),
						'default'       => 1,
						'required' => array( 'shop_header', 'contains', 'basic' ),
					),
					array(
						'id' => 'shop_slider_pausetime',
						'type' => 'slider',
						'title' => __( 'Slider Pause Time', 'ascend' ),
						'subtitle' => __( 'How long to pause on each slide, in milliseconds.', 'ascend' ),
						'default'       => '7000',
						'min'       => '3000',
						'step'      => '1000',
						'max'       => '12000',
						'required' => array( 'shop_header', 'contains', 'basic' ),
					),
					array(
						'id' => 'shop_trans_type',
						'type' => 'select',
						'title' => __( 'Transition Type', 'ascend' ),
						'subtitle' => __( 'Choose a transition type', 'ascend' ),
						'options' => array(
							'true' => __( 'Fade', 'ascend' ),
							'false' => __( 'Slide', 'ascend' ),
						),
						'default' => 'true',
						'required' => array(
							array( 'shop_header', '=', 'basic' ),
							array( 'shop_basic_slider_type', '!=', 'carousel' ),
						),
					),
					array(
						'id' => 'shop_slider_transtime',
						'type' => 'slider',
						'title' => __( 'Slider Transition Time', 'ascend' ),
						'subtitle' => __( 'How long for slide transitions, in milliseconds.', 'ascend' ),
						'default'       => '600',
						'min'       => '200',
						'step'      => '100',
						'max'       => '1200',
						'required' => array( 'shop_header', 'contains', 'basic' ),
					),
				),
			)
		);

		Redux::setSection(
			$opt_name,
			array(
				'id' => 'product_settings',
				'title' => __( 'Product Settings', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Single Product Settings', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'product_layout',
						'type' => 'select',
						'title' => __( 'Single Product Sidebar Layout Default', 'ascend' ),
						'options' => array(
							'full' => __( 'No sidebar layout', 'ascend' ),
							'sidebar' => __( 'Sidebar Layout', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'full',
					),
					array(
						'id' => 'product_sidebar_default',
						'type' => 'select',
						'title' => __( 'Choose a Default Sidebar for your Single Product post', 'ascend' ),
						'data' => 'sidebars',
						'default' => 'sidebar-primary',
						'width' => 'width:60%',
					),
					array(
						'id' => 'product_content_layout',
						'type' => 'select',
						'title' => __( 'Product Content Layout', 'ascend' ),
						'options' => array(
							'standard' => __( 'Standard', 'ascend' ),
							'large-image' => __( 'Large Image Center', 'ascend' ),
							'split-image' => __( 'Split Image and Info', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'large-image',
					),
					array(
						'id' => 'info_product_post_header',
						'type' => 'info',
						'desc' => __( 'Single Product Post Header', 'ascend' ),
					),
					array(
						'id' => 'product_post_title',
						'type' => 'switch',
						'title' => __( 'Show Product Title in Header area by default', 'ascend' ),
						'subtitle' => __( 'This can be overridden on each product.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'product_post_title_tag',
						'type' => 'select',
						'title' => __( 'Post title html tag output.', 'ascend' ),
						'subtitle' => __( 'This is used for SEO purposes in case you want an h1 tag futher down your post content.', 'ascend' ),
						'options' => array(
							'h1' => __( 'h1', 'ascend' ),
							'h2' => __( 'h2', 'ascend' ),
							'h3' => __( 'h3', 'ascend' ),
							'span' => __( 'span', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'h1',
					),
					array(
						'id' => 'product_post_title_content',
						'type' => 'select',
						'title' => __( 'Product Default Title Text', 'ascend' ),
						'options' => array(
							'posttitle' => __( 'Product Title', 'ascend' ),
							'category' => __( 'Category of Product', 'ascend' ),
							'custom' => __( 'Custom', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'posttitle',
					),
					array(
						'id' => 'product_header_title_text',
						'type' => 'text',
						'title' => __( 'Product Default Title', 'ascend' ),
						'subtitle' => __( 'Example: Shop', 'ascend' ),
						'required' => array( 'product_post_title_content', '=', 'custom' ),
					),
					array(
						'id' => 'product_header_subtitle_text',
						'type' => 'text',
						'title' => __( 'Product Default Subtitle', 'ascend' ),
						'required' => array( 'product_post_title_content', '=', 'custom' ),
					),
					array(
						'id' => 'info_product_nav_options',
						'type' => 'info',
						'desc' => __( 'Product Navigation Options', 'ascend' ),
					),
					array(
						'id' => 'product_single_nav',
						'type' => 'switch',
						'title' => __( 'Enable Arrow navigation for single product post?', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'info_product_post_content',
						'type' => 'info',
						'desc' => __( 'Single Product Content Settings', 'ascend' ),
					),
					array(
						'id' => 'product_cat_above_title',
						'type' => 'switch',
						'title' => __( 'Show the single Category above content title', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'product_post_title_inpost',
						'type' => 'switch',
						'title' => __( 'Show the Title in post content', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'product_gallery_slider',
						'type' => 'switch',
						'title' => __( 'Enable woocommerce slider for product gallery? (must be woocommerce 3.0+)', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'product_gallery_zoom',
						'type' => 'switch',
						'title' => __( 'Enable woocommerce hover zoom for product gallery? (must be woocommerce 3.0+)', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'product_radio',
						'type' => 'switch',
						'title' => __( 'Display variations as radio buttons instead of select box?', 'ascend' ),
						'subtitle' => __( 'This will display product variations in a box form.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'product_tabs',
						'title' => __( 'Display product tabs?', 'ascend' ),
						'subtitle' => __( 'This determines if product tabs are displayed', 'ascend' ),
						'type' => 'select',
						'options' => array(
							'true' => __( 'Show as tabs', 'ascend' ),
							'list' => __( 'Show Content section by section', 'ascend' ),
							'none' => __( 'Show no content', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'true',
					),
					array(
						'id'        => 'product_description_background',
						'type'      => 'background',
						'output'    => array( '.list-woocommerce-tab-panel-description' ),
						'title'     => __( 'Product Description Background', 'ascend' ),
						'required' => array( 'product_tabs', '=', 'list' ),
					),
					array(
						'id'        => 'product_additional_background',
						'type'      => 'background',
						'output'    => array( '.list-woocommerce-tab-panel-additional' ),
						'title'     => __( 'Product Additional Background', 'ascend' ),
						'required' => array( 'product_tabs', '=', 'list' ),
					),
					array(
						'id'        => 'product_reviews_background',
						'type'      => 'background',
						'output'    => array( '.list-woocommerce-tab-panel-reviews' ),
						'title'     => __( 'Product Reviews Background', 'ascend' ),
						'required' => array( 'product_tabs', '=', 'list' ),
					),
					array(
						'id' => 'ptab_description',
						'type' => 'slider',
						'title' => __( 'Product Tab Order - Lowest First', 'ascend' ),
						'desc' => __( 'Description Tab', 'ascend' ),
						'default'       => '10',
						'min'       => '5',
						'step'      => '5',
						'max'       => '60',
					),
					array(
						'id' => 'ptab_additional',
						'type' => 'slider',
						'desc' => __( 'Additional Information Tab', 'ascend' ),
						'default'       => '20',
						'min'       => '5',
						'step'      => '5',
						'max'       => '60',
					),
					array(
						'id' => 'ptab_reviews',
						'type' => 'slider',
						'desc' => __( 'Reviews Tab', 'ascend' ),
						'default'       => '30',
						'min'       => '5',
						'step'      => '5',
						'max'       => '60',
					),
					array(
						'id' => 'custom_tab_01',
						'type' => 'switch',
						'title' => __( 'Activate Custom Tab 01', 'ascend' ),
						'subtitle' => __( 'This adds a custom product tab to your products', 'ascend' ),
						'default'       => 0,
					),
					array(
						'id'        => 'product_custom_01_background',
						'type'      => 'background',
						'output'    => array( '.list-woocommerce-tab-panel-kad_custom_tab_01' ),
						'title'     => __( 'Product Custom Tab 01 Background', 'ascend' ),
						'required' => array(
							array( 'product_tabs', '=', 'list' ),
							array( 'custom_tab_01', '=', '1' ),
						),
					),
					array(
						'id' => 'custom_tab_02',
						'type' => 'switch',
						'title' => __( 'Activate Custom Tab 02', 'ascend' ),
						'subtitle' => __( 'This adds a custom product tab to your products', 'ascend' ),
						'default'       => 0,
					),
					array(
						'id'        => 'product_custom_02_background',
						'type'      => 'background',
						'output'    => array( '.list-woocommerce-tab-panel-kad_custom_tab_02' ),
						'title'     => __( 'Product Custom Tab 02 Background', 'ascend' ),
						'required' => array(
							array( 'product_tabs', '=', 'list' ),
							array( 'custom_tab_02', '=', '1' ),
						),
					),
					array(
						'id' => 'custom_tab_03',
						'type' => 'switch',
						'title' => __( 'Activate Custom Tab 03', 'ascend' ),
						'subtitle' => __( 'This adds a custom product tab to your products', 'ascend' ),
						'default'       => 0,
					),
					array(
						'id'        => 'product_custom_03_background',
						'type'      => 'background',
						'output'    => array( '.list-woocommerce-tab-panel-kad_custom_tab_03' ),
						'title'     => __( 'Product Custom Tab 03 Background', 'ascend' ),
						'required' => array(
							array( 'product_tabs', '=', 'list' ),
							array( 'custom_tab_03', '=', '1' ),
						),
					),
					array(
						'id' => 'related_products',
						'type' => 'switch',
						'title' => __( 'Display related products?', 'ascend' ),
						'subtitle' => __( 'This determines related products are displayed', 'ascend' ),
						'default'       => 1,
					),
					array(
						'id' => 'related_item_column',
						'type' => 'slider',
						'title' => __( 'Choose how many columns are in related product carousel', 'ascend' ),
						'default'   => '4',
						'min'       => '2',
						'step'      => '1',
						'max'       => '6',
						'required' => array( 'related_products', '=', '1' ),
					),
				),
			)
		);

		Redux::setSection(
			$opt_name,
			array(
				'id' => 'portfolio_settings',
				// 'priority'=> '37',
				'title' => __( 'Portfolio Settings', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Portfolio Settings', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'portfolio_permalink',
						'type' => 'text',
						'title' => __( 'Portfolio Permalink Base', 'ascend' ),
						'subtitle' => __( 'Standard: portfolio *NOTE If you change this resave your permalinks', 'ascend' ),
					),
					array(
						'id' => 'portfolio_layout',
						'type' => 'select',
						'title' => __( 'Single Portfolio Layout Default', 'ascend' ),
						'options' => array(
							'full' => __( 'No sidebar layout', 'ascend' ),
							'sidebar' => __( 'Sidebar Layout', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'full',
					),
					array(
						'id' => 'portfolio_sidebar_default',
						'type' => 'select',
						'title' => __( 'Choose a Default Sidebar for your Single Portfolio post', 'ascend' ),
						'data' => 'sidebars',
						'default' => 'sidebar-primary',
						'width' => 'width:60%',
					),
					array(
						'id' => 'info_portfolio_post_header',
						'type' => 'info',
						'desc' => __( 'Single Portfolio Post Header', 'ascend' ),
					),
					array(
						'id' => 'portfolio_post_title',
						'type' => 'switch',
						'title' => __( 'Show Portfolio Title in Header area by default', 'ascend' ),
						'subtitle' => __( 'This can be overridden on each portfolio.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'portfolio_post_title_tag',
						'type' => 'select',
						'title' => __( 'Post title html tag output.', 'ascend' ),
						'subtitle' => __( 'This is used for SEO purposes in case you want an h1 tag futher down your post content.', 'ascend' ),
						'options' => array(
							'h1' => __( 'h1', 'ascend' ),
							'h2' => __( 'h2', 'ascend' ),
							'h3' => __( 'h3', 'ascend' ),
							'span' => __( 'span', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'h1',
					),
					array(
						'id' => 'portfolio_post_title_content',
						'type' => 'select',
						'title' => __( 'Product Default Title Text', 'ascend' ),
						'options' => array(
							'posttitle' => __( 'Portfolio Title', 'ascend' ),
							'portfolio-type' => __( 'Type of Portfolio', 'ascend' ),
							'custom' => __( 'Custom', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'posttitle',
					),
					array(
						'id' => 'portfolio_header_title_text',
						'type' => 'text',
						'title' => __( 'Portfolio Default Title', 'ascend' ),
						'subtitle' => __( 'Example: Projects', 'ascend' ),
						'required' => array( 'portfolio_post_title_content', '=', 'custom' ),
					),
					array(
						'id' => 'portfolio_header_subtitle_text',
						'type' => 'text',
						'title' => __( 'Portfolio Default Subtitle', 'ascend' ),
						'required' => array( 'portfolio_post_title_content', '=', 'custom' ),
					),
					array(
						'id' => 'info_portfolio_nav_options',
						'type' => 'info',
						'desc' => __( 'Portfolio Navigation Options', 'ascend' ),
					),
					array(
						'id' => 'portfolio_single_nav',
						'type' => 'switch',
						'title' => __( 'Enable Arrow navigation for single portfolio posts?', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'portfolio_single_nav_cat',
						'type' => 'switch',
						'title' => __( 'Portfolio Navigation thru category only?', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'portfolio_link_type',
						'type' => 'select',
						'title' => __( 'Portfolio Grid Icon Link', 'ascend' ),
						'options' => array(
							'page' => __( 'Page', 'ascend' ),
							'type' => __( 'Parent Portfolio Type', 'ascend' ),
							'none' => __( 'None', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'type',
					),
					array(
						'id' => 'portfolio_link',
						'type' => 'select',
						'data' => 'pages',
						'width' => 'width:60%',
						'title' => __( 'Select Default Portfolio Page', 'ascend' ),
						'subtitle' => __( 'This sets the grid link in every portfolio post.', 'ascend' ),
					),
					array(
						'id' => 'info_portfolio_post_content',
						'type' => 'info',
						'desc' => __( 'Single Portfolio Content Settings', 'ascend' ),
					),
					array(
						'id' => 'portfolio_post_title_inpost',
						'type' => 'switch',
						'title' => __( 'Show the Title in post content', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'project_layout_default',
						'type' => 'select',
						'title' => __( 'Project Layout Default', 'ascend' ),
						'options' => array(
							'beside' => __( 'Beside 40%', 'ascend' ),
							'besidesmall' => __( 'Beside 33%', 'ascend' ),
							'above' => __( 'Above', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'beside',
					),
					array(
						'id' => 'portfolio_comments',
						'type' => 'switch',
						'title' => __( 'Allow Comments on Portfolio Posts', 'ascend' ),
						'subtitle' => __( 'Turn on to allow Comments on Portfolio posts', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'info_portfolio_recent_carousel',
						'type' => 'info',
						'desc' => __( 'Portfolio Post Bottom Carousel', 'ascend' ),
					),
					array(
						'id' => 'portfolio_bottom_carousel',
						'type' => 'select',
						'title' => __( 'Portfolio Bottom Carousel', 'ascend' ),
						'options' => array(
							'related' => __( 'Display Related Carousel by default ', 'ascend' ),
							'recent' => __( 'Display Recent Carousel by Default', 'ascend' ),
							'none' => __( 'No default carousel', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'none',
					),
					array(
						'id' => 'portfolio_bottom_car_column',
						'type' => 'slider',
						'title' => __( 'Choose how many columns to show on recent portfolio carousel.', 'ascend' ),
						'default'       => '4',
						'min'       => '2',
						'step'      => '1',
						'max'       => '6',
					),
					array(
						'id' => 'portfolio_bottom_car_speed',
						'type' => 'slider',
						'title' => __( 'Choose the carousel speed (in seconds).', 'ascend' ),
						'default'       => '9',
						'min'       => '2',
						'step'      => '1',
						'max'       => '12',
					),
					array(
						'id' => 'portfolio_bottom_car_items',
						'type' => 'slider',
						'title' => __( 'Choose how many items to show on recent portfolio carouselChoose how many portfolio columns to show on portfolio archive pages', 'ascend' ),
						'default'       => '8',
						'min'       => '6',
						'step'      => '1',
						'max'       => '18',
					),
					array(
						'id' => 'portfolio_bottom_car_scroll',
						'type' => 'select',
						'title' => __( 'Portfolio Carousel Scroll', 'ascend' ),
						'subtitle' => __( 'Choose how the portfolio items scroll.', 'ascend' ),
						'options' => array(
							'oneitem' => __( 'One Item', 'ascend' ),
							'all' => __( 'All Visible', 'ascend' ),
						),
						'default' => 'oneitem',
						'width' => 'width:60%',
					),
					array(
						'id' => 'info_portfolio_cat_defaults',
						'type' => 'info',
						'desc' => __( 'Portfolio Archive Pages', 'ascend' ),
					),
					array(
						'id' => 'portfolio_tax_style',
						'type' => 'select',
						'title' => __( 'Portfolio Style', 'ascend' ),
						'subtitle' => __( 'Choose how the portfolio items should be styled.', 'ascend' ),
						'options' => array(
							'pgrid' => __( 'Normal Grid', 'ascend' ),
							'pgrid-no-margin' => __( 'Grid without margin between items', 'ascend' ),
							'poststyle' => __( 'Post style', 'ascend' ),
							'mosaic' => __( 'Mosaic', 'ascend' ),
							'tiles' => __( 'Tiles', 'ascend' ),
						),
						'default' => 'pgrid',
						'width' => 'width:60%',
					),
					array(
						'id' => 'portfolio_tax_ratio',
						'type' => 'select',
						'title' => __( 'Portfolio Grid image ratio', 'ascend' ),
						'subtitle' => __( 'Choose how the portfolio items images should be cropped.', 'ascend' ),
						'options' => array(
							'square' => __( 'Square', 'ascend' ),
							'portrait' => __( 'Portrait', 'ascend' ),
							'landscape' => __( 'Landscape', 'ascend' ),
							'widelandscape' => __( 'Wide Landscape', 'ascend' ),
							'softcrop' => __( 'Inherit from image', 'ascend' ),
						),
						'default' => 'square',
						'width' => 'width:60%',
					),
					array(
						'id' => 'portfolio_tax_column',
						'type' => 'slider',
						'title' => __( 'Choose how many portfolio columns to show on portfolio archive pages', 'ascend' ),
						'default'   => '4',
						'min'       => '2',
						'step'      => '1',
						'max'       => '6',
					),
					array(
						'id'        => 'portfolio_tax_items',
						'type'      => 'slider',
						'title'     => __( 'Choose how many portfolio items show on portfolio archive pages', 'ascend' ),
						'default'   => '12',
						'min'       => '2',
						'step'      => '1',
						'max'       => '48',
					),
					array(
						'id'        => 'portfolio_tax_order',
						'type'      => 'select',
						'title'     => __( 'Choose order for portfolio archive pages', 'ascend' ),
						'options'   => array(
							'menu_order' => __( 'Menu Order', 'ascend' ),
							'date' => __( 'Date', 'ascend' ),
							'title' => __( 'Title', 'ascend' ),
						),
						'width'     => 'width:60%',
						'default'   => 'menu_order',
					),
					array(
						'id'        => 'portfolio_tax_show_lightbox',
						'type'      => 'switch',
						'title'     => __( 'Display lightbox link in grid?', 'ascend' ),
						'default'   => 1,
					),
					array(
						'id'        => 'portfolio_tax_show_type',
						'type'      => 'switch',
						'title'     => __( 'Show portfolio type in grid?', 'ascend' ),
						'default'   => 1,
					),
					array(
						'id'        => 'portfolio_tax_show_excerpt',
						'type'      => 'switch',
						'title'     => __( 'Display Portfolio excerpt in grid?', 'ascend' ),
						'default'   => 0,
					),

				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'page_settings',
				// 'priority'=> '37',
				'title' => __( 'Page Settings', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'page_layout',
						'type' => 'select',
						'title' => __( 'Single Page Layout Default', 'ascend' ),
						'options' => array(
							'full' => __( 'No sidebar layout', 'ascend' ),
							'sidebar' => __( 'Sidebar Layout', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'full',
					),
					array(
						'id' => 'page_sidebar_default',
						'type' => 'select',
						'title' => __( 'Choose a Default Sidebar for your Single Pages', 'ascend' ),
						'data' => 'sidebars',
						'default' => 'sidebar-primary',
						'width' => 'width:60%',
					),
					array(
						'id'        => 'default_showpagetitle',
						'type'      => 'switch',
						'title'     => __( 'Display page title by default', 'ascend' ),
						'default'   => 1,
					),
					array(
						'id' => 'page_title_tag',
						'type' => 'select',
						'title' => __( 'Page title html tag output.', 'ascend' ),
						'subtitle' => __( 'This is used for SEO purposes in case you want an h1 tag futher down your page content.', 'ascend' ),
						'options' => array(
							'h1' => __( 'h1', 'ascend' ),
							'h2' => __( 'h2', 'ascend' ),
							'h3' => __( 'h3', 'ascend' ),
							'span' => __( 'span', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'h1',
					),
					array(
						'id'        => 'page_comments',
						'type'      => 'switch',
						'title'     => __( 'Enable comments on pages', 'ascend' ),
						'default'   => 0,
					),
					array(
						'id'      => 'default_page_content_width',
						'type'    => 'select',
						'title'   => __( 'Single Page Content Width Default', 'ascend' ),
						'options' => array(
							'contained' => __( 'Contained', 'ascend' ),
							'full' => __( 'Fullwidth', 'ascend' ),
						),
						'width'   => 'width:60%',
						'default' => 'contained',
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'blog_settings',
				// 'priority'=> '37',
				'title' => __( 'Blog Settings', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Blog Settings', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'post_word_count',
						'type' => 'slider',
						'title' => __( 'Post Excerpt Length', 'ascend' ),
						'subtitle' => __( 'Determines how many words are in an Excerpt.', 'ascend' ),
						'default'   => '40',
						'min'       => '20',
						'step'      => '2',
						'max'       => '80',
					),
					array(
						'id' => 'hide_author',
						'type' => 'switch',
						'title' => __( 'Show Author output with posts?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide author output on posts.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'hide_categories',
						'type' => 'switch',
						'title' => __( 'Show Categories with posts?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide categories with posts.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'hide_comments',
						'type' => 'switch',
						'title' => __( 'Show Comment count with posts?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide comment counts with posts.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'hide_postdate',
						'type' => 'switch',
						'title' => __( 'Show Date with posts?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide date with post title.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'post_updated_date',
						'type' => 'switch',
						'title' => __( 'Show Modified Date Instead of Publish Date with posts?', 'ascend' ),
						'subtitle' => __( 'Choose to show Modified or Publish Date.', 'ascend' ),
						'default' => 0,
						'required' => array( 'hide_postdate', '=', '1' ),
					),
					array(
						'id' => 'info_blog_header',
						'type' => 'info',
						'desc' => __( 'Single Blog Post Header', 'ascend' ),
					),
					array(
						'id' => 'blog_post_title',
						'type' => 'switch',
						'title' => __( 'Show Blog Title in Header area by default', 'ascend' ),
						'subtitle' => __( 'This can be overridden on each post.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'post_title_tag',
						'type' => 'select',
						'title' => __( 'Post title html tag output.', 'ascend' ),
						'subtitle' => __( 'This is used for SEO purposes in case you want an h1 tag futher down your post content.', 'ascend' ),
						'options' => array(
							'h1' => __( 'h1', 'ascend' ),
							'h2' => __( 'h2', 'ascend' ),
							'h3' => __( 'h3', 'ascend' ),
							'span' => __( 'span', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'h1',
					),
					array(
						'id' => 'blog_post_title_content',
						'type' => 'select',
						'title' => __( 'Blog Default Title Text', 'ascend' ),
						'options' => array(
							'posttitle' => __( 'Blog Title', 'ascend' ),
							'category' => __( 'Category Title of Post', 'ascend' ),
							'custom' => __( 'Custom', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'category',
					),
					array(
						'id' => 'blog_header_title_text',
						'type' => 'text',
						'title' => __( 'Blog Default Title', 'ascend' ),
						'subtitle' => __( 'Example: Blog', 'ascend' ),
						'required' => array( 'blog_post_title_content', '=', 'custom' ),
					),
					array(
						'id' => 'blog_header_subtitle_text',
						'type' => 'text',
						'title' => __( 'Blog Default Subtitle', 'ascend' ),
						'required' => array( 'blog_post_title_content', '=', 'custom' ),
					),
					array(
						'id' => 'info_blog_post_content',
						'type' => 'info',
						'desc' => __( 'Single Blog Content Settings', 'ascend' ),
					),
					array(
						'id' => 'blog_post_title_inpost',
						'type' => 'switch',
						'title' => __( 'Show the Title in post content', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'post_author_default',
						'type' => 'select',
						'title' => __( 'Blog Post Author Box Default', 'ascend' ),
						'options' => array(
							'no' => __( 'No, Do not Show', 'ascend' ),
							'yes' => __( 'Yes, Show', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'no',
					),
					array(
						'id' => 'post_carousel_default',
						'type' => 'select',
						'title' => __( 'Blog Post Bottom Carousel Default', 'ascend' ),
						'options' => array(
							'no' => __( 'No, Do not Show', 'ascend' ),
							'recent' => __( 'Yes - Display Recent Posts', 'ascend' ),
							'similar' => __( 'Yes - Display Similar Posts', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'no',
					),
					array(
						'id' => 'post_carousel_columns',
						'type' => 'slider',
						'title' => __( 'Choose how many items to show on recent/similar post carousel.', 'ascend' ),
						'default'       => '3',
						'min'       => '2',
						'step'      => '1',
						'max'       => '6',
					),
					array(
						'id' => 'info_blog_nav_options',
						'type' => 'info',
						'desc' => __( 'Blog Navigation Options', 'ascend' ),
					),
					array(
						'id'        => 'show_postlinks',
						'type'      => 'switch',
						'title'     => __( 'Show Previous and Next posts links?', 'ascend' ),
						'subtitle'  => __( 'Choose to show or hide previous and next post links in the footer of a single post.', 'ascend' ),
						'default'   => 1,
					),
					array(
						'id' => 'postlinks_in_cat',
						'type' => 'select',
						'title' => __( 'Blog post navigation setting', 'ascend' ),
						'options' => array(
							'all' => __( 'Navigate through All Posts', 'ascend' ),
							'cat' => __( 'Navigate through Categories', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'all',
						'required' => array( 'show_postlinks', '=', '1' ),
					),
					array(
						'id' => 'info_blog_post_archive',
						'type' => 'info',
						'desc' => __( 'Blog archive Settings', 'ascend' ),
					),
					array(
						'id'        => 'blog_infinitescroll',
						'type'      => 'switch',
						'title'     => __( 'Use Infinite Scroll on Blog Archive pages', 'ascend' ),
						'subtitle'  => __( 'Removes Pagination and creates infinite scroll instead.', 'ascend' ),
						'default'   => 0,
					),
					array(
						'id'        => 'postexcerpt_hard_crop',
						'type'      => 'switch',
						'title'     => __( 'Crop blog grid images to equal height', 'ascend' ),
						'subtitle'  => __( 'Turn on if you want the blog grid images to have the same height.', 'ascend' ),
						'default'   => 0,
					),
					array(
						'id'        => 'blog_grid_display_height',
						'type'      => 'switch',
						'title'     => __( 'Display Blog Grid posts as rows instead of masonry', 'ascend' ),
						'subtitle'  => __( 'Turn on if you want the blog grid to be displayed in equal rows regardless of post content.', 'ascend' ),
						'default'   => 1,
					),
					array(
						'id' => 'info_blog_defaults',
						'type' => 'info',
						'desc' => __( 'Blog Post Defaults', 'ascend' ),
					),
					array(
						'id' => 'blog_layout',
						'type' => 'select',
						'title' => __( 'Single Blog Post Layout Default', 'ascend' ),
						'options' => array(
							'full' => __( 'No sidebar layout', 'ascend' ),
							'sidebar' => __( 'Sidebar Layout', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'sidebar',
					),
					array(
						'id' => 'blog_sidebar_default',
						'type' => 'select',
						'title' => __( 'Choose a Default Sidebar for your Single blog post', 'ascend' ),
						'data' => 'sidebars',
						'default' => 'sidebar-primary',
						'width' => 'width:60%',
					),
					array(
						'id' => 'default_placeholder_image',
						'type' => 'media',
						'url' => true,
						'title' => __( 'Default post summary feature Image', 'ascend' ),
						'subtitle' => __( 'Replace theme default feature image for posts without a featured image', 'ascend' ),
					),
					array(
						'id'        => 'post_header_single_image_height',
						'type'      => 'switch',
						'title'     => __( 'Soft crop post header landscape images and blog list landscape images', 'ascend' ),
						'subtitle'  => __( 'Turn on if you want the blog standard list images height to be based on the ratio of the uploaded image not a fixed crop.', 'ascend' ),
						'default'   => 0,
					),
					array(
						'id' => 'info_blog_defaults_stand',
						'type' => 'info',
						'desc' => __( 'Blog Post Defaults Standard', 'ascend' ),
					),
					array(
						'id' => 'post_summery_default',
						'type' => 'select',
						'title' => __( 'Standard Blog Post Summary Default', 'ascend' ),
						'options' => array(
							'text' => __( 'Text', 'ascend' ),
							'img_portrait' => __( 'Portrait Image', 'ascend' ),
							'img_landscape' => __( 'Landscape Image', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'img_landscape',
					),
					array(
						'id' => 'info_blog_defaults_image',
						'type' => 'info',
						'desc' => __( 'Blog Post Defaults Image', 'ascend' ),
					),
					array(
						'id' => 'image_post_summery_default',
						'type' => 'select',
						'title' => __( 'Image Blog Post Summary Default', 'ascend' ),
						'options' => array(
							'text' => __( 'Text', 'ascend' ),
							'img_portrait' => __( 'Portrait Image', 'ascend' ),
							'img_landscape' => __( 'Landscape Image', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'img_portrait',
					),
					array(
						'id' => 'image_post_blog_default',
						'type' => 'select',
						'title' => __( 'Single Image Post Head Content', 'ascend' ),
						'options' => array(
							'none' => __( 'None', 'ascend' ),
							'image' => __( 'Image', 'ascend' ),
							'image_below' => __( 'Image Below Title', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'image',
					),
					array(
						'id' => 'info_blog_defaults_gallery',
						'type' => 'info',
						'desc' => __( 'Blog Post Defaults gallery', 'ascend' ),
					),
					array(
						'id' => 'gallery_post_summery_default',
						'type' => 'select',
						'title' => __( 'Gallery Blog Post Summary Default', 'ascend' ),
						'options' => array(
							'text' => __( 'Text', 'ascend' ),
							'img_portrait' => __( 'Portrait Image', 'ascend' ),
							'img_landscape' => __( 'Landscape Image', 'ascend' ),
							'slider_portrait' => __( 'Portrait Slider', 'ascend' ),
							'slider_landscape' => __( 'Landscape Slider', 'ascend' ),
							'gallery_grid' => __( 'Photo Collage - (Use 2 to 5 images)', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'slider_landscape',
					),
					array(
						'id' => 'gallery_post_blog_default',
						'type' => 'select',
						'title' => __( 'Single Gallery Post Head Content', 'ascend' ),
						'options' => array(
							'none' => __( 'None', 'ascend' ),
							'flex' => __( 'Image Slider - (Cropped Image Ratio)', 'ascend' ),
							'carouselslider' => __( 'Carousel Slider - (Different Image Ratio)', 'ascend' ),
							'thumbslider' => __( 'Image Slider with thumbnails (Cropped Image Ratio)', 'ascend' ),
							'imgcarousel' => __( 'Image Carousel - (Muiltiple Images Showing At Once)', 'ascend' ),
							'imgcarousel' => __( 'Image Collage - (Use 2 to 5 images)', 'ascend' ),
							'shortcode' => __( 'Shortcode', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'flex',
					),
					array(
						'id' => 'info_blog_defaults_video',
						'type' => 'info',
						'desc' => __( 'Blog Post Defaults Video', 'ascend' ),
					),
					array(
						'id' => 'video_post_summery_default',
						'type' => 'select',
						'title' => __( 'Video Blog Post Summary Default', 'ascend' ),
						'options' => array(
							'text' => __( 'Text', 'ascend' ),
							'img_portrait' => __( 'Portrait Image', 'ascend' ),
							'img_landscape' => __( 'Landscape Image', 'ascend' ),
							'video' => __( 'Video', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'video',
					),
					array(
						'id' => 'video_post_blog_default',
						'type' => 'select',
						'title' => __( 'Single Video Post Head Content', 'ascend' ),
						'options' => array(
							'none' => __( 'None', 'ascend' ),
							'video' => __( 'Video', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'video',
					),
					array(
						'id' => 'info_blog_category',
						'type' => 'info',
						'desc' => __( 'Blog Category/Archive Defaults', 'ascend' ),
					),
					array(
						'id' => 'category_post_summary',
						'type' => 'select',
						'title' => __( 'Category Display Type', 'ascend' ),
						'options' => array(
							'normal' => __( 'Standard', 'ascend' ),
							'below_title' => __( 'Standard with image below title', 'ascend' ),
							'full' => __( 'Full Post', 'ascend' ),
							'grid' => __( 'Grid', 'ascend' ),
							'grid_standard' => __( 'Grid with first post as standard', 'ascend' ),
							'photo' => __( 'Photo', 'ascend' ),
							'mosaic' => __( 'Mosaic', 'ascend' ),
						),
						'default' => 'normal',
						'width' => 'width:60%',
					),
					array(
						'id' => 'category_post_grid_column',
						'type' => 'select',
						'title' => __( 'Category Display Columns', 'ascend' ),
						'options' => array(
							'2' => __( 'Two Column', 'ascend' ),
							'3' => __( 'Three Column', 'ascend' ),
							'4' => __( 'Four Column', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => '3',
						'required' => array(
							array( 'category_post_summary', '!=', 'normal' ),
							array( 'category_post_summary', '!=', 'below_title' ),
							array( 'category_post_summary', '!=', 'full' ),
							array( 'category_post_summary', '!=', 'mosaic' ),
						),
					),
					array(
						'id' => 'blog_cat_layout',
						'type' => 'select',
						'title' => __( 'Blog Category/Archive Layout', 'ascend' ),
						'options' => array(
							'full' => __( 'No sidebar layout', 'ascend' ),
							'sidebar' => __( 'Sidebar Layout', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'full',
					),
					array(
						'id' => 'blog_cat_sidebar_default',
						'type' => 'select',
						'title' => __( 'Choose a Default Sidebar for your Category/Archive pages', 'ascend' ),
						'data' => 'sidebars',
						'default' => 'sidebar-primary',
						'width' => 'width:60%',
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'staff_settings',
				'title' => __( 'Staff Settings', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'staff_layout',
						'type' => 'select',
						'title' => __( 'Single Staff Layout Default', 'ascend' ),
						'options' => array(
							'full' => __( 'No sidebar layout', 'ascend' ),
							'sidebar' => __( 'Sidebar Layout', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'sidebar',
					),
					array(
						'id' => 'staff_sidebar_default',
						'type' => 'select',
						'title' => __( 'Choose a Default Sidebar for your Single Staff posts', 'ascend' ),
						'data' => 'sidebars',
						'default' => 'sidebar-primary',
						'width' => 'width:60%',
					),
					array(
						'id' => 'info_staff_post_header',
						'type' => 'info',
						'desc' => __( 'Single Staff Post Header', 'ascend' ),
					),
					array(
						'id' => 'staff_post_title',
						'type' => 'switch',
						'title' => __( 'Show Post Title in Header area by default', 'ascend' ),
						'subtitle' => __( 'This can be overridden on each post.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'staff_post_title_tag',
						'type' => 'select',
						'title' => __( 'Post title html tag output.', 'ascend' ),
						'subtitle' => __( 'This is used for SEO purposes in case you want an h1 tag futher down your post content.', 'ascend' ),
						'options' => array(
							'h1' => __( 'h1', 'ascend' ),
							'h2' => __( 'h2', 'ascend' ),
							'h3' => __( 'h3', 'ascend' ),
							'span' => __( 'span', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'h1',
					),
					array(
						'id' => 'staff_post_title_content',
						'type' => 'select',
						'title' => __( 'Staff Default Title Text', 'ascend' ),
						'options' => array(
							'posttitle' => __( 'Staff Title', 'ascend' ),
							'group' => __( 'Group of Staff', 'ascend' ),
							'custom' => __( 'Custom', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'posttitle',
					),
					array(
						'id' => 'staff_header_title_text',
						'type' => 'text',
						'title' => __( 'Post Default Title', 'ascend' ),
						'subtitle' => __( 'Example: Staff', 'ascend' ),
						'required' => array( 'staff_post_title_content', '=', 'custom' ),
					),
					array(
						'id' => 'staff_header_subtitle_text',
						'type' => 'text',
						'title' => __( 'Post Default Subtitle', 'ascend' ),
						'required' => array( 'staff_post_title_content', '=', 'custom' ),
					),
					array(
						'id' => 'info_staff_post_content',
						'type' => 'info',
						'desc' => __( 'Single Staff Post Content', 'ascend' ),
					),
					array(
						'id' => 'staff_post_title_inpost',
						'type' => 'switch',
						'title' => __( 'Show the Title in post content', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'info_staff_nav_options',
						'type' => 'info',
						'desc' => __( 'Staff Navigation Options', 'ascend' ),
					),
					array(
						'id' => 'staff_single_nav',
						'type' => 'switch',
						'title' => __( 'Enable Arrow navigation for single staff post?', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'staff_single_nav_cat',
						'type' => 'switch',
						'title' => __( 'Staff navigation thru group only?', 'ascend' ),
						'default' => 0,
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'testimonial_options',
				// 'priority'=> '37',
				'title' => __( 'Testimonial Options', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'testimonial_layout',
						'type' => 'select',
						'title' => __( 'Single Testimonial Layout Default', 'ascend' ),
						'options' => array(
							'full' => __( 'No sidebar layout', 'ascend' ),
							'sidebar' => __( 'Sidebar Layout', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'full',
					),
					array(
						'id' => 'testimonial_sidebar_default',
						'type' => 'select',
						'title' => __( 'Choose a Default Sidebar for your Single Testimonial post', 'ascend' ),
						'data' => 'sidebars',
						'default' => 'sidebar-primary',
						'width' => 'width:60%',
					),
					array(
						'id' => 'info_testimonial_post_header',
						'type' => 'info',
						'desc' => __( 'Single Testimonial Post Header', 'ascend' ),
					),
					array(
						'id' => 'testimonial_post_title',
						'type' => 'switch',
						'title' => __( 'Show Post Title in Header area by default', 'ascend' ),
						'subtitle' => __( 'This can be overridden on each post.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'testimonial_post_title_tag',
						'type' => 'select',
						'title' => __( 'Post title html tag output.', 'ascend' ),
						'subtitle' => __( 'This is used for SEO purposes in case you want an h1 tag futher down your post content.', 'ascend' ),
						'options' => array(
							'h1' => __( 'h1', 'ascend' ),
							'h2' => __( 'h2', 'ascend' ),
							'h3' => __( 'h3', 'ascend' ),
							'span' => __( 'span', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'h1',
					),
					array(
						'id' => 'testimonial_post_title_content',
						'type' => 'select',
						'title' => __( 'Testimonial Default Title Text', 'ascend' ),
						'options' => array(
							'posttitle' => __( 'Testimonial Title', 'ascend' ),
							'group' => __( 'Group of Testimonial', 'ascend' ),
							'custom' => __( 'Custom', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'posttitle',
					),
					array(
						'id' => 'testimonial_header_title_text',
						'type' => 'text',
						'title' => __( 'Post Default Title', 'ascend' ),
						'subtitle' => __( 'Example: Testimonial', 'ascend' ),
						'required' => array( 'testimonial_post_title_content', '=', 'custom' ),
					),
					array(
						'id' => 'testimonial_header_subtitle_text',
						'type' => 'text',
						'title' => __( 'Post Default Subtitle', 'ascend' ),
						'required' => array( 'testimonial_post_title_content', '=', 'custom' ),
					),
					array(
						'id' => 'info_testimonial_post_content',
						'type' => 'info',
						'desc' => __( 'Single testimonial Post Content', 'ascend' ),
					),
					array(
						'id' => 'testimonial_post_title_inpost',
						'type' => 'switch',
						'title' => __( 'Show the Title in post content', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'info_testimonial_nav_options',
						'type' => 'info',
						'desc' => __( 'Testimonial Navigation Options', 'ascend' ),
					),
					array(
						'id' => 'testimonial_single_nav',
						'type' => 'switch',
						'title' => __( 'Enable Arrow navigation for single testimonial post?', 'ascend' ),
						'default' => 0,
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id'         => 'custom_post_options',
				'icon'       => 'icon-quill2',
				'icon_class' => 'icon-large',
				'customizer' => false,
				'title'      => __( 'Custom Post Type Options', 'ascend' ),
				'desc'       => '<div class="redux-info-field"><p>' . __( 'This applies to post types that may be added by 3rd party plugins or through a child theme.', 'ascend' ) . '</p></div>',
				'fields'     => array(
					array(
						'id'      => 'custom_post_sidebar_default',
						'type'    => 'select',
						'title'   => __( 'Custom Post Type Sidebar Default', 'ascend' ),
						'options' => array(
							'yes' => __( 'Yes, Show', 'ascend' ),
							'no'  => __( 'No, Do not Show', 'ascend' ),
						),
						'width'   => 'width:60%',
						'default' => 'yes',
					),
					array(
						'id'      => 'custom_post_sidebar_id_default',
						'type'    => 'select',
						'title'   => __( 'Choose a default sidebar for your Custom Post Types', 'ascend' ),
						'data'    => 'sidebars',
						'default' => 'sidebar-primary',
						'width'   => 'width:60%',
					),
					array(
						'id'       => 'custom_post_show_featured_image',
						'type'     => 'switch',
						'title'    => __( 'Show featured image with custom post type?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide featured image above post title.', 'ascend' ),
						'default'  => 0,
					),
					array(
						'id'      => 'custom_post_title_inpost',
						'type'    => 'switch',
						'title'   => __( 'Show the Title in post content', 'ascend' ),
						'default' => 1,
					),
					array(
						'id'       => 'custom_post_show_postdate',
						'type'     => 'switch',
						'title'    => __( 'Show date with posts?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide date with post title.', 'ascend' ),
						'default'  => 0,
					),
					array(
						'id'       => 'custom_post_show_author',
						'type'     => 'switch',
						'title'    => __( 'Show Author icon with custom post type?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide author icon under post title.', 'ascend' ),
						'default'  => 0,
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'basic_styling',
				'icon_class' => 'icon-large',
				'title' => __( 'Basic Styling', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Basic Styling', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'primary_color',
						'type' => 'color',
						'title' => __( 'Primary Color', 'ascend' ),
						'subtitle' => __( 'Choose the default Highlight color for your site.', 'ascend' ),
						'transparent' => false,
						'validate' => 'color',
					),
					array(
						'id' => 'topbar_font_color',
						'type' => 'color',
						'title' => __( 'Topbar Font color', 'ascend' ),
						'default' => '',
						'output'    => array( '.kad-topbar-flex-item, .kad-topbar-flex-item a, .kad-topbar-flex-item .kadence_social_widget a, .topbarclass .kt-woo-account-nav .kad-customer-name h5, .topbarclass .kt-mini-cart-refreash .total, #topbar .kt-header-extras p.woocommerce-mini-cart__empty-message' ),
						'transparent' => false,
						'validate' => 'color',
					),
					array(
						'id' => 'topbar_font_hover_color',
						'type' => 'color',
						'title' => __( 'Topbar Font Link Hover color', 'ascend' ),
						'default' => '',
						'output'    => array( '.kad-topbar-flex-item a:hover' ),
						'transparent' => false,
						'validate' => 'color',
					),
					array(
						'id' => 'footerfont_color',
						'type' => 'color',
						'title' => __( 'Footer Font Color', 'ascend' ),
						'output'    => array( '.footerclass a, .footerclass, .footerclass h4, .footerclass h3, .footerclass h5' ),
						'transparent' => false,
						'validate' => 'color',
					),
					array(
						'id' => 'footerfont_hover_color',
						'type' => 'color',
						'title' => __( 'Footer Font Link Hover Color', 'ascend' ),
						'output'    => array(
							'color' => '.footerclass a:hover',
							'border-color' => '.footerclass .menu li a:hover',
						),
						'transparent' => false,
						'validate' => 'color',
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'advanced_styling',
				'icon_class' => 'icon-large',
				'title' => __( 'Advanced Styling', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Main Content Background', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id'        => 'content_background',
						'type'      => 'background',
						'output'    => array( '.contentclass, .above-footer-widgets .widget-title span, .footer-widget-title span, .kt-title span, .sidebar .widget-title span' ),
						'title'     => __( 'Content Background', 'ascend' ),
					),
					array(
						'id' => 'info_topbar_background',
						'type' => 'info',
						'desc' => __( 'Topbar Background', 'ascend' ),
					),
					array(
						'id'        => 'topbar_background',
						'type'      => 'background',
						'output'    => array( '.topbarclass, .topbarclass .sf-menu ul ' ),
						'title'     => __( 'Topbar Background', 'ascend' ),
					),
					array(
						'id' => 'info_header_background',
						'type' => 'info',
						'desc' => __( 'Header Background', 'ascend' ),
					),
					array(
						'id' => 'header_background_choice',
						'type' => 'select',
						'title' => __( 'Header Background Style', 'ascend' ),
						'options' => array(
							'simple' => __( 'Simple', 'ascend' ),
							'full' => __( 'Full', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'simple',

					),
					array(
						'id'        => 'header_background',
						'type'      => 'background',
						'output'    => array( '.headerclass, .mobile-headerclass, .kad-fixed-vertical-background-area' ),
						'title'     => __( 'Header Background', 'ascend' ),
						'required'  => array( 'header_background_choice', '=', 'full' ),
					),
					array(
						'id' => 'header_background_color',
						'type' => 'color',
						'title' => __( 'Header Background Color', 'ascend' ),
						'default' => '',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'header_background_choice', '=', 'simple' ),
					),
					array(
						'id' => 'header_background_transparency',
						'type' => 'select',
						'title' => __( 'If background is color, select Transparency', 'ascend' ),
						'options' => array(
							'1' => '1',
							'0.9' => '0.9',
							'0.8' => '0.8',
							'0.7' => '0.7',
							'0.6' => '0.6',
							'0.5' => '0.5',
							'0.4' => '0.4',
							'0.3' => '0.3',
							'0.2' => '0.2',
							'0.1' => '0.1',
							'0' => '0',
						),
						'default' => '1',
						'width' => 'width:60%',
						'required' => array( 'header_background_choice', '=', 'simple' ),
					),
					array(
						'id' => 'vheader_border_color',
						'type' => 'color',
						'title' => __( 'Beside Header Border Color', 'ascend' ),
						'default' => '',
						'transparent' => true,
						'validate' => 'color',
						'output' => array( 'border-color' => '.kad-fixed-vertical-background-area' ),
						'required' => array( 'site_layout', '!=', 'above' ),
					),
					array(
						'id' => 'info_footer_background',
						'type' => 'info',
						'desc' => __( 'Footer Background', 'ascend' ),

					),
					array(
						'id'        => 'footer_background',
						'type'      => 'background',
						'output'    => array( '.footerclass, .footerclass .footer-widget-title span, body.body-style-bubbled .footerclass .footer-widget-title span' ),
						'title'     => __( 'Footer Background', 'ascend' ),
					),
					array(
						'id'        => 'footer_base_background',
						'type'      => 'background',
						'output'    => array( '.footerbase' ),
						'title'     => __( 'Footer Base Background', 'ascend' ),
					),
					array(
						'id' => 'info_body_background',
						'type' => 'info',
						'desc' => __( 'Body Background', 'ascend' ),
					),
					array(
						'id'        => 'body_background',
						'type'      => 'background',
						'output'    => array( 'body' ),
						'title'     => __( 'Body Background', 'ascend' ),
						'subtitle'  => __( 'This shows if site is using the boxed layout option.', 'ascend' ),
					),
				),
			)
		);

		Redux::setSection(
			$opt_name,
			array(
				'id' => 'typography',
				'title' => __( 'Typography', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Header Font Options', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'font_h1',
						'type' => 'typography',
						'title' => __( 'H1 Headings', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => true,
						'line-height' => true,
						'letter-spacing' => true,
						'text-align' => false,
						'color' => true,
						'preview' => true,
						'output' => array( 'h1, .h1class' ),
						'subtitle' => __( 'Choose Size and Style for h1 (This Styles Your Page Titles)', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'subsets' => 'latin',
							'color' => '#444444',
							'font-style' => '600',
							'font-size' => '40px',
							'line-height' => '40px',
							'letter-spacing' => '1.2px',
						),
					),
					array(
						'id' => 'font_h2',
						'type' => 'typography',
						'title' => __( 'H2 Headings', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color' => true,
						'preview' => true,
						'output' => array( 'h2, .h2class' ),
						'subtitle' => __( 'Choose Size and Style for h2', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'subsets' => 'latin',
							'color' => '#444444',
							'font-style' => '400',
							'font-size' => '32px',
							'line-height' => '40px',
							'letter-spacing' => '1.2px',
						),
					),
					array(
						'id' => 'font_h3',
						'type' => 'typography',
						'title' => __( 'H3 Headings', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color' => true,
						'preview' => true,
						'output' => array( 'h3' ),
						'subtitle' => __( 'Choose Size and Style for h3', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'subsets' => 'latin',
							'color' => '#444444',
							'font-style' => '400',
							'font-size' => '28px',
							'line-height' => '40px',
							'letter-spacing' => '1.2px',
						),
					),
					array(
						'id' => 'font_h4',
						'type' => 'typography',
						'title' => __( 'H4 Headings', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => true,
						'line-height' => true,
						'letter-spacing' => true,
						'text-align' => false,
						'color' => true,
						'preview' => true,
						'output' => array( 'h4' ),
						'subtitle' => __( 'Choose Size and Style for h4', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'subsets' => 'latin',
							'color' => '#555555',
							'font-style' => '400',
							'font-size' => '24px',
							'line-height' => '40px',
							'letter-spacing' => '1.2px',
						),
					),
					array(
						'id' => 'font_h5',
						'type' => 'typography',
						'title' => __( 'H5 Headings', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => true,
						'line-height' => true,
						'letter-spacing' => true,
						'text-align' => false,
						'color' => true,
						'preview' => true,
						'output' => array( 'h5' ),
						'subtitle' => __( 'Choose Size and Style for h5', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'subsets' => 'latin',
							'color' => '#555555',
							'font-style' => '',
							'font-size' => '18px',
							'line-height' => '24px',
							'letter-spacing' => '1.2px',
						),
					),
					array(
						'id' => 'font_subtitle',
						'type' => 'typography',
						'title' => __( 'Page Subtitle', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'line-height' => false,
						'color' => false,
						'preview' => true,
						'output' => array( '.titleclass .subtitle' ),
						'subtitle' => __( 'Choose Size and Style for Page Subtitle', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'subsets' => 'latin',
							'font-style' => '400',
							'letter-spacing' => '1.2px',
						),
					),
					array(
						'id' => 'info_body_font',
						'type' => 'info',
						'desc' => __( 'Body Font Options', 'ascend' ),
					),
					array(
						'id' => 'font_p',
						'type' => 'typography',
						'title' => __( 'Body Font', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'all_styles' => true,
						'color' => true,
						'preview' => true,
						'output' => array( 'body' ),
						'subtitle' => __( 'Choose Size and Style for paragraphs', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'subsets' => 'latin',
							'color' => '#444',
							'font-style' => '400',
							'font-size' => '16px',
							'line-height' => '24px',
							'letter-spacing' => '0px',
						),
					),
				),
			)
		);

		Redux::setSection(
			$opt_name,
			array(
				'id' => 'menu_settings',
				'title' => __( 'Menu Settings', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Menu Options', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'show_subindicator',
						'type' => 'switch',
						'title' => __( 'Enable sub-indicator in menu?', 'ascend' ),
						'subtitle' => __( 'Choose to enable arrows showing there is a submenu', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'show_vert_subindicator',
						'type' => 'switch',
						'title' => __( 'Enable sub-indicator in vertical menu?', 'ascend' ),
						'subtitle' => __( 'Choose to enable arrows showing there is a submenu', 'ascend' ),
						'default' => 0,
						'required' => array( 'site_layout', '!=', 'above' ),
					),
					array(
						'id' => 'info_menu_primary_font',
						'type' => 'info',

						'desc' => __( 'Primary Menu Options', 'ascend' ),
					),
					array(
						'id' => 'font_primary_menu',
						'type' => 'typography',
						'title' => __( 'Primary Menu Font', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => true,
						'text-align' => false,
						'line-height' => true,
						'text-transform' => true,
						'color' => true,
						'letter-spacing' => true,
						'preview' => true,
						'output' => array( '.nav-main ul.sf-menu > li > a, .kad-header-menu-inner .kt-header-extras ul.sf-menu > li > a, .kad-header-menu-inner .kt-header-extras .kt-extras-label [class*="kt-icon-"], .kt-header-extras .sf-vertical > li > a' ),
						'subtitle' => __( 'Choose Size and Style for primary menu', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'subsets' => 'latin',
							'color' => '#444',
							'font-style' => '400',
							'font-size' => '16px',
							'letter-spacing' => '.2',
							'line-height' => '24px',
							'text-transform' => 'uppercase',
						),
					),

					array(
						'id' => 'primarymenu_hover_color',
						'type' => 'color',
						'title' => __( 'Hover Font Color', 'ascend' ),
						'default' => '#000',
						'output'    => array(
							'color' => '.nav-main ul.sf-menu > li > a:hover, .nav-main ul.sf-menu > li.sfHover > a, .kt-header-extras .sf-vertical > li > a:hover',
							'background' => 'button.mobile-navigation-toggle:hover .kt-mnt span',
						),
						'transparent' => false,
						'validate' => 'color',
					),
					array(
						'id' => 'primarymenu_hover_bg_color',
						'type' => 'color',
						'title' => __( 'Hover Background Color', 'ascend' ),
						'default' => '',
						'output'    => array( 'background' => '.nav-main ul.sf-menu > li > a:hover, .nav-main ul.sf-menu > li.sfHover > a, .kt-header-extras .sf-vertical > li > a:hover, .mobile-header-container .kt-mobile-header-toggle:hover button' ),
						'transparent' => false,
						'validate' => 'color',
					),
					array(
						'id' => 'primarymenu_active_color',
						'type' => 'color',
						'title' => __( 'Active Font Color', 'ascend' ),
						'default' => '#000',
						'output'    => array( 'color' => '.nav-main ul.sf-menu > li.current-menu-item > a' ),
						'transparent' => false,
						'validate' => 'color',
					),
					array(
						'id' => 'primarymenu_active_bg_color',
						'type' => 'color',
						'title' => __( 'Active Background Color', 'ascend' ),
						'default' => '',
						'output'    => array( 'background' => '.nav-main ul.sf-menu > li.current-menu-item > a' ),
						'transparent' => false,
						'validate' => 'color',
					),
					array(
						'id' => 'info_menu_secondary_font',
						'type' => 'info',

						'desc' => __( 'Secondary Menu Options', 'ascend' ),
					),
					array(
						'id'        => 'second_menu_background',
						'type'      => 'background',
						'output'    => array( '.second-navclass' ),
						'title'     => __( 'Secondary Menu Background', 'ascend' ),
					),
					array(
						'id' => 'font_secondary_menu',
						'type' => 'typography',
						'title' => __( 'Secondary Menu Font', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => true,
						'text-align' => false,
						'line-height' => true,
						'color' => true,
						'text-transform' => true,
						'letter-spacing' => true,
						'preview' => true,
						'output' => array( '.second-navclass .sf-menu > li > a' ),
						'subtitle' => __( 'Choose Size and Style for secondary menu', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'color' => '#fff',
							'subsets' => 'latin',
							'font-style' => '400',
							'font-size' => '18px',
							'letter-spacing' => '.2px',
							'line-height' => '24px',
							'text-transform' => 'uppercase',
						),
					),
					array(
						'id' => 'secondarymenu_hover_color',
						'type' => 'color',
						'title' => __( 'Secondary Menu Divider Color', 'ascend' ),
						'default' => '',
						'output'    => array( 'background' => '.second-navclass .sf-menu > li:after' ),
						'validate' => 'color',
					),

					array(
						'id' => 'secondarymenu_hover_color',
						'type' => 'color',
						'title' => __( 'Secondary Hover Font Color', 'ascend' ),
						'default' => '',
						'output'    => array( 'color' => '.second-navclass ul.sf-menu > li > a:hover, .second-navclass ul.sf-menu > li.sfHover > a, body.trans-header #wrapper .second-navclass ul.sf-menu > li > a:hover, body.trans-header #wrapper .second-navclass ul.sf-menu > li.sfHover > a' ),
						'transparent' => false,
						'validate' => 'color',
					),
					array(
						'id' => 'secondarymenu_hover_bg_color',
						'type' => 'color',
						'title' => __( 'Secondary Hover and Active Background Color', 'ascend' ),
						'default' => '',
						'transparent' => false,
						'output'    => array( 'background' => '.second-navclass ul.sf-menu > li > a:hover, .second-navclass ul.sf-menu > li.sfHover > a' ),
						'validate' => 'color',
					),
					array(
						'id' => 'secondarymenu_active_color',
						'type' => 'color',
						'title' => __( 'Secondary Active Font Color', 'ascend' ),
						'default' => '',
						'output'    => array( 'color' => '.second-navclass ul.sf-menu > li.current-menu-item > a, body.trans-header #wrapper .second-navclass ul.sf-menu > li.current-menu-item > a' ),
						'transparent' => false,
						'validate' => 'color',
					),
					array(
						'id' => 'secondarymenu_active_bg_color',
						'type' => 'color',
						'title' => __( 'Secondary Active Background Color', 'ascend' ),
						'default' => '',
						'transparent' => false,
						'output'    => array( 'background' => '.second-navclass ul.sf-menu > li.current-menu-item > a' ),
						'validate' => 'color',
					),
					array(
						'id' => 'info_dropdown_menu_settings',
						'type' => 'info',

						'desc' => __( 'Dropdown Menu Style', 'ascend' ),
					),
					array(
						'id' => 'dropdown_background_color',
						'type' => 'color',
						'title' => __( 'Dropdown Background Color', 'ascend' ),
						'default' => '',
						'output'    => array( 'background' => '.nav-main ul.sf-menu ul, .nav-main ul.sf-menu ul a, .second-navclass ul.sf-menu ul a,  .kad-header-menu-inner .kt-header-extras ul.sf-menu ul, .kad-relative-vertical-content .kt-header-extras ul.sf-menu ul,.second-navclass .sf-menu > li.kt-lgmenu > ul, .nav-main .sf-menu > li.kt-lgmenu > ul' ),
						'transparent' => false,
						'validate' => 'color',
					),
					array(
						'id' => 'dropdown_border_color',
						'type' => 'color',
						'title' => __( 'Dropdown Border Color', 'ascend' ),
						'default' => '',
						'output'    => array(
							'border-color' => '.nav-main ul.sf-menu ul, .second-navclass ul.sf-menu ul,  .kad-header-menu-inner .kt-header-extras ul.sf-menu ul,.kad-relative-vertical-content .kt-header-extras ul.sf-menu ul, .kad-relative-vertical-content .nav-main .sf-vertical ul',
							'border-bottom-color' => '.nav-main .sf-menu.sf-menu-normal > li > ul:before, .second-navclass .sf-menu.sf-menu-normal > li > ul:before,  .kad-header-menu-inner .kt-header-extras ul.sf-menu > li > ul:before ',
						),
						'transparent' => true,
						'validate' => 'color',
					),
					array(
						'id' => 'dropdown_menu_font_size',
						'type' => 'typography',
						'title' => __( 'Dropdown Menu Font', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => false,
						'subsets' => false,
						'font-size' => true,
						'font-weight' => true,
						'text-transform' => false,
						'line-height' => true,
						'text-align' => false,
						'all_styles' => false,
						'letter-spacing' => true,
						'color' => true,
						'preview' => false,
						'output' => array( '.nav-main ul.sf-menu ul a, .second-navclass ul.sf-menu ul a, .kad-header-menu-inner .kt-header-extras .kt-woo-account-nav a, .kad-relative-vertical-content .kt-header-extras .kt-woo-account-nav a, .kt-header-extras p.woocommerce-mini-cart__empty-message' ),
						'subtitle' => __( 'Choose Size for the Dropdown menus', 'ascend' ),
						'default' => array(
							'font-family' => '',
							'font-size' => '16px',
							'font-weight' => '',
							'color' => '#444',
							'letter-spacing' => '.2',
							'line-height' => '24px',
						),
					),

					array(
						'id' => 'dropdown_font_hover_color',
						'type' => 'color',
						'title' => __( 'Dropdown Font Hover and Active Color', 'ascend' ),
						'default' => '#000',
						'transparent' => false,
						'output' => array( 'color' => '.nav-main ul.sf-menu ul a:hover, .nav-main ul.sf-menu > li:not(.kt-lgmenu) ul li.sfHover > a, .nav-main ul.sf-menu ul li.current-menu-item > a, .second-navclass ul.sf-menu ul a:hover, .second-navclass ul.sf-menu li:not(.kt-lgmenu) ul li.sfHover > a, .second-navclass ul.sf-menu ul li.current-menu-item > a, .kad-header-menu-inner .kt-header-extras .kt-woo-account-nav a:hover, body.woocommerce-account .kad-header-menu-inner .kt-header-extras .kt-woo-account-nav li.is-active a, .kad-relative-vertical-content  .kt-header-extras .kt-woo-account-nav a:hover, body.woocommerce-account .kad-relative-vertical-content  .kt-header-extras .kt-woo-account-nav li.is-active a' ),
						'validate' => 'color',
					),
					array(
						'id' => 'dropdown_font_hover_background',
						'type' => 'color',
						'title' => __( 'Dropdown Font Background Hover and Active Color', 'ascend' ),
						'default' => '',
						'transparent' => false,
						'output' => array( 'background' => '.nav-main ul.sf-menu ul a:hover, .nav-main ul.sf-menu > li:not(.kt-lgmenu) ul li.sfHover > a, .nav-main ul.sf-menu ul li.current-menu-item > a, .second-navclass ul.sf-menu ul a:hover, .second-navclass ul.sf-menu > li:not(.kt-lgmenu) ul li.sfHover > a, .second-navclass ul.sf-menu ul li.current-menu-item > a, .kad-header-menu-inner .kt-header-extras .kt-woo-account-nav a:hover, body.woocommerce-account .kad-header-menu-inner .kt-header-extras .kt-woo-account-nav li.is-active a, .kad-relative-vertical-content  .kt-header-extras .kt-woo-account-nav a:hover, body.woocommerce-account .kad-relative-vertical-content  .kt-header-extras .kt-woo-account-nav li.is-active a' ),
						'validate' => 'color',
					),
					array(
						'id' => 'info_menu_mobile_font',
						'type' => 'info',
						'desc' => __( 'Mobile Menu Options', 'ascend' ),
					),
					array(
						'id' => 'mobilemenu_background',
						'type' => 'background',
						'title' => __( 'Mobile Menu background', 'ascend' ),
						'default' => '',
						'output' => array( '.mfp-slide #kt-mobile-menu, .mfp-slide #kt-mobile-cart, .mfp-slide #kt-mobile-account' ),
					),
					array(
						'id' => 'mobile_submenu_collapse',
						'type' => 'switch',
						'title' => __( 'Submenu items collapse until opened', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'mobile_submenu_collapse_subitems',
						'type' => 'switch',
						'title' => __( 'Make menu items that have child elements only open sub items', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'font_mobile_menu',
						'type' => 'typography',
						'title' => __( 'Mobile Menu Font', 'ascend' ),
						'font-family' => true,
						'google' => true,
						'font-backup' => false,
						'font-style' => true,
						'subsets' => true,
						'font-size' => true,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'text-transform' => true,
						'color' => true,
						'preview' => true,
						'output' => array( '.kad-mobile-nav li a, .kad-mobile-nav li', '.kt-mobile-menu form.search-form input[type="search"].search-field, .kt-mobile-menu form.search-form .search-submit', '.mfp-slide #kt-mobile-account, .mfp-slide #kt-mobile-cart' ),
						'subtitle' => __( 'Choose Size and Style for Mobile Menu', 'ascend' ),
						'default' => array(
							'font-family' => 'Source Sans Pro',
							'subsets' => 'latin',
							'color' => '#fff',
							'font-style' => '400',
							'font-size' => '16px',
							'letter-spacing' => '.2',
							'line-height' => '20px',
							'text-transform' => 'uppercase',
						),
					),
					array(
						'id' => 'mobilemenu_bottom_border',
						'type' => 'color',
						'title' => __( 'Mobile Menu font bottom border color', 'ascend' ),
						'default' => '',
						'transparent' => true,
						'output' => array( 'border-color' => '.kad-mobile-nav li a' ),
						'validate' => 'color',
					),
					array(
						'id' => 'mobilemenu_hover_color',
						'type' => 'color',
						'title' => __( 'Mobile Hover and Active Font Color', 'ascend' ),
						'default' => '',
						'transparent' => false,
						'output' => array( 'color' => '.kad-mobile-nav li a:hover, .kad-mobile-nav li.current-menu-item > a' ),
						'validate' => 'color',
					),
					array(
						'id' => 'mobilemenu_hover_bg_color',
						'type' => 'color',
						'title' => __( 'Mobile Hover and Active Background Color', 'ascend' ),
						'default' => '',
						'output' => array( 'background' => '.kad-mobile-nav li a:hover, .kad-mobile-nav li.current-menu-item > a' ),
						'transparent' => false,
						'validate' => 'color',
					),
					array(
						'id' => 'info_anchor_links',
						'type' => 'info',
						'desc' => __( 'Anchor Link options', 'ascend' ),
					),
					array(
						'id' => 'kt_anchor_links',
						'type' => 'switch',
						'title' => __( 'Enable animated scroll for menu anchor links', 'ascend' ),
						'subtitle' => __( 'Menu items with an anchor link will scroll to the spot on the page.', 'ascend' ),
						'default' => 0,
					),
				),
			)
		);

		Redux::setSection(
			$opt_name,
			array(
				'id' => 'language_settings',
				'title' => __( 'Language Settings', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Quick Language Settings', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'search_placeholder_text',
						'type' => 'text',
						'title' => __( 'Search Placeholder Text', 'ascend' ),
						'subtitle' => __( 'Standard: Search...', 'ascend' ),
					),
					array(
						'id' => 'info_lang_header_extras',
						'type' => 'info',
						'desc' => __( 'Header Quick Language Settings', 'ascend' ),
					),
					array(
						'id' => 'tl_cart',
						'type' => 'text',
						'title' => __( 'Cart label', 'ascend' ),
						'subtitle' => __( 'Standard: Cart', 'ascend' ),
					),
					array(
						'id' => 'tl_login_signup',
						'type' => 'text',
						'title' => __( 'Login/Signup label', 'ascend' ),
						'subtitle' => __( 'Standard: Login', 'ascend' ),
					),
					array(
						'id' => 'tl_my_account',
						'type' => 'text',
						'title' => __( 'My Account label', 'ascend' ),
						'subtitle' => __( 'Standard: My Account', 'ascend' ),
					),
					array(
						'id' => 'info_lang_blog_settings',
						'type' => 'info',
						'desc' => __( 'Blog Quick Language Settings', 'ascend' ),
					),
					array(
						'id' => 'post_readmore_text',
						'type' => 'text',
						'title' => __( 'Post READ MORE text', 'ascend' ),
						'subtitle' => __( 'Standard: Read More', 'ascend' ),
					),
					array(
						'id' => 'post_by_text',
						'type' => 'text',
						'title' => __( 'Post Author BY text', 'ascend' ),
						'subtitle' => __( 'Standard: by', 'ascend' ),
					),
					array(
						'id' => 'post_updated_date_text',
						'type' => 'text',
						'title' => __( 'Post Updated Text', 'ascend' ),
						'subtitle' => __( 'Standard: Updated:', 'ascend' ),
					),
					array(
						'id' => 'info_lang_filter_settings',
						'type' => 'info',
						'desc' => __( 'Filter Quick Language Settings', 'ascend' ),
					),
					array(
						'id' => 'filter_all_text',
						'type' => 'text',
						'title' => __( 'Dynamic filter All text', 'ascend' ),
						'subtitle' => __( 'Standard: All', 'ascend' ),
					),
					array(
						'id' => 'filter_text',
						'type' => 'text',
						'title' => __( 'Mobile dynamic Filter text', 'ascend' ),
						'subtitle' => __( 'Standard: Filter', 'ascend' ),
					),
					array(
						'id' => 'info_lang_woocommerce',
						'type' => 'info',
						'desc' => __( 'Woocommerce Quick Language Settings', 'ascend' ),
					),
					array(
						'id' => 'sold_placeholder_text',
						'type' => 'text',
						'title' => __( 'Product Sold Text', 'ascend' ),
						'subtitle' => __( 'Standard: Sold', 'ascend' ),
					),
					array(
						'id' => 'sale_placeholder_text',
						'type' => 'text',
						'title' => __( 'Product Sale Text', 'ascend' ),
						'subtitle' => __( 'Standard: Sale', 'ascend' ),
					),
					array(
						'id' => 'wc_clear_placeholder_text',
						'type' => 'text',
						'title' => __( 'Clear Selection Text', 'ascend' ),
						'subtitle' => __( 'Standard: Clear selection', 'ascend' ),
					),
					array(
						'id' => 'notavailable_placeholder_text',
						'type' => 'text',
						'title' => __( 'Not Available Text (radio button tooltip)', 'ascend' ),
						'subtitle' => __( 'Standard: Not Available', 'ascend' ),
					),
					array(
						'id' => 'description_tab_text',
						'type' => 'text',
						'title' => __( 'Product Page: Description tab text', 'ascend' ),
						'subtitle' => __( 'Standard: Description', 'ascend' ),
					),
					array(
						'id' => 'description_header_text',
						'type' => 'text',
						'title' => __( 'Product Page: Description header text', 'ascend' ),
						'subtitle' => __( 'Standard: Product Description', 'ascend' ),
					),
					array(
						'id' => 'additional_information_tab_text',
						'type' => 'text',
						'title' => __( 'Product Page: Additional Information tab text', 'ascend' ),
						'subtitle' => __( 'Standard: Additional Information', 'ascend' ),
					),
					array(
						'id' => 'additional_information_header_text',
						'type' => 'text',
						'title' => __( 'Product Page: Additional Information Header text', 'ascend' ),
						'subtitle' => __( 'Standard: Additional Information', 'ascend' ),
					),
					array(
						'id' => 'reviews_tab_text',
						'type' => 'text',
						'title' => __( 'Product Page: Reviews tab text', 'ascend' ),
						'subtitle' => __( 'Standard: Reviews', 'ascend' ),
					),
					array(
						'id' => 'related_products_text',
						'type' => 'text',
						'title' => __( 'Product Page: Related Products text', 'ascend' ),
						'subtitle' => __( 'Standard: Related Products', 'ascend' ),
					),
					array(
						'id' => 'wc_upsell_products_text',
						'type' => 'text',
						'title' => __( 'Product Page: You may also like... text', 'ascend' ),
						'subtitle' => __( 'Standard: You may also like&hellip;', 'ascend' ),
					),
					array(
						'id' => 'info_lang_lightbox_settings',
						'type' => 'info',
						'desc' => __( 'Lightbox Quick Language Settings', 'ascend' ),
					),
					array(
						'id' => 'lightbox_of_text',
						'type' => 'text',
						'title' => __( 'LightBox: of text', 'ascend' ),
						'subtitle' => __( 'Standard: of', 'ascend' ),
					),
					array(
						'id' => 'lightbox_error_text',
						'type' => 'text',
						'title' => __( 'LightBox: Error text', 'ascend' ),
						'subtitle' => __( 'Standard: The Image could not be loaded.', 'ascend' ),
					),
				),
			)
		);

		Redux::setSection(
			$opt_name,
			array(
				'id' => 'breadcrumbs',
				'title' => __( 'Breadcrumb Settings', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Sitewide Breadcrumbs', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'show_breadcrumbs_shop',
						'type' => 'switch',
						'title' => __( 'Show Breadcrumbs in Woocommerce archive pages?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide breadcrumbs on your Woocommerce archive pages', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'show_breadcrumbs_product',
						'type' => 'switch',
						'title' => __( 'Show Breadcrumbs on Products?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide breadcrumbs on your Woocommerce products', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'show_breadcrumbs_post',
						'type' => 'switch',
						'title' => __( 'Show Breadcrumbs on Blog Posts?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide breadcrumbs on your single blog post', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'blog_link',
						'type' => 'select',
						'data' => 'pages',
						'width' => 'width:60%',
						'title' => __( 'All Blog Post Page', 'ascend' ),
						'subtitle' => __( 'This sets the link for your main blog page, for breadcrumbs. Use only if your blog page is not your home page.', 'ascend' ),
						'required' => array( 'show_breadcrumbs_post', '=', '1' ),
					),
					array(
						'id' => 'show_breadcrumbs_portfolio',
						'type' => 'switch',
						'title' => __( 'Show Breadcrumbs on Portfolio Posts?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide breadcrumbs on your single portfolio posts', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'show_breadcrumbs_staff',
						'type' => 'switch',
						'title' => __( 'Show Breadcrumbs on Staff Post?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide breadcrumbs on your single staff posts', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'staff_link',
						'type' => 'select',
						'data' => 'pages',
						'width' => 'width:60%',
						'title' => __( 'All Staff Post Page', 'ascend' ),
						'subtitle' => __( 'This sets the link for your main staff page, for breadcrumbs.', 'ascend' ),
						'required' => array( 'show_breadcrumbs_staff', '=', '1' ),
					),
					array(
						'id' => 'show_breadcrumbs_testimonial',
						'type' => 'switch',
						'title' => __( 'Show Breadcrumbs on Testimonial Post?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide breadcrumbs on your single Testimonial posts', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'testimonial_link',
						'type' => 'select',
						'data' => 'pages',
						'width' => 'width:60%',
						'title' => __( 'All Testimonial Post Page', 'ascend' ),
						'subtitle' => __( 'This sets the link for your main Testimonial page, for breadcrumbs.', 'ascend' ),
						'required' => array( 'show_breadcrumbs_testimonial', '=', '1' ),
					),
					array(
						'id' => 'show_breadcrumbs_archive',
						'type' => 'switch',
						'title' => __( 'Show Breadcrumbs on Archives?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide breadcrumbs on your archives', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'show_breadcrumbs_page',
						'type' => 'switch',
						'title' => __( 'Show Breadcrumbs on Pages?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide breadcrumbs on your pages', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'home_breadcrumb_text',
						'type' => 'text',
						'title' => __( 'Home title for breadcrumbs', 'ascend' ),
						'subtitle' => __( 'Standard: Home', 'ascend' ),
					),
					array(
						'id' => 'shop_breadcrumbs',
						'type' => 'switch',
						'title' => __( 'Show Shop page in breadcrumbs?', 'ascend' ),
						'subtitle' => __( 'Choose to show or hide the shop page in breadcrumbs on your site', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'breadcrumbs_position',
						'type' => 'select',
						'title' => __( 'Breadcrumbs Position', 'ascend' ),
						'options' => array(
							'below' => __( 'Below Title', 'ascend' ),
							'above' => __( 'Above Title', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'below',
					),
					array(
						'id' => 'breadcrumbs_noheader_background',
						'type' => 'color',
						'title' => __( 'No page header, Breadcrumbs Background Color', 'ascend' ),
						'subtitle' => __( 'This sets the background for the breadcrumbs only where a page header is not used but breadcrumbs are showing.', 'ascend' ),
						'transparent' => true,
						'default' => '',
						'output' => array( 'background-color' => '.kt_bc_nomargin #kadbreadcrumbs' ),
						'validate' => 'color',
					),
					array(
						'id' => 'breadcrumbs_noheader_color',
						'type' => 'color',
						'title' => __( 'No page header, Breadcrumbs font color', 'ascend' ),
						'subtitle' => __( 'This sets the font color for the breadcrumbs only where a page header is not used but breadcrumbs are showing.', 'ascend' ),
						'transparent' => true,
						'default' => '',
						'output' => array( 'color' => '.kt_bc_nomargin #kadbreadcrumbs, .kt_bc_nomargin #kadbreadcrumbs a' ),
						'validate' => 'color',
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'search_settings',
				'title' => __( 'Search Results Settings', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Search page Settings', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'search_layout',
						'type' => 'select',
						'title' => __( 'Search Results Layout', 'ascend' ),
						'options' => array(
							'full' => __( 'No sidebar layout', 'ascend' ),
							'sidebar' => __( 'Sidebar Layout', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'sidebar',
					),
					array(
						'id' => 'search_sidebar_default',
						'type' => 'select',
						'title' => __( 'Choose a Default Sidebar for your search results', 'ascend' ),
						'data' => 'sidebars',
						'default' => 'sidebar-primary',
						'width' => 'width:60%',
					),
					array(
						'id' => 'search_layout_style',
						'type' => 'select',
						'title' => __( 'Search Results Layout Style', 'ascend' ),
						'options' => array(
							'grid' => __( 'Grid', 'ascend' ),
							'singlecolumn' => __( 'Blog Like Single Column', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => 'grid',
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'misc_settings',
				'title' => __( 'Misc Settings', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Misc Settings', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id'       => 'guten_preview',
						'type'     => 'switch',
						'title'    => __( 'Use Theme Options Colors in Gutenberg', 'ascend' ),
						'subtitle' => __( 'Turn off if you don not want the content background to effect the gutenberg interface.', 'ascend' ),
						'default'  => 1,
					),
					array(
						'id'       => 'select2_select',
						'type'     => 'switch',
						'title'    => __( 'Select2 Select', 'ascend' ),
						'subtitle' => __( 'Turn on or off the select2 select', 'ascend' ),
						'default'  => 0,
					),
					// array(
					// 	'id' => 'minimal_icons',
					// 	'type' => 'switch',
					// 	'title' => __( 'Enable Minimal Icons', 'ascend' ),
					// 	'subtitle' => __( 'Turning this on will make the theme only load a few icons on the front end.', 'ascend' ),
					// 	'default' => 0,
					// ),
					array(
						'id' => 'minimal_icons',
						'type' => 'select',
						'title' => __( 'Icons', 'ascend' ),
						'options' => array(
							'0' => __( 'Normal Icons', 'ascend' ),
							'1' => __( 'Minimal Icons', 'ascend' ),
							'2' => __( 'Only in-line SVG Icons (BETA)', 'ascend' ),
						),
						'default' => 0,
					),
					array(
						'id' => 'info_sidebars',
						'type' => 'info',
						'desc' => __( 'Create Sidebars', 'ascend' ),
					),
					array(
						'id' => 'cust_sidebars',
						'type' => 'multi_text',
						'title' => __( 'Create Custom Sidebars', 'ascend' ),
						'subtitle' => __( 'Type new sidebar name into textbox', 'ascend' ),
						'default' => __( 'Extra Sidebar', 'ascend' ),
					),
					array(
						'id' => 'info_smoothscrolling',
						'type' => 'info',
						'desc' => __( 'Smooth Scrolling', 'ascend' ),
					),
					array(
						'id' => 'smooth_scrolling',
						'type' => 'select',
						'title' => __( 'Smooth Scrolling', 'ascend' ),
						'subtitle' => __( 'Please Note, while this can be considered a "cool" feature it is not always the best feature for your users. We suggest caution and testing if you are going to enable.', 'ascend' ),
						'options' => array(
							'0' => __( 'Leave Off', 'ascend' ),
							'1' => __( 'Use - with scroll bar replacement', 'ascend' ),
							'2' => __( 'Use - no replacement of scroll bar (chrome browser only)', 'ascend' ),
						),
						'width' => 'width:60%',
						'default' => '0',
					),
					array(
						'id' => 'smooth_scrolling_hide',
						'type' => 'switch',
						'title' => __( 'Enable Auto Hide', 'ascend' ),
						'subtitle' => __( 'This hides the scroll bar when not scrolling.', 'ascend' ),
						'default' => 0,
						'required' => array( 'smooth_scrolling', '=', '1' ),
					),
					array(
						'id' => 'smooth_scrolling_background',
						'type' => 'switch',
						'title' => __( 'Hide Scroll background', 'ascend' ),
						'subtitle' => __( 'This hides the scroll bar background.', 'ascend' ),
						'default' => 0,
						'required' => array( 'smooth_scrolling', '=', '1' ),
					),
					array(
						'id' => 'info_wpgallerys',
						'type' => 'info',
						'desc' => __( 'WordPress Galleries', 'ascend' ),
					),
					array(
						'id' => 'kadence_gallery',
						'type' => 'switch',
						'title' => __( 'Enable Ascend Galleries to override WordPress', 'ascend' ),
						'subtitle' => __( 'Disable this if using a plugin to customize galleries, for example jetpack tiled gallery.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'kadence_gallery_masonry',
						'type' => 'switch',
						'title' => __( 'Use Masonry Feature on Ascend Galleries by default?', 'ascend' ),
						'subtitle' => __( 'This can be changed on a gallery by gallery basis', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'gallery_captions',
						'type' => 'switch',
						'title' => __( 'Show captions on Ascend Galleries by default', 'ascend' ),
						'subtitle' => __( 'This can be changed on a gallery by gallery basis', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'info_lightbox',
						'type' => 'info',
						'desc' => __( 'Theme Lightbox', 'ascend' ),
					),
					array(
						'id' => 'kadence_themes_lightbox',
						'type' => 'switch',
						'on' => __( 'Lightbox On', 'ascend' ),
						'off' => __( 'Lightbox Off', 'ascend' ),
						'title' => __( 'Theme Lightbox?', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'info_gfonts',
						'type' => 'info',
						'desc' => __( 'Google Fonts', 'ascend' ),
					),
					array(
						'id' => 'load_google_fonts_locally',
						'type' => 'switch',
						'title' => __( 'Load Google Fonts Locally', 'ascend' ),
						'subtitle' => __( 'This will download font files to your server instead of using google servers.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'info_google_analytics',
						'type' => 'info',
						'desc' => __( 'Google Analytics', 'ascend' ),
					),
					array(
						'id' => 'google_analytics',
						'type' => 'text',
						'title' => __( 'Google Analytics Tracking ID', 'ascend' ),
						'subtitle' => __( 'Paste your Google Analytics Tracking ID Here. (example: UA-########-#)', 'ascend' ),
					),
					array(
						'id' => 'google_analytics_anony',
						'type' => 'switch',
						'title' => __( 'Enable IP Anonymization in Google Analytics', 'ascend' ),
						'subtitle' => __( 'Anonymizes the last part of visitors IP address.', 'ascend' ),
						'default' => 0,
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'custom_css',
				'customizer' => false,
				'title' => __( 'Custom Css', 'ascend' ),
				'fields' => array(
					array(
						'id' => 'custom_css',
						'type' => 'textarea',
						'title' => __( 'Custom CSS', 'ascend' ),
						'subtitle' => __( 'Quickly add some CSS to your theme by adding it to this block.', 'ascend' ),
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'header_footer_scripts',
				'icon_class' => 'icon-large',
				'customizer' => false,
				'title' => __( 'Header and Footer Scripts', 'ascend' ),
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Simple output for header and footer scripts', 'ascend' ) . '</h3></div>',
				'fields' => array(
					array(
						'id' => 'info_header_script',
						'type' => 'info',
						'desc' => __( 'Header Output', 'ascend' ),
					),
					array(
						'id' => 'kt_header_script',
						'type' => 'textarea',
						'title' => __( 'Outputs between &lt;head&gt; and &lt;/head&gt;', 'ascend' ),
						'subtitle' => __( 'Quickly add a script to your header.', 'ascend' ),
					),
					array(
						'id' => 'info_kt_after_body_open_script',
						'type' => 'info',
						'desc' => __( 'After the opening &lt;body&gt; tag', 'ascend' ),
					),
					array(
						'id' => 'kt_after_body_open_script',
						'type' => 'textarea',
						'title' => __( 'Outputs immediately after the opening &lt;body&gt; tag', 'ascend' ),
						'subtitle' => __( 'Quickly add a script for google tag manager.', 'ascend' ),
					),
					array(
						'id' => 'info_footer_script',
						'type' => 'info',
						'desc' => __( 'Footer Output', 'ascend' ),
					),
					array(
						'id' => 'kt_footer_script',
						'type' => 'textarea',
						'title' => __( 'Outputs right before &lt;/body&gt;', 'ascend' ),
						'subtitle' => __( 'Quickly add a script to your footer.', 'ascend' ),
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'icon' => 'icon-cog',
				'icon_class' => 'icon-large',
				'title' => __( 'Theme Extensions', 'ascend' ),
				'id' => 'theme_extensions',
				'customizer' => false,
				'desc' => "<div class='redux-info-field'><h3>" . __( 'Theme Extensions', 'ascend' ) . '</h3></div>
    <p>' . __( 'Disable Built in Theme Extensions. Please Note, this does not change how the front end loads. If these items where already not used then they were not loaded it the front end. These options only clean up the admin area.', 'ascend' ) . '</p>',
				'fields' => array(
					array(
						'id' => 'kadence_woo_extension',
						'type' => 'switch',
						'title' => __( 'Woocommerce Shop', 'ascend' ),
						'subtitle' => __( 'Turn Off/On all Woocommerce references and code', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'kadence_portfolio_extension',
						'type' => 'switch',
						'title' => __( 'Portfolio Posts', 'ascend' ),
						'subtitle' => __( 'Turn Off/On all Portfolio references and code', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'kadence_staff_extension',
						'type' => 'switch',
						'title' => __( 'Staff Posts', 'ascend' ),
						'subtitle' => __( 'Turn Off/On all Staff references and code', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'kadence_testimonial_extension',
						'type' => 'switch',
						'title' => __( 'Testimonial Posts', 'ascend' ),
						'subtitle' => __( 'Turn Off/On all Testimonial references and code', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'customizer_limiter',
						'type' => 'switch',
						'title' => __( 'Customizer Limiter', 'ascend' ),
						'subtitle' => __( 'Limits how many panels are shown in the customizer for faster loading.', 'ascend' ),
						'default' => 1,
					),
					array(
						'id' => 'enable_custom_404',
						'type' => 'switch',
						'title' => __( 'Custom 404 Page', 'ascend' ),
						'subtitle' => __( 'Turn Off/On option for custom 404 page.', 'ascend' ),
						'default' => 0,
					),
					array(
						'id' => 'custom_404_page',
						'type' => 'select',
						'data' => 'pages',
						'width' => 'width:60%',
						'title' => __( 'Choose a 404 page', 'ascend' ),
						'subtitle' => __( 'Select the page to be used instead of the standard 404 page.', 'ascend' ),
						'required' => array( 'enable_custom_404', '=', '1' ),
					),
				),
			)
		);
		Redux::setSection(
			$opt_name,
			array(
				'id' => 'import_export',
				'title'  => __( 'Import / Export', 'ascend' ),
				'desc'   => __( 'Import and Export your Theme Options from text or URL.', 'ascend' ),
				'fields' => array(
					array(
						'id'         => 'kadence-import-export',
						'type'       => 'import_export',
						'full_width' => true,
					),
				),
			)
		);


		function ascend_override_redux_icons_css() {
			wp_dequeue_style( 'redux-admin-css' );
			wp_register_style( 'kt-redux-custom-css', get_template_directory_uri() . '/themeoptions/options/css/style.css', false, 001 );
			wp_enqueue_style( 'kt-redux-custom-css' );
			wp_dequeue_style( 'select2-css' );
			wp_dequeue_style( 'redux-elusive-icon' );
			wp_dequeue_style( 'redux-elusive-icon-ie7' );
		}
		add_action( 'redux/page/ascend/enqueue', 'ascend_override_redux_icons_css', 100 );

		function ascend_remove_demo() {

			if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
				remove_filter(
					'plugin_row_meta',
					array(
						ReduxFrameworkPlugin::instance(),
						'plugin_metalinks',
					),
					null,
					2
				);

				remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
			}
		}

