<?php
/**
 * Post Single Head Content
 *
 * @package Ascend Theme
 */

global $post, $ascend, $kt_feat_width, $ascend_has_sidebar;
if ( has_post_format( 'gallery' ) ) {
	$swidth = get_post_meta( $post->ID, '_kad_gallery_posthead_width', true );
	$height = get_post_meta( $post->ID, '_kad_gallery_posthead_height', true );
	if ( ! empty( $height ) ) {
		$slideheight = $height;
		$imageheight = $height;
	} else {
		$slideheight = 400;
		$imageheight = apply_filters( 'kt_single_post_image_height', 400 );
	}
	if ( ! empty( $swidth ) ) {
		$slidewidth = $swidth;
	} else {
		$slidewidth = $kt_feat_width;
	}
} elseif ( has_post_format( 'image' ) ) {
	$swidth = get_post_meta( $post->ID, '_kad_image_posthead_width', true );
	$height = get_post_meta( $post->ID, '_kad_image_posthead_height', true );
	if ( ! empty( $height ) ) {
		$imageheight = $height;
	} else {
		$imageheight = apply_filters( 'kt_single_post_image_height', 400 );
	}
	if ( ! empty( $swidth ) ) {
		$slidewidth = $swidth;
	} else {
		$slidewidth = $kt_feat_width;
	}
} elseif ( has_post_format( 'video' ) ) {
	$swidth = get_post_meta( $post->ID, '_kad_video_posthead_width', true );
	if ( ! empty( $swidth ) ) {
		$slidewidth = $swidth;
	} else {
		$slidewidth = $kt_feat_width;
	}
} else {
	$imageheight = apply_filters( 'kt_single_custom_post_image_height', null );
	$slidewidth  = apply_filters( 'kt_single_custom_post_image_width', $kt_feat_width );
}

$kt_headcontent = ascend_get_post_head_content();

if ( 'flex' === $kt_headcontent ) {

	$image_gallery = get_post_meta( $post->ID, '_kad_image_gallery', true );
	echo '<section class="postfeat">';
		ascend_build_slider( $post->ID, $image_gallery, $slidewidth, $slideheight, 'image', 'kt-slider-same-image-ratio' );
	echo '</section>';

} elseif ( 'carouselslider' === $kt_headcontent ) {

	$image_gallery = get_post_meta( $post->ID, '_kad_image_gallery', true );
	echo '<section class="postfeat">';
		ascend_build_slider( $post->ID, $image_gallery, null, $slideheight, 'image', 'kt-slider-different-image-ratio' );
	echo '</section>';

} elseif ( 'thumbslider' === $kt_headcontent ) {

	$image_gallery = get_post_meta( $post->ID, '_kad_image_gallery', true );
	echo '<section class="postfeat">';
		ascend_build_slider( $post->ID, $image_gallery, $slidewidth, $slideheight, 'image', 'kt-slider-same-image-ratio-thumb', 'thumb' );
	echo '</section>';

} elseif ( 'gallery' === $kt_headcontent ) {

		echo '<section class="postfeat">';
			ascend_build_image_collage( $post->ID, 'image', $ascend_has_sidebar );
		echo '</section>';

} elseif ( 'video' === $kt_headcontent ) {

		echo '<section class="postfeat">';
			echo '<div style="max-width:' . esc_attr( $slidewidth ) . 'px; margin:0 auto;">';
						get_template_part( 'templates/post', 'video-output' );
			echo '</div>';
		echo '</section>';

} elseif ( 'image' === $kt_headcontent ) {
	if ( has_post_thumbnail( $post->ID ) ) {
		$image_id = get_post_thumbnail_id();
		$img = ascend_get_image( $slidewidth, $height, true, null, null, $image_id, false );

		?>
			<div class="imghoverclass postfeat post-single-img">
				<a href="<?php echo esc_url( $img['full'] ); ?>" data-rel="lightbox">
				<?php echo ascend_get_image_markup( $img ); ?>
				</a>
			</div>
		<?php
	}
}
