<?php
/**
 * Entry Meta Date and Author
 *
 * @package Ascend Theme
 */

global $ascend;
?>
<div class="post-top-meta kt_color_gray">
	<?php do_action( 'ascend_before_post_meta' ); ?>
	<?php
	if ( isset( $ascend['post_updated_date'] ) && '1' === $ascend['post_updated_date'] ) {
		if ( ! empty( $ascend['post_updated_date_text'] ) ) {
			$updated_date_text = $ascend['post_updated_date_text'];
		} else {
			$updated_date_text = __( 'Updated:', 'ascend' );
		}
		?>
		<span class="postdate kt-post-date updated">
			<?php echo '<span class="kt-updated-post-time">' . esc_html( $updated_date_text ) . ' </span>' . esc_html( get_the_modified_date( get_option( 'date_format' ) ) ); ?>
		</span>
	<?php } else { ?>
		<span class="postdate kt-post-date updated">
			<?php echo get_the_date( get_option( 'date_format' ) ); ?>
		</span>
	<?php } ?>
	<span class="postauthortop kt-post-author author vcard">
		<?php
		if ( ! empty( $ascend['post_by_text'] ) ) {
			$authorbytext = $ascend['post_by_text'];
		} else {
			$authorbytext = __( 'by', 'ascend' );
		}
			echo '<span class="kt-by-author">' . esc_html( $authorbytext ) . '</span>';
		?>
		<span itemprop="author">
			<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" class="fn kt_color_gray" rel="author">
				<?php echo get_the_author(); ?>
			</a>
		</span>
	</span> 
	<?php do_action( 'ascend_after_post_meta' ); ?>
</div>
<?php

