<?php
/**
 * Search Form
 *
 * @package Ascend Theme
 */

$searchtext = ascend_get_option( 'search_placeholder_text', __( 'Search &hellip;', 'ascend' ) );
?>
<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label>
		<span class="screen-reader-text"><?php esc_html_e( 'Search for:', 'ascend' ); ?></span>
		<input type="search" class="search-field" placeholder="<?php echo esc_attr( $searchtext ); ?>" value="<?php echo esc_attr( get_search_query() ); ?>" name="s" />
	</label>
	<button type="submit" class="search-submit search-icon">
		<?php
		if ( '2' === ascend_get_option( 'minimal_icons' ) ) {
			ascend_print_svg_icon( 'search', true );
		} else {
			echo '<i class="kt-icon-search"></i>';
		}
		?>
	</button>
</form>
