<?php
/**
 *  Post List Hooks
 *
 * @package Ascend Theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 *  Normal Post list Title Hook.
 */
function ascend_post_excerpt_header_title() {
	echo '<a href="' . esc_attr( get_the_permalink() ) . '">';
		echo '<h3 class="entry-title">';
			the_title();
		echo '</h3>';
	echo '</a>';
}
add_action( 'ascend_post_excerpt_header', 'ascend_post_excerpt_header_title', 10 );

/**
 *  Full Post in list Title Hook.
 */
function ascend_post_full_loop_title() {
	echo '<a href="' . esc_attr( get_the_permalink() ) . '">';
		echo '<h2 class="entry-title">';
				the_title();
		echo '</h2>';
	echo '</a>';
}
add_action( 'ascend_single_loop_post_header', 'ascend_post_full_loop_title', 20 );

/**
 * Get post summary
 */
function ascend_get_postsummary() {
	global $post, $ascend;
	if ( has_post_format( 'video' ) ) {
		$postsummery = get_post_meta( $post->ID, '_kad_video_post_summery', true );
		if ( empty( $postsummery ) || 'default' === $postsummery ) {
			if ( ! empty( $ascend['video_post_summery_default'] ) ) {
				$postsummery = $ascend['video_post_summery_default'];
			} else {
				$postsummery = 'video';
			}
		}
	} else if ( has_post_format( 'gallery' ) ) {
		$postsummery = get_post_meta( $post->ID, '_kad_gallery_post_summery', true );
		if ( empty( $postsummery ) || 'default' === $postsummery ) {
			if ( ! empty( $ascend['gallery_post_summery_default'] ) ) {
				$postsummery = $ascend['gallery_post_summery_default'];
			} else {
				$postsummery = 'slider_landscape';
			}
		}
	} elseif ( has_post_format( 'image' ) ) {
		$postsummery = get_post_meta( $post->ID, '_kad_image_post_summery', true );
		if ( empty( $postsummery ) || 'default' === $postsummery ) {
			if ( ! empty( $ascend['image_post_summery_default'] ) ) {
				$postsummery = $ascend['image_post_summery_default'];
			} else {
				$postsummery = 'img_portrait';
			}
		}
	} else {
		$postsummery = get_post_meta( $post->ID, '_kad_post_summery', true );
		if ( empty( $postsummery ) || 'default' === $postsummery ) {
			if ( ! empty( $ascend['post_summery_default'] ) ) {
				$postsummery = $ascend['post_summery_default'];
			} else {
				$postsummery = 'img_portrait';
			}
		}
	}

	return $postsummery;
}
/**
 * Get post layout settings
 *
 * @param string $type the type.
 */
function ascend_get_postlayout( $type = 'normal' ) {
	if ( isset( $type ) && 'full' === $type ) {
		$r['sum']       = 'full';
		$r['pclass']    = 'postlist fullpost';
		$r['tclass']    = '';
		$r['data']      = '';
		$r['highlight'] = 'false';
	} elseif ( isset( $type ) && 'grid' === $type ) {
		global $ascend;
		if ( isset( $ascend['blog_grid_display_height'] ) && 0 == $ascend['blog_grid_display_height'] ) {
			$iso_style = 'masonry';
			$match     = '';
		} else {
			$iso_style = 'matchheight';
			$match     = 'data-iso-match-height="1"';
		}
		$r['sum']       = 'grid';
		$r['pclass']    = 'grid-postlist';
		$r['tclass']    = 'init-isotope row';
		$r['data']      = 'data-iso-selector=".b_item" ' . $match . ' data-iso-style="' . $iso_style . '"';
		$r['highlight'] = 'false';
	} elseif ( isset( $type ) && 'grid_standard' === $type ) {
		$r['sum']       = 'grid';
		$r['pclass']    = 'grid-postlist';
		$r['tclass']    = 'init-isotope row';
		$r['data']      = 'data-iso-selector=".b_item" data-iso-match-height="1" data-iso-style="matchheight"';
		$r['highlight'] = 'true';
	} elseif ( isset( $type ) && 'photo' === $type ) {
		$r['sum']       = 'photo';
		$r['pclass']    = 'photo-postlist';
		$r['tclass']    = 'init-isotope-intrinsic row-margin-small';
		$r['data']      = 'data-iso-selector=".b_item" data-iso-style="masonry"';
		$r['highlight'] = 'false';
	} elseif ( isset( $type ) && 'below_title' === $type ) {
		$r['sum']       = 'below_title';
		$r['pclass']    = 'postlist';
		$r['tclass']    = '';
		$r['data']      = '';
		$r['highlight'] = 'false';
	} elseif ( isset( $type ) && 'mosaic' === $type ) {
		$r['sum']       = 'mosaic';
		$r['pclass']    = 'mosaic-postlist';
		$r['tclass']    = 'init-mosaic-isotope kt-mosiac-wrap row-nomargin';
		$r['data']      = 'data-iso-selector=".b_item" data-mosaic-selector=".mosaic-grid-size" data-iso-style="masonry"';
		$r['highlight'] = 'false';
	} else {
		$r['sum']       = 'normal';
		$r['pclass']    = 'postlist';
		$r['tclass']    = '';
		$r['data']      = '';
		$r['highlight'] = 'false';
	}
	return apply_filters( 'ascend_post_layout_args_array', $r );
}
