<?php
/**
 * Post Actions
 *
 * @package Ascend Theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Single Post Header
 */
function ascend_single_post_header() {
	if ( ascend_display_pagetitle() ) {
		get_template_part( 'templates/post', 'header' );
	} else {
		if ( is_attachment() ) {
			if ( apply_filters( 'ascend_attachment_breadcrumbs', false ) ) {
				echo '<div class="kt_bc_nomargin">';
				ascend_breadcrumbs();
				echo '</div>';
			}
		} elseif ( get_post_type() != 'post' ) {
			global $post;
			if ( apply_filters( 'ascend_custom_post_type_breadcrumbs', false, $post ) ) {
				echo '<div class="kt_bc_nomargin">';
				ascend_breadcrumbs();
				echo '</div>';
			}
		} else {
			if ( ascend_display_post_breadcrumbs() ) {
				echo '<div class="kt_bc_nomargin">';
				ascend_breadcrumbs();
				echo '</div>';
			}
		}
	}
}
add_action( 'ascend_post_header', 'ascend_single_post_header', 20 );

/**
 * Post Image Height
 */
function ascend_post_header_single_image_height() {
	global $ascend;
	if ( isset( $ascend['post_header_single_image_height'] ) && '1' === $ascend['post_header_single_image_height'] ) {
		return null;
	} else {
		return 400;
	}
}
add_filter( 'kt_single_post_image_height', 'ascend_post_header_single_image_height', 10 );

/**
 * Post Image Below Title
 */
function ascend_image_post_below_title() {
	if ( 'post' == get_post_type() ) {
		if ( 'image_below' == ascend_get_post_head_content() ) {
			global $post, $kt_feat_width;
			if ( has_post_thumbnail( $post->ID ) ) {
				$swidth = get_post_meta( $post->ID, '_kad_image_posthead_width', true );
				$height = get_post_meta( $post->ID, '_kad_image_posthead_height', true );
				if ( ! empty( $height ) ) {
					$imageheight = $height;
				} else {
					$imageheight = apply_filters( 'kt_single_post_image_height', 400 );
				}
				if ( ! empty( $swidth ) ) {
					$slidewidth = $swidth;
				} else {
					$slidewidth = $kt_feat_width;
				}
				$image_id = get_post_thumbnail_id();
				$img_args = array(
					'width'         => $slidewidth,
					'height'        => $height,
					'crop'          => true,
					'class'         => null,
					'alt'           => null,
					'id'            => $image_id,
					'placeholder'   => false,
				);
				$img = ascend_get_processed_image_array( $img_args );
				$img['schema'] = true;
				$img['span'] = true;
				?>
				<div class="imghoverclass postfeat post-single-img">
					<a href="<?php echo esc_url( $img['full'] ); ?>" data-rel="lightbox">
						<p>
						<?php echo ascend_get_image_markup( $img ); ?>
						</p>
					</a>
				</div>
				<?php
			}
		}
	}
}
add_action( 'kadence_single_post_content_before', 'ascend_image_post_below_title', 5 );
/**
 * Get Head Content
 */
function ascend_get_post_head_content() {
	global $post, $ascend;
	if ( 'post' == get_post_type() ) {
		if ( has_post_format( 'video' ) ) {
			$headcontent = get_post_meta( $post->ID, '_kad_video_blog_head', true );
			if ( empty( $headcontent ) || 'default' === $headcontent ) {
				if ( ! empty( $ascend['video_post_blog_default'] ) ) {
					$headcontent = $ascend['video_post_blog_default'];
				} else {
					$headcontent = 'video';
				}
			}
		} else if ( has_post_format( 'gallery' ) ) {
			$headcontent = get_post_meta( $post->ID, '_kad_gallery_blog_head', true );
			if ( empty( $headcontent ) || 'default' === $headcontent ) {
				if ( ! empty( $ascend['gallery_post_blog_default'] ) ) {
					$headcontent = $ascend['gallery_post_blog_default'];
				} else {
					$headcontent = 'gallery';
				}
			}
		} elseif ( has_post_format( 'image' ) ) {
			$headcontent = get_post_meta( $post->ID, '_kad_image_blog_head', true );
			if ( empty( $headcontent ) || 'default' === $headcontent ) {
				if ( ! empty( $ascend['image_post_blog_default'] ) ) {
					$headcontent = $ascend['image_post_blog_default'];
				} else {
					$headcontent = 'image';
				}
			}
		} else {
			$headcontent = 'none';
		}
	} elseif ( ! is_attachment() ) {
		if ( isset( $ascend['custom_post_show_featured_image'] ) && '1' === $ascend['custom_post_show_featured_image'] ) {
			$headcontent = 'image';
		} else {
			$headcontent = 'none';
		}
	}
	return $headcontent;
}

/**
 * Carousel for Single Posts
 */
function ascend_single_post_upper_headcontent() {
	if ( 'post' === get_post_type() ) {
		get_template_part( 'templates/post', 'head-upper-content' );
	}
}
add_action( 'ascend_single_post_begin', 'ascend_single_post_upper_headcontent', 10 );

/**
 * Above Title for Single Posts
 */
function ascend_single_post_headcontent() {
	get_template_part( 'templates/post', 'head-content' );
}
add_action( 'kadence_single_post_before_header', 'ascend_single_post_headcontent', 10 );

/**
 * Meta Date Author.
 */
function ascend_single_post_meta_date_author() {
	if ( 'post' === get_post_type() ) {
		get_template_part( 'templates/entry', 'meta-date-author' );
	} else {
		get_template_part( 'templates/entry', 'meta-custom-date-author' );
	}
}
add_action( 'ascend_single_attachment_header', 'ascend_single_post_meta_date_author', 30 );
add_action( 'ascend_post_excerpt_header', 'ascend_single_post_meta_date_author', 30 );
add_action( 'ascend_single_loop_post_header', 'ascend_single_post_meta_date_author', 30 );
add_action( 'ascend_single_post_header', 'ascend_single_post_meta_date_author', 30 );

/**
 * Single post title
 */
function ascend_post_header_title() {
	global $ascend;
	if ( 'post' === get_post_type() ) {
		if ( isset( $ascend['blog_post_title_inpost'] ) && '0' === $ascend['blog_post_title_inpost'] ) {
			// Nothing Needed.
		} else {
			$tag = apply_filters( 'ascend_post_inner_title_tag', 'h1' );
			echo '<' . esc_attr( $tag ) . ' class="entry-title">';
				the_title();
			echo '</' . esc_attr( $tag ) . '>';
		}
	} else {
		if ( isset( $ascend['custom_post_title_inpost'] ) && '0' === $ascend['custom_post_title_inpost'] ) {
			// Nothing Needed.
		} else {
			$tag = apply_filters( 'ascend_custom_post_inner_title_tag', 'h1' );
			echo '<' . esc_attr( $tag ) . ' class="entry-title">';
				the_title();
			echo '</' . esc_attr( $tag ) . '>';
		}
	}
}
add_action( 'ascend_single_attachment_header', 'ascend_post_header_title', 20 );
add_action( 'ascend_single_post_header', 'ascend_post_header_title', 20 );

/**
 * Single Image (ATTACHMENT PAGE)
 */
function ascend_single_attachment_image() {
	echo wp_get_attachment_image( get_the_ID(), 'full' );
}
add_action( 'kadence_single_attachment_before_header', 'ascend_single_attachment_image', 20 );


/**
 * Post Head categories.
 */
function ascend_post_header_meta_categories() {
	if ( 'post' === get_post_type() && has_category() ) {
		echo '<div class="kt_post_category kt-post-cats">';
			the_category( ' | ' );
		echo '</div>';
	} elseif ( has_term( null, 'series' ) ) {
		echo '<div class="kt_post_category kt-post-cats">';
				$terms = get_terms( 'series' );
		if ( $terms && ! is_wp_error( $terms ) ) {
			$output = array();
			foreach ( $terms as $term ) {
				$term_link = get_term_link( $term );
				if ( ! is_wp_error( $term_link ) ) {
					$output[] = '<a href="' . esc_url( $term_link ) . '">' . esc_html( $term->name ) . '</a>';
				}
			}
			echo implode( ' | ', $output );
		}
		echo '</div>';
	}
}
add_action( 'kadence_post_photo_grid_excerpt_after_header', 'ascend_post_header_meta_categories', 20 );
add_action( 'kadence_post_grid_excerpt_before_header', 'ascend_post_header_meta_categories', 20 );
add_action( 'kadence_post_excerpt_before_header', 'ascend_post_header_meta_categories', 20 );
add_action( 'kadence_single_loop_post_before_header', 'ascend_post_header_meta_categories', 20 );
add_action( 'kadence_single_post_before_header', 'ascend_post_header_meta_categories', 20 );

/**
 * Post Navigation
 */
function ascend_post_footer_pagination() {
	wp_link_pages(
		array(
			'before'      => '<nav class="pagination kt-pagination">',
			'after'       => '</nav>',
			'link_before' => '<span>',
			'link_after'  => '</span>',
		)
	);
}
add_action( 'ascend_single_attachment_footer', 'ascend_post_footer_pagination', 10 );
add_action( 'ascend_single_post_footer', 'ascend_post_footer_pagination', 10 );

/**
 * Post Tags
 */
function ascend_post_footer_tags() {
	$tags = get_the_tags();
	if ( $tags ) {
		echo '<div class="posttags post-footer-section">';
		the_tags( __( 'Tags:', 'ascend' ), ' ', '' );
		echo '</div>';
	}
}
add_action( 'ascend_single_post_footer', 'ascend_post_footer_tags', 20 );

/**
 * Post Navigation
 */
function ascend_post_nav() {
	global $ascend;
	if ( ! isset( $ascend['show_postlinks'] ) || '0' !== $ascend['show_postlinks'] ) {
		get_template_part( 'templates/entry', 'post-links' );
	}
}
add_action( 'ascend_single_post_footer', 'ascend_post_nav', 40 );

/**
 * Post Author box
 */
function ascend_post_authorbox() {
	global $ascend, $post;
	$authorbox = get_post_meta( $post->ID, '_kad_blog_author', true );
	if ( ( empty( $authorbox ) || 'default' === $authorbox ) && is_singular( 'post' ) ) {
		if ( isset( $ascend['post_author_default'] ) && ( 'yes' === $ascend['post_author_default'] ) ) {
			ascend_author_box();
		}
	} elseif ( 'yes' === $authorbox ) {
		ascend_author_box();
	}
}
add_action( 'kadence_single_post_after', 'ascend_post_authorbox', 20 );

/**
 * Post Bottom Carousel
 */
function ascend_post_bottom_carousel() {
	if ( is_singular( 'post' ) ) {
		global $ascend, $post, $ascend_bottom_carousel;
		$ascend_bottom_carousel = get_post_meta( $post->ID, '_kad_blog_carousel_similar', true );
		if ( empty( $ascend_bottom_carousel ) || 'default' === $ascend_bottom_carousel ) {
			if ( isset( $ascend['post_carousel_default'] ) ) {
				$ascend_bottom_carousel = $ascend['post_carousel_default'];
			}
		}

		if ( 'similar' === $ascend_bottom_carousel || 'recent' === $ascend_bottom_carousel ) {
			get_template_part( 'templates/bottom', 'post-carousel' );
		}
	}
}
add_action( 'kadence_single_post_after', 'ascend_post_bottom_carousel', 30 );

/**
 * Post Comments
 */
function ascend_post_comments() {
	comments_template( '/templates/comments.php' );
}
add_action( 'kadence_single_attachment_after', 'ascend_post_comments', 40 );
add_action( 'kadence_single_post_after', 'ascend_post_comments', 40 );


// POST GRID.

/**
 * Post Grid Title
 */
function ascend_post_grid_excerpt_header_title() {
	$tag = apply_filters( 'ascend_post_grid_title_tag', 'h5' );
	echo '<a href="' . esc_url( get_permalink() ) . '">';
		echo '<' . esc_attr( $tag ) . ' class="entry-title">';
			the_title();
		echo '</' . esc_attr( $tag ) . '>';
	echo '</a>';
}
add_action( 'kadence_post_photo_grid_excerpt_header', 'ascend_post_grid_excerpt_header_title', 10 );
add_action( 'kadence_post_grid_excerpt_header', 'ascend_post_grid_excerpt_header_title', 10 );

/**
 * Footer Meta
 */
function ascend_post_grid_footer_meta() {
	get_template_part( 'templates/entry', 'meta-grid-footer' );
}
add_action( 'ascend_post_grid_excerpt_footer', 'ascend_post_grid_footer_meta', 20 );

if ( ! function_exists( 'ascend_build_image_collage' ) ) {
	function ascend_build_image_collage( $id = null, $link = 'image', $sidebar = false ) {
		if ( empty( $id ) ) {
			$id = get_the_ID();
		}
		echo '<div class="kad_post_grid kad-light-gallery">';
			$image_gallery = get_post_meta( $id, '_kad_image_gallery', true );
		if ( ! empty( $image_gallery ) ) {
			$attachments = array_filter( explode( ',', $image_gallery ) );
			if ( $attachments ) {
				$i = 1;
				$count = count( $attachments );
				if ( $count == 2 ) {
					echo '<div class="kad_postgrid_wrap kt-2-collage clearfix">';
					if ( $sidebar ) {
						$widthimgsize = 525;
						$heightimgsize = 350;
						$smallimgsize = 330;
					} else {
						$widthimgsize = 750;
						$heightimgsize = 500;
						$smallimgsize = 460;
					}
					foreach ( $attachments as $attachment ) {
						$alt = get_post_meta( $attachment, '_wp_attachment_image_alt', true );
						$img_args = array(
							'width'         => $smallimgsize,
							'height'        => $smallimgsize,
							'crop'          => true,
							'class'         => null,
							'alt'           => get_post_meta( $attachment, '_wp_attachment_image_alt', true ),
							'id'            => $attachment,
							'placeholder'   => false,
						);
						$padding = ( $smallimgsize / $smallimgsize ) * 100;
						if ( $i == 1 ) {
							$img_args['width'] = $widthimgsize;
							$img_args['height'] = $heightimgsize;
							$padding = ( $heightimgsize / $widthimgsize ) * 100;
						}

						$img = ascend_get_processed_image_array( $img_args );
						$img['schema'] = true;
						$img['extras'] = 'data-caption="' . esc_attr( get_post_field( 'post_excerpt', $attachment ) ) . '"';

						$datarel = 'post';
						if ( $link == 'post' ) {
							$imagelink = get_the_permalink();
						} else if ( $link == 'attachment' ) {
							$imagelink = get_permalink( $attachment );
						} else {
							$imagelink = $img['full'];
							$datarel = 'lightbox';
						}
						?>
								<div class="kpgi kad_post_grid_item-<?php echo esc_attr( $i ); ?>">
									<div class="kpgi-inner">
										<a href="<?php echo esc_url( $imagelink ); ?>" class="kt-intrinsic" style="padding-bottom:<?php echo esc_attr( $padding ); ?>%;" data-rel="<?php echo esc_attr( $datarel ); ?>">
										<?php echo ascend_get_image_markup( $img ); ?>
										</a>
									</div>
								</div>
							<?php
							$i ++;
							if ( $i == 5 ) {
								break;
							}
					}
					echo '</div>';
				} elseif ( $count == 3 ) {
					echo '<div class="kad_postgrid_wrap kt-3-collage clearfix">';
					if ( $sidebar ) {
						$widthimgsize = 525;
						$heightimgsize = 350;
						$swidthimgsize = 330;
						$sheightimgsize = 170;
					} else {
						$widthimgsize = 750;
						$heightimgsize = 500;
						$swidthimgsize = 460;
						$sheightimgsize = 230;
					}
					foreach ( $attachments as $attachment ) {
						$img_args = array(
							'width'         => $swidthimgsize,
							'height'        => $sheightimgsize,
							'crop'          => true,
							'class'         => null,
							'alt'           => get_post_meta( $attachment, '_wp_attachment_image_alt', true ),
							'id'            => $attachment,
							'placeholder'   => false,
						);
						$padding = ( $sheightimgsize / $swidthimgsize ) * 100;
						if ( $i == 1 ) {
							$img_args['width'] = $widthimgsize;
							$img_args['height'] = $heightimgsize;
							$padding = ( $heightimgsize / $widthimgsize ) * 100;
						}
						$img = ascend_get_processed_image_array( $img_args );
						$img['schema'] = true;
						$img['extras'] = 'data-caption="' . esc_attr( get_post_field( 'post_excerpt', $attachment ) ) . '"';

						$datarel = 'post';
						if ( $link == 'post' ) {
							$imagelink = get_the_permalink();
						} elseif ( $link == 'attachment' ) {
							$imagelink = get_permalink( $attachment );
						} else {
							$imagelink = $img['full'];
							$datarel = 'lightbox';
						}
						if ( $i == 2 || $i == 3 ) {
							echo '<div class="side_post_gal">';
						}
						?>
								<div class="kpgi kad_post_grid_item-<?php echo esc_attr( $i ); ?>">
									<div class="kpgi-inner">
										<a href="<?php echo esc_url( $imagelink ); ?>" class="kt-intrinsic" style="padding-bottom:<?php echo esc_attr( $padding ); ?>%;" data-rel="<?php echo esc_attr( $datarel ); ?>">
										<?php echo ascend_get_image_markup( $img ); ?>
										</a>
									</div>
								</div>
							<?php
							if ( $i == 2 || $i == 3 ) {
								echo '</div>';
							}
							$i ++;
							if ( $i == 5 ) {
								break;
							}
					}
					echo '</div>';

				} else if ( $count == 4 ) {
					echo '<div class="kad_postgrid_wrap kt-4-collage clearfix">';
					if ( $sidebar ) {
						$largeimgsize = 440;
						$smallimgsize = 220;
					} else {
						$largeimgsize = 600;
						$smallimgsize = 300;
					}
					foreach ( $attachments as $attachment ) {
						$img_args = array(
							'width'         => $smallimgsize,
							'height'        => $smallimgsize,
							'crop'          => true,
							'class'         => null,
							'alt'           => get_post_meta( $attachment, '_wp_attachment_image_alt', true ),
							'id'            => $attachment,
							'placeholder'   => false,
						);
						$padding = ( $smallimgsize / $smallimgsize ) * 100;
						if ( $i == 1 ) {
							$img_args['width'] = $largeimgsize;
							$img_args['height'] = floor( $largeimgsize * 1.55 );
							$padding = ( floor( $largeimgsize * 1.55 ) / $largeimgsize ) * 100;
						} elseif ( $i == 4 ) {
							$img_args['width'] = $largeimgsize;
							$img_args['height'] = $smallimgsize;
							$padding = ( $smallimgsize / $largeimgsize ) * 100;
						}
						$img = ascend_get_processed_image_array( $img_args );
						$img['schema'] = true;
						$img['extras'] = 'data-caption="' . esc_attr( get_post_field( 'post_excerpt', $attachment ) ) . '"';

						$datarel = 'post';
						if ( $link == 'post' ) {
							$imagelink = get_the_permalink();
						} else if ( $link == 'attachment' ) {
							$imagelink = get_permalink( $attachment );
						} else {
							$imagelink = $img['full'];
							$datarel = 'lightbox';
						}
						if ( $i == 2 || $i == 4 ) {
							echo '<div class="side_post_gal">';
						}
						?>
								<div class="kpgi kad_post_grid_item-<?php echo esc_attr( $i ); ?>">
									<div class="kpgi-inner">
										<a href="<?php echo esc_url( $imagelink ); ?>" class="kt-intrinsic" style="padding-bottom:<?php echo esc_attr( $padding ); ?>%;" data-rel="<?php echo esc_attr( $datarel ); ?>">
									   <?php echo ascend_get_image_markup( $img ); ?>
										</a>
									</div>
								</div>
							<?php
							if ( $i == 3 || $i == 4 ) {
								echo '</div>';
							}
							$i ++;
							if ( $i == 5 ) {
								break;
							}
					}
					echo '</div>';

				} else {
					echo '<div class="kad_postgrid_wrap kt-5-collage clearfix">';
					if ( $sidebar ) {
						$largeimgsize = 440;
						$smallimgsize = 220;
					} else {
						$largeimgsize = 600;
						$smallimgsize = 300;
					}
					foreach ( $attachments as $attachment ) {

						$img_args = array(
							'width'         => $smallimgsize,
							'height'        => $smallimgsize,
							'crop'          => true,
							'class'         => null,
							'alt'           => get_post_meta( $attachment, '_wp_attachment_image_alt', true ),
							'id'            => $attachment,
							'placeholder'   => false,
						);
						$padding = ( $smallimgsize / $smallimgsize ) * 100;
						if ( $i == 3 ) {
							$img_args['width'] = $largeimgsize;
							$img_args['height'] = $largeimgsize;
							$padding = ( $largeimgsize / $largeimgsize ) * 100;
						} elseif ( $i == 4 || $i == 5 ) {
							$img_args['width'] = $largeimgsize;
							$img_args['height'] = $smallimgsize;
							$padding = ( $smallimgsize / $largeimgsize ) * 100;
						}
						$img = ascend_get_processed_image_array( $img_args );
						$img['schema'] = true;
						$img['extras'] = 'data-caption="' . esc_attr( get_post_field( 'post_excerpt', $attachment ) ) . '"';

						$datarel = 'post';
						if ( $link == 'post' ) {
							$imagelink = get_the_permalink();
						} else if ( $link == 'attachment' ) {
							$imagelink = get_permalink( $attachment );
						} else {
							$imagelink = $img['full'];
							$datarel = 'lightbox';
						}
						if ( $i == 1 || $i == 4 ) {
							echo '<div class="side_post_gal side-post-gal-' . esc_attr( $i ) . '">';
						}
						?>
								<div class="kpgi kad_post_grid_item-<?php echo esc_attr( $i ); ?>">
									<div class="kpgi-inner">
										<a href="<?php echo esc_url( $imagelink ); ?>" class="kt-intrinsic" style="padding-bottom:<?php echo esc_attr( $padding ); ?>%;" data-rel="<?php echo esc_attr( $datarel ); ?>">
										 <?php echo ascend_get_image_markup( $img ); ?>
										</a>
									</div>
								</div>
							<?php
							if ( $i == 2 || $i == 5 ) {
								echo '</div>';
							}
							$i ++;
							if ( $i == 6 ) {
								break;
							}
					}
					echo '</div>';
				}
			}
		}
		echo '</div>';
	}
}

