<?php
/**
 * Ascend Sidebar ID Class
 *
 * @package Ascend Theme
 */

/**
 * Determines what sidebar to show.
 *
 * @return string with sidebar ID.
 */
class Ascend_Sidebar_Id {
	/**
	 * Holds the string for sidebar ID.
	 *
	 * @var values of the sidebar ID string.
	 */
	public static $sidebar = null;

	/**
	 * Checks if page has a sidebar.
	 *
	 * @return boolean True will display the sidebar, False will not
	 */
	public static function sidebar() {
		if ( is_null( self::$sidebar ) ) {
			self::$sidebar = self::check_conditionals();
		}
		return self::$sidebar;
	}
	/**
	 * Checks conditionals to see if page has a sidebar.
	 *
	 * @return boolean True will display the sidebar, False will not.
	 */
	public static function check_conditionals() {
		$sidebar = 'sidebar-primary';
		if ( is_front_page() ) {
			$sidebar = ascend_get_option( 'home_sidebar', 'sidebar-primary' );
		} elseif ( is_home() ) {
			$homeid      = get_option( 'page_for_posts' );
			$postsidebar = get_post_meta( $homeid, '_kad_sidebar_choice', true );
			if ( isset( $postsidebar ) && 'default' === $postsidebar || empty( $postsidebar ) ) {
				$sidebar = ascend_get_option( 'blog_cat_sidebar_default', 'sidebar-primary' );
			} else {
				$sidebar = $postsidebar;
			}
		} elseif ( is_page() && ! is_attachment() ) {
			$postsidebar = get_post_meta( get_the_ID(), '_kad_sidebar_choice', true );
			if ( isset( $postsidebar ) && 'default' === $postsidebar || empty( $postsidebar ) ) {
				$sidebar = ascend_get_option( 'page_sidebar_default', 'sidebar-primary' );
			} else {
				$sidebar = $postsidebar;
			}
		} elseif ( is_post_type_archive( 'llms_membership' ) && function_exists( 'llms_get_page_id' ) ) {
			$pageid       = llms_get_page_id( 'memberships' );
			$sidebar_name = get_post_meta( $pageid, '_kad_sidebar_choice', true );
			if ( isset( $postsidebar ) && 'default' === $postsidebar || empty( $postsidebar ) ) {
				$sidebar = ascend_get_option( 'page_sidebar_default', 'sidebar-primary' );
			} else {
				$sidebar = $sidebar_name;
			}
		} elseif ( is_post_type_archive( 'course' ) && function_exists( 'llms_get_page_id' ) ) {
			$pageid       = llms_get_page_id( 'courses' );
			$sidebar_name = get_post_meta( $pageid, '_kad_sidebar_choice', true );
			if ( isset( $postsidebar ) && 'default' === $postsidebar || empty( $postsidebar ) ) {
				$sidebar = ascend_get_option( 'page_sidebar_default', 'sidebar-primary' );
			} else {
				$sidebar = $sidebar_name;
			}
		} elseif ( is_singular() ) {
			$postsidebar = get_post_meta( get_the_ID(), '_kad_sidebar_choice', true );
			if ( isset( $postsidebar ) && 'default' === $postsidebar || empty( $postsidebar ) ) {
				if ( is_singular( 'post' ) ) {
					$sidebar = ascend_get_option( 'blog_sidebar_default', 'sidebar-primary' );
				} elseif ( is_singular( 'portfolio' ) ) {
					$sidebar = ascend_get_option( 'portfolio_sidebar_default', 'sidebar-primary' );
				} elseif ( is_singular( 'testimonial' ) ) {
					$sidebar = ascend_get_option( 'testimonial_sidebar_default', 'sidebar-primary' );
				} elseif ( is_singular( 'staff' ) ) {
					$sidebar = ascend_get_option( 'staff_sidebar_default', 'sidebar-primary' );
				} elseif ( is_singular( 'product' ) ) {
					$sidebar = ascend_get_option( 'product_sidebar_default', 'sidebar-primary' );
				} else {
					$sidebar = ascend_get_option( 'custom_post_sidebar_id_default', 'sidebar-primary' );
				}
			} else {
				$sidebar = $postsidebar;
			}
		} elseif ( class_exists( 'woocommerce' ) && is_archive() && is_shop() ) {
			$sidebar = ascend_get_option( 'shop_cat_sidebar', 'sidebar-primary' );
		} elseif ( class_exists( 'woocommerce' ) && is_archive() && ( is_product_category() || is_product_tag() || is_tax( 'product_brands' ) || is_tax( 'pa_brands' ) ) ) {
			$sidebar = ascend_get_option( 'shop_cat_sidebar', 'sidebar-primary' );
		} elseif ( is_archive() && is_tax( 'portfolio-type' ) || is_archive() && is_tax( 'portfolio-tag' ) ) {
			$sidebar = ascend_get_option( 'portfolio_sidebar_default', 'sidebar-primary' );
		} elseif ( is_archive() && is_tax( 'staff-group' ) ) {
			$sidebar = ascend_get_option( 'staff_sidebar_default', 'sidebar-primary' );
		} elseif ( is_archive() && is_tax( 'testimonial-group' ) ) {
			$sidebar = ascend_get_option( 'testimonial_sidebar_default', 'sidebar-primary' );
		} elseif ( is_archive() && is_category() || is_archive() && is_tag() ) {
			$sidebar = ascend_get_option( 'blog_cat_sidebar_default', 'sidebar-primary' );
		} elseif ( is_search() ) {
			$sidebar = ascend_get_option( 'search_sidebar_default', 'sidebar-primary' );
		} elseif ( is_archive() ) {
			$sidebar = ascend_get_option( 'custom_post_sidebar_id_default', 'sidebar-primary' );
		}
		return $sidebar;
	}
}
