<?php
/**
 * Related Products
 *
 * @author     WooThemes
 * @package    WooCommerce/Templates
 * @version    3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( $related_products ) :

	$rpc = apply_filters( 'kt_related_products_columns', ascend_carousel_columns( ascend_get_option( 'related_item_column', '4' ) ) );

	$heading = apply_filters( 'woocommerce_product_related_products_heading', ascend_get_option( 'related_products_text', __( 'Related Products', 'ascend' ) ) );
?>
	<section class="related products carousel_outerrim">
		<h3 class="kt-title"><span><?php echo esc_html( $heading ); ?></span></h3>
		<div class="related-carouselcontainer row-margin-small">
			<div id="related-product-carousel" class="products slick-slider product_related_carousel kt-slickslider kt-content-carousel loading clearfix" data-slider-fade="false" data-slider-type="content-carousel" data-slider-anim-speed="400" data-slider-scroll="1" data-slider-auto="true" data-slider-speed="9000" data-slider-xxl="<?php echo esc_attr( $rpc['xxl'] ); ?>" data-slider-xl="<?php echo esc_attr( $rpc['xl'] ); ?>" data-slider-md="<?php echo esc_attr( $rpc['md'] ); ?>" data-slider-sm="<?php echo esc_attr( $rpc['sm'] ); ?>" data-slider-xs="<?php echo esc_attr( $rpc['xs'] ); ?>" data-slider-ss="<?php echo esc_attr( $rpc['ss'] ); ?>">

					<?php foreach ( $related_products as $related_product ) : ?>

						<?php
							$post_object = get_post( $related_product->get_id() );

							setup_postdata( $GLOBALS['post'] =& $post_object ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found

							wc_get_template_part( 'content', 'product' );
						?>

					<?php endforeach; ?>

			</div>
		</div>
	</section>

	<?php
endif;

wp_reset_postdata();


