<?php
global $post, $kt_portfolio_loop, $kt_portfolio_loop_count;
do_action( 'kadence_portfolio_loop_start' );
	$postsummery = get_post_meta( $post->ID, '_kad_post_summery', true );
	$crop = true;
if ( $kt_portfolio_loop['carousel'] == 'true' ) {
	$class = 'portfolio_carousel_item kt-slick-slide p_item';
} else {
	$class = 'p_item';
}
if ( $kt_portfolio_loop['style'] == 'mosaic' ) {
	$imosaic = ascend_mosaic_sizes( $kt_portfolio_loop_count['count'], $kt_portfolio_loop_count['loop'] );
	$image_width = apply_filters( 'kt_portfolio_mosaic_image_width', $imosaic['width'], $kt_portfolio_loop_count['loop'] );
	$image_height = apply_filters( 'kt_portfolio_mosaic_image_height', $imosaic['height'], $kt_portfolio_loop_count['loop'] );
	$itemsize = apply_filters( 'kt_portfolio_mosaic_size', $imosaic['itemsize'], $kt_portfolio_loop_count['loop'] );
} else if ( $kt_portfolio_loop['style'] == 'tiles' ) {
	$image_width = null;
	$image_height = $kt_portfolio_loop['tileheight'] + 120;
	$itemsize = 'tiles_item';
} else {
	if ( $kt_portfolio_loop['columns'] == '2' ) {
		$itemsize   = 'col-xxl-4 col-xl-6 col-md-6 col-sm-6 col-xs-12 col-ss-12';
		$image_width = 860;
	} else if ( $kt_portfolio_loop['columns'] == '1' ) {
		$itemsize = 'col-xxl-12 col-xl-12 col-md-12 col-sm-12 col-xs-12 col-ss-12';
		$image_width = 860;
	} else if ( $kt_portfolio_loop['columns'] == '3' ) {
		$itemsize = 'col-xxl-3 col-xl-4 col-md-4 col-sm-4 col-xs-6 col-ss-12';
		$image_width = 600;
	} else if ( $kt_portfolio_loop['columns'] == '6' ) {
		$itemsize = 'col-xxl-15 col-xl-2 col-md-2 col-sm-3 col-xs-4 col-ss-6';
		$image_width = 240;
	} else if ( $kt_portfolio_loop['columns'] == '5' ) {
		$itemsize = 'col-xxl-2 col-xl-2 col-md-25 col-sm-3 col-xs-4 col-ss-6';
		$image_width = 240;
	} else {
		$itemsize = 'col-xxl-2 col-xl-25 col-md-3 col-sm-4 col-xs-6 col-ss-12';
		$image_width = 300;
	}
	if ( isset( $kt_portfolio_loop['ratio'] ) && ! empty( $kt_portfolio_loop['ratio'] ) ) {
		$portfolio_ratio = $kt_portfolio_loop['ratio'];
	} else {
		$portfolio_ratio = 'square';
	}
	if ( $portfolio_ratio == 'portrait' ) {
		$temppimgheight = $image_width * 1.35;
		$image_height = floor( $temppimgheight );
	} else if ( $portfolio_ratio == 'landscape' ) {
		$temppimgheight = $image_width / 1.35;
		$image_height = floor( $temppimgheight );
	} else if ( $portfolio_ratio == 'widelandscape' ) {
		$temppimgheight = $image_width / 2;
		$image_height = floor( $temppimgheight );
	} else if ( $portfolio_ratio == 'softcrop' ) {
		$image_height = null;
		$crop = false;
	} else {
		$image_height = $image_width;
	}
	$image_width = apply_filters( 'kt_portfolio_grid_image_width', $image_width );
	$image_height = apply_filters( 'kt_portfolio_grid_image_height', $image_height );
}
	$terms = get_the_terms( $post->ID, 'portfolio-type' );
if ( $terms && ! is_wp_error( $terms ) ) :
	$links = array();
	foreach ( $terms as $term ) {
		$links[] = $term->slug;
	}
	$tax = join( ' ', $links );
	else :
		$tax = '';
	endif;
	?>
	<div class="<?php echo esc_attr( $itemsize ); ?> <?php echo esc_attr( $tax ); ?> <?php echo esc_attr( $class ); ?>">
		<div class="portfolio_item grid_item kt_item_fade_in" data-post-title="<?php the_title_attribute(); ?>">
			<div class="portfolio-loop-image-container">
			<?php
			if ( $postsummery == 'slider' ) {
					$image_gallery = get_post_meta( $post->ID, '_kad_image_gallery', true );
					$attachments = array_filter( explode( ',', $image_gallery ) );
				if ( ! empty( $attachments ) ) {
					$img = ascend_get_image( $image_width, $image_height, $crop, null, null, $attachments[0], true );
				} else {
					$attach_args = array(
						'order' => 'ASC',
						'post_type' => 'attachment',
						'post_parent' => $post->ID,
						'post_mime_type' => 'image',
						'post_status' => null,
						'orderby' => 'menu_order',
						'numberposts' => -1,
					);
					$attachments_posts = get_posts( $attach_args );
					if ( isset( $attachments_posts[0]->ID ) && ! empty( $attachments_posts[0]->ID ) ) {
						$img = ascend_get_image( $image_width, $image_height, $crop, null, null, $attachments_posts[0]->ID, true );
					} else {
						$img['width'] = $image_width;
						$img['height'] = $image_width;
					}
				}
					echo '<div class="img-hoverclass kt-intrinsic grid_mosiac_item portfolio-loop-image" style="padding-bottom:' . ( ( $img['height'] / $img['width'] ) * 100 ) . '%;">';
					echo '</div><div class="portfolio-loop-slider portfolio-light-gallery portfolio-light-gallery-' . esc_attr( $post->ID ) . '">';
						ascend_build_slider( $post->ID, $image_gallery, $img['width'], $img['height'], 'image', 'kt-slider-same-image-ratio', 'slider', 'false', 'true', '7000', 'false', 'true', '400', rand( 1, 400 ) );
					echo '</div>';
			} else {
				$img = ascend_get_image( $image_width, $image_height, $crop, null, null, null, true );
				echo '<div class="img-hoverclass kt-intrinsic grid_mosiac_item portfolio-loop-image" style="padding-bottom:' . ( ( $img['height'] / $img['width'] ) * 100 ) . '%;">';
					echo '<div class="portfolio-img-hover-inner">';
				if ( $kt_portfolio_loop['style'] == 'tiles' ) {
					$img['lazy'] = false;
				}
					echo ascend_get_image_markup( $img );
					echo '</div>';
				echo '</div>';
			}
			echo '<div class="portfolio-hover-item">';
			echo '<div class="portfolio-overlay-color"></div>';
			echo '<div class="portfolio-overlay-border"></div>';
			echo '<a href="' . get_the_permalink() . '" class="portfolio-hover-item-link"></a>';
			echo '<div class="portfolio-hover-item-inner">';
			if ( $kt_portfolio_loop['lightbox'] == 'true' ) {
				$light_class = 'portfolio_lightbox';
				if ( $postsummery == 'videolight' ) {
					$video = get_post_meta( $post->ID, '_kad_post_video', true );
					if ( filter_var( $video, FILTER_VALIDATE_URL ) ) {
						$light_url = $video;
						$light_class = 'ktvideolight mfp-iframe';
					} else {
						$light_url = $img['full'];
					}
				} else if ( $postsummery == 'slider' ) {
					$light_class = 'kt-no-lightbox portfolio-light-gallery-open';
					$light_url = $img['full'];
				} else {
					$light_url = $img['full'];
				}
				?>
						<a href="<?php echo esc_url( $light_url ); ?>" data-gallery-id="portfolio-light-gallery-<?php echo esc_attr( $post->ID ); ?>" class="kad_portfolio_lightbox_link <?php echo esc_attr( $light_class ); ?>" aria-label="<?php the_title_attribute(); ?>" data-rel="lightbox">
						<?php
						if ( '2' === ascend_get_option( 'minimal_icons' ) ) {
							ascend_print_svg_icon( 'zoom', false );
						} else {
							echo '<i class="kt-icon-search"></i>';
						}
						?>
						</a>
				<?php
			}
			if ( $kt_portfolio_loop['style'] != 'poststyle' ) {
				?>
					<a href="<?php the_permalink(); ?>" class="portfolio-inner-link">
						<h5 class="portfolio-loop-title"><?php the_title(); ?></h5>
						<?php
						if ( $kt_portfolio_loop['showtypes'] == 'true' ) {
							if ( $terms && ! is_wp_error( $terms ) ) {
								?>
								 
									   <div class="portfolio-loop-types">
										<?php
										$output = array();
										foreach ( $terms as $term ) {
											$output[] = $term->name;
										}
										echo implode( ' | ', $output );
										?>
									</div>
								<?php
							}
						}
						?>
						</a>
						<?php if ( $kt_portfolio_loop['showexcerpt'] == 'true' ) { ?> 
							<div class="portfolio-loop-excerpt">
								<?php the_excerpt(); ?>
							</div>
						<?php } ?>
				<?php } ?>
				</div>
				</div>
			</div> 
			<?php
			if ( $kt_portfolio_loop['style'] == 'poststyle' ) {
				?>
				<div class="portfolio-poststyle-content postclass">
					  <a href="<?php the_permalink(); ?>" class="portfolio-poststyle-link">  
						<h5 class="portfolio-loop-title"><?php the_title(); ?></h5>
						<?php
						if ( $kt_portfolio_loop['showtypes'] == 'true' ) {
							if ( $terms && ! is_wp_error( $terms ) ) {
								?>
								 
									   <div class="portfolio-loop-types">
										<?php
										$output = array();
										foreach ( $terms as $term ) {
											$output[] = $term->name;
										}
										echo implode( ' | ', $output );
										?>
									</div>
								<?php
							}
						}
						?>
					</a>
					<?php
					if ( $kt_portfolio_loop['showexcerpt'] == 'true' ) {
						?>
						 
							   <div class="portfolio-loop-excerpt">
								<?php the_excerpt(); ?>
							   </div> 
						<?php } ?>
				</div>
			<?php } ?>
		</div>
	</div>
	<?php
	do_action( 'kadence_portfolio_loop_end' );

