<?php
/**
 * Initial setup functions
 *
 * @package Ascend Theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
/**
 * Initial setup
 */
function ascend_setup() {
	global $pagenow, $ascend;
	if ( isset( $ascend['above_header_style'] ) && 'center' === $ascend['above_header_style'] && isset( $ascend['site_layout'] ) && 'above' === $ascend['site_layout'] ) {
		register_nav_menus(
			array(
				'left_navigation'      => __( 'Left Navigation', 'ascend' ),
				'right_navigation'     => __( 'Right Navigation', 'ascend' ),
				'secondary_navigation' => __( 'Secondary Navigation', 'ascend' ),
				'mobile_navigation'    => __( 'Mobile Navigation', 'ascend' ),
				'topbar_navigation'    => __( 'Topbar Navigation', 'ascend' ),
				'footer_navigation'    => __( 'Footer Navigation', 'ascend' ),
			)
		);
	} else {
		register_nav_menus(
			array(
				'primary_navigation'   => __( 'Primary Navigation', 'ascend' ),
				'secondary_navigation' => __( 'Secondary Navigation', 'ascend' ),
				'mobile_navigation'    => __( 'Mobile Navigation', 'ascend' ),
				'topbar_navigation'    => __( 'Topbar Navigation', 'ascend' ),
				'footer_navigation'    => __( 'Footer Navigation', 'ascend' ),
			)
		);
	}

	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'site-logo', array( 'size' => 'full' ) );
	add_theme_support( 'post-formats', array( 'gallery', 'image', 'video', 'quote' ) );
	add_theme_support( 'automatic-feed-links' );
	add_editor_style( '/assets/css/kt-editor-style.css' );
	add_theme_support(
		'editor-color-palette',
		array(
			array(
				'name'  => __( 'Primary Color', 'ascend' ),
				'slug'  => 'ascend-primary',
				'color' => ( isset( $ascend['primary_color'] ) && ! empty( $ascend['primary_color'] ) ? $ascend['primary_color'] : '#16A085' ),
			),
			array(
				'name'  => esc_html__( 'Lighter Primary Color', 'ascend' ),
				'slug'  => 'ascend-primary-light',
				'color' => ( isset( $ascend['primary_color'] ) && ! empty( $ascend['primary_color'] ) ? ascend_adjust_brightness( $ascend['primary_color'], 20 ) : ascend_adjust_brightness( '#16A085', 20 ) ),
			),
			array(
				'name'  => esc_html__( 'Very light gray', 'ascend' ),
				'slug'  => 'very-light-gray',
				'color' => '#eee',
			),
			array(
				'name'  => esc_html__( 'White', 'ascend' ),
				'slug'  => 'white',
				'color' => '#fff',
			),
			array(
				'name'  => esc_html__( 'Very dark gray', 'ascend' ),
				'slug'  => 'very-dark-gray',
				'color' => '#444',
			),
			array(
				'name'  => esc_html__( 'Black', 'ascend' ),
				'slug'  => 'black',
				'color' => '#000',
			),
		)
	);
	add_theme_support( 'align-wide' );

	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		)
	);
	add_theme_support( 'responsive-embeds' );
	// Indicate widget sidebars can use selective refresh in the Customizer.
	add_theme_support( 'customize-selective-refresh-widgets' );

	add_post_type_support( 'attachment', 'page-attributes' );

	if ( is_admin() && 'themes.php' == $pagenow && isset( $_GET['activated'] ) ) {
		wp_redirect( admin_url( 'themes.php?page=kt_api_manager_dashboard' ) );
	}
	define( 'ASCEND_VERSION', '1.9.19' );

	include_once ABSPATH . 'wp-admin/includes/plugin.php';
	if ( is_plugin_active( 'virtue-toolkit/virtue_toolkit.php' ) ) {
		/**
		 * Function for admin notice about toolkit.
		 */
		function ascend_plugin_admin_notice() {
			echo '<div class="error"><p>Please <strong>Disable</strong> the Kadence ToolKit Plugin. It is not needed with Ascend Premium.</p></div>';
		}
		add_action( 'admin_notices', 'ascend_plugin_admin_notice' );
	}
	if ( isset( $ascend['pagetitle_background_parallax'] ) && '1' == $ascend['pagetitle_background_parallax'] ) {
		add_filter( 'ascend_parallax_background_page_title', 'ascend_enable_parallax_page_title' );
	}
	/**
	 * Function to add parallax class
	 *
	 * @param string $class arg.
	 */
	function ascend_enable_parallax_page_title( $class ) {
		return 'kad-ascend-parallax';
	}
}
add_action( 'after_setup_theme', 'ascend_setup' );

/**
 * Handles JavaScript detection.
 */
function ascend_javascript_detection() {
	echo "<script>(function(html){html.className = html.className.replace(/\bno-js\b/,'js')})(document.documentElement);</script>\n";
}
add_action( 'wp_head', 'ascend_javascript_detection', 0 );


require_once trailingslashit( get_template_directory() ) . 'lib/schema-functions.php'; // Add Schema Functions.
require_once trailingslashit( get_template_directory() ) . 'lib/deprecated.php'; // Add Deprecated Functions.

require_once trailingslashit( get_template_directory() ) . 'lib/plugin-support/facet-wp.php'; // Add Facet Support.
require_once trailingslashit( get_template_directory() ) . 'lib/plugin-support/kadence-galleries.php'; // Add Galleries Support.
require_once trailingslashit( get_template_directory() ) . 'lib/plugin-support/lifterlms.php'; // Add Lifter Support.
require_once trailingslashit( get_template_directory() ) . 'lib/plugin-support/beaverthemer.php'; // Add Lifter Support.

