<?php
/**
 * Include the TGM_Plugin_Activation and add the plugins.
 *
 * @package Ascend Theme
 */

/**
 * Include the TGM_Plugin_Activation class.
 */
require_once trailingslashit( get_template_directory() ) . 'lib/vendor/class-tgm-plugin-activation.php';

if ( 'Activated' === get_option( 'kt_api_manager_ascend_premium_activated' ) ) {
	if ( ! class_exists( 'ZipArchive' ) ) {
		add_action( 'admin_notices', 'ascend_ziparchive_not_active' );
	} else {
		add_action( 'tgmpa_register', 'ascend_register_bundled_plugins', 30 );
	}
}
/**
 * Adds a notice to install Zip Archive.
 */
function ascend_ziparchive_not_active() {
	if ( ! current_user_can( 'manage_options' ) ) {
		return;
	}
	echo '<div id="message" class="error">';
		echo '<p>' . esc_html__( 'ZipArchive is not enabled on this server. Please contact your hosting provider and ask them to enabled ZipArchive', 'ascend' ) . '</p>';
	echo '</div>';
}
/**
 * Register the bundled plugins for this theme.
 */
function ascend_register_bundled_plugins() {
	$plugins  = array();
	$addons   = array();
	$addons[] = array(
		'name'    => 'Kadence Slider',
		'slug'    => 'kadence-slider',
		'source'  => 'https://kernl-file-uploads.s3.amazonaws.com/uploads/01-04-2019/04-22-25/kadence-slider/kadence-slider.zip',
		'version' => '2.3.0',
	);
	$addons[] = array(
		'name'    => 'Kadence Blocks Pro',
		'slug'    => 'kadence-blocks-pro',
		'source'  => 'https://kernl-file-uploads.s3.amazonaws.com/uploads/11-11-2019/12-04-52/kadence-blocks-pro/kadence-blocks-pro.zip',
		'version' => '1.3.4',
	);
	$addons[] = array(
		'name'    => 'Kadence Custom Fonts',
		'slug'    => 'kadence-custom-fonts',
		'source'  => 'https://kernl-file-uploads.s3.amazonaws.com/uploads/14-10-2019/04-43-06/kadence-custom-fonts/kadence-custom-fonts.zip',
		'version' => '1.0.2',
	);
	$addons[] = array(
		'name'    => 'Kadence reCAPTCHA',
		'slug'    => 'kadence-recaptcha',
		'source'  => 'https://kernl-file-uploads.s3.amazonaws.com/uploads/29-04-2019/02-50-11/kadence-recaptcha/kadence-recaptcha.zip',
		'version' => '1.0.6',
	);
	$addons[] = array(
		'name'    => 'Kadence Importer',
		'slug'    => 'kadence-importer',
		'source'  => 'https://kernl-file-uploads.s3.amazonaws.com/uploads/15-02-2019/12-32-53/kadence-importer/kadence-importer.zip',
		'version' => '2.0.5',
	);

	foreach ( $addons as $ext => $data ) {
		$plugins[ $ext ] = array(
			'name'               => $data['name'],
			'slug'               => $data['slug'],
			'source'             => $data['source'],
			'required'           => false,
			'version'            => $data['version'],
			'force_activation'   => false,
			'force_deactivation' => false,
		);
	}
	/**
	 * Array of configuration settings. Amend each line as needed.
	 * If you want the default strings to be available under your own theme domain,
	 * leave the strings uncommented.
	 * Some of the strings are added into a sprintf, so see the comments at the
	 * end of each line for what each argument will be.
	 */
	$config = array(
		'domain'       => 'ascend',
		'default_path' => '',
		'parent_slug'  => 'themes.php',
		'menu'         => 'install-recommended-plugins',
		'has_notices'  => false,
		'is_automatic' => false,
		'message'      => '',
		'strings'      => array(
			'page_title'                     => __( 'Install Bundled Plugins', 'ascend' ),
			'menu_title'                     => __( 'Theme Plugins', 'ascend' ),
			'oops'                           => __( 'Something went wrong with the plugin API.', 'ascend' ),
			/* translators: %1$s = plugin name(s) */
			'notice_can_install_recommended' => _n_noop( 'This theme comes packaged with the following premium plugin: %1$s. Plugin is not required.', 'This theme comes packaged with the following premium plugins: %1$s. Plugins are not required.', 'ascend' ),
			/* translators: %1$s = plugin name(s) */
			'notice_cannot_install'          => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'ascend' ),
			/* translators: %1$s = plugin name(s) */
			'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'ascend' ),
			/* translators: %1$s = plugin name(s) */
			'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'ascend' ),
			/* translators: %1$s = plugin name(s) */
			'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'ascend' ),
			'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'ascend' ),
			'activate_link'                   => _n_noop( 'Activate installed plugin', 'Activate installed plugins', 'ascend' ),
			'return'                          => __( 'Return to recommended Plugins Installer', 'ascend' ),
			'plugin_activated'                => __( 'Plugin activated successfully.', 'ascend' ),
			/* translators: %1$s = plugin name(s) */
			'complete'                        => __( 'All plugins installed and activated successfully. %s', 'ascend' ),
			'nag_type'                        => 'updated',
		),
	);
	tgmpa( $plugins, $config );
}
