<?php

namespace WpTypek\Core;

use WpTypek\Platform\Plugin;

defined( '_WPTYPEK_EXEC' ) or die( 'Restricted access' );

/**
 * ## <plugin_mod@mirek> ##
 */
class WPTypekJavascriptManager {
    public static function dequeueScripts() {
        global $wp_scripts;

        $options = Plugin::getPluginParams()->getOptions();
        if ( ! empty( $options['remove_javascript_rules'] ) ) {
            $rules          = $options['remove_javascript_rules'];

            foreach ( $rules as $ruleKey => $rule ) {
                if ( $ruleKey !== '++rule--key++' && ! empty( $rule['scripts'] ) ) {
                    $rule['do_exclude'] = 1;
                    if ( WPTypekAssetsManager::shouldDequeue( $rule ) ) {
                        foreach ( $wp_scripts->registered as $registeredScriptKey => $registeredScript ) {
                            foreach($rule['scripts'] as $script) {
                                $script = str_replace(array('.../', '...'), array('', ''), $script);
                                if ( strpos( $registeredScript->src, $script ) !== false ) {
                                    wp_dequeue_script( $registeredScriptKey );
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static function getScriptsToBeLoadedOnScroll() {
        global $wp_scripts;
        $scriptsToBeLoadedOnScroll = [];

        $options = Plugin::getPluginParams()->getOptions();
        if ( ! empty( $options['remove_javascript_rules'] ) ) {
            $rules          = $options['remove_javascript_rules'];

            foreach ( $rules as $ruleKey => $rule ) {
                if ( $ruleKey !== '++rule--key++' && ! empty( $rule['scripts'] ) ) {
                    $rule['do_exclude'] = 1;
                    if ( WPTypekAssetsManager::shouldDequeue( $rule ) && isset( $rule['load_on_scroll'] ) && $rule['load_on_scroll'] > 0 ) {
                        foreach ( $wp_scripts->registered as $registeredScriptKey => $registeredScript ) {
                            foreach($rule['scripts'] as $script) {
                                $script = str_replace(array('.../', '...'), array('', ''), $script);
                                if ( strpos( $registeredScript->src, $script ) !== false ) {
                                    $scriptsToBeLoadedOnScroll[$registeredScriptKey] = $registeredScript;
                                }
                            }
                        }
                    }
                }
            }
        }

        return $scriptsToBeLoadedOnScroll;
    }
}
