<?php

namespace WpTypek\Minify;

defined('_WPTYPEK_EXEC') or die('Restricted access');

abstract class Base
{

	//regex for double quoted strings
	// language=RegExp
	const DOUBLE_QUOTE_STRING = '"(?>(?:\\\\.)?[^\\\\"]*+)+?(?:"|(?=$))';

	//regex for single quoted string
	// language=RegExp
	const SINGLE_QUOTE_STRING = "'(?>(?:\\\\.)?[^\\\\']*+)+?(?:'|(?=$))";

	//regex for backtick quoted string
	//language=RegExp
	const BACK_TICK_STRING = '`(?>(?:\\\\.)?[^\\\\`]*+)+?(?:`|(?=$))';

	//regex for block comments
	// language=RegExp
	const BLOCK_COMMENT = '/\*(?>[^*]++|\*(?!/))*+\*/';

	//regex for line comments
	// language=RegExp
	const LINE_COMMENT = '//[^\r\n]*+';

	//regex for HTML comments
	// language=RegExp
	const HTML_COMMENT = '(?:(?:<!--|(?<=[\s/^])-->)[^\r\n]*+)';

	//Regex for HTML attributes
	// language=RegExp
	const HTML_ATTRIBUTE = '[^\s/"\'=<>]*+(?:\s*=(?>\s*+"[^"]*+"|\s*+\'[^\']*+\'|[^\s>]*+[\s>]))?';

	//Regex for HTML attribute values
	// language=RegExp
	const ATTRIBUTE_VALUE = '(?>(?<=")[^"]*+|(?<=\')[^\']*+|(?<==)[^\s*+>]*+)';

	// language=RegExp
	const URI = '(?<=url)\(\s*+(?:"[^"]*+"|\'[^\']*+\'|[^)]*+)\s*+\)';

	protected $_debug = false;
	protected $_regexNum = -1;
	protected $_limit = 0;

	/**
	 *
	 * @param   string   $regex
	 * @param   string   $code
	 * @param   integer  $regexNum
	 *
	 * @return boolean|void
	 */
	protected function _debug($regex, $code, $regexNum = 0)
	{
		if (!$this->_debug) return false;

		/** @var float $pstamp */
		static $pstamp = 0;

		if ($pstamp === 0)
		{
			$pstamp = microtime(true);

			return;
		}

		$nstamp = microtime(true);
		$time   = $nstamp - $pstamp;

		if ($time > $this->_limit)
		{
			print 'num=' . $regexNum . "\n";
			print 'time=' . $time . "\n\n";
		}

		if ($regexNum == $this->_regexNum)
		{
			print $regex . "\n";
			print $code . "\n\n";
		}

		$pstamp = $nstamp;
	}

	/**
	 *
	 * @staticvar bool $tm
	 *
	 * @param   string    $regex
	 * @param   string    $replacement
	 * @param   string    $code
	 * @param   mixed     $regex_num
	 * @param   callable  $callback
	 *
	 * @return string
	 * @throws \Exception
	 */
	protected function _replace($regex, $replacement, $code, $regex_num, $callback = null)
	{
		static $tm = false;

		if ($tm === false)
		{
			$this->_debug('', '');
			$tm = true;
		}

		if (empty($callback))
		{
			$op_code = preg_replace($regex, $replacement, $code);
		}
		else
		{
			$op_code = preg_replace_callback($regex, $callback, $code);
		}

		$this->_debug($regex, $code, $regex_num);

		$error = array_flip(array_filter(get_defined_constants(true)['pcre'], function ($value) {
			return substr($value, -6) === '_ERROR';
		}, ARRAY_FILTER_USE_KEY))[preg_last_error()];

		if (preg_last_error() != PREG_NO_ERROR)
		{
			throw new \Exception($error);
		}

		return $op_code;
	}

}
