<?php

namespace WpTypek\Core;

defined('_WPTYPEK_EXEC') or die('Restricted access');

use WpTypek\Platform\Settings;
use WpTypek\Platform\Utility;

/**
 *
 *
 */
class Logger
{
	/**
	 *
	 * @param   string    $sMessage
	 * @param   Settings  $params
	 */
	public static function log($sMessage, Settings $params)
	{
		WPTYPEK_DEBUG ? Utility::log($sMessage, 'ERROR', 'plg_wp_typek.errors.php') : null;
	}

	/**
	 *
	 * @param   string  $variable
	 * @param   string  $name
	 */
	public static function debug($variable, $name = '')
	{
		$sMessage = $name != '' ? "$name = '" . $variable . "'" : $variable;

		Utility::log($sMessage, 'DEBUG', 'plg_wp_typek.debug.php');
	}

	/**
	 *
	 * @param   string  $sMessage
	 */
	public static function logInfo($sMessage)
	{
		Utility::log($sMessage, 'INFO', 'plg_wp_typek.logs.php');
	}

}
