<?php

if ( ! defined( '_WPTYPEK_EXEC' ) ) {
    define( '_WPTYPEK_EXEC', '1' );
}

defined( '_WPTYPEK_EXEC' ) or die( 'Restricted access' );


function wptypek_class_autoload( $class ) {
    $class = ltrim( $class, '\\' );
    $file  = dirname( __FILE__ ) . DIRECTORY_SEPARATOR;

    if ( substr( $class, 0, 13 ) == 'WpTypek\\LIBS\\' ) {
        $file .= 'libs' . DIRECTORY_SEPARATOR . substr( $class, 13 ) . '.php';
    } elseif ( substr( $class, 0, 13 ) == 'WpTypek\\Core\\' ) {
        $file .= strtolower( substr( $class, 13 ) ) . '.php';
    } elseif ( substr( $class, 0, 17 ) == 'WpTypek\\Platform\\' ) {
        $file = dirname( dirname( __FILE__ ) ) . DIRECTORY_SEPARATOR . 'platform' . DIRECTORY_SEPARATOR . strtolower( substr( $class, 17 ) ) . '.php';
    } elseif ( substr( $class, 0, 19 ) == 'WpTypek\\Interfaces\\' ) {
        $file .= 'interfaces' . DIRECTORY_SEPARATOR . strtolower( substr( $class, 19, - 9 ) ) . '.php';
    } elseif ( substr( $class, 0, 15 ) == 'WpTypek\\Minify\\' ) {
        $file .= 'minify' . DIRECTORY_SEPARATOR . strtolower( substr( $class, 15 ) ) . '.php';
    } elseif ( substr( $class, 0, 13 ) == 'WpTypek\\Root\\' ) {
        $file = dirname( dirname( __FILE__ ) ) . substr( $class, 13 ) . '.php';
    } elseif ( substr( $class, 0, 15 ) == 'WP_Optimization' ) {
        require_once dirname( dirname( __FILE__ ) ) . DIRECTORY_SEPARATOR . 'platform' . DIRECTORY_SEPARATOR . 'database_optimizations' . DIRECTORY_SEPARATOR . 'abstract.php';
        $file = dirname( dirname( __FILE__ ) ) . DIRECTORY_SEPARATOR . 'platform' . DIRECTORY_SEPARATOR . 'database_optimizations' . DIRECTORY_SEPARATOR . str_replace('WP_Optimization_', '', $class) . '.php';
    } else {
        return false;
    }


    if ( file_exists( $file ) ) {
        require_once( $file );
    }
}

spl_autoload_register( 'wptypek_class_autoload', true, true );




