<?php

namespace WpTypek\Interfaces;

defined('_WPTYPEK_EXEC') or die('Restricted access');

/**
 * Interface HttpInterface
 * @package WpTypek\Interfaces
 */
interface HttpInterface
{
	/**
	 *
	 * @param   string      $sPath
	 * @param   array       $aPost
	 * @param   array|null  $aHeaders
	 * @param   string      $sUserAgent
	 *
	 * @return array
	 */
	public function request($sPath, $aPost = null, $aHeaders = null, $sUserAgent = '');

	/**
	 * Returns an available http transport object
	 *
	 * @return mixed False if no http adapter found, Http object otherwise
	 */
	public function available();
}
