<?php

namespace WPTypek\Interfaces;

defined('_WPTYPEK_EXEC') or die('Restricted access');

interface CacheInterface
{
	/**
	 *
	 * @param   string    $id
	 * @param   callable  $function
	 * @param   array     $args
	 */
	public static function getCallbackCache($id, $function, $args);

	/**
	 *
	 * @param   string  $id
	 * @param   bool    $checkexpire
	 */
	public static function getCache($id, $checkexpire = false);

	/**
	 *
	 *
	 */
	public static function gc();

	/**
	 *
	 * @param   string  $content
	 * @param   string  $id
	 */
	public static function saveCache($content, $id);

	/**
	 *
	 * @param   string  $context
	 */
	public static function deleteCache($context = 'both');
}
