<?php

namespace WpTypek\Core;

defined( '_WP_EXEC' ) or die( 'Restricted access' );

class Database {
    private $wpdb;

    public function __construct() {
        global $wpdb;

        $this->wpdb = $wpdb;
    }

    public function optimizeTables() {
        foreach ( $this->getTables() as $table ) {
            $this->wpdb->query( "OPTIMIZE TABLE `{$table}`" );
        }

        wptypek_flash_message('success', __('Tables optimized', 'wp-typek'));
        $this->redirect();
    }

    public function cleanAllPostRevisions() {
        $clean = "DELETE FROM `" . $this->wpdb->posts . "` WHERE post_type = 'revision';";
        $this->wpdb->query( $clean );

        $this->clearOrphanedPostMeta();
        wptypek_flash_message('success', __('Post revisions cleared', 'wp-typek'));
        $this->redirect();
    }

    public function cleanAllAutoDraftPosts() {
        $clean = "DELETE FROM `" . $this->wpdb->posts . "` WHERE post_status = 'auto-draft';";
        $this->wpdb->query( $clean );

        $this->clearOrphanedPostMeta();
        wptypek_flash_message('success', __('Auto-draft posts cleaned', 'wp-typek'));
        $this->redirect();
    }

    public function cleanAllTrashedPosts() {
        $remove_ids_sql = "SELECT ID FROM `" . $this->wpdb->posts . "` WHERE post_status = 'trash';";
        $post_remove_ids = $this->wpdb->get_col( $remove_ids_sql );
        if ( ! empty( $post_remove_ids ) ) {
            $post_remove_ids = join( ',', $post_remove_ids );
            $clean = "DELETE FROM `" . $this->wpdb->postmeta . "` WHERE post_id IN (" . $post_remove_ids . ");";
            $this->wpdb->query( $clean );
            $clean = "DELETE FROM `" . $this->wpdb->term_relationships . "` WHERE object_id IN (" . $post_remove_ids . ");";
            $this->wpdb->query( $clean );
            $clean = "DELETE c, cm FROM `" . $this->wpdb->comments . "` c LEFT JOIN `" . $this->wpdb->commentmeta . "` cm ON c.comment_ID = cm.comment_id WHERE c.comment_post_ID IN (" . $post_remove_ids . ");";
            $this->wpdb->query( $clean );
        }

        $clean = "DELETE FROM `" . $this->wpdb->posts . "` WHERE post_status = 'trash';";
        $this->wpdb->query( $clean );
        wptypek_flash_message('success', __('Trashed posts cleaned', 'wp-typek'));
        $this->redirect();
    }

    public function removeSpamAndTrashedComments() {
        foreach(['spam', 'trash'] as $type) {
            $clean = "DELETE c, cm FROM `" . $this->wpdb->comments . "` c LEFT JOIN `" . $this->wpdb->commentmeta . "` cm ON c.comment_ID = cm.comment_id WHERE c.comment_approved = '{$type}';";
            $this->wpdb->query( $clean );
        }
        wptypek_flash_message('success', __('Spam and trashed comments removed', 'wp-typek'));
        $this->redirect();
    }

    public function removeUnapprovedComments() {
        $clean = "DELETE c, cm FROM `" . $this->wpdb->comments . "` c LEFT JOIN `" . $this->wpdb->commentmeta . "` cm ON c.comment_ID = cm.comment_id WHERE comment_approved = '0';";
        $this->wpdb->query( $clean );
        wptypek_flash_message('success', __('Unapproved comments removed', 'wp-typek'));
        $this->redirect();
    }

    public function removeExpiredTransientOptions() {
        // clean transients rows.
        $clean = "
				DELETE
					a
				FROM
					" . $this->wpdb->options . " a
				LEFT JOIN " . $this->wpdb->options . " b
				ON
					b.option_name = CONCAT(
						'_transient_timeout_',
						SUBSTRING(
							a.option_name,
							CHAR_LENGTH('_transient_') + 1
						)
					)
				WHERE
					a.option_name LIKE '_transient_%' AND
					a.option_name NOT LIKE '_transient_timeout_%'
        ";

        // clean transient timeouts rows.
        $clean_timeouts = "
				DELETE
					b
				FROM
					" . $this->wpdb->options . " b
				WHERE
					b.option_name LIKE '_transient_timeout_%'
        ";

        $this->wpdb->query($clean);
        $this->wpdb->query($clean_timeouts);
        wptypek_flash_message('success', __('Expired transients removed', 'wp-typek'));
        $this->redirect();
    }

    public function removeAllTransientOptions() {
        // clean transients rows.
        $clean = "
				DELETE
					a
				FROM
					" . $this->wpdb->options . " a
				LEFT JOIN " . $this->wpdb->options . " b
				ON
					b.option_name = CONCAT(
						'_transient_timeout_',
						SUBSTRING(
							a.option_name,
							CHAR_LENGTH('_transient_') + 1
						)
					)
				WHERE
					a.option_name LIKE '_transient_%' AND
					a.option_name NOT LIKE '_transient_timeout_% AND b.option_value < UNIX_TIMESTAMP()'
        ";

        // clean transient timeouts rows.
        $clean_timeouts = "
				DELETE
					b
				FROM
					" . $this->wpdb->options . " b
				WHERE
					b.option_name LIKE '_transient_timeout_% AND b.option_value < UNIX_TIMESTAMP()'
        ";

        $this->wpdb->query($clean);
        $this->wpdb->query($clean_timeouts);
        wptypek_flash_message('success', __('All transients removed', 'wp-typek'));

        $this->redirect();
    }

    public function removePingbacks() {
        $clean = "DELETE FROM `" . $this->wpdb->comments . "` WHERE comment_type = 'pingback';";
        $this->wpdb->query( $clean );
        wptypek_flash_message('success', __('Pingbacks removed', 'wp-typek'));
        $this->redirect();
    }

    public function removeTrackbacks() {
        $clean = "DELETE c, cm FROM `" . $this->wpdb->comments . "` c LEFT JOIN `" . $this->wpdb->commentmeta . "` cm ON c.comment_ID = cm.comment_id WHERE comment_type = 'trackback';";
        $this->wpdb->query( $clean );
        wptypek_flash_message('success', __('Trackbacks removed', 'wp-typek'));
        $this->redirect();
    }

    public function cleanPostMetaData() {
        $this->clearOrphanedPostMeta();
        wptypek_flash_message('success', __('Posts meta removed', 'wp-typek'));
        $this->redirect();
    }

    public function cleanCommentMetaData() {
        $clean = "DELETE FROM `" . $this->wpdb->commentmeta . "` WHERE comment_id NOT IN (SELECT comment_id FROM `" . $this->wpdb->comments . "`);";
        $this->wpdb->query( $clean );
        wptypek_flash_message('success', __('Comments meta removed', 'wp-typek'));
        $this->redirect();
    }

    public function cleanOrphanedRelationshipData() {
        $clean = "DELETE FROM `" . $this->wpdb->term_relationships . "` WHERE term_taxonomy_id=1 AND object_id NOT IN (SELECT id FROM `" . $this->wpdb->posts . "`);";
        $this->wpdb->query( $clean );
        wptypek_flash_message('success', __('Orphaned relationships removed', 'wp-typek'));
        $this->redirect();
    }

    private function getTables() {
        return $this->wpdb->tables();
    }

    private function clearOrphanedPostMeta() {
        $clean = "DELETE pm FROM `" . $this->wpdb->postmeta . "` pm LEFT JOIN `" . $this->wpdb->posts . "` p ON pm.post_id = p.ID WHERE p.ID IS NULL;";
        $this->wpdb->query( $clean );
    }

    private function redirect() {
        global $wptypek_redirect;
        $wptypek_redirect = 'wp-typek_database';
        wptypek_redirect();
    }
}
