<?php

namespace WpTypek\Core;

defined( '_WPTYPEK_EXEC' ) or die( 'Restricted access' );

use WpTypek\Platform\Profiler;
use WpTypek\Platform\Cache;
use WpTypek\Platform\Settings;
use WpTypek\Platform\Utility;

class Cron {
    public $params;

    /**
     *
     * @param Settings $params
     */
    public function __construct( $params ) {
        $this->params = $params;
    }

    /**
     *
     * @param Parser $oParser
     *
     * @return string
     */
    public function runCronTasks( $oParser ) {
        //$this->getAdminObject($oParser);
        $this->garbageCron();
//        $this->garbageCronCacheOnly(); //@TODO should be as separate one?

        return 'CRON';
    }

    /**
     * @param Parser $oParser
     */
    public function getAdminObject( $oParser ) {
        WPTYPEK_DEBUG ? Profiler::start( 'GetAdminObject' ) : null;

        try {
            $oAdmin = new Admin( $this->params );
            $oAdmin->getAdminLinks( $oParser->getOriginalHtml(), Utility::menuId() );
        } catch ( Exception $ex ) {
            Logger::log( $ex->getMessage(), $this->params );
        }

        WPTYPEK_DEBUG ? Profiler::stop( 'GetAdminObject', true ) : null;
    }

    /**
     *
     */
    public function garbageCron() {
        WPTYPEK_DEBUG ? Profiler::start( 'GarbageCron' ) : null;

        // $url = Paths::ajaxUrl('garbagecron');
        // Helper::postAsync($url, $this->params, array('async' => '1'));
        Cache::gc();

        WPTYPEK_DEBUG ? Profiler::stop( 'GarbageCron', true ) : null;
    }

    /**
     * ## <plugin_mod@mirek> ##
     */
    public function garbageCronCacheOnly() {
        WPTYPEK_DEBUG ? Profiler::start( 'GarbageCronCacheOnly' ) : null;
        Cache::gcCacheOnly();
        WPTYPEK_DEBUG ? Profiler::stop( 'GarbageCronCacheOnly', true ) : null;
    }
}
