<?php

namespace WpTypek\Core;

defined('_WPTYPEK_EXEC') or die('Restricted access');

/**
 * Some basic utility functions required by the plugin and shared by class
 *
 */
class Base extends \WpTypek\Minify\Base
{

	/**
	 * Search area used to find js and css files to remove
	 *
	 * @return string
	 * @throws Exception
	 */
	public function getHeadHtml()
	{
		$sHeadRegex = $this->getHeadRegex();

		if (preg_match($sHeadRegex, $this->sHtml, $aHeadMatches) === false || empty($aHeadMatches))
		{
			throw new Exception('An error occurred while trying to find the <head> tags in the HTML document. Make sure your template has <head> and </head>');
		}

		return $aHeadMatches[0] . $this->sRegexMarker;
	}

	protected function cleanRegexMarker($sHtml)
	{
		return preg_replace('#' . preg_quote($this->sRegexMarker, '#') . '.*+$#', '', $sHtml);
	}

	public function setHeadHtml($sHtml)
	{
		$sHtml       = $this->cleanRegexMarker($sHtml);
		$this->sHtml = preg_replace($this->getHeadRegex(), Helper::cleanReplacement($sHtml), $this->sHtml, 1);
	}

	/**
	 * Fetches HTML to be sent to browser
	 *
	 * @return string
	 */
	public function getHtml()
	{
		return $this->sHtml;
	}

	/**
	 * Determines if file requires http protocol to get contents (Not allowed)
	 *
	 * @param   string  $sUrl
	 *
	 * @return boolean
	 */
	public function isHttpAdapterAvailable($sUrl)
	{
		return !(preg_match('#^(?:http|//)#i', $sUrl) && !Url::isInternal($sUrl)
			|| $this->isPHPFile($sUrl));
	}

	/**
	 * Regex for head search area
	 *
	 * @param   bool  $head_only
	 *
	 * @return string
	 */
	public static function getHeadRegex($head_only = false)
	{
		return '#' . self::headRegex($head_only) . '#si';
	}

	public static function headRegex($head_only=false)
	{
		$s = $head_only ? '<head\b' : '^';

		return "$s(?><?[^<]*+(?:<script\b(?><?[^<]*+)*?</\s*script\b|" . Parser::ifRegex()
			. ")?)*?(?:</\s*head\s*+>|(?=<body\b))";
	}

	/**
	 *
	 * @param   string  $sUrl
	 *
	 * @return boolean
	 */
	public function isPHPFile($sUrl)
	{
		return preg_match('#\.php|^(?![^?\#]*\.(?:css|js|png|jpe?g|gif|bmp)(?:[?\#]|$)).++#i', $sUrl);
	}

	/**
	 *
	 * @param $sType
	 *
	 * @return boolean
	 */
	public function excludeDeclaration($sType)
	{
		return true;
	}

	/**
	 *
	 * @return boolean
	 */
	public function runCookieLessDomain()
	{
		return false;
	}

	/**
	 *
	 * @return boolean
	 */
	public function lazyLoadImages()
	{
		return false;
	}

	/**
	 * Regex for body section in Html
	 *
	 * @return string
	 */
	public static function getBodyRegex()
	{
		return '#' . self::headRegex() . '\K.*$#si';
	}

}
