<?php

/**
 * Plugin Name: WPTypek Performance
 * Plugin URI: https://wptypek.com
 * Description: WPTypek Performance makes your site fast and efficient. It cleans the database, compresses images and caches pages. Fast sites attract more traffic and users.
 * Version: 3.0.20
 * Author: Team WPTypek
 * Author URI: https://wptypek.com
 * Text Domain: wp-typek
 * Domain Path: /languages
 * License: GPLv2 or later
 * -------------------- LICENSE --------------------
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * For more information, see http://www.gnu.org/licenses/
 *
 * -------------------- ACKNOWLEDGEMENTS --------------------
 *
 * Certain aspects of this plugin are built using code found in the following freely available resources:
 *
 * 1. https://www.jch-optimize.net/
 */

$wptypek_backend     = filter_input( INPUT_GET, 'wptypek-backend', FILTER_SANITIZE_STRING );
$wptypek_no_optimize = false;

if ( ! defined( '_WP_EXEC' ) ) {
    define( '_WP_EXEC', '1' );
}

use WpTypek\Platform\Plugin;
use WpTypek\Platform\Uri;
use WpTypek\Platform\Cache;
use WpTypek\Platform\Utility;
use WpTypek\Core\Helper;
use WpTypek\Core\Optimize;
use WpTypek\Core\Logger;
use WpTypek\Core\PageCache;
use WpTypek\Core\Admin;

if ( ! defined( 'WPTYPEK_PLUGIN_URL' ) ) {
    define( 'WPTYPEK_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}
if ( ! defined( 'WPTYPEK_PLUGIN_DIR' ) ) {
    define( 'WPTYPEK_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}
if ( ! defined( 'WPTYPEK_VERSION' ) ) {
    define( 'WPTYPEK_VERSION', '3.0.20' );
}

require_once( WPTYPEK_PLUGIN_DIR . 'wptypek/loader.php' );

$params = Plugin::getPluginParams();

//Handles activation routines
include_once WPTYPEK_PLUGIN_DIR . '/wptypekplugininstaller.php';
$wpTypekPluginInstaller = new WPTypekPluginInstaller();
register_activation_hook( __FILE__, array( $wpTypekPluginInstaller, 'activate' ) );

if ( ! file_exists( dirname( __FILE__ ) . '/dir.php' ) ) {
    $wpTypekPluginInstaller->activate();
}

if ( is_admin() ) {
    require_once( WPTYPEK_PLUGIN_DIR . 'options.php' );
} else {
    require_once( WPTYPEK_PLUGIN_DIR . 'topbar.php' ); //## <plugin_mod@mirek> ##
    $url_exclude = $params->get( 'url_exclude', array() );

// ## <plugin_mod@mirek> ##
    if (
        defined( 'WP_USE_THEMES' )
        && WP_USE_THEMES
        && $wptypek_backend != 1
        && version_compare( PHP_VERSION, '5.3.0', '>=' )
        && ! defined( 'DOING_AJAX' )
        && ! defined( 'DOING_CRON' )
        && ! defined( 'APP_REQUEST' )
        && ! defined( 'XMLRPC_REQUEST' )
        && ( ! defined( 'SHORTINIT' ) || ( defined( 'SHORTINIT' ) && ! SHORTINIT ) )
        && ! Helper::findExcludes( $url_exclude, Uri::getInstance()->toString() )
        && ! Helper::isDoingPostRequest()
    ) {
        //Disable NextGen Resource Manager; incompatible with plugin
        //add_filter( 'run_ngg_resource_manager', '__return_false' );

        add_action( 'init', 'wptypek_init', 0 );

        add_action('wp_enqueue_scripts', function() {
            \WpTypek\Core\WPTypekJavascriptManager::dequeueScripts();
        }, 99);

        ob_start( 'wptypek' );
    }
}

function wptypek_init() {
    Pagecache::initialize();
//    \WpTypek\Core\WPTypekAssetsManager::initialize();
//    \WpTypek\Core\WPTypekAssetsManager::attachAssetsExclude();
}

function wptypek_load_plugin_textdomain() {
    load_plugin_textdomain( 'wp-typek', false, basename( dirname( __FILE__ ) ) . '/languages' );
}

add_action( 'plugins_loaded', 'wptypek_load_plugin_textdomain' );

function wptypek( $sHtml ) {
    if ( ! Helper::validateHtml( $sHtml ) ) {
        return $sHtml;
    }

    //need to check this here, it could be set dynamically
    global $wptypek_no_optimize;

    // ##<plugin_mod_start@mirek>##
    $params            = Plugin::getPluginParams();
    $disable_logged_in = $params->get( 'disable_logged_in_users', '0' );
    $disable_admin     = $params->get( 'disable_admin_users', '0' );

    //Need to call Utility::isGuest after init has been called
    if ( $wptypek_no_optimize || ( $disable_logged_in && ! Utility::isGuest() ) || ( $disable_admin && Utility::isAdmin() ) ) {
        return $sHtml;
    }
    // ##<plugin_mod_end@mirek>##

    try {
        $sOptimizedHtml = Optimize::optimize( $params, $sHtml );
        Pagecache::store( $sOptimizedHtml );
    } catch ( Exception $e ) {
        Logger::log( $e->getMessage(), $params );

        $sOptimizedHtml = $sHtml;
    }


    return $sOptimizedHtml;
}

add_filter( 'plugin_action_links', 'wptypek_plugin_action_links', 10, 2 );

function wptypek_plugin_action_links( $links, $file ) {
    static $this_plugin;

    if ( ! $this_plugin ) {
        $this_plugin = plugin_basename( __FILE__ );
    }

    if ( $file == $this_plugin ) {
        $settings_link = '<a href="' . admin_url( 'admin.php?page=wp-typek' ) . '">' . __( 'Settings' ) . '</a>';
        array_unshift( $links, $settings_link );
    }

    return $links;
}

function wp_typek_uninstall() {
    delete_option( 'wptypek_options' );

    try {
        Cache::deleteCache();
    } catch ( \WpTypek\Core\Exception $e ) {
    }

    Admin::cleanHtaccess();
}

register_uninstall_hook( __FILE__, 'wp_typek_uninstall' );

// ## <plugin_mod@mirek> ##
function wp_typek_deactivation() {
    @unlink( ABSPATH . 'wp-content/mu-plugins/wptypek-mu-plugin.php' );
}

register_deactivation_hook( __FILE__, 'wp_typek_deactivation' );

$options = get_option( 'wptypek_options' );

if ( ! isset( $options['order_plugin'] ) || ( isset( $options['order_plugin'] ) && $options['order_plugin'] ) ) {
    //Adjusts the plugins load order when a plugin is activated
    function wptypek_order_plugin() {
        $active_plugins = (array) get_option( 'active_plugins', array() );
        $order          = array(
            'wp-super-cache/wp-cache.php',
            'w3-total-cache/w3-total-cache.php',
            'litespeed-cache/litespeed-cache.php',
            'wp-fastest-cache/wpFastestCache.php',
            'comet-cache/comet-cache.php',
            'hyper-cache/plugin.php',
            'wptypek-performance/wp-typek-performance.php'
        );

        //Get the plugins in $order that are currently activated
        $order_short_list = array_intersect( $order, $active_plugins );
        //Remove plugins in $order_short_list from list of activated plugins
        $active_plugins_slist = array_diff( $active_plugins, $order_short_list );
        //Merge $order with $active_plugins_list
        $ordered_active_plugins = array_merge( $order_short_list, $active_plugins_slist );

        update_option( 'active_plugins', $ordered_active_plugins );
    }

    add_action( 'activated_plugin', 'wptypek_order_plugin' );
}


if ( ! empty( $options['lazyload_enable'] ) ) {
    function wptypek_load_lazy_images() {
        $params = Plugin::getPluginParams();

        wp_register_script( 'wptypek-lazyloader-js', WPTYPEK_PLUGIN_URL . 'media/js/ls.loader.js', array(), WPTYPEK_VERSION );
        wp_enqueue_script( 'wptypek-lazyloader-js' );
        ##<procode>##
        if ( $params->get( 'pro_lazyload_effects', '0' ) ) {
            wp_enqueue_style( 'wptypek-lazyload-css', WPTYPEK_PLUGIN_URL . 'media/css/pro-ls.effects.css', array(), WPTYPEK_VERSION );

            wp_register_script( 'wptypek-lseffects-js', WPTYPEK_PLUGIN_URL . 'media/js/pro-ls.loader.effects.js', array( 'wptypek-lazyloader-js' ), WPTYPEK_VERSION );
            wp_enqueue_script( 'wptypek-lseffects-js' );
        }
        ##</procode>##
        if ( $params->get( 'lazyload_autosize', '0' ) ) {
            wp_register_script( 'wptypek-lsautosize-js', WPTYPEK_PLUGIN_URL . 'media/js/ls.autosize.js', array( 'wptypek-lazyloader-js' ), WPTYPEK_VERSION );
            wp_enqueue_script( 'wptypek-lsautosize-js' );
        }

        wp_register_script( 'wptypek-lazyload-js', WPTYPEK_PLUGIN_URL . 'media/js/lazysizes.js', array( 'wptypek-lazyloader-js' ), WPTYPEK_VERSION );
        wp_enqueue_script( 'wptypek-lazyload-js' );
    }

    add_action( 'wp_head', 'wptypek_load_lazy_images' );
}

// ## <plugin_mod@mirek> ##
// Load WC_AM_Client class if it exists.
if ( ! class_exists( 'WC_AM_Client_24' ) ) {
    // Uncomment next line if this is a plugin
    require_once( plugin_dir_path( __FILE__ ) . 'wc-am-client.php' );

    // Uncomment next line if this is a theme
    // require_once( get_stylesheet_directory() . '/wc-am-client.php' );
}

// Instantiate WC_AM_Client class object if the WC_AM_Client class is loaded.
if ( class_exists( 'WC_AM_Client_24' ) ) {
    /**
     * This file is only an example that includes a plugin header, and this code used to instantiate the client object. The variable $wcam_lib
     * can be used to access the public properties from the WC_AM_Client class, but $wcam_lib must have a unique name. To find data saved by
     * the WC_AM_Client in the options table, search for wc_am_client_{product_id}, so in this example it would be wc_am_client_13.
     *
     * All data here is sent to the WooCommerce API Manager API, except for the $software_title, which is used as a title, and menu label, for
     * the API Key activation form the client will see.
     *
     * ****
     * NOTE
     * ****
     * If $product_id is empty, the customer can manually enter the product_id into a form field on the activation screen.
     *
     * @param string $file Must be __FILE__ from the root plugin file, or theme functions, file locations.
     * @param int $product_id Must match the Product ID number (integer) in the product.
     * @param string $software_version This product's current software version.
     * @param string $plugin_or_theme 'plugin' or 'theme'
     * @param string $api_url The URL to the site that is running the API Manager. Example: https://www.toddlahman.com/
     * @param string $software_title The name, or title, of the product. The title is not sent to the API Manager APIs, but is used for menu titles.
     *
     * Example:
     *
     * $wcam_lib = new WC_AM_Client_24( $file, $product_id, $software_version, $plugin_or_theme, $api_url, $software_title );
     */

//     Example of empty string product_id.
    $wcam_lib = new WC_AM_Client_24( __FILE__, '', '3.0.20', 'plugin', 'https://wptypek.com/', 'WPTypek performance' );
}

add_action( 'plugins_loaded', 'wptypek_update_settings' );

function wptypek_update_settings() {
    clear_exclude_options_if_not_original_values(); // ## <plugin_mod@mirek> ##

    $wptypek_options = get_option( 'wptypek_options' );

    if ( isset( $wptypek_options['pro_bottom_js'] ) ) {
        Helper::updateNewSettings();
    }
}

// ## <plugin_mod@mirek> ##
function clear_exclude_options_if_not_original_values() {
    $params = Plugin::getPluginParams();

    foreach ( [ 'excludeCss', 'excludeCssComponents', 'excludeJs', 'excludeJsComponents' ] as $keyToCheck ) {
        $options = $params->get( $keyToCheck );
        if ( is_array( $options ) ) {
            $optionKeys = array_keys( $options );

            if ( !empty($optionKeys[0]) && isset( $options[ $optionKeys[0] ]['do_exclude'] ) ) {
                $params->remove( $keyToCheck );
            }
        }
    }

    Plugin::saveSettings( $params );
}

##</procode>##

// ## <plugin_mod@mirek> ##
function create_mu_file() {
    $mu_plugin_file_source_path = WPTYPEK_PLUGIN_DIR . 'mu-plugins/wptypek-mu-plugin.php';
    $mu_plugins                 = get_mu_plugins();

    $mu_plugin_file = 'wptypek-mu-plugin.php';
    if ( defined( 'WPMU_PLUGIN_DIR' ) ) {
        $mu_plugins_path = WPMU_PLUGIN_DIR;
    } else {
        $mu_plugins_path = WP_CONTENT_DIR . '/' . 'mu-plugins';
    }

    $mu_plugin_file_path = $mu_plugins_path . '/wptypek-mu-plugin.php';

    // add mu file
    if ( file_exists( $mu_plugins_path ) && ! array_key_exists( $mu_plugin_file, $mu_plugins ) ) {
        copy( $mu_plugin_file_source_path, $mu_plugin_file_path );
    } else {
        // create mu-plugins folder
        if ( ! file_exists( $mu_plugins_path ) ) {
            $create_mu_folder = mkdir( $mu_plugins_path, 0755, true );
            if ( $create_mu_folder ) {
                copy( $mu_plugin_file_source_path, $mu_plugin_file_path );
            }
        }
    }
}

add_action( 'admin_init', 'create_mu_file' );

// ## <plugin_mod@mirek> ##
function format_exclude_plugins() {
    $params = Plugin::getPluginParams();

    $excludePluginsFormatted = [];
    foreach ( $params->get( 'excludePlugins', [] ) as $plugin => $rules ) {
        $urlsToExclude = $rules['exclude_urls'];
        //format pages and posts to urls
        foreach ( [ 'exclude_pages', 'exclude_posts' ] as $pageOrPost ) {
            if ( ! empty( $rules[ $pageOrPost ] ) ) {
                foreach ( $rules[ $pageOrPost ] as $ID ) {
                    $urlsToExclude[] = [
                        'rule' => 'c',
                        'url'  => get_permalink( $ID ),
                    ];
                }
            }
        }

        $excludePluginsFormatted[ $plugin ] = [
            'do_exclude'      => 1,
            'exclude_urls'    => $urlsToExclude,
            'reverse_exclude' => $rules['reverse_exclude']
        ];
    }

    $params->set( 'excludePlugins_formatted', $excludePluginsFormatted );

    Plugin::saveSettings( $params );
}

add_action( 'admin_init', 'format_exclude_plugins' );

function clear_cache_after_form_save() {
    if (
        $_SERVER['REQUEST_METHOD'] === 'POST'
        && ! empty( $_POST )
        && ! empty( $_POST['option_page'] )
        && $_POST['option_page'] === 'wptypek_options'
    ) {
        Cache::deleteCache( 'page' );

        return;
    }
}

add_action( 'admin_init', 'clear_cache_after_form_save' );

function clear_currentpage_cache_after_page_update() {
    if (
        $_SERVER['REQUEST_METHOD'] === 'POST'
        && ! empty( $_POST )
        && ! empty( $_POST['action'] )
        && $_POST['action'] === 'editpost'
        && ! empty( $_POST['post_ID'] )
    ) {
        $url        = get_permalink( $_POST['post_ID'] );
        $pidRequest = wp_remote_post( $url, array( 'method' => 'POST', 'body' => array( 'getpid' => 1 ) ) );

        if ( ! empty( $pidRequest['body'] ) ) {
            delete_wptypek_cache( 'currentpage', $pidRequest['body'] );
        }

        return;
    }
}

add_action( 'admin_init', 'clear_currentpage_cache_after_page_update' );

function get_pid_handle() {
    if ( ! empty( $_POST['getpid'] ) && (bool) $_POST['getpid'] ) {
        echo PageCache::getPageCacheId();
        exit;
    }
}

add_action( 'plugins_loaded', 'get_pid_handle' );
