<?php

use WpTypek\Core\Pagecache;

/** ## <plugin_mod@mirek> ## */

/**
 * @param WP_Admin_Bar $wp_admin_bar
 */
add_action( 'admin_bar_menu', 'add_wp_typek_topbar', 100 );
function add_wp_typek_topbar( $wp_admin_bar ) {
    $nodes = array();

    $nodes[] = array(
        'id'     => 'wp_typek_topbar_cleancache_currentpage',
        'title'  => __( 'Clean current page cache', 'wp-typek' ),
        'href'   => admin_url( 'admin.php?page=wp-typek_settings&wptypek-task=cleancache_currentpage&pid=' . Pagecache::getPageCacheId() ),
        'meta'   => array(
            'title' => __( 'Clean current page cache', 'wp-typek' ),
        ),
        'parent' => 'wp_typek_topbar',
    );

    if ( ! empty( $nodes ) ) {
        $wp_admin_bar->add_menu( array(
            'id'     => 'wp_typek_topbar',
            'title'  => __( 'WPTypek Performance', 'wp-typek' ),
            'href'   => admin_url( 'admin.php?page=wp-typek' ),
            'meta'   => array(
                'title' => __( 'Purge cache', 'wp-typek' ),
            ),
            'parent' => false,
        ) );

        foreach ( $nodes as $node ) {
            $wp_admin_bar->add_node( $node );
        }
    }
}
