<?php

namespace WpTypek\Platform;

use WpTypek\Interfaces\SettingsInterface;

defined('_WP_EXEC') or die('Restricted access');

class Settings implements SettingsInterface
{
	private $params;

	/**
	 *
	 * @param   array  $params
	 *
	 * @return Settings
	 */
	public static function getInstance($params)
	{
		return new Settings($params);
	}

	/**
	 *
	 * @param   string  $param
	 * @param   mixed   $default
	 *
	 * @return mixed
	 */
	public function get($param, $default = null)
	{
		if (!isset($this->params[$param]))
		{
			return $default;
		}

		return $this->params[$param];
	}

	/**
	 *
	 * @param   array  $params
	 */
	private function __construct($params)
	{
		$this->params = $params;

		if (!defined('WPTYPEK_DEBUG'))
		{
			define('WPTYPEK_DEBUG', ($this->get('debug', 0)));
		}
	}

	/**
	 *
	 * @param   string  $param
	 * @param   mixed   $value
	 */
	public function set($param, $value)
	{
		$this->params[$param] = $value;
	}

	/**
	 *
	 * @return array
	 */
	public function getOptions()
	{
		return $this->params;
	}

	/**
	 * Delete a value from the settings array
	 *
	 * @param   string  $param  The parameter value to be deleted
	 *
	 * @return   null
	 */
	public function remove($param)
	{
		unset($this->params[$param]);

		return;
	}
}
