<?php

namespace WpTypek\Platform;

defined('_WP_EXEC') or die('Restricted access');

use WpTypek\Core\FileRetriever;
use WpTypek\Core\Logger;
use WpTypek\Core\Exception;
use WpTypek\Interfaces\HtmlInterface;

class Html implements HtmlInterface
{
        protected $params;

        public function __construct($params)
        {
                $this->params = $params;
        }

        /** ## <to_optimise@mirek> ## */
        public function getOriginalHtml()
        {
                WPTYPEK_DEBUG ? Profiler::mark('beforeGetHtml') : null;

                $url = home_url() . '/?wptypek-backend=1';

                try
                {
                        $oFileRetriever = FileRetriever::getInstance();

                        $response = $oFileRetriever->getFileContents($url);

                        if ($oFileRetriever->response_code != 200)
                        {
                                throw new Exception(
                                Utility::translate('Failed fetching front end HTML with response code ' . $oFileRetriever->response_code)
                                );
                        }

                        WPTYPEK_DEBUG ? Profiler::mark('afterGetHtml') : null;

                        return $response;
                }
                catch (Exception $e)
                {
                        Logger::log($url . ': ' . $e->getMessage(), $this->params);

                        WPTYPEK_DEBUG ? Profiler::mark('afterGetHtml)') : null;

                        throw new \RunTimeException(_('Load or refresh the front-end site first then refresh this page '
                                . 'to populate the multi select exclude lists.'));
                }
        }
}

