<?php

/* ##<plugin_mod_start@mirek>## */

use WpTypek\Core\Ajax;
use WpTypek\Core\Admin;
use WpTypek\Core\Helper;
use WpTypek\Core\Logger;
use WpTypek\Core\WPTypekAssetsManager;
use WpTypek\Platform\Cache;
use WpTypek\Platform\Settings;
use WpTypek\Platform\Html;
use WpTypek\Platform\Plugin;


$menuOptions = [
    'css'                => [
        'label' => __( 'CSS', 'wp-typek' ),
        'slug'  => 'wp-typek_css',
    ],
    'js'                 => [
        'label' => __( 'JS', 'wp-typek' ),
        'slug'  => 'wp-typek_js',
    ],
    'html'               => [
        'label' => __( 'HTML', 'wp-typek' ),
        'slug'  => 'wp-typek_html',
    ],
    'plugin_manager'     => [
        'label' => __( 'Plugin manager', 'wp-typek' ),
        'slug'  => 'wp-typek_plugin_manager',
    ],
    'javascript_manager' => [
        'label' => __( 'Javascript manager', 'wp-typek' ),
        'slug'  => 'wp-typek_javascript_manager',
    ],
    'database'           => [
        'label' => __( 'Database', 'wp-typek' ),
        'slug'  => 'wp-typek_database',
    ],
    'cache'              => [
        'label' => __( 'Cache', 'wp-typek' ),
        'slug'  => 'wp-typek_cache',
    ],
    'image'              => [
        'label' => __( 'Image', 'wp-typek' ),
        'slug'  => 'wp-typek_image',
    ],
    'settings'           => [
        'label' => __( 'Settings', 'wp-typek' ),
        'slug'  => 'wp-typek_settings',
    ],
];

if ( get_transient( 'wptypek_notices' ) ) {
    add_action( 'admin_notices', 'wptypek_send_notices' );
}

add_action( 'admin_menu', 'add_wp_typek_menu' );
function add_wp_typek_menu() {
    add_action( 'admin_enqueue_scripts', 'wptypek_load_resource_files' );
    add_action( 'admin_head', 'wptypek_load_scripts' );

    global $menuOptions;
    add_menu_page( 'WPTypek Performance', 'WPTypek Performance', 'manage_options', 'wp-typek', 'wptypek_options_page' );
    foreach ( $menuOptions as $key => $menuOption ) {
        add_submenu_page( 'wp-typek', $menuOption['label'], $menuOption['label'], 'manage_options', $menuOption['slug'], 'wptypek_options_page' );
    }
//    add_submenu_page(null, 'wptypek-save-options', 'wptypek-save-options', 'manage_options', 'wptypek-save-options', 'wptypek_handle_form_save');
}


function wptypek_options_page() {
    if ( version_compare( PHP_VERSION, '5.3.0', '<' ) ) {
        ?>

        <div class="notice notice-error">
            <p> <?php _e( 'This plugin requires PHP 5.3.0 or greater to run. Your installed version is: ' . PHP_VERSION, 'wp-typek' ) ?></p>
        </div>
        <?php

    }

    ?>
    <div class="full-screen-settings-page">

        <nav class="flex items-center justify-between flex-wrap bg-blue-500 p-4 mb-6 rounded">
            <div class="flex items-center flex-shrink-0 text-white mr-6 my-2">
                <span class="font-semibold text-xl tracking-tight">WPTypek Performance Settings</span>
            </div>
            <div>
                <?php
                global $menuOptions;

                $page = $_GET['page'];
                $saveFormUrl = admin_url('admin.php?page=' . $page);

                foreach ( $menuOptions as $menuOption ) {
                    $isActive = ( $_GET['page'] === $menuOption['slug'] ? 'class="active"' : '' );
                    $class    = "inline-block text-sm px-4 py-2 mr-2 leading-none border rounded text-white border-white hover:border-transparent hover:text-blue-500 hover:bg-white mt-4 lg:mt-0";
                    if ( $isActive ) {
                        $class .= ' bg-white text-blue-500';
                    }
                    echo "<a href=\"admin.php?page={$menuOption['slug']}\" class=\"{$class}\">{$menuOption['label']}</a>";
                }
                ?>
            </div>
        </nav>
    </div>

    <?php /* ##<plugin_mod@mirek>## */ ?>
    <form action="<?= $saveFormUrl ?>" method="POST" class="wptypek-settings-form">
        <?php
        $subscribe_url = 'https://www.wp-typek.net/subscribe/levels.html/#wordpress';
        /* ##<freecode>##
          ?>
          <a class="right button button-secondary" href="<?php echo $subscribe_url; ?>" target="_blank"><?php _e('Upgrade to Pro', 'wp-typek'); ?></a>

          <?php
          ##<freecode>## */

        ?>
        <!-- Nav tabs -->
        <ul class="nav nav-tabs">
            <?php
            if ( version_compare( PHP_VERSION, '5.3.0', '>=' ) ) {

            }

            ?>
        </ul>

        <!-- Tab panes -->
        <div class="wptypek-container">
            <div id="extension-container" class="bg-white shadow-sm rounded p-4 mb-4 text-gray-700 left-admin-panel">
                <!--                <input name="Submit" type="submit" class="btn button-primary w-full" value="--><?php //esc_attr_e( 'Save Changes', 'wp-typek' ); ?><!--"/>-->

                <?php if ( $_GET['page'] == 'wp-typek' ): ?>
                    <script>
                        jQuery(document).ready(function () {
                            window.location.href = 'admin.php?page=wp-typek_settings';
                        })
                    </script>
                <?php else: ?>
                    <?php wptypek_do_settings_sections( 'wptypek-sections' ); ?>
                <?php endif; ?>

                <br/>
                <?php if ( $_GET['page'] !== 'wp-typek' ): ?>
                    <input name="Submit" type="submit" class="btn btn-success w-full" value="<?php esc_attr_e( 'Save Changes', 'wp-typek' ); ?>"/>
                <?php endif; ?>
            </div>

            <div class="bg-white shadow-sm rounded p-4 mb-4 text-gray-700 right-admin-panel">
                <h2>WPTypek</h2>

                <?php if ( $_GET['page'] === 'wp-typek_css' ): ?>
                    <h3>CSS</h3>
                    <p>
                        <?= __ ('This section is responsible for managing <strong>CSS</strong> code. Here you can reduce your CSS code. If you have any problems with minified CSS code use: “Exclude CSS files and Styles” to exclude some files/class from reducing. You can combine CSS code here to reduce blank spaces in your code. Your code can be lighter and faster after configurating your CSS code here.', 'wp-typek') ?>
                    </p>
                <?php elseif ( $_GET['page'] === 'wp-typek_js' ): ?>
                    <h3>JS</h3>
                    <p>
                        <?= __ ('This section is responsible for managing <strong>JavaScript</strong> code. Here you can reduce your JavaScript code. If you have any problems with minified JavaScript code use: “Exclude javascript files and scripts” to exclude some files/class from reducing. You can combine JavaScript code here to reduce blank spaces in your code. Your code can be lighter and faster after configurating your JavaScript code here.', 'wp-typek') ?>
                    </p>
                <?php elseif ( $_GET['page'] === 'wp-typek_html' ): ?>
                    <h3>HTML</h3>
                    <p>
                        <?= __ ('This section is responsible for managing <strong>HTML</strong> code. Here you can reduce your HTML code. You can enable minify HTML to reduce unused code. Remember to set HTML Minification Level. If it is higher, it will remove more unused codes. Here you can also enable the GZIP compression and http2 push and much more!', 'wp-typek') ?>
                    </p>
                <?php elseif ( $_GET['page'] === 'wp-typek_plugin_manager' ): ?>
                    <h3>Plugin manager</h3>
                    <p>
                        <?= __ ('If you have plugins, which are uploading their scripts to your subpages you can disable this here. For example, if you have the plugin, which is responsible for contact form, but you have only contact form on one subpage, you can disable this plugin from other subpages. You can also set that scripts from this plugin will be uploading only on contact subpage. This can help with making your website faster.', 'wp-typek') ?>
                    </p>
                <?php elseif ( $_GET['page'] === 'wp-typek_javascript_manager' ): ?>
                    <h3>Javascript manager</h3>
                    <p>
                        <?= __ ('Here you can add some rules, which can remove scripts from some pages, posts or URLs. If you have any script, which is unused by you, you can disable it here.', 'wp-typek') ?>
                    </p>
                <?php elseif ( $_GET['page'] === 'wp-typek_database' ): ?>
                    <h3>Database</h3>
                    <p>
                        <?= __ ('A lot of plugins and themes are using database to save some important settings, but what if you don’t need this plugin anymore, and you want to uninstall it. Not every plugins are cleaning the database when you want to uninstall it, but here you can delete some database tables which are unused. Here you can also clean thing like post versions, trashed posts, auto-draft posts or unapproved comments and much more!', 'wp-typek') ?>
                    </p>
                <?php elseif ( $_GET['page'] === 'wp-typek_cache' ): ?>
                    <h3>Cache</h3>
                    <p>
                        <?= __ ('Here you can enable cache in your website. You can set a lifetime here, after which all files will be removed and re-generated. If you have some subpages that cannot be cached you can use the option: “Exclude URLs from cache” or “Exclude these urls from any caching” to exclude this subpage with any variation of caching. For example, you have a ”my account page” and it has a subpage example.com/my-account/orders, so you can set that my account will be excluded from any caching and subpage orders will be excluded too.', 'wp-typek') ?>
                    </p>
                <?php elseif ( $_GET['page'] === 'wp-typek_image' ): ?>
                    <h3>Image</h3>
                    <p>
                        <?= __ ('Here you can enable the lazy load for images and iframes. If you have for example photos or videos from YouTube you can enable the lazy load for them here. It can help your website with speed, but if you have some photos, which are on first view you can exclude it in: “Exclude these images from lazy load”. Iframes can be disabled here: “Exclude these classes”. If you use effects on photos in your website remember to enable effects on this page. Autosize images can help if you have some problems.” Remove image attributes” will remove some information from photos like author, date, and more.', 'wp-typek') ?>
                    </p>
                <?php elseif ( $_GET['page'] === 'wp-typek_settings' ): ?>
                    <h3>Settings</h3>
                    <p>
                        <?= __ ('Here you can set some things which involve your website or this plugin. Here you can set predefined automatic settings, which are prepacked or pre-configured settings. You don’t have to do everything by yourself. Here you can also enable the CDN or set the admin options like plugin to be disabled for logged-in Users or Debugging plugin.', 'wp-typek') ?>
                    </p>
                <?php endif; ?>
            </div>
        </div>

        <?php /* ##<plugin_mod_end@mirek>## */ ?>

        <?php settings_fields( 'wptypek_options' ); ?>
        <?php

        $options = get_option( 'wptypek_options' );

        ?>
        <input type="hidden" id="wptypek_options_hidden_containsgf" name="wptypek_options[hidden_containsgf]"
               value="<?php echo ! empty( $options['hidden_containsgf'] ) ? $options['hidden_containsgf'] : ''; ?>">
        <input type="hidden" id="wptypek_options_hidden_api_secret" name="wptypek_options[hidden_api_secret]"
               value="11e603aa">
    </form>
    <?php
}

add_action( 'admin_init', 'wptypek_initialize_settings' );

function wptypek_initialize_settings() {
    register_setting( 'wptypek_options', 'wptypek_options', 'wptypek_options_validate' );

//    wp_register_style('wptypek-bootstrap-css', WPTYPEK_PLUGIN_URL . 'media/css/bootstrap/bootstrap.css', array(), WPTYPEK_VERSION);
    wp_register_style( 'wptypek-admin-css', WPTYPEK_PLUGIN_URL . 'media/css/admin.css', array(), WPTYPEK_VERSION );
    wp_register_style( 'wptypek-fonts-css', '//netdna.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.css' );
    wp_register_style( 'wptypek-chosen-css', WPTYPEK_PLUGIN_URL . 'media/css/chosen/jquery.chosen.min.css', array(), WPTYPEK_VERSION );
    wp_register_style( 'wptypek-wordpress-css', WPTYPEK_PLUGIN_URL . 'media/css/wordpress.css', array(), WPTYPEK_VERSION );
    wp_register_style( 'wptypek-tailwind-css', WPTYPEK_PLUGIN_URL . 'media/css/tailwind/dist/styles.css', array(), WPTYPEK_VERSION );

//    wp_register_script('wptypek-bootstrap-js', WPTYPEK_PLUGIN_URL . 'media/js/bootstrap/bootstrap.min.js', array('jquery'), WPTYPEK_VERSION, true);
    wp_register_script( 'wptypek-wordpress-js', WPTYPEK_PLUGIN_URL . 'media/js/wordpress.js', array( 'jquery' ), WPTYPEK_VERSION, true );
    wp_register_script( 'wptypek-tabsstate-js', WPTYPEK_PLUGIN_URL . 'media/js/bootstrap/tabs-state.js', array( 'jquery' ), WPTYPEK_VERSION, true );
    wp_register_script( 'wptypek-adminutility-js', WPTYPEK_PLUGIN_URL . 'media/js/admin-utility.js', array( 'jquery' ), WPTYPEK_VERSION, true );
    wp_register_script( 'wptypek-chosen-js', WPTYPEK_PLUGIN_URL . 'media/js/chosen/jquery.chosen.min.js', array( 'jquery' ), WPTYPEK_VERSION, true );
    wp_register_script( 'wptypek-collapsible-js', WPTYPEK_PLUGIN_URL . 'media/js/jquery.collapsible.js', array( 'jquery' ), WPTYPEK_VERSION, true );

    /* ##<plugin_mod_end@mirek>## */

    ##<procode>##
    wp_register_style( 'wptypek-progressbar-css', WPTYPEK_PLUGIN_URL . 'media/css/pro-jquery-ui-progressbar.css', array(), WPTYPEK_VERSION );
    wp_register_style( 'wptypek-filetree-css', WPTYPEK_PLUGIN_URL . 'media/css/pro-jquery.filetree.css', array(), WPTYPEK_VERSION );

    wp_register_script( 'wptypek-filetree-js', WPTYPEK_PLUGIN_URL . 'media/js/pro-jquery.filetree.js', array( 'jquery' ), WPTYPEK_VERSION, true );
    wp_register_script( 'wptypek-proadminutility-js', WPTYPEK_PLUGIN_URL . 'media/js/pro-admin-utility.js', array( 'jquery' ), WPTYPEK_VERSION, true );
    ##</procode>##

    if ( version_compare( PHP_VERSION, '5.3.0', '<' ) ) {
        return;
    }

    global $wptypek_redirect;
    $wptypek_redirect = false;

    check_wptypek_tasks();
    wptypek_get_cache_info();
    wptypek_redirect();

    /* ##<plugin_mod_start@mirek>## */

    if (! empty( $_GET['page'] ) && strpos($_GET['page'], 'wp-typek') !== false) {
        wptypek_get_admin_object();
    }

    //CSS
    add_settings_section( 'wp-typek_css', __( 'CSS', 'wp-typek' ), '', 'wptypek-sections' );

    if ( ! empty( $_GET['page'] ) && $_GET['page'] === 'wp-typek_css' ) {
        add_section_separator( __( 'Basic CSS options', 'wp-typek' ), 'wp-typek_css' );
        add_settings_field( 'wptypek_options_css', __( 'Combine CSS Files', 'wp-typek' ), 'wptypek_options_css_string', 'wptypek-sections', 'wp-typek_css' );
        add_settings_field( 'wptypek_options_css_minify', __( 'Minify Combined CSS File', 'wp-typek' ), 'wptypek_options_css_minify_string', 'wptypek-sections', 'wp-typek_css' );
        add_settings_field( 'wptypek_options_inlineStyle', __( 'Include inline CSS styles', 'wp-typek' ), 'wptypek_options_inlineStyle_string', 'wptypek-sections', 'wp-typek_css' );
        add_settings_field( 'wptypek_options_replaceImports', __( 'Replace <span class="notranslate">@imports</span> in CSS', 'wp-typek' ), 'wptypek_options_replaceImports_string', 'wptypek-sections', 'wp-typek_css' );
        add_section_separator_end( __( 'Basic CSS options', 'wp-typek' ), 'wp-typek_css' );

        add_section_separator( __( 'Optimize CSS delivery', 'wp-typek' ), 'wp-typek_css' );
        add_settings_field( 'wptypek_options_optimizeCssDelivery_enable', __( 'Enable optimized css delivery', 'wp-typek' ), 'wptypek_options_optimizeCssDelivery_enable_string', 'wptypek-sections', 'wp-typek_css' );
        add_toggling_section( 'optimizeCssDelivery_enable', 'wp-typek_css' );
        add_settings_field( 'wptypek_options_optimizeCssDelivery', __( 'Number optimized css delivery of Elements', 'wp-typek' ), 'wptypek_options_optimizeCssDelivery_string', 'wptypek-sections', 'wp-typek_css' );
        add_settings_field( 'wptypek_options_pro_remove_unused_css', __( 'Remove unused CSS', 'wp-typek' ), 'wptypek_options_pro_remove_unused_css_string', 'wptypek-sections', 'wp-typek_css' );
        add_settings_field( 'wptypek_options_pro_dynamic_selectors', __( 'Dynamic Selectors', 'wp-typek' ), 'wptypek_options_pro_dynamic_selectors_string', 'wptypek-sections', 'wp-typek_css' );
        add_settings_field( 'wptypek_options_pro_load_css_on_scroll', __( 'Load CSS on scroll', 'wp-typek' ), 'wptypek_options_pro_load_css_on_scroll_string', 'wptypek-sections', 'wp-typek_css' );
        add_toggling_section_end( 'optimizeCssDelivery_enable', 'wp-typek_css' );
        add_section_separator_end( __( 'Optimize CSS delivery', 'wp-typek' ), 'wp-typek_css' );

        add_section_separator( __( 'Exclude CSS files and Styles', 'wp-typek' ), 'wp-typek_css' );
        add_settings_field( 'wptypek_options_excludeCss', __( 'Exclude these CSS files', 'wp-typek' ), 'wptypek_options_excludeCss_string', 'wptypek-sections', 'wp-typek_css' );
        add_settings_field( 'wptypek_options_excludeCssComponents', __( 'Exclude CSS files from these plugins', 'wp-typek' ), 'wptypek_options_excludeCssComponents_string', 'wptypek-sections', 'wp-typek_css' );
        add_settings_field( 'wptypek_options_excludeStyles', __( 'Exclude individual internal STYLE declarations', 'wp-typek' ), 'wptypek_options_excludeStyles_string', 'wptypek-sections', 'wp-typek_css' );
        add_settings_field( 'wptypek_options_excludeAllStyles', __( 'Exclude all STYLE declarations', 'wp-typek' ), 'wptypek_options_excludeAllStyles_string', 'wptypek-sections', 'wp-typek_css' );
        add_settings_field( 'wptypek_options_includeAllExtensions_css', __( 'Include files from all plugins', 'wp-typek' ), 'wptypek_options_includeAllExtensions_css_string', 'wptypek-sections', 'wp-typek_css' );
        add_settings_field( 'wptypek_options_phpAndExternal_css', __( 'Include PHP files and files from external domains', 'wp-typek' ), 'wptypek_options_phpAndExternal_css_string', 'wptypek-sections', 'wp-typek_css' );
        add_section_separator_end( __( 'Exclude CSS files and Styles', 'wp-typek' ), 'wp-typek_css' );
    }

    //JS
    add_settings_section( 'wp-typek_js', __( 'JS', 'wp-typek' ), '', 'wptypek-sections' );

    if ( ! empty( $_GET['page'] ) && $_GET['page'] === 'wp-typek_js' ) {
        add_section_separator( __( 'Basic JS options', 'wp-typek' ), 'wp-typek_js' );
        add_settings_field( 'wptypek_options_javascript', __( 'Combine Javascript Files', 'wp-typek' ), 'wptypek_options_javascript_string', 'wptypek-sections', 'wp-typek_js' );
        add_settings_field( 'wptypek_options_js_minify', __( 'Minify Combined Javascript File', 'wp-typek' ), 'wptypek_options_js_minify_string', 'wptypek-sections', 'wp-typek_js' );
        add_settings_field( 'wptypek_options_inlineScripts', __( 'Include inline scripts', 'wp-typek' ), 'wptypek_options_inlineScripts_string', 'wptypek-sections', 'wp-typek_js' );
        add_settings_field( 'wptypek_options_loadAsynchronous', __( 'Load combined javascript asynchronously', 'wp-typek' ), 'wptypek_options_loadAsynchronous_string', 'wptypek-sections', 'wp-typek_js' );
        add_settings_field( 'wptypek_options_try_catch', __( 'Use <span class="notranslate">try-catch</span>', 'wp-typek' ), 'wptypek_options_try_catch_string', 'wptypek-sections', 'wp-typek_js' );
        add_settings_field( 'wptypek_options_bottom_js', __( 'Position javascript file at bottom', 'wp-typek' ), 'wptypek_options_bottom_js_string', 'wptypek-sections', 'wp-typek_js' );
        add_settings_field( 'wptypek_options_dontmoveJs', __( 'Javascript files exclude from move to bottom' ), 'wptypek_options_dontmoveJs_string', 'wptypek-sections', 'wp-typek_js' );
        add_settings_field( 'wptypek_options_dontmoveScripts', 'Inline scripts exclude from move to bottom', 'wptypek_options_dontmoveScripts_string', 'wptypek-sections', 'wp-typek_js' );
        add_section_separator_end( __( 'Basic JS options', 'wp-typek' ), 'wp-typek_js' );

        add_section_separator( __( 'Exclude javascript files and scripts', 'wp-typek' ), 'wp-typek_js' );
        add_settings_field( 'wptypek_options_excludeJs', __( 'Exclude these javascript files', 'wp-typek' ), 'wptypek_options_excludeJs_string', 'wptypek-sections', 'wp-typek_js' );
        add_settings_field( 'wptypek_options_excludeJsComponents', __( 'Exclude javascript files from these plugins', 'wp-typek' ), 'wptypek_options_excludeJsComponents_string', 'wptypek-sections', 'wp-typek_js' );
        add_settings_field( 'wptypek_options_excludeAllScripts', __( 'Exclude all SCRIPT declarations', 'wp-typek' ), 'wptypek_options_excludeAllScripts_string', 'wptypek-sections', 'wp-typek_js' );
        add_settings_field( 'wptypek_options_excludeScripts', __( 'Exclude individual internal SCRIPT declarations', 'wp-typek' ), 'wptypek_options_excludeScripts_string', 'wptypek-sections', 'wp-typek_js' );
        add_settings_field( 'wptypek_options_remove_js', __( 'Remove javascript', 'wp-typek' ), 'wptypek_options_remove_js_string', 'wptypek-sections', 'wp-typek_js' );
        add_settings_field( 'wptypek_options_includeAllExtensions_js', __( 'Include files from all plugins', 'wp-typek' ), 'wptypek_options_includeAllExtensions_js_string', 'wptypek-sections', 'wp-typek_js' );
        add_settings_field( 'wptypek_options_phpAndExternal_js', __( 'Include PHP files and files from external domains', 'wp-typek' ), 'wptypek_options_phpAndExternal_js_string', 'wptypek-sections', 'wp-typek_js' );
        add_section_separator_end( __( 'Exclude javascript files and scripts', 'wp-typek' ), 'wp-typek_js' );

//            add_section_separator( __( 'Exclude javascript files and scripts (with exec order kept?)', 'wp-typek' ), 'wp-typek_js' );
//            add_settings_field( 'wptypek_options_excludeJs_peo', __( 'Exclude these javascript files', 'wp-typek' ), 'wptypek_options_excludeJs_peo_string', 'wptypek-sections', 'wp-typek_js' );
//            add_settings_field( 'wptypek_options_excludeJsComponents_peo', __( 'Exclude javascript files from these plugins', 'wp-typek' ), 'wptypek_options_excludeJsComponents_peo_string', 'wptypek-sections', 'wp-typek_js' );
//            add_settings_field( 'wptypek_options_excludeScripts_peo', __( 'Exclude individual internal SCRIPT declarations', 'wp-typek' ), 'wptypek_options_excludeScripts_peo_string', 'wptypek-sections', 'wp-typek_js' );
    }

    //HTML
    add_settings_section( 'wp-typek_html', __( 'HTML', 'wp-typek' ), '', 'wptypek-sections' );

    if ( ! empty( $_GET['page'] ) && $_GET['page'] === 'wp-typek_html' ) {
        add_section_separator( __( 'Basic HTML options', 'wp-typek' ), 'wp-typek_html' );
        add_settings_field( 'wptypek_options_html_minify', __( 'Minify HTML', 'wp-typek' ), 'wptypek_options_html_minify_string', 'wptypek-sections', 'wp-typek_html' );
        add_settings_field( 'wptypek_options_html_minify_level', __( 'HTML Minification Level', 'wp-typek' ), 'wptypek_options_html_minify_level_string', 'wptypek-sections', 'wp-typek_html' );
        add_settings_field( 'wptypek_options_pro_reduce_dom', __( 'Enable reduce DOM', 'wp-typek' ), 'wptypek_options_pro_reduce_dom_string', 'wptypek-sections', 'wp-typek_html' );
        add_settings_field( 'wptypek_options_order_plugin', __( 'Order plugin', 'wp-typek' ), 'wptypek_options_order_plugin_string', 'wptypek-sections', 'wp-typek_html' );
        add_section_separator_end( __( 'Basic HTML options', 'wp-typek' ), 'wp-typek_html' );

        add_section_separator( __( 'Assets compression', 'wp-typek' ), 'wp-typek_html' );
        add_settings_field( 'wptypek_options_gzip', __( 'Gzip Combined Files', 'wp-typek' ), 'wptypek_options_gzip_string', 'wptypek-sections', 'wp-typek_html' );
        add_settings_field( 'wptypek_options_pro_http2_push_enable', __( 'Enable http2 push', 'wp-typek' ), 'wptypek_options_pro_http2_push_enable_string', 'wptypek-sections', 'wp-typek_html' );
        add_settings_field( 'wptypek_options_pro_http2_file_types', __( 'File types for http2', 'wp-typek' ), 'wptypek_options_pro_http2_file_types_string', 'wptypek-sections', 'wp-typek_html' );
        add_settings_field( 'wptypek_options_pro_http2_exclude_deferred', __( 'Exclude deferred files for http2', 'wp-typek' ), 'wptypek_options_pro_http2_exclude_deferred_string', 'wptypek-sections', 'wp-typek_html' );
        add_section_separator_end( __( 'Assets compression', 'wp-typek' ), 'wp-typek_html' );

        add_section_separator( __( 'Assets combining', 'wp-typek' ), 'wp-typek_html' );
        add_settings_field( 'wptypek_options_combine_files_enable', __( 'Enable files combine', 'wp-typek' ), 'wptypek_options_combine_files_enable_string', 'wptypek-sections', 'wp-typek_html' );
        add_settings_field( 'wptypek_options_htaccess', __( 'Combine files delivery', 'wp-typek' ), 'wptypek_options_htaccess_string', 'wptypek-sections', 'wp-typek_html' );
        add_section_separator_end( __( 'Assets combining', 'wp-typek' ), 'wp-typek_html' );
    }

    //Plugin manager
    add_settings_section( 'wp-typek_plugin_manager', __( 'Plugin manager', 'wp-typek' ), '', 'wptypek-sections' );

    if ( ! empty( $_GET['page'] ) && $_GET['page'] === 'wp-typek_plugin_manager' ) {
        add_section_separator( __( 'Exclude plugins', 'wp-typek' ), 'wp-typek_plugin_manager' );
        add_settings_field( 'wptypek_options_exclude_plugins', '', 'wptypek_options_excludePlugins_string', 'wptypek-sections', 'wp-typek_plugin_manager' );
        add_section_separator_end( __( 'Exclude plugins', 'wp-typek' ), 'wp-typek_plugin_manager' );
    }

    //Javascript manager
    add_settings_section( 'wp-typek_javascript_manager', __( 'Javascript manager', 'wp-typek' ), '', 'wptypek-sections' );

    if ( ! empty( $_GET['page'] ) && $_GET['page'] === 'wp-typek_javascript_manager' ) {
        add_section_separator( __( 'Remove javascript', 'wp-typek' ), 'wp-typek_javascript_manager' );
        add_settings_field( 'wptypek_options_remove_javascript_rules', '', 'wptypek_options_remove_javascript_rules_string', 'wptypek-sections', 'wp-typek_javascript_manager' );
        add_section_separator_end( __( 'Remove javascript', 'wp-typek' ), 'wp-typek_javascript_manager' );
    }

    //Database
    add_settings_section( 'wp-typek_database', __( 'Database', 'wp-typek' ), '', 'wptypek-sections' );

    if ( ! empty( $_GET['page'] ) && $_GET['page'] === 'wp-typek_database' ) {
        add_section_separator( __( 'Database optimizations', 'wp-typek' ), 'wp-typek_database' );
        add_action_button( __( 'Optimize database tables', 'wp-typek' ), 'optimize_database_tables', 'wp-typek_database' );
        add_action_button( __( 'Clean all post revisions', 'wp-typek' ), 'clean-all-post-revisions', 'wp-typek_database' );
        add_action_button( __( 'Clean all auto-draft posts', 'wp-typek' ), 'clean-all-auto-draft-posts', 'wp-typek_database' );
        add_action_button( __( 'Clean all trashed posts', 'wp-typek' ), 'clean-all-trashed-posts', 'wp-typek_database' );
        add_action_button( __( 'Remove spam and trashed comments', 'wp-typek' ), 'remove-spam-and-trashed-comments', 'wp-typek_database' );
        add_action_button( __( 'Remove unapproved comments', 'wp-typek' ), 'remove-unapproved-comments', 'wp-typek_database' );
        add_action_button( __( 'Remove expired transient options', 'wp-typek' ), 'remove-expired-transient-options', 'wp-typek_database' );
        add_action_button( __( 'Remove all transient options', 'wp-typek' ), 'remove-all-transient-options', 'wp-typek_database' );
        add_action_button( __( 'Remove pingbacks', 'wp-typek' ), 'remove-pingbacks', 'wp-typek_database' );
        add_action_button( __( 'Remove trackbacks', 'wp-typek' ), 'remove-trackbacks', 'wp-typek_database' );
        add_action_button( __( 'Clean post meta data', 'wp-typek' ), 'clean-post-meta-data', 'wp-typek_database' );
        add_action_button( __( 'Clean comment meta data', 'wp-typek' ), 'clean-comment-meta-data', 'wp-typek_database' );
        add_action_button( __( 'Clean orphaned relationship data', 'wp-typek' ), 'clean-orphaned-relationship-data', 'wp-typek_database' );
        add_section_separator_end( __( 'Database optimizations', 'wp-typek' ), 'wp-typek_database' );
    }

    //Cache
    add_settings_section( 'wp-typek_cache', __( 'Cache', 'wp-typek' ), '', 'wptypek-sections' );

    if ( ! empty( $_GET['page'] ) && $_GET['page'] === 'wp-typek_cache' ) {
        add_section_separator( __( 'Basic cache options', 'wp-typek' ), 'wp-typek_cache' );
        add_settings_field( 'wptypek_options_cache_enable', __( 'Enable cache', 'wp-typek' ), 'wptypek_options_cache_enable_string', 'wptypek-sections', 'wp-typek_cache' );
        add_settings_field( 'wptypek_options_cache_lifetime', __( 'Cache lifetime (assets + page)', 'wp-typek' ), 'wptypek_options_cache_lifetime_string', 'wptypek-sections', 'wp-typek_cache' );
        add_settings_field( 'wptypek_options_page_cache_lifetime', __( 'Cache lifetime (page only)', 'wp-typek' ), 'wptypek_options_page_cache_lifetime_string', 'wptypek-sections', 'wp-typek_cache' );
        add_settings_field( 'wptypek_options_cache_exclude', __( 'Exclude urls from cache', 'wp-typek' ), 'wptypek_options_cache_exclude_string', 'wptypek-sections', 'wp-typek_cache' );
        add_settings_field( 'wptypek_options_url_exclude', __( 'Exclude these urls from any caching', 'wp-typek' ), 'wptypek_options_url_exclude_string', 'wptypek-sections', 'wp-typek_cache' );
        add_settings_field( 'wptypek_options_cache_utility_settings', __( 'Cache utility Settings', 'wp-typek' ), 'wptypek_options_cache_utility_settings_string', 'wptypek-sections', 'wp-typek_cache' );
        add_section_separator_end( __( 'Basic cache options', 'wp-typek' ), 'wp-typek_cache' );
    }

    //Image
    add_settings_section( 'wp-typek_image', __( 'Image', 'wp-typek' ), '', 'wptypek-sections' );

    if ( ! empty( $_GET['page'] ) && $_GET['page'] === 'wp-typek_image' ) {
        add_section_separator( __( 'Lazy loading', 'wp-typek' ), 'wp-typek_image' );
        add_settings_field( 'wptypek_options_lazyload_enable', __( 'Enable lazyload', 'wp-typek' ), 'wptypek_options_lazyload_enable_string', 'wptypek-sections', 'wp-typek_image' );
        add_settings_field( 'wptypek_options_pro_lazyload_iframe', __( 'Lazy load iframes', 'wp-typek' ), 'wptypek_options_pro_lazyload_iframe_string', 'wptypek-sections', 'wp-typek_image' );
        add_settings_field( 'wptypek_options_excludeLazyLoad', __( 'Exclude these images from lazyload', 'wp-typek' ), 'wptypek_options_excludeLazyLoad_string', 'wptypek-sections', 'wp-typek_image' );
        add_settings_field( 'wptypek_options_pro_excludeLazyLoadFolder', __( 'Exclude these folders', 'wp-typek' ), 'wptypek_options_pro_excludeLazyLoadFolder_string', 'wptypek-sections', 'wp-typek_image' );
        add_settings_field( 'wptypek_options_pro_excludeLazyLoadClass', __( 'Exclude these classes', 'wp-typek' ), 'wptypek_options_pro_excludeLazyLoadClass_string', 'wptypek-sections', 'wp-typek_image' );
        add_settings_field( 'wptypek_options_pro_lazyload_effects', __( 'Enable effects', 'wp-typek' ), 'wptypek_options_pro_lazyload_effects_string', 'wptypek-sections', 'wp-typek_image' );
        add_settings_field( 'wptypek_options_lazyload_autosize', __( 'Autosize images', 'wp-typek' ), 'wptypek_options_lazyload_autosize_string', 'wptypek-sections', 'wp-typek_image' );
        add_section_separator_end( __( 'Lazy loading', 'wp-typek' ), 'wp-typek_image' );

        add_section_separator( __( 'Other options', 'wp-typek' ), 'wp-typek_image' );
        add_settings_field( 'wptypek_img_attributes_enable', __( 'Remove image attributes', 'wp-typek' ), 'wptypek_options_img_attributes_enable_string', 'wptypek-sections', 'wp-typek_image' );
        add_section_separator_end( __( 'Other options', 'wp-typek' ), 'wp-typek_image' );
    }

    //SETTINGS
    add_settings_section( 'wp-typek_settings', __( 'Settings', 'wp-typek' ), '', 'wptypek-sections' );

    if ( ! empty( $_GET['page'] ) && $_GET['page'] === 'wp-typek_settings' ) {
        add_section_separator( __( 'Quick settings', 'wp-typek' ), 'wp-typek_settings' );
        add_settings_field( 'wptypek_options_auto_settings', __( 'Automatic Settings', 'wp-typek' ), 'wptypek_options_auto_settings_string', 'wptypek-sections', 'wp-typek_settings' );
        add_settings_field( 'wptypek_options_utility_settings', __( 'Utility Settings', 'wp-typek' ), 'wptypek_options_utility_settings_string', 'wptypek-sections', 'wp-typek_settings' );
        add_section_separator_end( __( 'Quick settings', 'wp-typek' ), 'wp-typek_settings' );

        add_section_separator( __( 'CDN/Cookieless domain', 'wp-typek' ), 'wp-typek_settings' );
        add_settings_field( 'wptypek_options_cookielessdomain_enable', __( 'Enable cookieless domain', 'wp-typek' ), 'wptypek_options_cookielessdomain_enable_string', 'wptypek-sections', 'wp-typek_settings' );
        add_settings_field( 'wptypek_options_cdn_scheme', __( 'CDN scheme', 'wp-typek' ), 'wptypek_options_cdn_scheme_string', 'wptypek-sections', 'wp-typek_settings' );
        add_settings_field( 'wptypek_options_cookielessdomain', __( 'Domain 1 cookieless', 'wp-typek' ), 'wptypek_options_cookielessdomain_string', 'wptypek-sections', 'wp-typek_settings' );
        add_settings_field( 'wptypek_options_staticfiles', __( 'Static Files 1', 'wp-typek' ), 'wptypek_options_staticfiles_string', 'wptypek-sections', 'wp-typek_settings' );
        add_settings_field( 'wptypek_options_pro_customcdnextensions', __( 'Custom Extensions', 'wp-typek' ), 'wptypek_options_pro_customcdnextensions_string', 'wptypek-sections', 'wp-typek_settings' );
        add_settings_field( 'wptypek_options_pro_cookielessdomain_2', __( 'Domain 2 cookieless', 'wp-typek' ), 'wptypek_options_pro_cookielessdomain_2_string', 'wptypek-sections', 'wp-typek_settings' );
        add_settings_field( 'wptypek_options_pro_staticfiles_2', __( 'Static Files 2', 'wp-typek' ), 'wptypek_options_pro_staticfiles_2_string', 'wptypek-sections', 'wp-typek_settings' );
        add_settings_field( 'wptypek_options_pro_cookielessdomain_3', __( 'Domain 3 cookieless', 'wp-typek' ), 'wptypek_options_pro_cookielessdomain_3_string', 'wptypek-sections', 'wp-typek_settings' );
        add_settings_field( 'wptypek_options_pro_staticfiles_3', __( 'Static Files 3', 'wp-typek' ), 'wptypek_options_pro_staticfiles_3_string', 'wptypek-sections', 'wp-typek_settings' );
        add_section_separator_end( __( 'CDN/Cookieless domain', 'wp-typek' ), 'wp-typek_settings' );

        add_section_separator( __( 'Admin options', 'wp-typek' ), 'wp-typek_settings' );
        add_settings_field( 'wptypek_options_disable_logged_in_users', __( 'Disable logged in Users', 'wp-typek' ), 'wptypek_options_disable_logged_in_users_string', 'wptypek-sections', 'wp-typek_settings' );
        add_settings_field( 'wptypek_options_disable_admin_users', __( 'Disable admin Users', 'wp-typek' ), 'wptypek_options_disable_admin_users_string', 'wptypek-sections', 'wp-typek_settings' );
        add_settings_field( 'wptypek_options_debug', __( 'Debug plugin', 'wp-typek' ), 'wptypek_options_debug_string', 'wptypek-sections', 'wp-typek_settings' );
        add_section_separator_end( __( 'Admin options', 'wp-typek' ), 'wp-typek_settings' );

//    ##<procode>##
//    add_settings_field('wptypek_options_pro_downloadid', __('Download ID', 'wp-typek'), 'wptypek_options_pro_downloadid_string', 'wptypek-sections', 'wp-typek_settings');
//    ##</procode>##
    }
}

function check_wptypek_tasks() {
    if ( isset( $_GET['wptypek-task'] ) ) {
        $databaseOptimizations = new \WpTypek\Core\Database();

        switch ( $_GET['wptypek-task'] ) {
            //CACHE
            case 'cleancache':
                delete_wptypek_cache();
                break;
            case 'cleancache_currentpage':
                delete_wptypek_cache( 'currentpage' );
                break;

            //DATABASE
            case 'optimize_database_tables':
//                $optimization = new WP_Optimization_optimizetables();
//                $optimization->optimize();
                $databaseOptimizations->optimizeTables();
                break;
            case 'clean-all-post-revisions':
                $databaseOptimizations->cleanAllPostRevisions();
                break;
            case 'clean-all-auto-draft-posts':
                $databaseOptimizations->cleanAllAutoDraftPosts();
                break;
            case 'clean-all-trashed-posts':
                $databaseOptimizations->cleanAllTrashedPosts();
                break;
            case 'remove-spam-and-trashed-comments':
                $databaseOptimizations->removeSpamAndTrashedComments();
                break;
            case 'remove-unapproved-comments':
                $databaseOptimizations->removeUnapprovedComments();
                break;
            case 'remove-expired-transient-options':
                $databaseOptimizations->removeExpiredTransientOptions();
                break;
            case 'remove-all-transient-options':
                $databaseOptimizations->removeAllTransientOptions();
                break;
            case 'remove-pingbacks':
                $databaseOptimizations->removePingbacks();
                break;
            case 'remove-trackbacks':
                $databaseOptimizations->removeTrackbacks();
                break;
            case 'clean-post-meta-data':
                $databaseOptimizations->cleanPostMetaData();
                break;
            case 'clean-comment-meta-data':
                $databaseOptimizations->cleanCommentMetaData();
                break;
            case 'clean-orphaned-relationship-data':
                $databaseOptimizations->cleanOrphanedRelationshipData();
                break;


            case 'browsercaching':
                wptypek_leverage_browser_cache();
                break;

            case 'filepermissions':
                wptypek_fix_file_permissions();
                break;

            case 'postresults':
                wptypek_process_optimize_images_results();
                break;

            default:
                break;
        }
    }
}

/* ##<plugin_mod_end@mirek>## */

function wptypek_load_resource_files( $hook ) {
    if ( strpos( $hook, 'wp-typek' ) === false ) {
        return;
    }

    wp_enqueue_style( 'wptypek-tailwind-css' );
//    wp_enqueue_style('wptypek-bootstrap-css');
    wp_enqueue_style( 'wptypek-admin-css' );
    wp_enqueue_style( 'wptypek-fonts-css' );
    wp_enqueue_style( 'wptypek-chosen-css' );
    wp_enqueue_style( 'wptypek-wordpress-css' );

    wp_enqueue_script( 'wptypek-wordpress-js' );
    wp_enqueue_script( 'wptypek-bootstrap-js' );
    wp_enqueue_script( 'wptypek-tabsstate-js' );
    wp_enqueue_script( 'wptypek-adminutility-js' );
    wp_enqueue_script( 'wptypek-chosen-js' );
    wp_enqueue_script( 'wptypek-collapsible-js' );

    ##<procode>##
    wp_enqueue_style( 'wptypek-progressbar-css' );
    wp_enqueue_style( 'wptypek-filetree-css' );

    wp_enqueue_script( 'wptypek-filetree-js' );
    wp_enqueue_script( 'jquery-ui-progressbar' );
    wp_enqueue_script( 'wptypek-proadminutility-js' );
    ##</procode>##
}

function wptypek_load_scripts() {
    ?>
    <style type="text/css">
        .chosen-container-multi .chosen-choices li.search-field input[type=text] {
            height: 25px;
        }

        .chosen-container {
            margin-right: 4px;
        }

    </style>
    <script type="text/javascript">
        function submitWPTypekSettings() {
            jQuery("form.wptypek-settings-form").submit();
        }

        jQuery(document).ready(function () {
            if (!!jQuery.prototype.chosen) {
                jQuery(".chzn-custom-value").chosen({width: "240px"});
            }
            if (!!jQuery.prototype.collapsible) {
                jQuery('.collapsible').collapsible();
            }
        });

        <?php ##<procode>##                                    ?>
        var wptypek_ajax_optimizeimages = ajaxurl + '?action=optimizeimages';
        var wptypek_message = "<?php _e( 'Please open a directory to optimize images', 'wp-typek' ) ?>";
        var wptypek_noproid = "<?php _e( 'Please enter your Download ID on the Pro Options tab.' ) ?>";

        jQuery(document).ready(function () {
            if (!!jQuery.prototype.fileTree) {
                jQuery("#file-tree-container").fileTree(
                    {
                        root: "",
                        script: ajaxurl + '?action=filetree',
                        expandSpeed: 1000,
                        collapseSpeed: 1000,
                        multiFolder: false
                    }, function (file) {
                    });
            }
        });



        <?php ##</procode>##                                 ?>

    </script>
    <?php

}

/** ## <plugin_mod@mirek> ## */
function delete_wptypek_cache( $context = 'both', $pid = null ) {
    global $wptypek_redirect;

    Helper::clearHiddenValues( Plugin::getPluginParams() );

    try {
        if ( $context === 'currentpage' ) {
            $pageCacheId = ! empty( $_GET['pid'] ) ? trim( $_GET['pid'] ) : ( ! empty( $pid ) ? $pid : \WpTypek\Core\Pagecache::getPageCacheId() );
            $pageCache   = Cache::getCache( $pageCacheId, false, true );
            $cssCacheId  = '';
            if ( ! empty( $pageCache ) && preg_match( '/wp\-typek\/css\/(.+)\.css/', $pageCache, $matches ) ) {
                $cssCacheId = $matches[1];
            }

            $result = Cache::deleteCssCacheById( $cssCacheId ) && Cache::deletePagecache( $pageCacheId );
        } else {
            $result = Cache::deleteCache( $context );
        }
    } catch ( \WpTypek\Core\Exception $e ) {
    }

    if ( $result !== false ) {
        wptypek_flash_message( 'success', __( 'The plugin\'s cache files were deleted successfully!', 'wp-typek' ) );
    } else {
        wptypek_flash_message( 'error', __( 'An error occurred while trying to delete the plugin\'s cache files!', 'wp-typek' ) );
    }

    if ( strpos( $_SERVER['HTTP_REFERER'], 'admin.php' ) !== false ) {
        $wptypek_redirect = 'wp-typek_cache';
    } else {
        $wptypek_redirect = null;
        wp_redirect( $_SERVER['HTTP_REFERER'] );
    }
}

function wptypek_leverage_browser_cache() {
    global $wptypek_redirect;

    $expires = Admin::leverageBrowserCaching();

    if ( $expires === false ) {
        wptypek_flash_message( 'error', __( 'The plugin failed to add the \'leverage browser cache\' codes to the .htaccess file.', 'wp-typek' ) );
    } elseif ( $expires == 'FILEDOESNTEXIST' ) {
        wptypek_flash_message( 'warning', __( 'An .htaccess file could not be found in the root folder of the site.', 'wp-typek' ) );
    } elseif ( $expires == 'CODEALREADYINFILE' ) {
        wptypek_flash_message( 'notice', __( 'Codes for \'leverage browser caching\' already exists in the .htaccess file.', 'wp-typek' ) );
    } else {
        wptypek_flash_message( 'success', __( 'Codes for \'leverage browser caching\' were added to the .htaccess file successfully.', 'wp-typek' ) );
    }

    $wptypek_redirect = true;
}

function wptypek_fix_file_permissions() {
    global $wptypek_redirect;

    try {
        $wp_filesystem = Cache::getWpFileSystem();
    } catch ( \WpTypek\Core\Exception $e ) {
        $wp_filesystem = false;
    }

    if ( $wp_filesystem === false ) {
        $result = false;
    } else {
        $result = true;

        try {
            wptypek_chmod( WPTYPEK_PLUGIN_DIR, $wp_filesystem );
        } catch ( Exception $ex ) {
            $result = false;
        }
    }

    if ( $result ) {
        wptypek_flash_message( 'success', __( 'The permissions of all the files and folders in the plugin were successfully updated.', 'wp-typek' ) );
    } else {
        wptypek_flash_message( 'error', __( 'The plugin failed to update the permissions of the files and folders in the plugin.', 'wp-typek' ) );
    }

    $wptypek_redirect = true;
}

function wptypek_chmod( $file, $wp_fs ) {

    /** @var \WP_Filesystem_Base $wp_fs */
    if ( $wp_fs->is_file( $file ) ) {
        $mode = FS_CHMOD_FILE;
    } elseif ( $wp_fs->is_dir( $file ) ) {
        $mode = FS_CHMOD_DIR;
    } else {
        throw new Exception;
    }

    if ( ! ( @chmod( $file, $mode ) ) ) {
        throw new Exception;
    }

    if ( $wp_fs->is_dir( $file ) ) {
        $file     = trailingslashit( $file );
        $filelist = $wp_fs->dirlist( $file );

        foreach ( (array) $filelist as $filename => $filemeta ) {
            wptypek_chmod( $file . $filename, $wp_fs );
        }
    }
}

function wptypek_redirect() {
    global $wptypek_redirect;

    if ( $wptypek_redirect ) {
        if ( $wptypek_redirect === true ) {
            $wptypek_redirect = 'wp-typek_settings';
        }
        $url = admin_url( 'admin.php?page=' . $wptypek_redirect );

        wp_redirect( $url );
        exit;
    }
}

function wptypek_process_optimize_images_results() {
    global $wptypek_redirect;

    if ( file_exists( WPTYPEK_PLUGIN_DIR . 'status.json' ) ) {
        unlink( WPTYPEK_PLUGIN_DIR . 'status.json' );
    }

    $cnt    = filter_input( INPUT_GET, 'cnt', FILTER_SANITIZE_NUMBER_INT );
    $dir    = filter_input( INPUT_GET, 'dir', FILTER_SANITIZE_STRING );
    $status = filter_input( INPUT_GET, 'status', FILTER_SANITIZE_STRING );
    $msg    = filter_input( INPUT_GET, 'msg', FILTER_DEFAULT );

    //$dir = Utility::decrypt($dir);

    if ( $cnt !== false && ! is_null( $cnt ) ) {
        wptypek_flash_message( 'success', sprintf( __( '<span class="notranslate">%1$d</span> images were optimized in <span class="notranslate">%2$s</span>', 'wp-typek' ), $cnt, $dir ) );
    } elseif ( $status !== false && ! is_null( $status ) ) {
        wptypek_flash_message( 'error', sprintf( __( 'Failed to optimize image: <span class="notranslate">%1$s</span>', 'wp-typek' ), $msg ) );
    }

    $wptypek_redirect = true;
}

/** ## <plugin_mod@mirek> ## */
function wptypek_flash_message( $type, $text ) {
    $wptypek_notices = [];

    if ( $notices = get_transient( 'wptypek_notices' ) ) {
        $wptypek_notices = $notices;
    }

    $wptypek_notices[ $type ][] = $text;

    set_transient( 'wptypek_notices', $wptypek_notices, 20 );
}

/** ## <plugin_mod@mirek> ## */
function wptypek_send_notices() {
    $wptypek_notices = get_transient( 'wptypek_notices' );

    foreach ( $wptypek_notices as $type => $notices ) {
        $notices = array_unique( $notices );
        ?>
        <div class="notice notice-<?php echo $type ?>">
            <?php

            foreach ( $notices as $notice ) {

                ?>
                <p> <?php echo $notice ?></p>
                <?php

            }

            ?>
        </div>
        <?php

    }

    delete_transient( 'wptypek_notices' );
}

function wptypek_options_validate( $input ) {
    return $input;
}

function wptypek_group_start( $header = '', $description = '', $class = '' ) {
    echo '<fieldset class="wptypek-group">'
         . ( $header != '' ? '             <legend>' . $header . '</legend>' : '' )
         . '        <div ' . $class . '> <p><em>' . $description . '</em></p></div>'
         . '<div>';
}

function wptypek_group_end() {
    echo '</div></fieldset>';
}

function wptypek_basic_pre_section_text() {
    echo '<div class="tab-pane" id="basic">';

    $header      = __( 'Combine CSS and javascript files', 'wp-typek' );
    $description = __( 'These settings are concerned with combining CSS and javascript files into one respectively, and the minification of the combined files and the HTML, and also determines where in the HTML the combined files are placed. Refer to the documentation for more information..',
        'wp-typek' );

    wptypek_group_start( $header, $description );
}

function wptypek_options_combine_files_enable_string() {
    $description = '';

    echo wptypek_gen_radio_field( 'combine_files_enable', '1', $description );
}

function wptypek_options_auto_settings_string() {
    $description = __( 'The six icons that are above represent six preconfigured settings of the options in the \'Automatic Settings Group\'. The level of optimization increases as you go to the right but the risks of conflicts will also increase, so try each in turn and use the highest setting that work for your site. The first, which is the safest, is the default and should work on most websites. These settings do not affect the files/extensions/images etc. that you have excluded.',
        'wp-typek' );

    $aButton = wptypek_get_auto_settings_buttons();

    echo '<div style="display: inline-block;">';
    echo wptypek_gen_button_icons( $aButton, $description, '</div>', true );
}

function wptypek_options_html_minify_level_string() {
    $description = __( 'If \'Minify HTML\' is enabled, this will determine the level of minification. The incremental changes per level are as follows: Basic - Adjoining whitespaces outside of elements are reduced to one whitespace; Advanced - Remove HTML comments, whitespace around block elements and undisplayed elements, Remove unnecessary whitespaces inside of elements and around their attributes; Ultra - Remove redundant attributes, for example, <span class="notranslate">\'text/javascript\'</span>, and remove quotes from around selected attributes (HTML5)',
        'wp-typek' );

    $values = array(
        '0' => __( 'Basic', 'wp-typek' ),
        '1' => __( 'Advanced', 'wp-typek' ),
        '2' => __( 'Ultra', 'wp-typek' )
    );

    echo wptypek_gen_select_field( 'html_minify_level', '0', $values, $description );
}


function wptypek_options_htaccess_string() {
    $description = __( 'By default the combined files will be loaded as static css and javascript files. You would need to include directives in your .htaccess file to gzip these files. You can use PHP files instead that will be gzipped if that option is set. PHP files can be loaded with a query attached with the information to find the combined files, or you can use url rewrite if it\'s available on the server so the files can be masked as static files. If your server prohibits the use of the Options +FollowSymLinks directive in .htaccess files use the respective option.',
        'wp-typek' );

    $values = array(
        '0' => __( 'PHP file with query', 'wp-typek' ),
        '1' => __( 'PHP using url re-write', 'wp-typek' ),
        '3' => __( 'PHP using url re-write (Without Options +FollowSymLinks)', 'wp-typek' ),
        '2' => __( 'Static css and js files', 'wp-typek' )
    );

    echo wptypek_gen_select_field( 'htaccess', '2', $values, $description, '' );
}

function wptypek_options_try_catch_string() {
    $description = __( 'If you\'re seeing javascript errors in the console, you can try enabling this option to wrap each javascript file in a <span class="notranslate">\'try-catch\'</span> block to prevent the errors from one file affecting the combined file.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'try_catch', '1', $description );
}

function wptypek_basic_misc_section_text() {
    wptypek_group_end();

    $header = __( 'Miscellaneous Settings', 'wp-typek' );

    wptypek_group_start( $header );
}

function wptypek_options_utility_settings_string() {
    $attribute = null;

    $description = '';

    $aButtons = Admin::getUtilityIcons();

    echo '<div style="display: -webkit-flex; display: -ms-flex; display: -moz-flex; display: flex;">';
    echo wptypek_gen_button_icons( $aButtons, $description, $attribute );
    echo '</div>';
}

function wptypek_options_cache_utility_settings_string() {
    $attribute = wptypek_get_cache_info();

    $description = '';

    $aButtons = Admin::getCacheUtilityIcons();

    echo '<div style="display: -webkit-flex; display: -ms-flex; display: -moz-flex; display: flex;">';
    echo wptypek_gen_button_icons( $aButtons, $description, $attribute );
}

function wptypek_options_order_plugin_string() {
    $description = __( 'The plugin will automatically set the execution order of plugins so to ensure compatibility with other plugins.', 'wp-typek' );

    echo wptypek_gen_radio_field( 'order_plugin', '1', $description );
}

function wptypek_options_debug_string() {
    $description = __( 'This option will add the \'commented out\' url of the individual files inside the combined file above the contents that came from that file. This is useful when configuring the plugin and trying to resolve conflicts. This will also add a <span class="notranslate">Profiler</span> menu to the <span class="notranslate">AdminBar</span> so you can review the times that the plugin methods take to run.',
        'wp-typek' );
    echo wptypek_gen_radio_field( 'debug', '0', $description );
}

function wptypek_options_disable_logged_in_users_string() {
    $description = __( 'When enabled the plugin will be disabled for all users that are logged in', 'wp-typek' );
    echo wptypek_gen_radio_field( 'disable_logged_in_users', '0', $description );
}

function wptypek_options_disable_admin_users_string() {
    $description = __( 'When enabled the plugin will be disabled for all admins', 'wp-typek' );
    echo wptypek_gen_radio_field( 'disable_admin_users', '0', $description );
}


function wptypek_group_start_auto() {
    wptypek_group_end();

    $header      = __( 'Automatic Settings Group', 'wp-typek' );
    $description = __( 'The fields in this group are automatically configured with the Automatic Settings - <span class="notranslate">(Minimum - Optimum)</span>. This is highly recommended to avoid conflicts. It is usually not necessary to set these fields manually unless you are troubleshooting a problem, so do not change these settings yourself unless you know what you are doing .',
        'wp-typek' );
    $class       = 'class="collapsible" ';

    wptypek_group_start( $header, $description, $class );
}

function wptypek_basic_auto_section_text() {
    wptypek_group_start_auto();
}

function wptypek_options_cache_lifetime_string() {
    $description = __( 'The amount of time that the cache will remain valid before the plugin generates a new one. All expired cache will be expunged at this time. Selecting higher values can cause excess cache build-up.' );

    $values = array(
        '1800'    => __( '30 min', 'wp-typek' ),
        '3600'    => __( '1 hour', 'wp-typek' ),
        '10800'   => __( '3 hours', 'wp-typek' ),
        '21600'   => __( '6 hours', 'wp-typek' ),
        '43200'   => __( '12 hours', 'wp-typek' ),
        '86400'   => __( '1 day', 'wp-typek' ),
        '1209600' => __( '14 days', 'wp-typek' ),
        '2592000' => __( '30 days', 'wp-typek' ),
    );

    echo wptypek_gen_select_field( 'cache_lifetime', '900', $values, $description, '' );
}

function wptypek_options_spacer_string() {
    echo '&nbsp;';
}

function wptypek_options_css_string() {
    $description = __( 'This will combine all CSS files into one file and remove all the links to the individual files from the page, replacing it with a link generated by the plugin to the combined file.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'css', '1', $description, 's1-on s2-on s3-on s4-on s5-on s6-on' );
}

function wptypek_options_javascript_string() {
    $description = __( 'This will combine all javascript files into one file and remove all the links to the individual files from the page, replacing it with a link generated by the plugin to the combined file.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'javascript', '1', $description, 's1-on s2-on s3-on s4-on s5-on s6-on' );
}

function wptypek_options_gzip_string() {
    $description = __( 'This setting compresses the generated javascript and CSS combined files with gzip, decreasing file size dramatically. This can decrease file size dramatically.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'gzip', '0', $description, 's1-off s2-on s3-on s4-on s5-on s6-on' );
}

function wptypek_options_css_minify_string() {
    $description = __( 'If yes, the plugin will remove all unnecessary whitespaces and comments from the combined CSS file to reduce the total file size.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'css_minify', '0', $description, 's1-off s2-on s3-on s4-on s5-on s6-on' );
}

function wptypek_options_js_minify_string() {
    $description = __( 'If yes, the plugin will remove all unnecessary whitespaces and comments from the combined javascript file to reduce the total file size.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'js_minify', '0', $description, 's1-off s2-on s3-on s4-on s5-on s6-on' );
}

function wptypek_options_html_minify_string() {
    $description = __( 'If yes, the plugin will remove all unneccessary whitespaces and comments from HTML to reduce the total size of the web page.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'html_minify', '0', $description, 's1-off s2-on s3-on s4-on s5-on s6-on' );
}

function wptypek_options_defer_js_string() {
    $description = __( 'This option will add a <span class="notranslate">\'defer\'</span> attribute to the link of the combined javascript file. This will defer the loading of the javascript until after the page is loaded to reduce \'render-blocking\'.  Do not configure this setting manually to avoid breaking your page.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'defer_js', '0', $description, 's1-off s2-off s3-off s4-off s5-off s6-on' );
}


function wptypek_options_auto_exclude_string() {
    echo '&nbsp;';
}

// ## <plugin_mod@mirek> ##
function wptypek_options_includeAllExtensions_js_string() {
    $description = __( 'By default, all files from third party plugins and external domains are excluded. If this setting is enabled, they will be included.', 'wp-typek' );
    echo wptypek_gen_radio_field( 'includeAllExtensions_js', '0', $description, 's1-off s2-off s3-on s4-on s5-on s6-on' );
}

// ## <plugin_mod@mirek> ##
function wptypek_options_includeAllExtensions_css_string() {
    $description = __( 'By default, all files from third party plugins and external domains are excluded. If this setting is enabled, they will be included.', 'wp-typek' );
    echo wptypek_gen_radio_field( 'includeAllExtensions_css', '0', $description, 's1-off s2-off s3-on s4-on s5-on s6-on' );
}

function wptypek_options_auto_advanced_string() {
    echo '&nbsp;';
}

function wptypek_options_replaceImports_string() {
    $description = __( 'The plugin will replace <span class="notranslate">@import</span> at-rules with the contents of the files they are importing. This will be done recursively.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'replaceImports', '0', $description, 's1-off s2-off s3-off s4-on s5-on s6-on' );
}

// ## <plugin_mod@mirek> ##
function wptypek_options_phpAndExternal_js_string() {
    $description = __( 'Javascript files with <span class="notranslate">\'.php\'</span> file extensions, and files from external domains will be included in the combined file. This option requires that <span class="notranslate">cURL</span> is installed on your server.', 'wp-typek' );

    echo wptypek_gen_radio_field( 'phpAndExternal_js', '0', $description, 's1-off s2-off s3-off s4-on s5-on s6-on' );
}

// ## <plugin_mod@mirek> ##
function wptypek_options_phpAndExternal_css_string() {
    $description = __( 'Css files with <span class="notranslate">\'.php\'</span> file extensions, and files from external domains will be included in the combined file. This option requires that <span class="notranslate">cURL</span> is installed on your server.', 'wp-typek' );

    echo wptypek_gen_radio_field( 'phpAndExternal_css', '0', $description, 's1-off s2-off s3-off s4-on s5-on s6-on' );
}

function wptypek_options_inlineStyle_string() {
    $description = __( 'In-page CSS inside <span class="notranslate">&lt;style&gt;</span> tags will be included in the aggregated file in the order they appear on the page.', 'wp-typek' );

    echo wptypek_gen_radio_field( 'inlineStyle', '0', $description, 's1-off s2-off s3-off s4-on s5-on s6-on' );
}

function wptypek_options_inlineScripts_string() {
    $description = __( 'In-page javascript inside <span class="notranslate">&lt;script&gt;</span> tags will be included in the combined file in the order they appear on the page.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'inlineScripts', '0', $description, 's1-off s2-off s3-off s4-on s5-on s6-on' );
}

function wptypek_options_bottom_js_string() {
    $description = __( 'Place combined javascript file at bottom of the page just before the ending BODY tag. If some javascript files are excluded while preserving execution order so that the combined javascript file is split around the excluded files, only the last combined javascript file will be placed at the bottom of the page. By default the plugin only combines files found in the HEAD section of the page. This option extends the search to the BODY section.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'bottom_js', '0', $description, 's1-off s2-off s3-off s4-off s5-on s6-on' );
}

function wptypek_options_loadAsynchronous_string() {
    $description = __( 'The \'asnyc\' attribute is added to the combined javascript file so it will be loaded asynchronously to avoid render blocking and speed up download of the web page. If other files/scripts are excluded while preserving execution order so that the combined file is split around the excluded files, the \'defer\' attribute is instead added to the last combined file following an excluded file/script. This option only works when the combined javascript file is placed at the bottom of the page.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'loadAsynchronous', '0', $description, 's1-off s2-off s3-off s4-off s5-off s6-on' );
}

function wptypek_get_cache_info() {
    static $attribute = false;

    if ( $attribute === false ) {
        try {
            $wp_filesystem = Cache::getWpFileSystem();
        } catch ( \WpTypek\Core\Exception $e ) {
            $wp_filesystem = false;
        }

        if ( $wp_filesystem !== false && $wp_filesystem->exists( WPTYPEK_CACHE_DIR ) ) {
            try {
                Cache::initializecache();
            } catch ( \WpTypek\Core\Exception $e ) {
                return;
            }


            $size    = 0;
            $dirlist = $wp_filesystem->dirlist( WPTYPEK_CACHE_DIR );

            foreach ( $dirlist as $file ) {
                if ( $file['name'] == 'index.html' ) {
                    continue;
                }

                $size += $file['size'];
            }

            $decimals = 2;
            $sz       = 'BKMGTP';
            $factor   = (int) floor( ( strlen( $size ) - 1 ) / 3 );
            $size     = sprintf( "%.{$decimals}f", $size / pow( 1024, $factor ) ) . $sz[ $factor ];

            $no_files = number_format( count( $dirlist ) - 1 );
        } else {
            $size     = '0';
            $no_files = '0';
        }

        $attribute = '<div><br><div><em>' . sprintf( __( 'Number of files: <span class="notranslate">%s</span>' ), $no_files ) . '</em></div>'
                     . '<div><em>' . sprintf( __( 'Size: <span class="notranslate">%s</span>' ), $size ) . '</em></div></div>'
                     . '</div>';
    }

    return $attribute;
}

function wptypek_url_exclude_section_text() {
    wptypek_group_end();

    echo '</div>
  <div class="tab-pane" id="exclude">';

    $header      = __( 'Exclude urls from the plugin', 'wp-typek' );
    $description = __( 'Enter any part of a url to exclude that page from optimization. You will need to add these urls to the list manually by typing the url in the textbox and click the \'Add item\' button.',
        'wp-typek' );

    wptypek_group_start( $header, $description );
}

function wptypek_options_url_exclude_string() {
    $description = __( 'Enter urls to exclude', 'wp-typek' );
    $option      = 'url_exclude';

    $values = wptypek_get_field_value( 'url', $option, 'file' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

function wptypek_exclude_peo_section_text() {
    wptypek_group_end();

    $header      = __( 'Exclude files while preserving the original execution order of codes on the page', 'wp-typek' );
    $description = __( 'These settings are used to exclude individual files, or files from select plugins, while maintaining the original execution order of codes on the page to ensure the page doesn\'t break. The combined file will split itself around the excluded files to preserve the order and ensure that no dependencies on any other combined files/scripts are broken. If you\'re not seeing the files or extensions you want to exclude in the drop-down list, manually add the files or extensions to the list. To add a file to the list manually, type the url in the textbox and click the \'Add item\' button.',
        'wp-typek' );

    wptypek_group_start( $header, $description );
}

/** ## <plugin_mod@mirek> ## */
function wptypek_gen_exclude_fields_group( $mainOptionName, $assets, $assetExtension = null ) {
    if ( ! empty( $assets ) ) {
        global $wpdb;
        $params = Plugin::getPluginParams();

        foreach ( $assets as $otherAsset ) {
            if ( ! empty( $params->getOptions()[ $mainOptionName ] ) && ! empty( $params->getOptions()[ $mainOptionName ][ $otherAsset ] ) ) {
                $values = $params->getOptions()[ $mainOptionName ][ $otherAsset ];
            } else {
                /**
                 * Data structure for this feature
                 */
                $values = [
                    'do_exclude'      => false,
                    'exclude_pages'   => [],
                    'exclude_posts'   => [],
                    'exclude_urls'    => [
                        [
                            'rule' => '',
                            'url'  => '',
                        ],
                    ],
                    'reverse_exclude' => '0',
                ];
            }
            $md5Asset       = md5( $otherAsset . $assetExtension . $mainOptionName );
            $doExclude      = ! empty( $values['do_exclude'] ) ? $values['do_exclude'] > 0 : false;
            $reverseExclude = ! empty( $values['reverse_exclude'] ) ? $values['reverse_exclude'] > 0 : false;
            $fieldName      = function ( $paramsName, $asArray = false ) use ( $mainOptionName, $otherAsset ) {
                if ( ! is_array( $paramsName ) ) {
                    $paramsName = [ $paramsName ];
                }
                $fieldName = 'wptypek_options[' . $mainOptionName . '][' . $otherAsset . ']';
                foreach ( $paramsName as $paramName ) {
                    $fieldName .= "[{$paramName}]";
                }
                if ( $asArray ) {
                    $fieldName .= '[]';
                }

                return $fieldName;
            };

            echo '<div class="exclude-wrapper">';

            //GENERAL CHECKBOX IF EXCLUDE
            echo '<span class="exclude-label">' . $otherAsset . ( ! empty( $assetExtension ) ? ( '.' . $assetExtension ) : '' ) . '</span>'
                 . '<div class="btn-group hide-radio-checkbox">'
                 . '<input type="radio" id="' . $md5Asset . '0" name="' . $fieldName( 'do_exclude' ) . '" value="0" ' . ( $doExclude ? '' : 'checked' ) . ' >'
                 . '<label for="' . $md5Asset . '0" class="btn danger">' . __( 'No', 'wp-typek' ) . '</label>'
                 . '<input type="radio" id="' . $md5Asset . '1" name="' . $fieldName( 'do_exclude' ) . '" value="1" ' . ( $doExclude ? 'checked' : '' ) . ' >'
                 . '<label for="' . $md5Asset . '1" class="btn success">' . __( 'Yes', 'wp-typek' ) . '</label>'
                 . '</div>';

            echo '<div class="exclude-expand" ' . ( $doExclude ? '' : 'style="display: none;"' ) . '>';
            //PAGES EXCLUDE
            $pages          = WpTypek\Platform\Utility::getPages();
            $pagesAsOptions = join( '', array_map( function ( $page ) use ( $values ) {
                $selected = ! empty( $values['exclude_pages'] ) && is_array( $values['exclude_pages'] ) && in_array( $page->ID, $values['exclude_pages'] ) ? 'selected' : '';

                return '<option value="' . $page->ID . '" ' . $selected . '>' . $page->post_title . '</option>';
            }, $pages ) );
            echo '<div class="my-4"><span class="exclude-label normal">Exclude pages:</span>'
                 . '<select id="' . $md5Asset . 'exclude_pages" name="' . $fieldName( 'exclude_pages', true ) . '" class="inputbox chzn-custom-value input-xlarge" multiple="multiple" size="5" data-custom_group_text="Custom Position" data-no_results_text="No pages">'
                 . $pagesAsOptions
                 . '</select>'
                 . '<div class="tooltip">?<div class="tooltip-content">' . __( 'Select pages to exclude asset. <br />Leave empty to ommit that option.', 'wp-typek' ) . '</div></div>'
                 . '</div>';

            //POSTS EXCLUDE
            $posts = WpTypek\Platform\Utility::getPosts();
            $postsAsOptions = join( '', array_map( function ( $post ) use ( $values ) {
                $selected = ! empty( $values['exclude_posts'] ) && is_array( $values['exclude_posts'] ) && in_array( $post->ID, $values['exclude_posts'] ) ? 'selected' : '';

                return '<option value="' . $post->ID . '" ' . $selected . '>' . $post->post_title . '</option>';
            }, $posts ) );
            echo '<div class="my-4"><span class="exclude-label normal">Exclude posts:</span>'
                 . '<select id="' . $md5Asset . 'exclude_posts" name="' . $fieldName( 'exclude_posts', true ) . '" class="inputbox chzn-custom-value input-xlarge" multiple="multiple" size="5" data-custom_group_text="Custom Position" data-no_results_text="No pages">'
                 . $postsAsOptions
                 . '</select>'
                 . '<div class="tooltip">?<div class="tooltip-content">' . __( 'Select posts to exclude asset. <br />Leave empty to ommit that option.', 'wp-typek' ) . '</div></div>'
                 . '</div>';

            //CUSTOM URL FIELDS
            if ( ! is_array( $values['exclude_urls'] ) ) {
                $values['exclude_urls'] = [ [ 'rule' => '', 'url' => '' ] ];
            }
            echo '<div class="my-4"><span class="exclude-label normal">Exclude URLS:'
                 . '<div class="tooltip">?<div class="tooltip-content">' . __( 'Select URLs to be excluded. <br />Leave empty to ommit that option.', 'wp-typek' ) . '</div></div>'
                 . '</span>';
            foreach ( $values['exclude_urls'] as $key => $excludeUrlData ) {
                echo '<div class="exclude-url-group" data-asset="' . $md5Asset . '">'
                     . '<select id="' . $md5Asset . 'exclude_urls_rule' . $key . '" name="' . $fieldName( [ 'exclude_urls', $key, 'rule' ] ) . '">';
                foreach ( WPTypekAssetsManager::EXCLUDE_URL_RULES as $value => $name ) {
                    $selected = $excludeUrlData['rule'] === $value ? 'selected' : '';
                    echo( '<option value="' . $value . '" ' . $selected . '>' . __( $name, 'wptypek-option' ) . '</option>' );
                }
                echo '</select>'
                     . '<input type="text" id="' . $md5Asset . 'exclude_urls_url' . $key . '" name="' . $fieldName( [ 'exclude_urls', $key, 'url' ] ) . '" value="' . $excludeUrlData['url'] . '"/>'
                     . '</div>';
            }

            echo '<div class="exclude-url-buttons" data-asset="' . $md5Asset . '">'
                 . '<div class="btn-group">'
                 . '<input class="btn" type="button" value="+" onclick="addExcludeUrlGroup(\'' . $md5Asset . '\')"/>'
                 . '<input class="btn remove" type="button" value="-" onclick="removeExcludeUrlGroup(\'' . $md5Asset . '\')" ' . ( count( $values['exclude_urls'] ) <= 1 ? 'disabled' : '' ) . '>'
                 . '</div>'
                 . '</div>'
                 . '</div>';

            //REVERSE EXCEPT
            echo '<span class="exclude-label">Reverse exclude logic'
                 . '<div class="tooltip">?<div class="tooltip-content">' . __( 'Reverse means that asset will not be excluded if any of set rules will be matched. <br /> Be careful as this option without any other logic will simply exclude this asset everywhere.', 'wp-typek' ) . '</div></div>'
                 . '</span>'
                 . '<div class="btn-group hide-radio-checkbox">'
                 . '<input type="radio" id="' . $md5Asset . 'reverse0" name="' . $fieldName( 'reverse_exclude' ) . '" value="0" ' . ( $reverseExclude ? '' : 'checked' ) . ' >'
                 . '<label for="' . $md5Asset . 'reverse0" class="btn danger">' . __( 'No', 'wp-typek' ) . '</label>'
                 . '<input type="radio" id="' . $md5Asset . 'reverse1" name="' . $fieldName( 'reverse_exclude' ) . '" value="1" ' . ( $reverseExclude ? 'checked' : '' ) . ' >'
                 . '<label for="' . $md5Asset . 'reverse1" class="btn success">' . __( 'Yes', 'wp-typek' ) . '</label>'
                 . '</div><br /><br />';

            echo '</div>';
            echo '</div>';
        }
    } else {
        echo( '<strong>' . __( 'No assets found', 'wp-typek' ) . '</strong>' );
    }
}

/** ## <plugin_mod@mirek> ## */
function wptypek_options_excludeCss_string() {
//    $option = 'excludeCss';
//    $assets = ( new WPTypekAssetsManager() )->getAssets();
//
//    echo wptypek_gen_exclude_fields_group( $option, $assets['other']['css'], 'css' );

    $description = __( 'Select the CSS files you want to exclude.', 'jch-optimize' );
    $option      = 'excludeCss';

    $values = wptypek_get_field_value( 'css', $option, 'file' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

function wptypek_options_excludeJs_peo_string() {
    $description = __( 'Select the javascript files you want to exclude.', 'wp-typek' );
    $option      = 'excludeJs_peo';

    $values = wptypek_get_field_value( 'js', $option, 'file' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

/** ## <plugin_mod@mirek> ## */
function wptypek_options_excludeCssComponents_string() {
//    $option = 'excludeCssComponents';
//
//    $assets = ( new WPTypekAssetsManager() )->getAssets();
//
//    echo wptypek_gen_exclude_fields_group( $option, array_keys( $assets['plugins']['css'] ), 'css' );

    $description = __( 'Select the plugins that you want to exclude CSS files from.', 'jch-optimize' );
    $option      = 'excludeCssComponents';

    $values = wptypek_get_field_value( 'css', $option, 'extension' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

function wptypek_options_excludeJsComponents_peo_string() {
    $description = __( 'Select the plugins that you want to exclude javascript files from.',
        'wp-typek' );
    $option      = 'excludeJsComponents_peo';

    $values = wptypek_get_field_value( 'js', $option, 'extension' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

function wptypek_options_excludeStyles_string() {
    $description = __( 'Select the \'in-page\' <span class="notranslate">&lt;style&gt;</span> you want to exclude.',
        'wp-typek' );

    $option = 'excludeStyles';

    $values = wptypek_get_field_value( 'css', $option, 'style' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

function wptypek_options_excludeScripts_peo_string() {
    $description = __( 'Select the \'in-page\' <span class="notranslate">&lt;script&gt;</span> you want to exclude.',
        'wp-typek' );

    $option = 'excludeScripts_peo';

    $values = wptypek_get_field_value( 'js', $option, 'script' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

function wptypek_options_excludeAllStyles_string() {
    $description = __( 'This is useful if you are generating an excess amount of cache files due to the file name of the combined CSS file keeps changing and you can\'t identify which STYLE declaration is responsible',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'excludeAllStyles', '0', $description );
}

function wptypek_options_excludeAllScripts_string() {
    $description = __( 'This is useful if you are generating an excess amount of cache files due to the file name of the combined javascript file keeps changing and you can\'t identify which SCRIPT declaration is responsible',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'excludeAllScripts', '0', $description );
}

function wptypek_exclude_ieo_section_text() {
    wptypek_group_end();

    $header      = __( 'Exclude files without maintaining the original execution order of files on the page', 'wp-typek' );
    $description = __( 'Only use these settings if you\'re sure that the files/scripts you are excluding does not have any dependencies on any other files/scripts that are combined. If you are not sure then use the above section to exclude your files to avoid breaking your page.',
        'wp-typek' );

    wptypek_group_start( $header, $description );
}

/** ## <plugin_mod@mirek> ## */
function wptypek_options_excludeJs_string() {
//    $option = 'excludeJs';
//    $assets = ( new WPTypekAssetsManager() )->getAssets();
//
//    echo wptypek_gen_exclude_fields_group( $option, $assets['other']['js'], 'js' );

    $description = __( 'Select the javascript files you want to exclude.', 'jch-optimize' );
    $option      = 'excludeJs';

    $values = wptypek_get_field_value( 'js', $option, 'file' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

/** ## <plugin_mod@mirek> ## */
function wptypek_options_excludeJsComponents_string() {
//    $option = 'excludeJsComponents';
//
//    $assets = ( new WPTypekAssetsManager() )->getAssets();
//
//    echo wptypek_gen_exclude_fields_group( $option, array_keys( $assets['plugins']['js'] ), 'js' );

    $description = __( 'Select the plugins that you want to exclude javascript files from.',
        'jch-optimize' );
    $option      = 'excludeJsComponents';

    $values = wptypek_get_field_value( 'js', $option, 'extension' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

/** ## <plugin_mod@mirek> ## */
function wptypek_options_excludePlugins_string() {
    $option = 'excludePlugins';

    $plugins = Helper::getActivePlugins();

    echo wptypek_gen_exclude_fields_group( $option, $plugins );
}

function wptypek_options_excludeScripts_string() {
    $description = __( 'Select the \'in-page\' <span class="notranslate">&lt;script&gt;</span> you want to exclude.',
        'wp-typek' );

    $option = 'excludeScripts';

    $values = wptypek_get_field_value( 'js', $option, 'script' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

function wptypek_dontmove_section_text() {
    wptypek_group_end();

    $header      = __( 'Don\'t move these files to the bottom of the page' );
    $description = __( 'The plugin will move all excluded and combined javascript files to the bottom of the page when using the Premium or Optimum setting. If there\'s a javascript file or script that is excluded that you DON\'T want moved to the bottom of the page, enter them here in these settings. These files/scripts must be excluded above for these settings to take effect.' );

    wptypek_group_start( $header, $description );
}

function wptypek_options_dontmoveJs_string() {
    $description = __( 'Don\'t move these javascript files that were excluded above to the bottom of the page. These files will be left at their original position on the page.' );
    $option      = 'dontmoveJs';

    $values = wptypek_get_field_value( 'js', $option, 'file' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

function wptypek_options_dontmoveScripts_string() {
    $description = __( 'Enter any substring of an excluded script here to prevent this script being moved to the bottom. Inline scripts in the BODY of the document containing the \'document.write\' method will NOT be moved by default.' );
    $option      = 'dontmoveScripts';

    $values = wptypek_get_field_value( 'js', $option, 'script' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

// ## <plugin_mod@mirek> ##
function wptypek_gen_button_icons( array $aButton, $description = '', $attribute = '', $descriptionLeft = false ) {
    $sField = Admin::generateIcons( $aButton );
    $sField .= $attribute;
    if ( $description != '' ) {
        $descriptionLeft = $descriptionLeft ? 'left' : '';
        $sField          .= ( '<div class="tooltip ' . $descriptionLeft . '" style="top: -10px">?<div class="tooltip-content">' . $description . '</div></div>' );
    }

    return $sField;
}

function wptypek_page_cache_section_text() {
    wptypek_group_end();

    echo '</div>
  <div class="tab-pane" id="sprite">';

    $header      = __( 'Page Cache', 'wp-typek' );
    $description = __( 'The HTML source of the page will be cached to significantly speed up page loads. Deactivate caching while confguring the plugin and be sure to flush cache after making changes to the site.' );

    wptypek_group_start( $header, $description );
}

function wptypek_options_cache_enable_string() {
    $description = 'Enable page caching';

    echo wptypek_gen_radio_field( 'cache_enable', '0', $description );
}

function wptypek_options_page_cache_lifetime_string() {
    $description = __( 'The period of time for which the page cache will be valid. Be sure to set this lower that the cache lifetime of combined files at all times.' );

    $values = array(
        '900'     => __( '15 min', 'wp-typek' ),
        '1800'    => __( '30 min', 'wp-typek' ),
        '3600'    => __( '1 hour', 'wp-typek' ),
        '10800'   => __( '3 hours', 'wp-typek' ),
        '21600'   => __( '6 hours', 'wp-typek' ),
        '43200'   => __( '12 hours', 'wp-typek' ),
        '86400'   => __( '1 day', 'wp-typek' ),
        '1209600' => __( '14 days', 'wp-typek' ),
        '2592000' => __( '30 days', 'wp-typek' ),
    );

    echo wptypek_gen_select_field( 'page_cache_lifetime', '900', $values, $description, '' );
}

function wptypek_options_cache_exclude_string() {

    $description = __( 'Enter any part of a url to exclude that page from caching.', 'wp-typek' );

    $option = 'cache_exclude';

    $values = wptypek_get_field_value( 'url', $option, 'file' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}


function wptypek_remove_js_section_text() {
    wptypek_group_end();

    $header      = __( 'Remove unused javascript', 'wp-typek' );
    $description = __( 'Identify and select the javascript files that are not being used on the site. The plugin will remove it from the page and prevent it from loading.', 'wp-typek' );
    wptypek_group_start( $header, $description );
}

/** ##<plugin_mod@mirek> */
function wptypek_options_remove_javascript_rules_string() {
    $mainOptionName = 'remove_javascript_rules';
    $option         = 'remove_js';
    $scripts        = wptypek_get_field_value( 'js', $option, 'file' );
    $pages          = WpTypek\Platform\Utility::getPages();
    $posts          = WpTypek\Platform\Utility::getPosts();
    $params         = Plugin::getPluginParams();
    $options        = $params->getOptions();
    $emptyRule      = [
        'scripts'         => [],
        'exclude_pages'   => [],
        'exclude_posts'   => [],
        'exclude_urls'    => [
            [
                'rule' => '',
                'url'  => '',
            ],
        ],
        'reverse_exclude' => '0',
    ];
    $rules          = [ $emptyRule ];
    if ( ! empty( $options[ $mainOptionName ] ) ) {
        $rules = $options[ $mainOptionName ];
    }

    foreach ( $rules as $ruleKey => $rule ) {
        $loadOnScroll = ! empty( $rule['load_on_scroll'] ) ? $rule['load_on_scroll'] > 0 : false;
        $reverseExclude = ! empty( $rule['reverse_exclude'] ) ? $rule['reverse_exclude'] > 0 : false;
        $isEmptyRule    = '';
        $chznFieldClass = 'chzn-custom-value';
        if ( $ruleKey === 0 || $ruleKey === '++rule--key++' ) {
            $isEmptyRule    = ' id="empty-ruleset" style="display: none;"';
            $ruleKey        = '++rule--key++';
            $chznFieldClass = '_chzn-custom-value';
        }

        $fieldName = function ( $paramsName, $asArray = false ) use ( $mainOptionName, $ruleKey ) {
            if ( ! is_array( $paramsName ) ) {
                $paramsName = [ $paramsName ];
            }
            $fieldName = 'wptypek_options[' . $mainOptionName . '][' . $ruleKey . ']';
            foreach ( $paramsName as $paramName ) {
                $fieldName .= "[{$paramName}]";
            }
            if ( $asArray ) {
                $fieldName .= '[]';
            }

            return $fieldName;
        };

        echo '<div class="exclude-wrapper" ' . $isEmptyRule . '>';
        echo '<button class="btn btn-danger remove-exclude-wrapper" onclick="removeJavascriptRemoveRule(event, this)">' . __( 'Remove', 'wptypek' ) . '</button>';

        echo '<div>';
        //SCRIPTS SELECT
        $currentScripts = $scripts;
        if ( ! empty( $rule['scripts'] ) && is_array( $rule['scripts'] ) ) {
            foreach ( $rule['scripts'] as $customScript ) {
                if ( ! isset( $currentScripts[ $customScript ] ) && ! in_array( $customScript, $currentScripts ) ) {
                    $currentScripts[ $customScript ] = $customScript;
                }
            }
        }

        $scriptsAsOptions = join( '', array_map( function ( $script ) use ( $rule ) {
            $selected = ! empty( $rule['scripts'] ) && is_array( $rule['scripts'] ) && in_array( $script, $rule['scripts'] ) ? 'selected' : '';

            return '<option value="' . $script . '" ' . $selected . '>' . $script . '</option>';
        }, $currentScripts ) );
        echo '<div class="my-4"><span class="exclude-label normal">Scripts to remove:</span>'
             . '<select id="scripts_' . $ruleKey . '" name="' . $fieldName( 'scripts', true ) . '" class="inputbox ' . $chznFieldClass . ' input-xlarge" multiple="multiple" size="5" data-custom_group_text="Custom Position" data-no_results_text="No scripts found">'
             . $scriptsAsOptions
             . '</select>'
             . '<button class="btn" type="button" onclick="addWPTypekOption(\'scripts_' . $ruleKey . '\')">Add item</button>'
             . '<div class="tooltip">?<div class="tooltip-content">' . __( 'Select which scripts to remove.', 'wp-typek' ) . '</div></div>'
             . '</div>';

        //PAGES EXCLUDE
        $pagesAsOptions = join( '', array_map( function ( $page ) use ( $rule ) {
            $selected = ! empty( $rule['exclude_pages'] ) && is_array( $rule['exclude_pages'] ) && in_array( $page->ID, $rule['exclude_pages'] ) ? 'selected' : '';

            return '<option value="' . $page->ID . '" ' . $selected . '>' . $page->post_title . '</option>';
        }, $pages ) );
        echo '<div class="my-4"><span class="exclude-label normal">Remove on pages:</span>'
             . '<select name="' . $fieldName( 'exclude_pages', true ) . '" class="inputbox ' . $chznFieldClass . ' input-xlarge" multiple="multiple" size="5" data-custom_group_text="Custom Position" data-no_results_text="No pages">'
             . $pagesAsOptions
             . '</select>'
             . '<div class="tooltip">?<div class="tooltip-content">' . __( 'Select pages to remove selected scripts. <br />Leave empty to ommit that option.', 'wp-typek' ) . '</div></div>'
             . '</div>';


        //POSTS EXCLUDE
        $postsAsOptions = join( '', array_map( function ( $post ) use ( $rule ) {
            $selected = ! empty( $rule['exclude_posts'] ) && is_array( $rule['exclude_posts'] ) && in_array( $post->ID, $rule['exclude_posts'] ) ? 'selected' : '';

            return '<option value="' . $post->ID . '" ' . $selected . '>' . $post->post_title . '</option>';
        }, $posts ) );
        echo '<div class="my-4"><span class="exclude-label normal">Remove on posts:</span>'
             . '<select name="' . $fieldName( 'exclude_posts', true ) . '" class="inputbox ' . $chznFieldClass . ' input-xlarge" multiple="multiple" size="5" data-custom_group_text="Custom Position" data-no_results_text="No pages">'
             . $postsAsOptions
             . '</select>'
             . '<div class="tooltip">?<div class="tooltip-content">' . __( 'Select posts to remove selected scripts. <br />Leave empty to ommit that option.', 'wp-typek' ) . '</div></div>'
             . '</div>';

        //CUSTOM URL FIELDS
        if ( ! is_array( $rule['exclude_urls'] ) ) {
            $rule['exclude_urls'] = [ [ 'rule' => '', 'url' => '' ] ];
        }
        echo '<div class="my-4"><span class="exclude-label normal">Remove on URLS:'
             . '<div class="tooltip">?<div class="tooltip-content">' . __( 'Select URLs where to remove selected scripts. <br />Leave empty to ommit that option.', 'wp-typek' ) . '</div></div>'
             . '</span>';
        foreach ( $rule['exclude_urls'] as $key => $excludeUrlData ) {
            echo '<div class="exclude-url-group" data-asset="' . $ruleKey . '">'
                 . '<select name="' . $fieldName( [ 'exclude_urls', $key, 'rule' ] ) . '">';
            foreach ( WPTypekAssetsManager::EXCLUDE_URL_RULES as $value => $name ) {
                $selected = $excludeUrlData['rule'] === $value ? 'selected' : '';
                echo( '<option value="' . $value . '" ' . $selected . '>' . __( $name, 'wptypek-option' ) . '</option>' );
            }
            echo '</select>'
                 . '<input type="text" name="' . $fieldName( [ 'exclude_urls', $key, 'url' ] ) . '" value="' . $excludeUrlData['url'] . '"/>'
                 . '</div>';
        }

        echo '<div class="exclude-url-buttons" data-asset="' . $ruleKey . '">'
             . '<div class="btn-group">'
             . '<input class="btn" type="button" value="+" onclick="addExcludeUrlGroup(\'' . $ruleKey . '\')"/>'
             . '<input class="btn remove" type="button" value="-" onclick="removeExcludeUrlGroup(\'' . $ruleKey . '\')" ' . ( count( $rule['exclude_urls'] ) <= 1 ? 'disabled' : '' ) . '>'
             . '</div>'
             . '</div>'
             . '</div>';

        //LOAD ON SCROLL
        echo '<span class="exclude-label">Load after scroll'
             . '<div class="tooltip">?<div class="tooltip-content">' . __( 'This option will not remove completely selected script, but will add them after scroll event on page.', 'wp-typek' ) . '</div></div>'
             . '</span>'
             . '<div class="btn-group hide-radio-checkbox" onchange="handleJavascriptManagerLazyLoadFieldChange(\'' . $fieldName( 'load_on_scroll' ) . '\', \'' . $ruleKey . '\')">'
             . '<input id="lazy_load_' . $ruleKey . '_0" type="radio" name="' . $fieldName( 'load_on_scroll' ) . '" value="0" ' . ( $loadOnScroll ? '' : 'checked' ) . ' >'
             . '<label for="lazy_load_' . $ruleKey . '_0" class="btn danger">' . __( 'No', 'wp-typek' ) . '</label>'
             . '<input id="lazy_load_' . $ruleKey . '_1" type="radio" name="' . $fieldName( 'load_on_scroll' ) . '" value="1" ' . ( $loadOnScroll ? 'checked' : '' ) . ' >'
             . '<label for="lazy_load_' . $ruleKey . '_1" class="btn success">' . __( 'Yes', 'wp-typek' ) . '</label>'
             . '</div><br /><br />';

        $hideReverseExcept = $loadOnScroll ? 'style="display: none;"' : '';
        //REVERSE EXCEPT
        echo '<div data-reverse-removal="' . $ruleKey . '" ' . $hideReverseExcept . '><span class="exclude-label">Reverse removal logic'
             . '<div class="tooltip">?<div class="tooltip-content">' . __( 'Reverse means that selected scripts will not be removed if any of set rules will be matched. <br /> Be careful as this option without any other logic will simply remove selected scripts everywhere.', 'wp-typek' ) . '</div></div>'
             . '</span>'
             . '<div class="btn-group hide-radio-checkbox">'
             . '<input id="' . $ruleKey . '_0" type="radio" name="' . $fieldName( 'reverse_exclude' ) . '" value="0" ' . ( $reverseExclude ? '' : 'checked' ) . ' >'
             . '<label for="' . $ruleKey . '_0" class="btn danger">' . __( 'No', 'wp-typek' ) . '</label>'
             . '<input id="' . $ruleKey . '_1" type="radio" name="' . $fieldName( 'reverse_exclude' ) . '" value="1" ' . ( $reverseExclude ? 'checked' : '' ) . ' >'
             . '<label for="' . $ruleKey . '_1" class="btn success">' . __( 'Yes', 'wp-typek' ) . '</label>'
             . '</div><br /><br />';

        echo '</div>';
        echo '</div>';
        echo '</div>';
    }

    echo '<button class="btn btn-primary" style="margin: 0 auto;" onclick="removeJavascriptAddRule(event, this)">' . __( 'Add rule', 'wp-typek' ) . '</button>';
}

function wptypek_options_remove_js_string() {
    $option = 'remove_js';
    $values = wptypek_get_field_value( 'js', $option, 'file' );

    echo wptypek_gen_multiselect_field( $option, $values, '' );
}

function wptypek_pro_reduce_dom_section_text() {
    wptypek_group_end();

    $header      = __( 'Reduce DOM size', 'wp-typek' );
    $description = __( '<span class="label label-important" style="padding: 1px 3px; ">Beta feature!</span> HTML5 sectioning related elements such as header, footer, section, aside, nav, and article that fall below the fold will be commented out if the number of DOM elements exceed 600. These sections will be inserted back into the DOM using javascript after the page has been loaded. <span class="label label-warning" style="padding: 1px 3px; ">Warning: Use with care. Can interfere with sections that use javascript to render.</span>', 'wp-typek' );

    wptypek_group_start( $header, $description );
}

function wptypek_options_pro_reduce_dom_string() {
    /* ##<freecode>##
      echo wptypek_gen_proonly_field();
      ##</freecode>## */

    ##<procode>##
    echo wptypek_gen_radio_field( 'pro_reduce_dom', '0', '' );
    ##</procode>##
}

function wptypek_img_attributes_section_text() {
    wptypek_group_end();

    $header      = __( 'Add Image Attributes', 'wp-typek' );
    $description = __( 'When enabled, the plugin will add missing width and height attributes to <span class="notranslate">&lt;img/&gt;</span>  elements',
        'wp-typek' );

    wptypek_group_start( $header, $description );
}

function wptypek_options_img_attributes_enable_string() {
    echo wptypek_gen_radio_field( 'img_attributes_enable', '0', '' );
}

function wptypek_sprite_manual_section_text() {
    wptypek_group_end();


    $header      = __( 'Sprite Generator', 'wp-typek' );
    $description = __( 'If yes will combine selected background images in one image called a sprite to reduce http requests.',
        'wp-typek' );

    wptypek_group_start( $header, $description );
}

function wptypek_options_csg_enable_string() {
    $description = '';

    echo wptypek_gen_radio_field( 'csg_enable', '0', $description );
}

function wptypek_options_csg_direction_string() {
    $description = __( 'Determine in which direction the images must be placed in the sprite.', 'wp-typek' );

    $values = array(
        'vertical'   => __( 'vertical', 'wp-typek' ),
        'horizontal' => __( 'horizontal', 'wp-typek' )
    );

    echo wptypek_gen_select_field( 'csg_direction', 'vertical', $values, $description );
}

function wptypek_options_csg_wrap_images_string() {
    $description = __( 'This setting will wrap images in sprite into another row or column if the length of the sprite becomes longer than 2000px.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'csg_wrap_images', '0', $description );
}

function wptypek_options_csg_exclude_images_string() {
    $description = __( 'You can exclude one or more of the images if they are displayed incorrectly.',
        'wp-typek' );

    $option = 'csg_exclude_images';

    $values = wptypek_get_field_value( 'images', $option );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

function wptypek_options_csg_include_images_string() {
    $description = __( 'You can include additional images in the sprite to the ones that were selected by default. Exercise care with this option as these files are likely to not display correctly.',
        'wp-typek' );

    $option = 'csg_include_images';

    $values = wptypek_get_field_value( 'images', $option );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

function wptypek_pro_group_section_text() {
    wptypek_group_end();

    echo '</div>
  <div class="tab-pane" id="pro">';

    ##<procode>##
    wptypek_group_start();
    ##</procode>##
}

function wptypek_options_pro_downloadid_string() {
    $description = __( 'Enter your download ID to enable automatic updates of the pro version. Log into your account on the wp-typek.net website and access the download id from the \'My Account -> My Download ID\' menu item',
        'wp-typek' );

    echo wptypek_gen_text_field( 'pro_downloadid', '', $description, '', '40' );
}

function wptypek_pro_http2_push_section_text() {
    ##<procode>##
    wptypek_group_end();
    ##</procode>##

    $header      = __( 'Http/2 Push', 'wp-typek' );
    $description = __( 'Plugin will send appropriate preload headers to your server to push resource files before the browser requests them and so speed up the loading of the page. Please note this only works if http/2 is enabled on the server', 'wp-typek' );

    wptypek_group_start( $header, $description );
}

function wptypek_options_pro_http2_push_enable_string() {
    /* ##<freecode>##
      echo wptypek_gen_proonly_field();
      ##</freecode>## */

    ##<procode>##
    echo wptypek_gen_radio_field( 'pro_http2_push_enable', '0', '' );
    ##</procode>##
}

function wptypek_options_pro_http2_exclude_deferred_string() {
    $description = __( 'Will exclude javascript files that are deferred or loaded asynchronously, deferred CSS file in Optimize CSS Delivery feature, and images that are lazy-loaded. This can help reduce bandwidth and speed up first paint rendering.', 'wp-typek' );

    /* ##<freecode>##
      echo wptypek_gen_proonly_field();
      ##</freecode>## */

    ##<procode>##
    echo wptypek_gen_radio_field( 'pro_http2_exclude_deferred', '1', $description );
    ##</procode>##
}

function wptypek_options_pro_http2_file_types_string() {
    /* ##<freecode>##
      echo wptypek_gen_proonly_field($description);
      ##</freecode>## */

    ##<procode>##
    ###</procode>##
    ##<procode>##
    $values = array(
        'style'  => 'style',
        'script' => 'script',
        'font'   => 'font',
        'image'  => 'image'
    );

    echo wptypek_gen_checkboxes_field( 'pro_http2_file_types', $values, 'checkboxes' );
    ##</procode>##
}

function wptypek_pro_ocd_section_text() {
    wptypek_group_end();

    $header      = __( 'Optimize CSS Delivery', 'wp-typek' );
    $description = __( 'The plugin will attempt to extract the critical CSS that is required to format the page above the fold and put this in a <span class="notranslate">&lt;style&gt;</span> element inside the <span class="notranslate">&lt;head&gt;</span> section of the HTML to prevent \'render-blocking\'. The combined CSS will then be loaded asynchronously via javascript. Select the number of HTML elements from the top of the page that you want the plugin to find the critical CSS for. The smaller the number, the faster your site but you might see some jumping of the page if the number is too small.',
        'wp-typek' );

    wptypek_group_start( $header, $description );
}

function wptypek_options_optimizeCssDelivery_enable_string() {
    echo wptypek_gen_radio_field( 'optimizeCssDelivery_enable', '0', '' );
}

function wptypek_options_optimizeCssDelivery_string() {
    $values = array( '200' => '200', '400' => '400', '600' => '600', '800' => '800' );

    echo wptypek_gen_select_field( 'optimizeCssDelivery', '200', $values, '' );
}

function wptypek_options_pro_remove_unused_css_string() {
    $description = __( 'Will attempt to remove any CSS from the combined file that is not being used on the page. NOTE: This setting will remove the CSS for dynamic content. Manually place CSS selectors that targets the dynamic elements you want rendered below.' );

    /* ##<freecode>##
     echo wptypek_gen_proonly_field($description);
     ##</freecode>## */

    ##<procode>##
    echo wptypek_gen_radio_field( 'pro_remove_unused_css', '0', $description );
    ##</procode>##
}

function wptypek_options_pro_dynamic_selectors_string() {
    $description = __( 'Add CSS selectors here that targets dynamic elements to ensure CSS rule-sets containing these selectors gets added to the combined CSS files when \'Remove unused CSS\' is enabled. These are normally classes that are added to elements dynamically.' );

    /* ##<freecode>##
     echo wptypek_gen_proonly_field($description);
     ##</freecode>## */

    ##<procode>##
    $option = 'pro_dynamic_selectors';
    $values = wptypek_get_field_value( 'dynamicselectors', $option, 'style' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
    ##</procode>##
}

// ##<plugin_mod@mirek>##
function wptypek_options_pro_load_css_on_scroll_string() {
    $description = __( 'Optimized CSS will be loaded on page after page scroll event occurs.', 'wp-typek' );

    /* ##<freecode>##
     echo wptypek_gen_proonly_field($description);
     ##</freecode>## */

    ##<procode>##
    echo wptypek_gen_radio_field( 'pro_load_css_on_scroll', '0', $description );
    ##</procode>##
}

function wptypek_options_pro_optimizeCssDelivery_loadFile_string() {
    $description = __( 'Select when the combined CSS file should be loaded', 'wp-typek' );

    /* ##<freecode>##
      echo wptypek_gen_proonly_field($description);
      ##</freecode>## */

    ##<procode>##
    $values = array(
        '0' => __( 'After page load', 'wp-typek' ),
        '1' => __( 'After initial paint', 'wp-typek' )
    );

    echo wptypek_gen_select_field( 'pro_optimizeCssDelivery_loadFile', '1', $values, $description );
    ##</procode>##
}

function wptypek_pro_cookielessdomain_section_text() {
    wptypek_group_end();

    $header      = __( 'CDN/Cookieless Domain', 'wp-typek' );
    $description = __( 'Enter your CDN or cookieless domain here. The plugin will load all static files including background images, combined javascript and css files, and generated sprite from this domain. This requires that this domain is already set up and points to your site root. You can also use multiple domains and the plugin will alternate the domains among the static files. You can also select the file types that you want to be loaded over these domains.',
        'wp-typek' );

    wptypek_group_start( $header, $description );
}

function wptypek_options_cookielessdomain_enable_string() {
    echo wptypek_gen_radio_field( 'cookielessdomain_enable', '0', '' );
}

function wptypek_options_cdn_scheme_string() {
    $description = __( 'Select the scheme that you want prepended to the CDN/Cookieless domain', 'wp-typek' );
    $values      = array(
        '0' => __( 'scheme relative', 'wp-typek' ),
        '1' => __( 'http', 'wp-typek' ),
        '2' => __( 'https', 'wp-typek' )
    );

    echo wptypek_gen_select_field( 'cdn_scheme', '0', $values, $description, $class = '' );
}

function wptypek_options_cookielessdomain_string() {
    echo wptypek_gen_text_field( 'cookielessdomain', '', '', '', '30' );
}

function wptypek_get_static_files_options() {
    return array(
        'css'   => 'css',
        'png'   => 'png',
        'gif'   => 'gif',
        'ico'   => 'ico',
        'pdf'   => 'pdf',
        'js'    => 'js',
        'jpe?g' => 'jp(e)g',
        'bmp'   => 'bmp',
        'webp'  => 'webp',
        'svg'   => 'svg'
    );
}

function wptypek_options_staticfiles_string() {
    $values = wptypek_get_static_files_options();

    echo wptypek_gen_checkboxes_field( 'staticfiles', $values, 'checkboxes' );
}

function wptypek_options_pro_customcdnextensions_string() {
    $description = __( 'To add custom extensions of file types to be loaded over CDN on Domain 1, type the extension in the textbox and press the \'Add item\' button' );
    /* ##<freecode>##
      echo wptypek_gen_proonly_field($description);
      ##</freecode>## */

    ##<procode>##
    $option = 'pro_customcdnextensions';
    $values = wptypek_get_field_value( 'customextension', $option, 'file' );

    //##<plugin_mod@mirek>##
    $values = array_combine($values, $values);

    echo wptypek_gen_multiselect_field( $option, $values, $description );
    ##</procode>##
}

function wptypek_options_pro_cookielessdomain_2_string() {
    /* ##<freecode>##
      echo wptypek_gen_proonly_field();
      ##</freecode>## */

    ##<procode>##
    echo wptypek_gen_text_field( 'pro_cookielessdomain_2', '', '', '', '30' );
    ##</procode>##
}

function wptypek_options_pro_staticfiles_2_string() {
    /* ##<freecode>##
      echo wptypek_gen_proonly_field($description);
      ##</freecode>## */

    ##<procode>##

    $values = wptypek_get_static_files_options();

    echo wptypek_gen_checkboxes_field( 'pro_staticfiles_2', $values, 'checkboxes' );
    ##</procode>##
}

function wptypek_options_pro_cookielessdomain_3_string() {
    /* ##<freecode>##
      echo wptypek_gen_proonly_field();
      ##</freecode>## */

    ##<procode>##
    echo wptypek_gen_text_field( 'pro_cookielessdomain_3', '', '', '', '30' );
    ##</procode>##
}

function wptypek_options_pro_staticfiles_3_string() {
    /* ##<freecode>##
      echo wptypek_gen_proonly_field($description);
      ##</freecode>## */

    ##<procode>##

    $values = wptypek_get_static_files_options();

    echo wptypek_gen_checkboxes_field( 'pro_staticfiles_3', $values, 'checkboxes' );
    ##</procode>##
}

function wptypek_pro_lazyload_section_text() {
    wptypek_group_end();

    $header      = __( 'Lazy Load Images', 'wp-typek' );
    $description = __( 'Enable to delay the loading of iframes, images and responsive images until they are scrolled into view. This further speeds up the loading of the page and reduces http requests.',
        'wp-typek' );

    wptypek_group_start( $header, $description );
}

function wptypek_options_lazyload_enable_string() {
    $description = __( 'Enable to delay the loading of images until after the page loads and they are scrolled into view. This further reduces http requests and speeds up the loading of the page.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'lazyload_enable', '0', $description );
}

function wptypek_options_pro_lazyload_iframe_string() {
    $description = __( 'If enabled will also lazy load IFRAME elements.',
        'wp-typek' );

    /* ##<freecode>##
      echo wptypek_gen_proonly_field($description);
      ##</freecode>## */

    ##<procode>##
    echo wptypek_gen_radio_field( 'pro_lazyload_iframe', '0', $description );
    ##</procode>##
}

function wptypek_options_excludeLazyLoad_string() {
    $description = __( 'Select or manually add the urls of the images you want to exclude from lazy load.', 'wp-typek' );

    $option = 'excludeLazyLoad';

    $values = wptypek_get_field_value( 'lazyload', $option, 'file' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
}

function wptypek_options_pro_excludeLazyLoadFolder_string() {
    $description = __( 'Exclude all the images in the selected folders.', 'wp-typek' );

    /* ##<freecode>##
      echo wptypek_gen_proonly_field($description);
      ##</freecode>## */

    ##<procode>##
    $option = 'pro_excludeLazyLoadFolder';

    $values = wptypek_get_field_value( 'lazyload', $option, 'folder' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
    ##</procode>##
}

function wptypek_options_pro_excludeLazyLoadClass_string() {
    $description = __( 'Exclude all images that have these classes declared on the <span class="notranslate">&lt;img&gt;</span> element', 'wp-typek' );

    /* ##<freecode>##
      echo wptypek_gen_proonly_field($description);
      ##</freecode>## */

    ##<procode>##
    $option = 'pro_excludeLazyLoadClass';

    $values = wptypek_get_field_value( 'lazyload', $option, 'class' );

    echo wptypek_gen_multiselect_field( $option, $values, $description );
    ##</procode>##
}

function wptypek_options_pro_lazyload_effects_string() {
    $description = __( 'Enable to use fade-in effects when images are scrolled into view', 'wp-typek' );

    /* ##<freecode>##
      echo wptypek_gen_proonly_field($description);
      ##</freecode>## */

    ##<procode>##
    echo wptypek_gen_radio_field( 'pro_lazyload_effects', '0', $description );
    ##</procode>##
}

function wptypek_options_lazyload_autosize_string() {
    $description = __( 'If the size of the images seem incorrect or if you see empty spaces under the images after enabling Lazy-load, try enabling this setting to correct that', 'wp-typek' );

    echo wptypek_gen_radio_field( 'lazyload_autosize', '0', $description );
}

function wptypek_images_section_text() {
    wptypek_group_end();

    echo '</div>
  <div class="tab-pane" id="images">';

    $header      = __( 'Optimize Images', 'wp-typek' );
    $description = __( 'Use our API to optimize the images on your server. Be sure to save your \'Download ID\' in the plugin before trying to optimize images as that will authenticate you to access the API. Use the file tree to select the subfolders and files you want to optimize. Files will be optimized in subfolders recursively. If you want to rescale your images while optimizing, enter the new width and height. Original images will be saved in the /wp-content/wp_typek_backup_images/ directory.',
        'wp-typek' );

    wptypek_group_start( $header, $description );
}

//function wptypek_options_kraken_optimization_level_string()
//{
//        $description = __('You can sacrifice a small amount of image quality for up to 90% of the original file weight by choosing lossy optimization versus Non-lossy. (Recommended!)',
//                          'wp-typek');
//
//        $values = array('0' => __('Non-Lossy', 'wp-typek'), '1' => __('Lossy', 'wp-typek'));
//
//        echo wptypek_gen_select_field('kraken_optimization_level', '0', $values, $description);
//        ;
//}

function wptypek_options_ignore_optimized_string() {
    $description = __( 'Will not attempt to optimize any images in subfolders that have already been marked as optimized.',
        'wp-typek' );

    echo wptypek_gen_radio_field( 'ignore_optimized', '1', $description );
}

function wptypek_images_foldertree_section_text() {
    wptypek_group_end();
}

function wptypek_options_optimize_images_string() {
    ##<procode>##
    if ( ! function_exists( 'curl_init' ) || ! function_exists( 'curl_exec' ) ) {

        ?>
        <div class="error">
            <p> <?php _e( 'cURL is required for this feature but it\'s not enabled on this server.', 'wp-typek' ); ?></p>
        </div>
        <?php

    } else {
        echo '<div id="optimize-images-container">';
        echo '<div id="file-tree-container"></div>';
        echo '<div id="files-container"></div>';

        $aButton = wptypek_get_optimize_images_buttons();

        echo wptypek_gen_button_icons( $aButton );

        echo '</div>';
    }
    ##</procode>##

    /* ##<freecode>##
      echo wptypek_gen_proonly_field();
      ##</freecode>## */
}

function wptypek_section_end_text() {
    echo '</div>';
}

/** ## <plugin_mod@mirek> ## */
function wptypek_gen_radio_field( $option, $default, $description, $class = '', $auto_option = false ) {
    $options = get_option( 'wptypek_options' );

    $checked = 'checked="checked"';
    $no      = '';
    $yes     = '';
    $auto    = '';
    $symlink = '';

    if ( ! isset( $options[ $option ] ) ) {
        $options[ $option ] = $default;
    }

    if ( $options[ $option ] == '1' ) {
        $yes = $checked;
    } elseif ( $options[ $option ] == '2' ) {
        $auto = $checked;
    } elseif ( $options[ $option ] == '3' ) {
        $symlink = $checked;
    } else {
        $no = $checked;
    }

    $radio = "<div class=\"btn-group hide-radio-checkbox {$class}\" data-toggling=\"{$option}\">"
             . '<input type="radio" id="wptypek_options_' . $option . '0" name="wptypek_options[' . $option . ']" value="0" ' . $no . ' >'
             . '<label for="wptypek_options_' . $option . '0" class="btn danger">' . __( 'No', 'wp-typek' ) . '</label>'
             . '<input type="radio" id="wptypek_options_' . $option . '1" name="wptypek_options[' . $option . ']" value="1" ' . $yes . ' >'
             . '<label for="wptypek_options_' . $option . '1" class="btn success">' . __( 'Yes', 'wp-typek' ) . '</label>'
             . '</div>';

    if ( $description ) {
        $radio .= '<div class="tooltip">?<div class="tooltip-content">' . $description . '</div></div>';
    }

    return $radio;
}

/** ## <plugin_mod@mirek> ## */
function wptypek_gen_checkboxes_field( $option, $values, $class ) {
    $options = get_option( 'wptypek_options' );

    if ( isset( $options[ $option ] ) ) {
        $checked_static_files = $options[ $option ];
    } else {
        $checked_static_files = array_keys( $values );
    }

    $input = "<div class=\"btn-group hide-radio-checkbox {$class}\">";

    $i = 0;
    foreach ( $values as $key => $value ) {
        $checked = '';

        if ( in_array( $key, $checked_static_files ) ) {
            $checked = 'checked';
        }

        $input .= '<input type="checkbox" id="wptypek_options_' . $option . $i . '" name="wptypek_options[' . $option . '][]" value="' . $key . '" ' . $checked . '>'
                  . '<label for="wptypek_options_' . $option . $i . '" class="btn">' . $value . '</label>';

        ++ $i;
    }

    $input .= '</div>';

    return $input;
}

function wptypek_gen_text_field( $option, $default, $description, $class = '', $size = '6' ) {
    $options = get_option( 'wptypek_options' );

    if ( ! isset( $options[ $option ] ) ) {
        $value = $default;
    } else {
        $value = $options[ $option ];
    }

    $input = '<input type="text" name="wptypek_options[' . $option . ']" id="wptypek_options_' . $option . '" value="' . $value . '" size="' . $size . '" class="' . $class . '">';

    if ( $description ) {
        $input .= '<div class="tooltip">?<div class="tooltip-content">' . $description . '</div></div>';
    }

    return $input;
}

function wptypek_gen_select_field( $option, $default, $values, $description, $class = '' ) {
    $options = get_option( 'wptypek_options' );

    if ( ! isset( $options[ $option ] ) ) {
        $selected_value = $default;
    } else {
        $selected_value = $options[ $option ];
    }

    $select = '<select id="wptypek_options_' . $option . '" name="wptypek_options[' . $option . ']" class="' . $class . '" >';

    foreach ( $values as $key => $value ) {
        $selected = $selected_value == $key ? 'selected="selected"' : '';
        $select   .= '          <option value="' . $key . '" ' . $selected . '>' . $value . '</option>';
    }

    $select .= '</select>';

    if ( $description ) {
        $select .= '<div class="tooltip">?<div class="tooltip-content">' . $description . '</div></div>';
    }

    return $select;
}

function wptypek_gen_multiselect_field( $option, $values, $description, $class = '' ) {
    $options = get_option( 'wptypek_options' );

    if ( isset( $options[ $option ] ) ) {
        $selected_values = Helper::getArray( $options[ $option ] );
    } else {
        $selected_values = array();
    }

    $select = '<select id="wptypek_options_' . $option . '" name="wptypek_options[' . $option . '][]" class="inputbox chzn-custom-value input-xlarge ' . $class . '" multiple="multiple" size="5" data-custom_group_text="Custom Position" data-no_results_text="Add custom item">';

    foreach ( $values as $key => $value ) {
        $selected = in_array( $key, $selected_values ) ? 'selected="selected"' : '';
        $select   .= '          <option value="' . $key . '" ' . $selected . '>' . $value . '</option>';
    }

    $select .= '</select>';
    $select .= '<button class="btn" type="button" onclick="addWPTypekOption(\'wptypek_options_' . $option . '\')">' . __( 'Add item', 'wp-typek' ) . '</button>';

    if ( $description ) {
        $select .= '<div class="tooltip">?<div class="tooltip-content">' . $description . '</div></div>';
    }

    return $select;
}

function wptypek_get_auto_settings_buttons() {
    return Admin::getSettingsIcons();
}

function wptypek_get_admin_object() {
    static $oWpTypekAdmin = null;

    if ( is_null( $oWpTypekAdmin ) ) {
        global $wptypek_redirect;

        $params        = Settings::getInstance( get_option( 'wptypek_options' ) );
        $oWpTypekAdmin = new Admin( $params, true );

        if ( get_transient( 'wp_typek_ao_exception' ) ) {
            delete_transient( 'wp_typek_ao_exception' );
        } else {
            try {
                $oHtml = new Html( $params );
                $sHtml = $oHtml->getOriginalHtml();
                $oWpTypekAdmin->getAdminLinks( $sHtml, '' );
            } catch ( RunTimeException $ex ) {
                wptypek_flash_message( 'info', $ex->getMessage() );
                set_transient( 'wp_typek_ao_exception', 1, 1 );

                $wptypek_redirect = true;
            } catch ( Exception $ex ) {
                Logger::log( $ex->getMessage(), $params );

                wptypek_flash_message( 'error', $ex->getMessage() );
                set_transient( 'wp_typek_ao_exception', 1, 1 );

                $wptypek_redirect = true;
            }
        }
    }

    return $oWpTypekAdmin;
}

function wptypek_get_field_value( $sType, $sExcludeParams, $sGroup = '' ) {
    $oWpTypekAdmin = wptypek_get_admin_object();

    return $oWpTypekAdmin->prepareFieldOptions( $sType, $sExcludeParams, $sGroup );
}

/* ##<freecode>##

  function wptypek_gen_proonly_field($description = '')
  {
  $field = '<div><em style="padding: 5px; background-color: white; border: 1px #ccc;">' . __('Only available in Pro Version!', 'wp-typek') . '</em></div>';

  if ($description != '')
  {
  $field .= '<div class="tooltip">?<div class="tooltip-content">' . $description . '</div></div>';
  }

  return $field;
  }

  ##</freecode>## */


##<procode>##

function wptypek_get_optimize_images_buttons() {
    $page    = add_query_arg( array( 'wptypek-task' => 'postresults' ), admin_url( 'admin.php?page=wp-typek_settings' ) );
    $aButton = array();

    $aButton[0]['link']   = '';
    $aButton[0]['icon']   = 'fa-compress';
    $aButton[0]['color']  = '#278EB1';
    $aButton[0]['text']   = 'Optimize Images';
    $aButton[0]['script'] = 'onclick="wptypek-OptimizeImages(\'' . $page . '\'); return false;"';
    $aButton[0]['class']  = 'enabled';

    return $aButton;
}

add_action( 'wp_ajax_filetree', 'wptypek_ajax_file_tree' );

function wptypek_ajax_file_tree() {
    echo Ajax::fileTree();

    die();
}

add_action( 'wp_ajax_optimizeimages', 'wptypek_ajax_optimize_images' );

function wptypek_ajax_optimize_images() {
    echo Ajax::optimizeImages();

    die();
}

##</procode>##

// ## <plugin_mod@mirek> ##
function add_section_separator( $text, $section ) {
    add_settings_field( md5( $text ) . '_start', $text, 'wptypek_options_section_separator', 'wptypek-sections', $section );
}

// ## <plugin_mod@mirek> ##
function add_section_separator_end( $text, $section ) {
    add_settings_field( md5( $text ) . '_end', '', 'wptypek_options_section_separator_end', 'wptypek-sections', $section );
}

// ## <plugin_mod@mirek> ##
function add_toggling_section( $value, $section ) {
    add_settings_field( md5( $value ) . '_start', $value, 'wptypek_options_toggling_section', 'wptypek-sections', $section );
}

// ## <plugin_mod@mirek> ##
function add_toggling_section_end( $value, $section ) {
    add_settings_field( md5( $value ) . '_end', $value, 'wptypek_options_toggling_section_end', 'wptypek-sections', $section );
}

// ## <plugin_mod@mirek> ##
function wptypek_options_section_separator() {
    //nothing
}

// ## <plugin_mod@mirek> ##
function wptypek_options_section_separator_end() {
    //nothing
}

// ## <plugin_mod@mirek> ##
function add_action_button( $title, $action, $section ) {
    add_settings_field( md5( $title ), $title, "@{$action}", 'wptypek-sections', $section );
}

// ## <plugin_mod@mirek> ##
function wptypek_do_settings_sections( $page ) {
    global $wp_settings_sections, $wp_settings_fields;

    if ( ! isset( $wp_settings_sections[ $page ] ) ) {
        return;
    }

    foreach ( (array) $wp_settings_sections[ $page ] as $section ) {
        $visible   = ! empty( $_GET['page'] ) && $_GET['page'] === $section['id'];
        $sectionId = $section['id'];

        if ( $visible ) {
            echo "<div {$visible} data-section=\"{$sectionId}\">";
            if ( $section['title'] ) {
                echo "<h2>{$section['title']}</h2>\n";
            }

            if ( $section['callback'] ) {
                call_user_func( $section['callback'], $section );
            }

            if ( ! isset( $wp_settings_fields ) || ! isset( $wp_settings_fields[ $page ] ) || ! isset( $wp_settings_fields[ $page ][ $section['id'] ] ) ) {
                continue;
            }

            echo '<div class="options-wrapper">';
            wptypek_do_settings_fields( $page, $section['id'] );
            echo '</div>';
            echo '</div>';
        }
    }
}

// ## <plugin_mod@mirek> ##
function wptypek_do_settings_fields( $page, $section ) {
    global $wp_settings_fields;

    if ( ! isset( $wp_settings_fields[ $page ][ $section ] ) ) {
        return;
    }

    foreach ( (array) $wp_settings_fields[ $page ][ $section ] as $field ) {
        if ( $field['callback'] == 'wptypek_options_section_separator' ) {
            echo '<div class="section-separator"><span class="separator-title">' . $field['title'] . '</span>';
        } else if ( $field['callback'] == 'wptypek_options_section_separator_end' ) {
            echo '</div>';
        } else if ( $field['callback'] == 'wptypek_options_toggling_section' ) {
            $params = Plugin::getPluginParams();
            $hidden = empty( $params->get( $field['title'], '0' ) ) ? 'style="display: none;"' : '';
            echo '<div class="toggling-section" data-toggled="' . $field['title'] . '" ' . $hidden . '>';
        } else if ( $field['callback'] == 'wptypek_options_toggling_section_end' ) {
            echo '</div>';
        } else {
            $class = '';

            if ( ! empty( $field['args']['class'] ) ) {
                $class = ' class="' . esc_attr( $field['args']['class'] ) . '"';
            }

            $secondClass  = '';
            $flexColViews = [
//                'wptypek_options_excludeCss',
//                'wptypek_options_excludeCssComponents',
//                'wptypek_options_excludeJs',
//                'wptypek_options_excludeJsComponents',
                'wptypek_options_exclude_plugins',
                'wptypek_options_remove_javascript_rules'
            ];

            if ( in_array( $field['id'], $flexColViews ) ) {
                $secondClass = 'flex-col';
            }

            echo '<div class="flex my-2 px-2 ' . $class . '">';
            if ( ! empty( $field['title'] ) ) {
                echo '<div class="flex flex-1 with-label">';
                $labelFor = ( ! empty( $field['args'] ) && ! empty( $field['args']['label_for'] ) ? $field['args']['label_for'] : '' );
                echo '<label for="' . esc_attr( $labelFor ) . '">' . $field['title'] . '</label>';
                echo '</div>';
            }

            echo '<div class="flex flex-1 ' . $secondClass . '">';
            if ( strpos( $field['callback'], '@' ) === 0 ) {
                echo '<a class="btn" href="' . admin_url( 'admin.php?page=wp-typek_settings&wptypek-task=' . str_replace( '@', '', $field['callback'] ) ) . '">' . $field['title'] . '</a>';
            } else {
                call_user_func( $field['callback'], $field['args'] );
            }
            echo '</div>';

            echo '</div>';
        }
    }
}

// ## <plugin_mod@mirek> ##
function wptypek_handle_form_save() {
    if (
        $_SERVER['REQUEST_METHOD'] === 'POST'
        && ! empty( $_POST )
        && ! empty( $_POST['wptypek_options'] )
        && ! empty($_GET)
        && ! empty($_GET['page'])
        && strpos($_GET['page'], 'wp-typek') !== false
    ) {
        try {
            $new_options     = ! empty( $_POST['wptypek_options'] ) ? $_POST['wptypek_options'] : array();
            $current_options = get_option( 'wptypek_options', array() );
            $page         = ! empty( $_GET['page'] ) ? $_GET['page'] : '';
            if ( ! is_array( $current_options ) ) {
                $current_options = array( $current_options );
            }

            if ( ! empty( $page ) ) {
                $array_keys_map = array(
                    'wp-typek_css'      => array(
                        'pro_dynamic_selectors',
                        'excludeCss',
                        'excludeCssComponents',
                        'excludeStyles',
                    ),
                    'wp-typek_js'       => array(
                        'dontmoveJs',
                        'dontmoveScripts',
                        'excludeJs',
                        'excludeJsComponents',
                        'excludeScripts',
                    ),
                    'wp-typek_html'     => array(
                        'pro_http2_file_types',
                    ),
                    'wp-typek_cache'    => array(
                        'cache_exclude',
                        'url_exclude',
                    ),
                    'wp-typek_image'    => array(
                        'excludeLazyLoad',
                        'pro_excludeLazyLoadFolder',
                        'pro_excludeLazyLoadClass',
                    ),
                    'wp-typek_settings' => array(
                        'staticfiles',
                        'pro_customcdnextensions',
                        'pro_staticfiles_2',
                        'pro_staticfiles_3',
                    ),
                );

                $to_save_options = array_merge( $current_options, $new_options );
                if ( ! empty( $array_keys_map[ $page ] ) ) {
                    foreach ( $array_keys_map[ $page ] as $key ) {
                        if ( empty( $new_options[ $key ] ) ) {
                            $to_save_options[ $key ] = [];
                        }
                    }
                }
            }

            if ( ! empty( $to_save_options ) ) {
                update_option( 'wptypek_options', $to_save_options, true );
                wptypek_flash_message( 'success', __( 'Options saved', 'wp-typek' ) );
            }
        } catch ( \Exception $e ) {
            wptypek_flash_message( 'error', __( 'Options were not saved', 'wp-typek' ) );
        }

        wp_redirect( $_POST['_wp_http_referer'] );
        exit;
    }
}

add_action( 'admin_init', 'wptypek_handle_form_save' );
