<?php

if ( ! defined( '_WPTYPEK_EXEC' ) ) {
    define( '_WPTYPEK_EXEC', '1' );
}
if ( ! defined( '_WPT_EXEC' ) ) {
    define( '_WP_EXEC', '1' );
}
$pluginLoaderPath = ABSPATH . 'wp-content/plugins/wptypek-performance/wptypek/loader.php';
$options          = get_option('wptypek_options');
if ( empty( $options ) || empty( $options['excludePlugins_formatted'] ) || !file_exists($pluginLoaderPath) ) {
    return;
}

$requestUri = parse_url( $_SERVER['REQUEST_URI'], PHP_URL_PATH );
$isAdmin    = strpos( $requestUri, '/wp-admin/' );

/**
 * Deactivate plugins for non admin users
 */
if ( ! is_admin() && false === $isAdmin ) {
    require_once $pluginLoaderPath;

    // Deactivate plugins base on the condition meets
    add_filter( 'option_active_plugins', 'wptypek_filter_plugins' );
}

function wptypek_filter_plugins( $plugins ) {
    if ( ! defined( '_WPTYPEK_EXEC' ) ) {
        define( '_WPTYPEK_EXEC', '1' );
    }
    $removePlugins = [];
    \WpTypek\Core\WPTypekAssetsManager::initialize();
    $options = get_option('wptypek_options');
    foreach($options['excludePlugins_formatted'] as $plugin => $excludeRules) {
        if (\WpTypek\Core\WPTypekAssetsManager::shouldDequeue($excludeRules)) {
            $removePlugins[] = $plugin;
        }
    }

    $plugins = array_diff( $plugins, $removePlugins );
    return $plugins;
}
