/** ## <plugin_mod@mirek> ## */

function applyAutoSettings(int, pos) {
    var selectoron = getSelector(int, "on");
    var selectoroff = getSelector(int, "off");

    if (jQuery(selectoron).length) {
        jQuery(selectoron).val("1");
    }

    if (jQuery(selectoroff).length) {
        jQuery(selectoroff).val("0");
    }

    submitWPTypekSettings();
}


jQuery(document).ready(function () {
    var i = 1;
    for (i = 1; i <= 6; i++) {
        var flag = true;

        var selectoron = getSelector(i, "on");
        var selectoroff = getSelector(i, "off");

        jQuery(selectoron + "[value=1]").each(function () {
            var attr = jQuery(this).attr("checked");

            if (typeof attr === typeof undefined || attr === false) {
                flag = false;
                return false;
            }
        });

        if (flag == true) {
            jQuery(selectoroff + "[value=0]").each(function () {
                var attr = jQuery(this).attr("checked");

                if (typeof attr === typeof undefined || attr === false) {
                    flag = false;
                    return false;
                }
            })
        }

        if (flag == true) {
            // ## <plugin_mod@mirek> ##
            jQuery("div.icon.enabled.settings-" + i + " a.btn").addClass("active");
            break;
        }
    }

    jQuery('.exclude-wrapper').each(function() {
       jQuery(this).find('input[type="radio"]').on('click', function() {
           var expand = jQuery(this.parentNode.parentNode).find('.exclude-expand');

           if (this.value == 0) {
               expand.slideUp();
           } else {
               expand.slideDown();
           }
       });
    });

    jQuery('[data-toggling]').each(function() {
        jQuery(this).find('input[type="radio"]').on('click', function() {
            var toggleSection = jQuery('[data-toggled="' + jQuery(this.parentNode).data('toggling') + '"]');

            if (toggleSection && toggleSection.length > 0) {
                if (this.value == 0) {
                    toggleSection.slideUp();
                } else {
                    toggleSection.slideDown();
                }
            }
        });
    });
});

function addWPTypekOption(id) {
    var input = jQuery("#" + id + " + .chzn-container > .chzn-choices > .search-field > input, #" + id + " + .chosen-container > .chosen-choices > .search-field > input");
    var txt = input.val();

    if (txt === input.prop("defaultValue")) {
        txt = null;
    }

    if (txt === null || txt === "") {
        alert("Please input an item in the box to add to the drop-down list");
        return false;
    }

    jQuery("#" + id).append(jQuery("<option/>", {
        value: txt.replace("...", ""),
        text: txt
    }).attr("selected", "selected"));

    jQuery("#" + id).trigger("liszt:updated");
    jQuery("#" + id).trigger("chosen:updated");
}

function ucFirst(string) {
    return string[0].toUpperCase() + string.slice(1);
}

function getTimeStamp() {
    return new Date().getTime();
}

function addExcludeUrlGroup(assetHash) {
    var excludeGroups = jQuery('.exclude-url-group[data-asset="' + assetHash + '"]');
    var excludeGroupsAmount = excludeGroups.length;
    var newExcludeGroup = excludeGroups.last().clone();
    var replaceIndexRegex = new RegExp('(\\[' + (excludeGroupsAmount - 1) + '\\])', 'g');
    newExcludeGroup.html(
        newExcludeGroup.html()
            .replace(replaceIndexRegex, '[' + (excludeGroupsAmount) + ']')
            .replace('selected', '')
    );
    newExcludeGroup.find('input').val('');

    var excludeButtons = jQuery('.exclude-url-buttons[data-asset="' + assetHash + '"]');
    jQuery(newExcludeGroup).insertBefore(excludeButtons);
    excludeButtons.find('.btn.remove').attr('disabled', false);
}

function removeExcludeUrlGroup(assetHash) {
    var excludeGroups = jQuery('.exclude-url-group[data-asset="' + assetHash + '"]');
    if(excludeGroups.length > 1) {
        excludeGroups.last().remove();
    }

    if (excludeGroups.length <= 2) {
        jQuery('.exclude-url-buttons[data-asset="' + assetHash + '"] .btn.remove').attr('disabled', 'disabled');
    }
}

function removeJavascriptAddRule(event, that) {
    event.preventDefault();
    event.stopPropagation();

    var $emptyRuleset = jQuery('#empty-ruleset');

    var newRuleset = $emptyRuleset.clone().attr('id', '').attr('style', '');

    newRuleset.html(
        newRuleset.html()
            .replace(/\+\+rule--key\+\+/g, (Date.now()))
            .replace(/_chzn-custom-value/g, 'chzn-custom-value')
    );
    newRuleset.insertBefore(that);

    if (!!jQuery.prototype.chosen) {
        jQuery("select.chzn-custom-value").chosen({width: "240px"});
    }
}

function removeJavascriptRemoveRule(event, that) {
    event.preventDefault();
    event.stopPropagation();

    jQuery(that).parent('.exclude-wrapper').remove();
}

function handleJavascriptManagerLazyLoadFieldChange(fieldName, ruleKey) {
    var $inputField = jQuery('input[name="' + fieldName + '"]').filter(':checked');
    var $reverseLogicField = jQuery('[data-reverse-removal="' + ruleKey + '"]');

    if ($inputField.val() > 0) {
        $reverseLogicField.slideUp();
    } else {
        $reverseLogicField.slideDown();
    }
}

