var gulp = require('gulp');
var sass = require('gulp-sass');
var postcss = require('gulp-postcss');
var cleanCSS = require('gulp-clean-css');

gulp.task('style', function () {
    return gulp
        .src('src/**/*.scss')
        .pipe(sass().on('error', sass.logError))
        .pipe(postcss([require('tailwindcss')]))
        .pipe(gulp.dest('./dist'));
});

gulp.task('prod', function () {
    return gulp
        .src('src/**/*.scss')
        .pipe(sass().on('error', sass.logError))
        .pipe(postcss([require('tailwindcss')]))
        .pipe(cleanCSS({compatibility: 'ie8'}))
        .pipe(gulp.dest('./dist'));
});

//Watch task
gulp.task('default', function () {
    gulp.watch('src/**/*.scss', gulp.series('style'));
});
