<?php
/**
 *  Plugin Name: WPO365 | CUSTOMERS
 *  Plugin URI: https://www.wpo365.com/downloads/wpo365-customers/
 *  Description: Everything you need to seamlessly integrate your WordPress website with Azure AD B2C / Entra External ID.
 *  Version: 38.0
 *  Author: marco@wpo365.com
 *  Author URI: https://www.wpo365.com
 *  License: See license.txt
 */

namespace Wpo;

require __DIR__ . '/vendor/autoload.php';

// Prevent public access to this script
defined( 'ABSPATH' ) || die();

if ( ! class_exists( '\Wpo\Customers' ) ) {

	class Customers {


		public function __construct() {
			// Show admin notification when BASIC edition is not installed
			add_action( 'admin_notices', array( $this, 'ensure_wpo365_login' ), 10, 0 );
			add_action( 'network_admin_notices', array( $this, 'ensure_wpo365_login' ), 10, 0 );
			add_action( 'plugins_loaded', array( $this, 'ensure_wpo365_login' ), 10, 0 );
		}

		public function ensure_wpo365_login() {
			$version_exists = \class_exists( '\Wpo\Core\Version' ) && isset( \Wpo\Core\Version::$current ) && \Wpo\Core\Version::$current >= 20;

			if ( current_action() === 'plugins_loaded' ) {

				if ( ! $version_exists ) {

					if ( function_exists( 'deactivate_plugins' ) === false ) {
						require_once ABSPATH . 'wp-admin/includes/plugin.php';
					}

					deactivate_plugins( plugin_basename( __FILE__ ) );
				}

				return;
			}

			$plugin_exists = \file_exists( dirname( __DIR__ ) . '/wpo365-login' );

			// Required version installed and activated
			if ( $version_exists ) {
				return;
			}

			// Required plugin not installed
			if ( ! $plugin_exists ) {
				$install_url = wp_nonce_url(
					add_query_arg(
						array(
							'action' => 'install-plugin',
							'plugin' => 'wpo365-login',
							'from'   => 'plugins',
						),
						self_admin_url( 'update.php' )
					),
					'install-plugin_wpo365-login'
				);
				echo '<div class="notice notice-error" style="margin-left: 2px;"><p>'
					/* translators: 1: Name of the premium plugin 2: Name of the WordPress.org plugin */
					. wp_kses( sprintf( __( 'The %1$s plugin requires the latest version of %2$s to be installed and activated.', 'wpo365-login' ), '<strong>WPO365 | CUSTOMERS</strong>', '<strong>WPO365 | LOGIN (free)</strong>' ), wp_kses_allowed_html( 'post' ) )
					. '</p><p>'
					. wp_kses( '<a class="button button-primary" href="' . esc_url_raw( $install_url ) . '">' . __( 'Install plugin', 'wpo365-login' ) . '</a>', wp_kses_allowed_html( 'post' ) )
					. '</p></div>';
				return;
			}

			// Required plubin installed but must either be activated or upgraded
			$activate_url = add_query_arg(
				array(
					'_wpnonce' => wp_create_nonce( 'activate-plugin_wpo365-login/wpo365-login.php' ),
					'action'   => 'activate',
					'plugin'   => 'wpo365-login/wpo365-login.php',
				),
				network_admin_url( 'plugins.php' )
			);

			if ( is_network_admin() ) {
				$activate_url = add_query_arg( array( 'networkwide' => 1 ), $activate_url );
			}

			$update_url = wp_nonce_url(
				self_admin_url( 'update.php?action=upgrade-plugin&plugin=' ) . 'wpo365-login/wpo365-login.php',
				'upgrade-plugin_wpo365-login/wpo365-login.php'
			);

			echo '<div class="notice notice-error" style="margin-left: 2px;"><p>'
				/* translators: 1: Name of the premium plugin 2: Name of the WordPress.org plugin */
				. wp_kses( sprintf( __( 'The %1$s plugin requires the latest version of %2$s to be installed and activated.', 'wpo365-login' ), '<strong>WPO365 | CUSTOMERS</strong>', '<strong>WPO365 | LOGIN (free)</strong>' ), wp_kses_allowed_html( 'post' ) )
				. '</p><p>'
				. wp_kses( '<a class="button button-primary" href="' . esc_url_raw( $activate_url ) . '">' . __( 'Activate plugin', 'wpo365-login' ) . '</a>&nbsp;', wp_kses_allowed_html( 'post' ) )
				. wp_kses( '<a class="button button-primary" href="' . esc_url_raw( $update_url ) . '">' . __( 'Update plugin', 'wpo365-login' ) . '</a>', wp_kses_allowed_html( 'post' ) )
				. '</p></div>';
		}
	}
}

$wpo365_customers = new Customers();
