<?php

namespace Wpo\Sync;

// Prevent public access to this script
defined( 'ABSPATH' ) || die();

use Wpo\Sync\SyncV2_Endpoints;

if ( ! class_exists( '\Wpo\Sync\SyncV2_Controller' ) ) {

	class SyncV2_Controller extends \WP_REST_Controller {


		/**
		 * Register the routes for the objects of the controller.
		 */
		public function register_routes() {

			$version   = '1';
			$namespace = 'wpo365/v' . $version;

			register_rest_route(
				$namespace,
				'/sync/start',
				array(
					array(
						'methods'             => \WP_REST_Server::CREATABLE,
						'callback'            => function ( $request ) {
							return SyncV2_Endpoints::sync_start( $request );
						},
						'permission_callback' => '\Wpo\Sync\Sync_Helpers::check_permissions',
					),
				)
			);

			register_rest_route(
				$namespace,
				'/sync/stop',
				array(
					array(
						'methods'             => \WP_REST_Server::CREATABLE,
						'callback'            => function ( $request ) {
							return SyncV2_Endpoints::sync_stop( $request );
						},
						'permission_callback' => '\Wpo\Sync\Sync_Helpers::check_permissions',
					),
				)
			);

			register_rest_route(
				$namespace,
				'/sync/schedule',
				array(
					array(
						'methods'             => \WP_REST_Server::CREATABLE,
						'callback'            => function ( $request ) {
							return SyncV2_Endpoints::sync_schedule( $request );
						},
						'permission_callback' => '\Wpo\Sync\Sync_Helpers::check_permissions',
					),
				)
			);

			register_rest_route(
				$namespace,
				'/sync/delete',
				array(
					array(
						'methods'             => \WP_REST_Server::CREATABLE,
						'callback'            => function ( $request ) {
							return SyncV2_Endpoints::sync_delete( $request );
						},
						'permission_callback' => '\Wpo\Sync\Sync_Helpers::check_permissions',
					),
				)
			);

			register_rest_route(
				$namespace,
				'/sync/results/summary',
				array(
					array(
						'methods'             => \WP_REST_Server::CREATABLE,
						'callback'            => function ( $request ) {
							return SyncV2_Endpoints::get_results_summary( $request );
						},
						'permission_callback' => '\Wpo\Sync\Sync_Helpers::check_permissions',
					),
				)
			);

			register_rest_route(
				$namespace,
				'/sync/results',
				array(
					array(
						'methods'             => \WP_REST_Server::CREATABLE,
						'callback'            => function ( $request ) {
							return SyncV2_Endpoints::get_results( $request );
						},
						'permission_callback' => '\Wpo\Sync\Sync_Helpers::check_permissions',
					),
				)
			);
		}
	}
}
