<?php

namespace Wpo\Services;

use Wpo\Services\Log_Service;
use Wpo\Services\Options_Service;

// Prevent public access to this script
defined( 'ABSPATH' ) || die();

if ( ! class_exists( '\Wpo\Services\Mapped_Custom_Fields_Service' ) ) {

	class Mapped_Custom_Fields_Service {


		/**
		 * @since 11.0
		 *
		 * @param mixed &$user_roles
		 * @param mixed $wpo_usr
		 * @return bool If mappings are defined but custom field was not found return true
		 */
		public static function custom_field_x_role( &$user_roles, $wpo_usr ) {
			// Add new roles as per custom field > WP role mapping
			$custom_field_role_settings = Options_Service::get_global_list_var( 'custom_fields_x_roles' );
			$request_service            = Request_Service::get_instance();
			$request                    = $request_service->get_request( $GLOBALS['WPO_CONFIG']['request_id'] );
			$custom_field_exists        = false;

			foreach ( $custom_field_role_settings as $kv_pair ) {
				$custom_field_setting = \explode( ':', $kv_pair['key'] );
				$value                = array_pop( $custom_field_setting ); // Take portion after the last semi colon
				$key                  = implode( ':', $custom_field_setting ); // To restore saml properties that include a namespace

				if ( empty( $key ) || empty( $value ) ) {
					Log_Service::write_log( 'WARN', __METHOD__ . ' -> Custom field mapping for WordPress role is not correctly entered: ' . $custom_field_setting . ' and should be of the form propertyName:value e.g. department:Communications' );
					continue;
				}

				$is_id_token_property = function () use ( $key, $value, $request, $wpo_usr, &$custom_field_exists ) {
					$id_token = ! empty( $wpo_usr->id_token ) ? $wpo_usr->id_token : $request->get_item( 'id_token' );

					if ( ! empty( $id_token ) && property_exists( $id_token, $key ) ) {
						$custom_field_exists = true;

						if ( $id_token->$key === $value ) {
							return true;
						}
					}

					return false;
				};

				$is_scim_attribute = function () use ( $key, $value, $request, &$custom_field_exists ) {
					$flattened_scim_attributes = $request->get_item( 'scim_attributes' );

					if ( ! empty( $flattened_scim_attributes ) ) {

						foreach ( $flattened_scim_attributes as $scim_attribute => $scim_value ) {

							if ( ! empty( $scim_attribute ) && strcasecmp( $scim_attribute, $key ) === 0 ) {
								$custom_field_exists = true;

								if ( ! empty( $scim_value ) && strcasecmp( $scim_value, $value ) === 0 ) {
									return true;
								}
							}
						}
					}

					return false;
				};

				$is_graph_attribute = function () use ( $key, $value, $wpo_usr, &$custom_field_exists ) {

					if ( ! empty( $wpo_usr->graph_resource ) && \array_key_exists( $key, $wpo_usr->graph_resource ) ) {
						$custom_field_exists = true;

						if ( $wpo_usr->graph_resource[ $key ] === $value ) {
							return true;
						}
					}

					return false;
				};

				$is_saml_attribute = function () use ( $key, $value, $wpo_usr, &$custom_field_exists ) {

					if ( ! empty( $wpo_usr->saml_attributes ) && array_key_exists( $key, $wpo_usr->saml_attributes ) ) {
						$custom_field_exists = true;

						if ( $wpo_usr->saml_attributes[ $key ] === $value || ( is_array( $wpo_usr->saml_attributes[ $key ] ) && in_array( $value, $wpo_usr->saml_attributes[ $key ], true ) ) ) {
							return true;
						}
					}

					return false;
				};

				if (
					$is_graph_attribute()
					|| $is_saml_attribute()
					|| $is_id_token_property()
					|| $is_scim_attribute()
				) {
					$role_from_role_mapping = $kv_pair['value'];

					// Check if the role exists (if not it is not added)
					if ( User_Role_Service::get_wp_role_case( $role_from_role_mapping ) === null ) {
						Log_Service::write_log( 'ERROR', __METHOD__ . ' -> Custom field mapping for WordPress role ' . $role_from_role_mapping . ' was found for user ' . $wpo_usr->preferred_username . ' but this role does not exist in WordPress' );
						continue;
					}

					// Only add new WordPress role
					if ( in_array( $role_from_role_mapping, $user_roles, true ) === false ) {
						$user_roles[] = $role_from_role_mapping;
						Log_Service::write_log( 'DEBUG', __METHOD__ . " -> Found custom field mapping for WordPress role ' . $role_from_role_mapping .' and added it to the user's roles array" );
					}
				}
			}

			// If attribute -> WP role mappings are defined but attribute was not updated return false otherwise true
			return ! empty( $custom_field_role_settings ) && ! $custom_field_exists;
		}
	}
}
