<?php

namespace Wpo\Services;

use Wpo\Services\Log_Service;
use Wpo\Services\Options_Service;

// Prevent public access to this script
defined( 'ABSPATH' ) || die();

if ( ! class_exists( '\Wpo\Services\Mapped_App_Roles_Service' ) ) {

	class Mapped_App_Roles_Service {

		/**
		 * @since 27.0
		 */
		public static function app_role_x_wp_role( &$user_roles, $wpo_usr ) {
			Log_Service::write_log( 'DEBUG', '##### -> ' . __METHOD__ );

			if ( ! isset( $wpo_usr->app_roles ) ) {
				Log_Service::write_log( 'ERROR', '%s -> Your version of WPO365 | LOGIN is outdated and not compatible with your WPO365 premium addon / bundle', __METHOD__ );
				return;
			}

			// Add new roles as per AD Group > WP role mapping
			$mappings            = Options_Service::get_global_list_var( 'app_roles_x_wp_roles' );
			$user_app_roles_case = array_change_key_case( $wpo_usr->app_roles );

			foreach ( $mappings as $kv_pair ) {

				if ( ! empty( $kv_pair['key'] ) && array_key_exists( strtolower( $kv_pair['key'] ), $user_app_roles_case ) ) {
					$wp_role_to_map = $kv_pair['value'];

					// Check if the role exists (if not it is not added)
					if ( User_Role_Service::get_wp_role_case( $wp_role_to_map ) === null ) {
						Log_Service::write_log( 'ERROR', __METHOD__ . ' -> An app role mapping for WordPress role ' . $wp_role_to_map . ' was found for user ' . $wpo_usr->preferred_username . ' but this role does not exist in WordPress' );
						continue;
					}

					// Only add new WordPress role
					if ( in_array( $wp_role_to_map, $user_roles, true ) === false ) {
						$user_roles[] = $wp_role_to_map;
						Log_Service::write_log( 'DEBUG', sprintf( '%s -> Adding WP role %s to user %s', __METHOD__, $wp_role_to_map, $wpo_usr->preferred_username ) );
					} else {
						Log_Service::write_log( 'DEBUG', sprintf( '%s -> Not adding WP role %s to user %s because the user already has that role', __METHOD__, $wp_role_to_map, $wpo_usr->preferred_username ) );
					}
				}
			}
		}
	}
}
