<?php

namespace Wpo\Services;

use WP_Query;
use Wpo\Core\WordPress_Helpers;
use Wpo\Services\Log_Service;
use Wpo\Services\Options_Service;

// Prevent public access to this script
defined( 'ABSPATH' ) || die();

if ( ! class_exists( '\Wpo\Services\LearnDash_Integration_Service' ) ) {

	class LearnDash_Integration_Service {

		public static function get_ld_items( $type = 'sfwd-courses', $ids = array() ) {
			$query_args = array(
				'post_type'   => $type,
				'post_status' => 'publish',
				'orderby'     => 'title',
				'order'       => 'ASC',
				'nopaging'    => true,    // Turns OFF paging logic to get ALL courses
			);

			if ( ! empty( $ids ) ) {
				$query_args['post_in'] = $ids;
			}

			$courses = array();
			$query   = new WP_Query( $query_args );

			if ( $query->have_posts() ) {

				for ( $i = 0; $i < $query->found_posts; $i++ ) {
					$courses[] = array(
						'id'    => isset( $query->posts[ $i ]->ID ) ? $query->posts[ $i ]->ID : 0,
						'title' => isset( $query->posts[ $i ]->post_title ) ? $query->posts[ $i ]->post_title : '',
					);
				}
			}

			return $courses;
		}

		public static function update_ld_assignments( $wp_usr_id, $aad_groups = array(), $preferred_username = '' ) {
			Log_Service::write_log( 'DEBUG', '##### -> ' . __METHOD__ );

			if ( ! function_exists( 'ld_update_course_access' ) || ! function_exists( 'ld_update_group_access' ) ) {
				Log_Service::write_log( 'DEBUG', sprintf( '%s -> Skipping enrolling users into LearnDash courses [Error: LearnDash is not installed]', __METHOD__ ) );
				return;
			}

			$ld_course_assignments = Options_Service::get_global_list_var( 'ld_course_assignments' );
			$ld_group_assignments  = Options_Service::get_global_list_var( 'ld_group_assignments' );

			self::ld_aad_based_assign( $ld_course_assignments, $wp_usr_id, $aad_groups );
			self::ld_aad_based_assign( $ld_group_assignments, $wp_usr_id, $aad_groups, true );

			$ld_default_course_assignments = Options_Service::get_global_list_var( 'ld_default_course_assignments' );
			$ld_default_group_assignments  = Options_Service::get_global_list_var( 'ld_default_group_assignments' );

			foreach ( $ld_default_course_assignments as $ld_default_course_assignment ) {
				self::ld_update_access( $wp_usr_id, $ld_default_course_assignment );
			}

			foreach ( $ld_default_group_assignments as $ld_default_group_assignment ) {
				self::ld_update_access( $wp_usr_id, $ld_default_group_assignment, true );
			}

			$ld_course_assignments_by_domain = Options_Service::get_global_list_var( 'ld_course_assignments_by_domain' );
			$ld_group_assignments_by_domain  = Options_Service::get_global_list_var( 'ld_group_assignments_by_domain' );

			if ( ! empty( $preferred_username ) && ( ! empty( $ld_course_assignments_by_domain ) || ! empty( $ld_group_assignments_by_domain ) ) ) {

				$user_domain = '';
				$atpos       = WordPress_Helpers::strpos( $preferred_username, '@' );

				if ( $atpos !== false ) {
					$user_domain = substr( $preferred_username, ( $atpos + 1 ) );
				}

				foreach ( $ld_course_assignments_by_domain as $ld_course_assignment_by_domain ) {

					if ( ! empty( $ld_course_assignment_by_domain['key'] ) && strcasecmp( $ld_course_assignment_by_domain['key'], $user_domain ) === 0 ) {
						self::ld_update_access( $wp_usr_id, $ld_course_assignment_by_domain['value'] );
					}
				}

				foreach ( $ld_group_assignments_by_domain as $ld_group_assignment_by_domain ) {

					if ( ! empty( $ld_group_assignment_by_domain['key'] ) && strcasecmp( $ld_group_assignment_by_domain['key'], $user_domain ) === 0 ) {
						self::ld_update_access( $wp_usr_id, $ld_group_assignment_by_domain['value'], true );
					}
				}
			}
		}

		private static function ld_aad_based_assign( $assignments, $wp_usr_id, $aad_groups = array(), $is_group = false ) {
			foreach ( $assignments as $kv_pair ) {

				if ( array_key_exists( $kv_pair['key'], $aad_groups ) ) {
					self::ld_update_access( $wp_usr_id, $kv_pair['value'], $is_group );
				}
			}
		}

		private static function ld_update_access( $wp_usr_id, $ld_info, $is_group = false ) {
			$_ld_info = explode( '|', $ld_info );

			if ( count( $_ld_info ) !== 2 ) {
				return;
			}

			$ld_item_id = absint( trim( $_ld_info[0] ) );

			if ( $is_group ) {

				if ( empty( self::get_ld_items( 'groups', array( $ld_item_id ) ) ) ) {
					Log_Service::write_log( 'WARN', sprintf( '%s -> The LearnDash group with ID %d cannot be assigned [error: %s not found]', __METHOD__, $ld_item_id, ( $is_group ? 'group' : 'course' ) ) );
					return;
				}

				if ( function_exists( 'learndash_get_users_group_ids' ) ) {
					$existing_group_assignments = learndash_get_users_group_ids( $wp_usr_id );

					if ( is_array( $existing_group_assignments ) && in_array( $ld_item_id, $existing_group_assignments, true ) ) {
						Log_Service::write_log( 'DEBUG', sprintf( '%s -> The LearnDash group with ID %d has already been assigned to user with ID %d', __METHOD__, $ld_item_id, $wp_usr_id ) );
						return;
					}
				}

				ld_update_group_access( $wp_usr_id, $ld_item_id );
				Log_Service::write_log( 'DEBUG', sprintf( '%s -> The LearnDash group with ID %d has been assigned to user with ID %d', __METHOD__, $ld_item_id, $wp_usr_id ) );

				do_action( 'wpo365/ld/group', $wp_usr_id, $ld_item_id );

				return;
			}

			if ( empty( self::get_ld_items( 'sfwd-courses', array( $ld_item_id ) ) ) ) {
				Log_Service::write_log( 'WARN', sprintf( '%s -> The LearnDash course with ID %d cannot be assigned [error: %s not found]', __METHOD__, $ld_item_id, ( $is_group ? 'group' : 'course' ) ) );
				return;
			}

			if ( function_exists( 'learndash_get_user_course_access_list' ) ) {
				$existing_course_assignments = learndash_user_get_enrolled_courses( $wp_usr_id );

				if ( is_array( $existing_course_assignments ) && in_array( $ld_item_id, $existing_course_assignments, true ) ) {
					Log_Service::write_log( 'DEBUG', sprintf( '%s -> The LearnDash course with ID %d has already been assigned to user with ID %d', __METHOD__, $ld_item_id, $wp_usr_id ) );
					return;
				}
			}

			ld_update_course_access( $wp_usr_id, $ld_item_id );
			Log_Service::write_log( 'DEBUG', sprintf( '%s -> The LearnDash course with ID %d has been assigned to user with ID %d', __METHOD__, $ld_item_id, $wp_usr_id ) );

			do_action( 'wpo365/ld/course', $wp_usr_id, $ld_item_id );
		}
	}
}
