<?php

namespace Wpo\Services;

use Wpo\Core\Url_Helpers;
use Wpo\Core\WordPress_Helpers;
use Wpo\Services\Options_Service;

// Prevent public access to this script
defined( 'ABSPATH' ) || die();

if ( ! class_exists( '\Wpo\Services\Dual_Login_Service' ) ) {

	class Dual_Login_Service {


		public static function redirect() {

			// Allow for dual login (if user isn't on the login form and tries to enter his username)
			if ( ! Url_Helpers::is_wp_login() ) {
				$dual_login = Options_Service::get_global_boolean_var( 'redirect_to_login' ) === true
					? 'DUAL_LOGIN'
					: (
						( Options_Service::get_global_boolean_var( 'redirect_to_login_v2' ) === true
							? 'DUAL_LOGIN_V2'
							: '' )
					);

				if ( ! empty( $dual_login ) ) {
					$redirect_url = Options_Service::get_aad_option( 'redirect_url' );
					$redirect_url = Options_Service::get_global_boolean_var( 'use_saml' )
						? Options_Service::get_aad_option( 'saml_sp_acs_url' )
						: $redirect_url;
					$redirect_url = apply_filters( 'wpo365/aad/redirect_uri', $redirect_url );
					$referer      = ( WordPress_Helpers::stripos( $redirect_url, 'https' ) !== false ? 'https' : 'http' ) . '://' . $GLOBALS['WPO_CONFIG']['url_info']['host'] . $GLOBALS['WPO_CONFIG']['url_info']['request_uri'];
					$login_url    = Url_Helpers::get_preferred_login_url();
					$login_url    = add_query_arg( 'login_errors', $dual_login, $login_url );
					$login_url    = add_query_arg( 'redirect_to', $referer, $login_url );
					Url_Helpers::force_redirect( $login_url );
				}
			}
		}
	}
}
