<?php

namespace Wpo\Services;

use Wpo\Core\WordPress_Helpers;
use Wpo\Services\Log_Service;
use Wpo\Services\Options_Service;

// Prevent public access to this script
defined( 'ABSPATH' ) || die();

if ( ! class_exists( '\Wpo\Services\Mapped_Domains_Service' ) ) {

	class Mapped_Domains_Service {


		/**
		 * @since 11.0
		 */
		public static function domain_x_role( &$user_roles, $wpo_usr ) {
			$user_domain = '';
			$atpos       = WordPress_Helpers::strpos( $wpo_usr->preferred_username, '@' );

			if ( $atpos !== false ) {
				$user_domain = substr( $wpo_usr->preferred_username, ( $atpos + 1 ) );
			}

			// Add new roles as per domain > WP role mapping
			$domain_role_settings = Options_Service::get_global_list_var( 'domains_x_roles' );

			foreach ( $domain_role_settings as $kv_pair ) {

				if ( ! empty( $user_domain ) && WordPress_Helpers::stripos( $user_domain, $kv_pair['key'] ) !== false ) {
					$role_from_role_mapping = $kv_pair['value'];

					// Check if the role exists (if not it is not added)
					if ( User_Role_Service::get_wp_role_case( $role_from_role_mapping ) === null ) {
						Log_Service::write_log( 'ERROR', __METHOD__ . ' -> Domain mapping for WordPress role ' . $role_from_role_mapping . ' was found for user ' . $wpo_usr->preferred_username . ' but this role does not exist in WordPress' );
						continue;
					}

					// Only add new WordPress role
					if ( in_array( $role_from_role_mapping, $user_roles, true ) === false ) {
						$user_roles[] = $role_from_role_mapping;
						Log_Service::write_log( 'DEBUG', __METHOD__ . " -> Found domain mapping for WordPress role ' . $role_from_role_mapping .' and added it to the user's roles array" );
					}
				}
			}
		}
	}
}
