<?php

namespace Wpo\Mail;

use Wpo\Core\Permissions_Helpers;
use Wpo\Services\Log_Service;
use Wpo\Services\Options_Service;

// Prevent public access to this script
defined( 'ABSPATH' ) || die();

if ( ! class_exists( '\Wpo\Services\Mail_Notifications' ) ) {

	class Mail_Notifications {

		/**
		 * Adds a "Mail Staging Mode enabled" button to the admin bar.
		 *
		 * @since 21.8
		 *
		 * @param mixed $wp_admin_bar  Current admin bar passed by reference.
		 * @return void
		 */
		public static function staging_mode_active( $wp_admin_bar ) {
			Log_Service::write_log( 'DEBUG', '##### -> ' . __METHOD__ );

			// Staging mode not activated
			if ( ! Options_Service::get_global_boolean_var( 'mail_staging_mode' ) ) {
				return;
			}

			// Only show the staging mode button for admins
			if ( Permissions_Helpers::user_is_admin( wp_get_current_user() ) === false ) {
				return;
			}

			// Decide where to link i.e. to the site admin or the network admin.
			$admin_url = is_multisite() && ! Options_Service::mu_use_subsite_options()
				? network_admin_url()
				: admin_url();

			// Add the main siteadmin menu item
			$wp_admin_bar->add_menu(
				array(
					'id'     => 'wpo365_staging_mode_menu',
					'href'   => $admin_url . 'admin.php?page=wpo365-wizard#mail',
					'parent' => 'top-secondary',
					'title'  => 'Mail Staging Mode enabled',
					'meta'   => array( 'class' => 'wpo365-staging-mode-active' ),
				)
			);
		}
	}
}
