<?php
/**
 * Import class.
 *
 * @package WP_To_Social_Pro
 * @author WP Zinc
 */

/**
 * Imports a JSON configuration file generated by the Plugin's export functionality.
 *
 * @package WP_To_Social_Pro
 * @author  WP Zinc
 * @version 4.2.2
 */
class WP_To_Social_Pro_Import {

	/**
	 * Holds the base object.
	 *
	 * @since   4.2.2
	 *
	 * @var     object
	 */
	public $base;

	/**
	 * Constructor.
	 *
	 * @since   4.2.2
	 *
	 * @param   object $base    Base Plugin Class.
	 */
	public function __construct( $base ) {

		// Store base class.
		$this->base = $base;

		// Import.
		add_action( $this->base->plugin->filter_name . '_import', array( $this, 'import' ), 10, 2 );

	}

	/**
	 * Import data created by this Plugin's export functionality
	 *
	 * @since   4.2.2
	 *
	 * @param   bool  $success    Success.
	 * @param   array $import     Array.
	 * @return  mixed               WP_Error | bool
	 */
	public function import( $success, $import ) {

		foreach ( $import['data'] as $key => $value ) {
			update_option( $key, $value );
		}

		return $success;

	}

}
