<?php
/**
 * Simple Pay: Payment Method options
 *
 * @package SimplePay\Pro\Post_Types\Simple_Pay\Edit_Form
 * @copyright Copyright (c) 2022, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.8.0
 */

namespace SimplePay\Pro\Post_Types\Simple_Pay\Edit_Form_Payment_Options;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use SimplePay\Pro\Payment_Methods;
use function SimplePay\Pro\Post_Types\Simple_Pay\Util\get_custom_fields;

/**
 * Add payment methods to the payment options panel.
 *
 * @since 4.11.0
 */
class Add_Payment_Methods {

	/**
	 * Constructor.
	 *
	 * @since 4.11.0
	 */
	public function __construct() {
		add_action(
			'simpay_form_settings_meta_payment_options_panel',
			array( $this, 'unstable_add_payment_methods' ),
			5
		);
		// Remove Lite output.
		remove_action(
			'simpay_form_settings_meta_payment_options_panel',
			'SimplePay\Core\Post_Types\Simple_Pay\Edit_Form\__unstable_add_payment_methods'
		);
	}

	/**
	 * Outputs markup for the payment method list.
	 *
	 * @since 4.4.7
	 *
	 * @param int $post_id Current Post ID (Payment Form ID).
	 * @return void
	 */
	public function unstable_add_payment_methods( $post_id ) {
		$payment_methods = simpay_get_payment_form_setting(
			$post_id,
			'payment_methods',
			array(),
			__unstable_simpay_get_payment_form_template_from_url()
		);

		$custom_fields = get_custom_fields( $post_id );

		// Retrieve available Payment Methods for the given context.
		uasort(
			$payment_methods,
			function ( $a ) {
				return isset( $a['id'] ) ? -1 : 1;
			}
		);

		$available_payment_methods = array_merge(
			array_flip( array_keys( $payment_methods ) ),
			Payment_Methods\get_payment_methods()
		);

		// Initial form type.
		$form = simpay_get_form( $post_id );

		$form_type = simpay_get_payment_form_setting(
			$post_id,
			'type',
			'stripe_checkout',
			__unstable_simpay_get_payment_form_template_from_url()
		);

		// Tax status.
		$tax_status = simpay_get_payment_form_setting(
			$post_id,
			'tax_status',
			'none',
			__unstable_simpay_get_payment_form_template_from_url()
		);

		// Account.
		$account_country = simpay_get_setting( 'account_country', 'us' );
		$license         = simpay_get_license();

		?>

	<table>
		<tbody class="simpay-panel-section">
			<?php include SIMPLE_PAY_INC . 'pro/post-types/simple-pay/edit-form-payment-methods.php'; ?>
		</tbody>
	</table>

		<?php
	}
}
