<?php
/**
 * Simple Pay: Multiple line items options
 *
 * @package SimplePay\Pro\Post_Types\Simple_Pay\Edit_Form
 * @copyright Copyright (c) 2022, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.8.0
 */

namespace SimplePay\Pro\Post_Types\Simple_Pay\Edit_Form_Payment_Options;

use SimplePay\Core\Utils;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Add the "Allow Purchasing Multiple Line Items" setting to the payment options panel.
 *
 * @since 4.11.0
 */
class Toggle_Multiple_Line_Items {

	/**
	 * Constructor.
	 *
	 * @since 4.11.0
	 */
	public function __construct() {
		add_action(
			'simpay_form_settings_meta_payment_options_panel',
			array( $this, 'unstable_add_allow_purchasing_multiple_line_items' ),
			5
		);

		// Remove Lite output.
		remove_action(
			'simpay_form_settings_meta_payment_options_panel',
			'SimplePay\Core\Post_Types\Simple_Pay\Edit_Form\__unstable_add_allow_purchasing_multiple_line_items',
			9
		);
	}
	/**
	 * Outputs markup for the "Allow Purchasing Multiple Line Items" setting.
	 *
	 * @since 4.11.0
	 * @access public
	 *
	 * @param int $post_id Payment form ID.
	 * @return void
	 */
	public function unstable_add_allow_purchasing_multiple_line_items( $post_id ) {
		$value = simpay_get_payment_form_setting(
			$post_id,
			'allow_purchasing_multiple_line_items',
			'no',
			__unstable_simpay_get_payment_form_template_from_url()
		);
		?>
	<table>
		<tbody class="simpay-panel-section">
			<tr class="simpay-panel-field">
				<th>
					<strong>
						<?php esc_html_e( 'Purchase Mode', 'simple-pay' ); ?>
					</strong>
				</th>
				<td style="border-bottom: 0; padding-bottom: 0;">

					<label for="_allow_purchasing_multiple_line_items">
						<input
							type="checkbox"
							id="_allow_purchasing_multiple_line_items"
							name="_allow_purchasing_multiple_line_items"
							value="yes"
							<?php
							checked( $value, 'yes' );
							disabled( false, true );
							?>
						/>

						<?php

						esc_html_e(
							'Allow purchasing multiple price options',
							'simple-pay'
						);

						?>
					</label>

					<p class="description">
						<?php
						echo wp_kses(
							sprintf(
								/* translators: %1$s Opening anchor tag, do not translate. %2$s Closing anchor tag, do not translate. */
								__(
									'Use Invoices to list separate line items on a single transaction. %1$sLearn more%2$s',
									'simple-pay'
								),
								'<a href="' . esc_url( simpay_docs_link( 'Stripe Invoices', 'how-to-sell-multiple-items-at-once', 'form-settings', true ) ) . '" target="_blank" rel="noopener noreferrer" class="simpay-external-link">',
								Utils\get_external_link_markup() . '</a>'
							),
							array(
								'a'    => array(
									'href'   => array(),
									'target' => array(),
									'rel'    => array(),
									'class'  => array(),
								),
								'span' => array(
									'class' => array(),
								),
							)
						);
						?>
					</p>
				</td>
			</tr>
		</tbody>
	</table>
		<?php
	}
}
