<?php
/**
 * Routines: Automatic tax rates + UPE
 *
 * If automatic tax rates are enabled on any payment form, and the user has not
 * yet opted in to UPE, we need to force them.
 *
 * The latest version of the Stripe PHP SDK no longer includes the Order resource
 * used to automatically calculate taxes prior to the TaxRates API.
 *
 * @package SimplePay\Core\Utils\Migrations
 * @copyright Copyright (c) 2023, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 4.7.11
 */

namespace SimplePay\Pro\Utils\Migrations\Routines;

use SimplePay\Core\Utils\Migrations;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Automatic_Tax_UPE class
 *
 * @since 4.7.11
 */
class Automatic_Tax_UPE extends Migrations\Bulk_Migration {

	/**
	 * Runs the migration.
	 *
	 * @since 4.0.0
	 */
	public function run() {
		if ( simpay_is_upe() ) {
			return $this->complete();
		}

		$forms = get_posts(
			array(
				'post_type'      => 'simple-pay',
				'posts_per_page' => -1,
				'meta_key'       => '_tax_status',
				'meta_value'     => 'automatic',
				'meta_compare'   => '=',
			)
		);

		if ( empty( $forms ) ) {
			return $this->complete();
		}

		simpay_update_setting( 'is_upe', 'yes' );

		$this->complete();
	}

}
