<?php
/**
 * Simple Pay: Multiple line items options
 *
 * @package SimplePay\Pro\Post_Types\Simple_Pay\Edit_Form
 * @copyright Copyright (c) 2022, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.8.0
 */

namespace SimplePay\Pro\Post_Types\Simple_Pay\Edit_Form_Payment_Options;

use SimplePay\Core\Settings;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Add the "Allow Purchasing Multiple Line Items" setting to the payment options panel.
 *
 * @since 4.11.0
 */
class Toggle_Multiple_Line_Items {

	/**
	 * Constructor.
	 *
	 * @since 4.11.0
	 */
	public function __construct() {
		add_action(
			'simpay_form_settings_meta_payment_options_panel',
			array( $this, 'unstable_add_allow_purchasing_multiple_line_items' ),
			5
		);

		// Remove Lite output.
		remove_action(
			'simpay_form_settings_meta_payment_options_panel',
			'SimplePay\Core\Post_Types\Simple_Pay\Edit_Form\__unstable_add_allow_purchasing_multiple_line_items',
			9
		);
	}
	/**
	 * Outputs markup for the "Allow Purchasing Multiple Line Items" setting.
	 *
	 * @since 4.11.0
	 * @access public
	 *
	 * @param int $post_id Payment form ID.
	 * @return void
	 */
	public function unstable_add_allow_purchasing_multiple_line_items( $post_id ) {
		?>
	<table>
		<tbody class="simpay-panel-section">
			<tr class="simpay-panel-field">
				<th>
					<strong>
						<?php esc_html_e( 'Purchase Mode', 'simple-pay' ); ?>
					</strong>
				</th>
				<td style="border-bottom: 0; padding-bottom: 0;">

					<label for="_allow_purchasing_multiple_line_items">
						<input
							type="checkbox"
							id="_allow_purchasing_multiple_line_items"
							name="_allow_purchasing_multiple_line_items"
							value="yes"
							<?php
							checked( get_post_meta( $post_id, '_allow_purchasing_multiple_line_items', true ), 'yes' );
							disabled( false, simpay_is_upe() );
							?>
						/>

						<?php
						if ( simpay_is_upe() ) {
							esc_html_e(
								'Allow purchasing multiple price options',
								'simple-pay'
							);
						} else {
							esc_html_e(
								'Purchasing multiple price options is currently disabled.',
								'simple-pay'
							);
						}
						?>
					</label>

						<?php
							$set_upe_url = Settings\get_url(
								array(
									'section'    => 'general',
									'subsection' => 'advanced',
									'setting'    => 'is_upe',
								)
							);
						?>
					<p class="description">
						<?php
						if ( simpay_is_upe() ) {
							esc_html_e(
								'Purchase multiple price options in a single transaction.',
								'simple-pay'
							);
						} else {
							echo esc_html__( 'To enable purchasing multiple price options, enable the New Payment Experience. ', 'simple-pay' ) .
								'<a href="' . esc_url( $set_upe_url ) . '">' . esc_html__( 'Enable now &rarr;', 'simple-pay' ) . '</a>';
						}
						?>
					</p>
				</td>
			</tr>
		</tbody>
	</table>
		<?php
	}
}
