<?php
/**
 * Cash App: Payment confirmation
 *
 * @package SimplePay\Pro\Payments\Payment_Methods\CashApp
 * @copyright Copyright (c) 2023, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 4.7.7
 */

namespace SimplePay\Pro\Payments\Payment_Methods\CashApp;

use SimplePay\Core\Payments\Payment_Confirmation;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Validates the Payment Confirmation data.
 *
 * If the data includes an invalid or incomplete PaymentIntent
 * redirect to the form's failure page.
 *
 * @since 4.7.7
 *
 * @return void
 */
function validate_payment_confirmation_data() {
	// Ensure we can retrieve a PaymentIntent.
	if ( ! isset( $_GET['payment_intent'] ) ) {
		return;
	}

	// Ensure we have a customer so `Payment_Confirmation\get_confirmation_data()` doesn't fail.
	if ( ! isset( $_GET['customer_id'] ) ) {
		return;
	}

	$payment_confirmation_data = Payment_Confirmation\get_confirmation_data();

	// Ensure we have a Payment Form to reference.
	if ( ! isset( $payment_confirmation_data['form'] ) ) {
		return;
	}

	$payment_intent = isset( $payment_confirmation_data['paymentintents'] )
		? current( $payment_confirmation_data['paymentintents'] )
		: false;

	$failure_page = $payment_confirmation_data['form']->payment_cancelled_page;

	// Redirect to failure if PaymentIntent cannot be found.
	if ( false === $payment_intent ) {
		wp_safe_redirect( $failure_page );
	}

	// Do nothing if the Intent has succeeded.
	if ( 'succeeded' === $payment_intent->status ) {
		return;
	}


	if ( ! isset( $payment_intent->last_payment_error->payment_method->type ) ) {
		return;
	}

	if ( 'cashapp' !== $payment_intent->last_payment_error->payment_method->type ) {
		return;
	}

	// Do nothing if the Intent does not have a next action.
	if ( 'requires_action' === $payment_intent->status ) {
		if ( ! isset( $payment_intent->next_action, $payment_intent->next_action->type ) ) {
			return;
		}

		if ( 'cashapp_handle_redirect_or_display_qr_code' !== $payment_intent->next_action->type ) {
			return;
		}
	}

	// Redirect to failure page.
	wp_safe_redirect( $failure_page );
}
add_action(
	'template_redirect',
	__NAMESPACE__ . '\\validate_payment_confirmation_data'
);
