( function ( $ ) {
	$( document ).ready( function () {
		const nonce = $( 'input[name="simpay_recreate_webhook_nonce"]' ).val();
		const $button = $( '#simpay-recreate-webhook' );
		const $message = $( '#simpay-recreate-webhook-message' );

		$button.click( function () {
			$button.prop( 'disabled', true ).text( 'Recreating...' );
			$message.text( '' ); // Clear previous messages

			wp.ajax.send( {
				data: {
					action: 'simpay_recreate_webhook',
					simpay_recreate_webhook_nonce: nonce,
				},
				success( response ) {
					$button
						.prop( 'disabled', false )
						.text( 'Recreate Webhook' );
					$message.text( response.message ).css( 'color', 'green' );
				},
				error( error ) {
					$button
						.prop( 'disabled', false )
						.text( 'Recreate Webhook' );
					$message
						.text( error.message || 'An error occurred.' )
						.css( 'color', 'red' );
				},
			} );
		} );
	} );
} )( jQuery );
