/* global simpayAdmin, jQuery */

/**
 * Internal dependencies.
 */
import './form-settings/payment-methods.js';
import './form-settings/taxes.js';
import './form-settings/custom-fields.js';
import './form-settings/purchase-restrictions.js';
import './settings/customers.js';
import './settings/taxes';
import './settings/upe.js';
import './settings/stripe/webhooks.js';
import './coupons';

const { hooks } = window.wpsp;

let spAdminPro = {};

( function ( $ ) {
	'use strict';

	let body, spFormSettings;

	spAdminPro = {
		init() {
			// We need to set these in here because this is when the page is ready to grab this info.
			body = $( document.body );
			spFormSettings = body.find( '#simpay-form-settings' );

			// Handle tax percent length
			$( '.simpay-tax-percent-field' ).on(
				'blur.simpayTaxPercentBlur',
				function () {
					spAdminPro.handleTaxPercent( $( this ) );
				}
			);
		},

		handleTaxPercent( el ) {
			el.val( accounting.toFixed( el.val(), 4 ) );
		},
	};

	$( document ).ready( function ( $ ) {
		spAdminPro.init();
	} );
} )( jQuery );
