<?php
/**
 * Forms field: Card
 *
 * @package SimplePay\Pro\Forms\Fields
 * @copyright Copyright (c) 2022, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.0.0
 */

namespace SimplePay\Pro\Forms\Fields;

use SimplePay\Pro\Payment_Methods;
use SimplePay\Core\Abstracts\Custom_Field;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Card class.
 *
 * @since 3.0.0
 */
class Card extends Custom_Field {

	/**
	 * Prints HTML for field on frontend.
	 *
	 * @since 3.0.0
	 * @since 3.8.0 Passes field type as second arugment.
	 * @since 3.8.0 Passes form instance as third argument.
	 *
	 * @param array                         $settings Field settings.
	 * @param string                        $type Field type.
	 * @param SimplePay\Core\Abstracts\Form $form Form.
	 * @return string
	 */
	public static function print_html( $settings, $type, $form ) {
		$label = isset( $settings['label'] ) ? $settings['label'] : '';
		$icons = isset( $settings['icons'] ) ? $settings['icons'] : 'no';

		$payment_form    = $form;
		$payment_methods = Payment_Methods\get_form_payment_methods( $form );

		/**
		 * Allows output or action to be taken before ouputting the Payment Form's
		 * Payment Methods.
		 *
		 * @since 3.9.0
		 *
		 * @param \SimplePay\Pro\Payment_Methods\Payment_Method[] $payment_methods Payment Methods.
		 * @param \SimplePay\Core\Abstracts\Form                  $payment_form    Payment Form.
		 */
		do_action(
			'simpay_payment_form_payment_methods_before',
			$payment_methods,
			$payment_form
		);

		$payment_methods = array_values( $payment_methods );

		ob_start();
		?>

		<div class="simpay-form-control simpay-form-control--card simpay-card-container">
			<?php

			echo self::get_upe_field();

			?>
		</div>


		<div class="simpay-payment-method-error simpay-errors" aria-live="assertive" aria-relevant="additions text" aria-atomic="true"></div>

		<?php
		return ob_get_clean();
	}

		/**
		 * Outputs markup for Universal Payment Element.
		 *
		 * @since 4.7.0
		 */
	public static function get_upe_field() {
		$id = self::get_id_attr();
		?>

		<div
			id="simpay-upe-element-<?php echo esc_attr( $id ); ?>"
			class="simpay-upe-wrap simpay-field-wrap"
		>
		</div>

			<?php
	}
}
