<?php
/**
 * Subscription totals
 *
 * Shows the info of a particular subscription without pricing for the recipient on the account page
 *
 * @package WooCommerce Subscriptions Gifting/Templates
 * @version 8.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<?php $allow_remove_items = wcs_can_items_be_removed( $subscription ); ?>
<?php $subscription_items = $subscription->get_items(); ?>
<h2><?php echo esc_html( _n( 'Subscription Item', 'Subscription Items', count( $subscription_items ), 'woocommerce-subscriptions' ) ); ?></h2>
<table class="shop_table order_details">
	<thead>
		<tr>
			<?php if ( $allow_remove_items ) : ?>
			<th class="product-remove" style="width: 3em;">&nbsp;</th>
			<?php endif; ?>
			<th class="product-name"><?php echo esc_html_x( 'Product', 'table headings in notification email', 'woocommerce-subscriptions' ); ?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		if ( count( $subscription_items ) > 0 ) {

			foreach ( $subscription_items as $item_id => $item ) {
				$_product = apply_filters( 'woocommerce_subscriptions_order_item_product', $item->get_product(), $item );
				if ( apply_filters( 'woocommerce_order_item_visible', true, $item ) ) {
					// Translators: %s: product name.
					$aria_label = sprintf( __( 'Remove %s', 'woocommerce-subscriptions' ), esc_html( $_product->get_name() ) );
					?>
					<tr class="<?php echo esc_attr( apply_filters( 'woocommerce_order_item_class', 'order_item', $item, $subscription ) ); ?>">
						<?php if ( $allow_remove_items ) : ?>
							<td class="remove_item">
								<?php if ( wcs_can_item_be_removed( $item, $subscription ) ) : ?>
									<?php $confirm_notice = apply_filters( 'woocommerce_subscriptions_order_item_remove_confirmation_text', __( 'Are you sure you want to remove this item from your subscription?', 'woocommerce-subscriptions' ), $item, $_product, $subscription ); ?>
									<a
										href="<?php echo esc_url( WCS_Remove_Item::get_remove_url( $subscription->get_id(), $item_id ) ); ?>"
										class="remove"
										role="button"
										onclick="return confirm('<?php printf( esc_html( $confirm_notice ) ); ?>');"
										aria-haspopup="dialog"
										aria-label="<?php echo esc_attr( $aria_label ); ?>"
									>
										&times;
									</a>
								<?php endif; ?>
							</td>
						<?php endif; ?>
						<td class="product-name">
							<?php
							if ( $_product && ! $_product->is_visible() ) {
								echo esc_html( apply_filters( 'woocommerce_order_item_name', $item['name'], $item, false ) );
							} else {
								echo wp_kses_post( apply_filters( 'woocommerce_order_item_name', sprintf( '<a href="%s">%s</a>', get_permalink( $item['product_id'] ), $item['name'] ), $item, false ) );
							}

							echo wp_kses_post( apply_filters( 'woocommerce_order_item_quantity_html', ' <strong class="product-quantity">' . sprintf( '&times; %s', $item['qty'] ) . '</strong>', $item ) );

							// Allow other plugins to add additional product information here.
							do_action( 'woocommerce_order_item_meta_start', $item_id, $item, $subscription );

							wcs_display_item_meta( $item, $subscription );

							wc_display_item_downloads( $item );

							// Allow other plugins to add additional product information here.
							do_action( 'woocommerce_order_item_meta_end', $item_id, $item, $subscription );
							?>
						</td>
					</tr>
					<?php
				}

				if ( $subscription->has_status( array( 'completed', 'processing' ) ) && ( $purchase_note = get_post_meta( $_product->id, '_purchase_note', true ) ) ) {
					?>
					<tr class="product-purchase-note">
						<td colspan="3"><?php echo wp_kses_post( wpautop( do_shortcode( $purchase_note ) ) ); ?></td>
					</tr>
					<?php
				}
			}
		}
		?>
	</tbody>
</table>
