<?php
/**
 * class-woocommerce-groupons.php
 *
 * Copyright (c) "kento" Karim Rahimpur www.itthinx.com
 *
 * This code is provided subject to the license granted.
 * Unauthorized use and distribution is prohibited.
 * See COPYRIGHT.txt and LICENSE.txt
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * This header and all notices must be kept intact.
 *
 * @author Karim Rahimpur
 * @package woocommerce-groupons
 * @since woocommerce-groupons 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Boots.
 */
class WooCommerce_Groupons {

	private static $admin_messages = array();

	/**
	 * Put hooks in place and activate.
	 */
	public static function init() {
		//register_activation_hook( WOO_GROUPONS_FILE, array( __CLASS__, 'activate' ) );
		//register_deactivation_hook( WOO_GROUPONS_FILE, array( __CLASS__, 'deactivate' ) );
		//register_uninstall_hook( WOO_GROUPONS_FILE, array( __CLASS__, 'uninstall' ) );
		add_action( 'admin_notices', array( __CLASS__, 'admin_notices' ) );
		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'admin_enqueue_scripts' ) );
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'wp_enqueue_scripts' ) );
		add_action( 'init', array( __CLASS__, 'wp_init' ) );
		if ( self::check_dependencies() ) {
			require_once( WOO_GROUPONS_CORE_LIB . '/constants.php');
			$options = get_option( 'woocommerce-groupons', null );
			$enable_roles = isset( $options[WOO_GROUPONS_ENABLE_ROLES] ) ? $options[WOO_GROUPONS_ENABLE_ROLES] : WOO_GROUPONS_ENABLE_ROLES_DEFAULT;
			require_once( WOO_GROUPONS_CORE_LIB . '/class-woocommerce-groupon.php');
			if ( $enable_roles ) {
				require_once( WOO_GROUPONS_CORE_LIB . '/class-woocommerce-group-coupon-roles.php');
			}
			if ( is_admin() ) {
				require_once( WOO_GROUPONS_ADMIN_LIB . '/class-woocommerce-groupons-admin.php');
				require_once( WOO_GROUPONS_ADMIN_LIB . '/class-woocommerce-groupons-coupons-admin.php');
				if ( $enable_roles ) {
					require_once( WOO_GROUPONS_ADMIN_LIB . '/class-woocommerce-groupons-coupons-roles-admin.php');
				}
			}
			require_once( WOO_GROUPONS_VIEWS_LIB . '/class-woocommerce-groupons-shortcodes.php');
			$logout_remove_coupons = isset( $options[WOO_GROUPONS_LOGOUT_REMOVE_COUPONS] ) ? $options[WOO_GROUPONS_LOGOUT_REMOVE_COUPONS] : WOO_GROUPONS_LOGOUT_REMOVE_COUPONS_DEFAULT;
			if ( $logout_remove_coupons ) {
				add_action( 'wp_logout', array( __CLASS__, 'wp_logout' ) );
			}
		}
	}

	/**
	 * Register the extension's admin scripts and styles.
	 */
	public static function admin_enqueue_scripts() {
		// Currently not used wp_register_script( 'woocommerce-group-coupons-admin', WOO_GROUPONS_PLUGIN_URL . '/js/admin.js', array( 'jquery' ), WOO_GROUPONS_PLUGIN_VERSION, true );
		wp_register_style(
			'woocommerce-group-coupons-admin',
			trailingslashit( WOO_GROUPONS_PLUGIN_URL ) . ( SCRIPT_DEBUG ? 'css/admin.css' : 'css/admin.min.css' ),
			array( 'woocommerce_admin_styles' ),
			WOO_GROUPONS_PLUGIN_VERSION
		);
		wp_register_style(
			'woocommerce-group-coupons-admin-product',
			trailingslashit( WOO_GROUPONS_PLUGIN_URL ) . ( SCRIPT_DEBUG ? 'css/admin-product.css' : 'css/admin-product.min.css' ),
			array(),
			WOO_GROUPONS_PLUGIN_VERSION
		);
	}

	/**
	 * Register the extension's frontend scripts and styles.
	 */
	public static function wp_enqueue_scripts() {
		wp_register_style(
			'woocommerce-group-coupons',
			trailingslashit( WOO_GROUPONS_PLUGIN_URL ) . ( SCRIPT_DEBUG ? 'css/woocommerce-group-coupons.css' : 'css/woocommerce-group-coupons.min.css' ),
			array(),
			WOO_GROUPONS_PLUGIN_VERSION
		);
		// If we needed to make sure that our styles are present on cart or shop pages later on ...
		// if ( is_cart() || is_shop() ) {
		// 	wp_enqueue_style( 'woocommerce-group-coupons' );
		// }
	}

	/**
	 * Placeholder.
	 */
	public static function wp_init() {
		__( 'You must be a <em>%s</em> member to use this coupon.', 'woocommerce-group-coupons' ); // for translation
		do_action( 'wpml_register_single_string', 'woocommerce-group-coupons', WOO_GROUPONS_YOU_MUST_BE_A_MEMBER, WOO_GROUPONS_YOU_MUST_BE_A_MEMBER_DEFAULT );
		add_filter( 'plugin_locale', array( __CLASS__, 'plugin_locale' ), 10, 2 );
		load_plugin_textdomain( 'woocommerce-group-coupons', null, 'woocommerce-group-coupons/languages' );
		remove_filter( 'plugin_locale', array( __CLASS__, 'plugin_locale' ), 10 );
	}

	/**
	 * Flexible generic locale.
	 *
	 * @param string $locale
	 * @param string $domain
	 *
	 * @return string
	 */
	public static function plugin_locale( $locale, $domain ) {
		// Use a language-generic translation if no country-specific translation is available,
		// unless this is explicitly disabled by setting the WGC_STRICT_LOCALE constant to true.
		if ( !WGC_STRICT_LOCALE ) {
			if ( 'woocommerce-group-coupons' === $domain ) {
				if ( !file_exists( WOO_GROUPONS_CORE_DIR . '/languages/' . $domain . '-' . $locale . '.mo' ) ) {
					$parts = explode( '_', $locale );
					if ( file_exists( WOO_GROUPONS_CORE_DIR . '/languages/' . $domain . '-' . $parts[0] . '.mo' ) ) {
						$locale = $parts[0];
					}
				}
			}
		}
		return $locale;
	}

	/**
	 * Avoid dangling coupons.
	 * These appear on orders with 0 discount - WooCommerce 2.0.10 when a coupon
	 * has been applied and the user logs out and then checks out.
	 */
	public static function wp_logout() {
		global $woocommerce;
		if (
			isset( $woocommerce ) &&
			isset( $woocommerce->cart ) &&
			$woocommerce->cart !== null
		) {
			$woocommerce->cart->remove_coupons();
		}
	}

	/**
	 * Activate plugin.
	 * Reschedules pending tasks.
	 * @param boolean $network_wide
	 */
	public static function activate( $network_wide = false ) {
	}

	/**
	 * Deactivate plugin.
	 * @param boolean $network_wide
	 */
	public static function deactivate( $network_wide = false ) {
	}

	/**
	 * Uninstall plugin.
	 */
	public static function uninstall() {
	}

	/**
	 * Prints admin notices.
	 */
	public static function admin_notices() {
		if ( !empty( self::$admin_messages ) ) {
			foreach ( self::$admin_messages as $msg ) {
				echo wp_kses_post( $msg ); // WPCS: XSS ok.
			}
		}
	}

	/**
	 * Check plugin dependencies and nag if they are not met.
	 * @param boolean $disable disable the plugin if true, defaults to false
	 */
	public static function check_dependencies( $disable = false ) {
		$result = true;
		$active_plugins = get_option( 'active_plugins', array() );
		if ( is_multisite() ) {
			$active_sitewide_plugins = get_site_option( 'active_sitewide_plugins', array() );
			$active_sitewide_plugins = array_keys( $active_sitewide_plugins );
			$active_plugins = array_merge( $active_plugins, $active_sitewide_plugins );
		}
		$groups_is_active = in_array( 'groups/groups.php', $active_plugins );
		define( 'WOO_GROUPONS_GROUPS_IS_ACTIVE', $groups_is_active );
		$woocommerce_is_active = in_array( 'woocommerce/woocommerce.php', $active_plugins );
		if ( !$woocommerce_is_active ) {
			self::$admin_messages[] =
				"<div class='error'>" .
				wp_kses_post( __( '<em>WooCommerce Group Coupons</em> requires <a href="https://woocommerce.com/" target="_blank">WooCommerce</a>. Please install and activate it.', 'woocommerce-group-coupons' ) ) .
				"</div>";
		}
		if ( !$woocommerce_is_active ) {
			if ( $disable ) {
				include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
				deactivate_plugins( array( __FILE__ ) );
			}
			$result = false;
		}
		return $result;
	}
}
WooCommerce_Groupons::init();
